/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.Maths;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.random.BinomialGenerator;

class BinomialDistribution
extends ProbabilityDistribution {
    private final int n;
    private final double p;

    public BinomialDistribution(int n, double p) {
        this.n = n;
        this.p = p;
    }

    @Override
    public Map<Double, Double> getExpectedValues() {
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        for (int i = 0; i <= this.n; ++i) {
            values.put(Double.valueOf(i), this.getExpectedProbability(i));
        }
        return values;
    }

    private double getExpectedProbability(int successes) {
        double prob = Math.pow(this.p, successes) * Math.pow(1.0 - this.p, this.n - successes);
        BigDecimal coefficient = new BigDecimal(this.binomialCoefficient(this.n, successes));
        return coefficient.multiply(new BigDecimal(prob)).doubleValue();
    }

    private BigInteger binomialCoefficient(int n, int k) {
        BigInteger nFactorial = Maths.bigFactorial(n);
        BigInteger kFactorial = Maths.bigFactorial(k);
        BigInteger nMinusKFactorial = Maths.bigFactorial(n - k);
        BigInteger divisor = kFactorial.multiply(nMinusKFactorial);
        return nFactorial.divide(divisor);
    }

    protected BinomialGenerator createValueGenerator(Random rng) {
        return new BinomialGenerator(this.n, this.p, rng);
    }

    @Override
    public double getExpectedMean() {
        return (double)this.n * this.p;
    }

    @Override
    public double getExpectedStandardDeviation() {
        return Math.sqrt((double)this.n * this.p * (1.0 - this.p));
    }

    @Override
    public String getDescription() {
        return "Binomial Distribution (n = " + this.n + ", p = " + this.p + ")";
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }
}

