/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuReflect {
    public static boolean makeRotation(PdMatrix pdMatrix, PdVector pdVector, double d) {
        if (pdMatrix == null) {
            PsDebug.warning("missing matrix");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing axis");
            return false;
        }
        if (pdVector.getSize() != 3) {
            PsDebug.warning("dimension of axis not 3");
            return false;
        }
        double d2 = pdVector.sqrLength();
        if (d2 < 1.0E-10) {
            PsDebug.warning("axis has zero length");
            return false;
        }
        d2 = Math.sqrt(d2);
        double d3 = pdVector.m_data[0] / d2;
        double d4 = pdVector.m_data[1] / d2;
        double d5 = pdVector.m_data[2] / d2;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = 1.0 - d6;
        pdMatrix.m_data[0][0] = d6 + d8 * d3 * d3;
        pdMatrix.m_data[0][1] = -d7 * d5 + d8 * d3 * d4;
        pdMatrix.m_data[0][2] = d7 * d4 + d8 * d3 * d5;
        pdMatrix.m_data[1][0] = d7 * d5 + d8 * d3 * d4;
        pdMatrix.m_data[1][1] = d6 + d8 * d4 * d4;
        pdMatrix.m_data[1][2] = -d7 * d3 + d8 * d4 * d5;
        pdMatrix.m_data[2][0] = -d7 * d4 + d8 * d3 * d5;
        pdMatrix.m_data[2][1] = d7 * d3 + d8 * d4 * d5;
        pdMatrix.m_data[2][2] = d6 + d8 * d5 * d5;
        return true;
    }

    public static Double getRotation(PdMatrix pdMatrix, PdVector pdVector) {
        double d;
        if (pdMatrix == null || pdMatrix.getISize() < 3 || pdMatrix.getJSize() < 3) {
            PsDebug.warning("missing matrix or not 3x3.");
            return null;
        }
        if (pdVector == null) {
            PsDebug.warning("missing axis");
            return null;
        }
        if (pdVector.getSize() != 3) {
            pdVector.setSize(3);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (Math.abs(pdMatrix.m_data[0][0] - 1.0) < 1.0E-10) {
            d3 = 1.0;
            d = -(pdMatrix.m_data[1][2] - pdMatrix.m_data[2][1]) / 2.0;
            d2 = Math.asin(d);
            pdVector.set(d3, d4, d5);
        } else if (Math.abs(pdMatrix.m_data[1][1] - 1.0) < 1.0E-10) {
            d4 = 1.0;
            d = (pdMatrix.m_data[0][2] - pdMatrix.m_data[2][0]) / 2.0;
            d2 = Math.asin(d);
            pdVector.set(d3, d4, d5);
        } else if (Math.abs(pdMatrix.m_data[2][2] - 1.0) < 1.0E-10) {
            d5 = 1.0;
            d = -(pdMatrix.m_data[0][1] - pdMatrix.m_data[1][0]) / 2.0;
            d2 = Math.asin(d);
            pdVector.set(d3, d4, d5);
        } else {
            d = (pdMatrix.m_data[1][1] - 1.0) * (pdMatrix.m_data[0][0] - 1.0) - pdMatrix.m_data[0][1] * pdMatrix.m_data[1][0];
            double d6 = pdMatrix.m_data[1][2] * (pdMatrix.m_data[0][0] - 1.0) - pdMatrix.m_data[0][2] * pdMatrix.m_data[1][0];
            d4 = -d6;
            d5 = d;
            d3 = -(pdMatrix.m_data[0][1] * d4 + pdMatrix.m_data[0][2] * d5) / (pdMatrix.m_data[0][0] - 1.0);
            pdVector.set(d3, d4, d5);
            if (!pdVector.normalize()) {
                PsDebug.warning("failed normalizing axis");
            }
            d3 = pdVector.getEntry(0);
            d4 = pdVector.getEntry(1);
            d5 = pdVector.getEntry(2);
            double d7 = -(pdMatrix.m_data[1][2] - pdMatrix.m_data[2][1]) / 2.0;
            double d8 = (pdMatrix.m_data[0][2] - pdMatrix.m_data[2][0]) / 2.0;
            double d9 = -(pdMatrix.m_data[0][1] - pdMatrix.m_data[1][0]) / 2.0;
            d2 = d5 > 1.0E-10 && Math.abs(d9 / d5) <= 1.0 ? Math.asin(d9 / d5) : (d4 > 1.0E-10 && Math.abs(d8 / d4) <= 1.0 ? Math.asin(d8 / d4) : Math.asin(d7 / d3));
        }
        d = 0.0;
        d = Math.abs(d3 - d5) > 1.0E-10 ? 1.0 - (pdMatrix.m_data[0][0] - pdMatrix.m_data[2][2]) / (d3 * d3 - d5 * d5) : (Math.abs(d3 - d4) > 1.0E-10 ? 1.0 - (pdMatrix.m_data[0][0] - pdMatrix.m_data[1][1]) / (d3 * d3 - d4 * d4) : 1.0 - (pdMatrix.m_data[1][1] - pdMatrix.m_data[2][2]) / (d4 * d4 - d5 * d5));
        if (d < 0.0) {
            d2 = d2 > 0.0 ? Math.PI - d2 : -Math.PI - d2;
        }
        return new Double(d2);
    }

    public static PdMatrix rotateLine(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        if (pdMatrix == null || pdMatrix.getSize() != 4) {
            PsDebug.warning("matrix missing or dimension!=4");
            return null;
        }
        if (pdVector == null || pdVector.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (pdVector2 == null || pdVector2.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        double d = pdVector.m_data[0];
        double d2 = pdVector.m_data[1];
        double d3 = pdVector.m_data[2];
        PdVector pdVector3 = pdVector2;
        double d4 = pdVector3.m_data[0];
        double d5 = pdVector3.m_data[1];
        double d6 = pdVector3.m_data[2];
        double d7 = pdVector3.sqrLength();
        pdMatrix.m_data[0][0] = 2.0 * d4 * d4 / d7;
        pdMatrix.m_data[0][1] = 2.0 * d5 * d4 / d7;
        pdMatrix.m_data[0][2] = 2.0 * d6 * d4 / d7;
        pdMatrix.m_data[0][3] = 2.0 * d - pdMatrix.m_data[0][0] * d - pdMatrix.m_data[0][1] * d2 - pdMatrix.m_data[0][2] * d3;
        pdMatrix.m_data[1][0] = pdMatrix.m_data[0][1];
        pdMatrix.m_data[1][1] = 2.0 * d5 * d5 / d7;
        pdMatrix.m_data[1][2] = 2.0 * d6 * d5 / d7;
        pdMatrix.m_data[1][3] = 2.0 * d2 - pdMatrix.m_data[1][0] * d - pdMatrix.m_data[1][1] * d2 - pdMatrix.m_data[1][2] * d3;
        pdMatrix.m_data[2][0] = pdMatrix.m_data[0][2];
        pdMatrix.m_data[2][1] = pdMatrix.m_data[1][2];
        pdMatrix.m_data[2][2] = 2.0 * d6 * d6 / d7;
        pdMatrix.m_data[2][3] = 2.0 * d3 - pdMatrix.m_data[2][0] * d - pdMatrix.m_data[2][1] * d2 - pdMatrix.m_data[2][2] * d3;
        double[] dArray = pdMatrix.m_data[0];
        dArray[0] = dArray[0] - 1.0;
        double[] dArray2 = pdMatrix.m_data[1];
        dArray2[1] = dArray2[1] - 1.0;
        double[] dArray3 = pdMatrix.m_data[2];
        dArray3[2] = dArray3[2] - 1.0;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2) {
        return PuReflect.rotateLine(new PdMatrix(4, 4), pdVector, pdVector2);
    }

    public static PdMatrix rotateLine(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2, double d) {
        if (pdMatrix == null || pdMatrix.getSize() != 4) {
            PsDebug.warning("matrix missing or dimension!=4");
            return null;
        }
        if (pdVector == null || pdVector.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (pdVector2 == null || pdVector2.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        double d2 = pdVector2.sqrLength();
        if (d2 < 1.0E-10) {
            PsDebug.warning("axis has zero length");
            return null;
        }
        d2 = Math.sqrt(d2);
        double d3 = pdVector2.m_data[0] / d2;
        double d4 = pdVector2.m_data[1] / d2;
        double d5 = pdVector2.m_data[2] / d2;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = 1.0 - d6;
        pdMatrix.m_data[0][0] = d6 + d8 * d3 * d3;
        pdMatrix.m_data[0][1] = -d7 * d5 + d8 * d3 * d4;
        pdMatrix.m_data[0][2] = d7 * d4 + d8 * d3 * d5;
        pdMatrix.m_data[0][3] = pdVector.m_data[0] - pdMatrix.m_data[0][0] * pdVector.m_data[0] - pdMatrix.m_data[0][1] * pdVector.m_data[1] - pdMatrix.m_data[0][2] * pdVector.m_data[2];
        pdMatrix.m_data[1][0] = d7 * d5 + d8 * d3 * d4;
        pdMatrix.m_data[1][1] = d6 + d8 * d4 * d4;
        pdMatrix.m_data[1][2] = -d7 * d3 + d8 * d4 * d5;
        pdMatrix.m_data[1][3] = pdVector.m_data[1] - pdMatrix.m_data[1][0] * pdVector.m_data[0] - pdMatrix.m_data[1][1] * pdVector.m_data[1] - pdMatrix.m_data[1][2] * pdVector.m_data[2];
        pdMatrix.m_data[2][0] = -d7 * d4 + d8 * d3 * d5;
        pdMatrix.m_data[2][1] = d7 * d3 + d8 * d4 * d5;
        pdMatrix.m_data[2][2] = d6 + d8 * d5 * d5;
        pdMatrix.m_data[2][3] = pdVector.m_data[2] - pdMatrix.m_data[2][0] * pdVector.m_data[0] - pdMatrix.m_data[2][1] * pdVector.m_data[1] - pdMatrix.m_data[2][2] * pdVector.m_data[2];
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2, double d) {
        return PuReflect.rotateLine(new PdMatrix(4, 4), pdVector, pdVector2, d);
    }

    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing base point.");
            return null;
        }
        int n = pdVector.getSize();
        if (n != 3 || pdVector2.getSize() != n || pdVector3.getSize() != n) {
            PsDebug.warning("wrong dimension of base point, must all be 3.");
            return null;
        }
        PdVector pdVector4 = new PdVector(3);
        if (!pdVector4.normalOfPlane(pdVector, pdVector2, pdVector3)) {
            PsDebug.warning("three points do not span a plane");
            return null;
        }
        double d = pdVector4.m_data[0];
        double d2 = pdVector4.m_data[1];
        double d3 = pdVector4.m_data[2];
        double d4 = PdVector.dot(pdVector, pdVector4);
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = 1.0 - 2.0 * d * d;
        pdMatrix.m_data[0][1] = -2.0 * d * d2;
        pdMatrix.m_data[0][2] = -2.0 * d * d3;
        pdMatrix.m_data[0][3] = 2.0 * d * d4;
        pdMatrix.m_data[1][0] = -2.0 * d * d2;
        pdMatrix.m_data[1][1] = 1.0 - 2.0 * d2 * d2;
        pdMatrix.m_data[1][2] = -2.0 * d2 * d3;
        pdMatrix.m_data[1][3] = 2.0 * d2 * d4;
        pdMatrix.m_data[2][0] = -2.0 * d * d3;
        pdMatrix.m_data[2][1] = -2.0 * d2 * d3;
        pdMatrix.m_data[2][2] = 1.0 - 2.0 * d3 * d3;
        pdMatrix.m_data[2][3] = 2.0 * d3 * d4;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing base point or normal vector");
            return null;
        }
        double d = pdVector2.sqrLength();
        if (Math.abs(1.0 - d) > 1.0E-10) {
            PsDebug.warning("normal is not normalized");
            return null;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix = new PdMatrix(n + 1, n + 1);
        double d2 = PdVector.dot(pdVector, pdVector2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                pdMatrix.m_data[i][j] = -2.0 * pdVector2.m_data[i] * pdVector2.m_data[j];
            }
            double[] dArray = pdMatrix.m_data[i];
            int n2 = i;
            dArray[n2] = dArray[n2] + 1.0;
            pdMatrix.m_data[i][n] = 2.0 * pdVector2.m_data[i] * d2;
        }
        pdMatrix.m_data[n][n] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix pointReflect(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing point");
            return null;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix = new PdMatrix(n + 1, n + 1);
        pdMatrix.m_data[n][n] = 1.0;
        for (int i = 0; i < n; ++i) {
            pdMatrix.m_data[i][i] = -1.0;
            pdMatrix.m_data[i][n] = 2.0 * pdVector.m_data[i];
        }
        pdMatrix.m_data[n][n] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix translate(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vector");
            return null;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        pdMatrix.setIdentity();
        for (int i = 0; i < n; ++i) {
            pdMatrix.m_data[i][n] = pdVector.m_data[i];
        }
        return pdMatrix;
    }

    public static PdMatrix scale(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vector");
            return null;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        for (int i = 0; i < n; ++i) {
            pdMatrix.m_data[i][i] = pdVector.m_data[i];
        }
        pdMatrix.m_data[n][n] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix scale(double d, int n) {
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        for (int i = 0; i < n; ++i) {
            pdMatrix.m_data[i][i] = d;
        }
        pdMatrix.m_data[n][n] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateXY(double d, int n) {
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        PuReflect.rotate(pdMatrix, d, 0, 1);
        return pdMatrix;
    }

    public static PdMatrix rotateYZ(double d, int n) {
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        PuReflect.rotate(pdMatrix, d, 1, 2);
        return pdMatrix;
    }

    public static PdMatrix rotateXZ(double d, int n) {
        PdMatrix pdMatrix = new PdMatrix(n + 1);
        PuReflect.rotate(pdMatrix, d, 0, 2);
        return pdMatrix;
    }

    public static PdMatrix rotate(PdMatrix pdMatrix, double d, int n, int n2) {
        double d2;
        if (pdMatrix == null) {
            return null;
        }
        int n3 = pdMatrix.getSize();
        if (n3 <= n || n3 <= n2) {
            PsDebug.warning("index out of range, dim=" + n3 + ", indI=" + n + ", indJ=" + n2);
            return null;
        }
        pdMatrix.setIdentity();
        double d3 = Math.sin(d);
        pdMatrix.m_data[n][n] = d2 = Math.cos(d);
        pdMatrix.m_data[n][n2] = -d3;
        pdMatrix.m_data[n2][n] = d3;
        pdMatrix.m_data[n2][n2] = d2;
        return pdMatrix;
    }
}

