/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBaryDir
extends P_Vector {
    public static final PdBaryDir[] TRIANGLE_EDGE = new PdBaryDir[]{new PdBaryDir(0.0, -1.0, 1.0), new PdBaryDir(1.0, 0.0, -1.0), new PdBaryDir(-1.0, 1.0, 0.0)};
    public double[] m_data;
    protected int m_elementInd;

    public static PdBaryDir[][] alloc(int n, int n2, int n3) {
        PdBaryDir[][] pdBaryDirArray = new PdBaryDir[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                pdBaryDirArray[i][j] = new PdBaryDir(n3);
            }
        }
        return pdBaryDirArray;
    }

    public static PdBaryDir[] realloc(PdBaryDir[] pdBaryDirArray, int n, int n2) {
        int n3;
        int n4;
        if (pdBaryDirArray != null && pdBaryDirArray.length == n) {
            for (int i = 0; i < pdBaryDirArray.length; ++i) {
                if (pdBaryDirArray[i] == null) {
                    pdBaryDirArray[i] = new PdBaryDir(n2);
                    continue;
                }
                if (pdBaryDirArray[i].m_data != null && pdBaryDirArray[i].m_data.length == n2) continue;
                pdBaryDirArray[i].setSize(n2);
            }
            return pdBaryDirArray;
        }
        PdBaryDir[] pdBaryDirArray2 = new PdBaryDir[n];
        if (pdBaryDirArray == null) {
            n4 = 0;
        } else {
            n4 = Math.min(pdBaryDirArray.length, n);
            System.arraycopy(pdBaryDirArray, 0, pdBaryDirArray2, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (pdBaryDirArray2[n3] == null) {
                pdBaryDirArray2[n3] = new PdBaryDir(n2);
                continue;
            }
            if (pdBaryDirArray2[n3].m_data != null && pdBaryDirArray2[n3].m_data.length == n2) continue;
            pdBaryDirArray2[n3].setSize(n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            pdBaryDirArray2[n3] = new PdBaryDir(n2);
        }
        return pdBaryDirArray2;
    }

    public PdBaryDir() {
        this(0);
    }

    public PdBaryDir(int n) {
        this.m_data = new double[n];
        this.m_elementInd = -1;
    }

    public PdBaryDir(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdBaryDir(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdBaryDir(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public void setZero() {
        if (this.m_data == null || this.m_data.length == 0) {
            return;
        }
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            this.m_data[i] = 0.0;
        }
    }

    public int getElementInd() {
        return this.m_elementInd;
    }

    public void setElementInd(int n) {
        this.m_elementInd = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PdBaryDir *********\n");
        int n = this.getSize();
        stringBuffer.append("\t m_elementInd = " + String.valueOf(this.m_elementInd) + "\n");
        stringBuffer.append("\t m_size = " + String.valueOf(n) + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append(")\n");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getSize();
        if (n > 0) {
            stringBuffer.append("\t {").append(String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", ").append(String.valueOf(this.m_data[i]));
            }
            stringBuffer.append("},");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {},");
        } else {
            stringBuffer.append("\t m_data = null,");
        }
        stringBuffer.append("\t m_elementInd = " + String.valueOf(this.m_elementInd) + ",");
        stringBuffer.append("\t Attr = (" + this.getBits() + ")\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        PdBaryDir pdBaryDir = null;
        pdBaryDir = (PdBaryDir)super.clone();
        if (pdBaryDir == null) {
            return null;
        }
        if (this.m_data != null) {
            pdBaryDir.m_data = (double[])this.m_data.clone();
        }
        return pdBaryDir;
    }

    public static PdBaryDir copyNew(PdBaryDir pdBaryDir) {
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (pdBaryDir.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(pdBaryDir.getSize());
        pdBaryDir2.copy(pdBaryDir);
        return pdBaryDir2;
    }

    public void copy(PdBaryDir pdBaryDir) {
        if (this == pdBaryDir) {
            return;
        }
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(pdBaryDir);
        if (pdBaryDir.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data.length != pdBaryDir.getSize()) {
            this.setSize(pdBaryDir.getSize());
        }
        System.arraycopy(pdBaryDir.m_data, 0, this.m_data, 0, this.m_data.length);
        this.m_elementInd = pdBaryDir.m_elementInd;
    }

    public void copyArray(PdBaryDir pdBaryDir) {
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pdBaryDir.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data.length != pdBaryDir.getSize()) {
            this.setSize(pdBaryDir.getSize());
        }
        System.arraycopy(pdBaryDir.m_data, 0, this.m_data, 0, this.m_data.length);
        this.m_elementInd = pdBaryDir.m_elementInd;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null || this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public void blend(double d, PdBaryDir pdBaryDir, double d2, PdBaryDir pdBaryDir2) {
        if (pdBaryDir == null || pdBaryDir2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data.length != pdBaryDir.m_data.length || this.m_data.length != pdBaryDir2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        if (this.m_data == null) {
            this.setSize(pdBaryDir.m_data.length);
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = d * pdBaryDir.m_data[i] + d2 * pdBaryDir2.m_data[i];
        }
        this.m_elementInd = d >= d2 ? pdBaryDir.m_elementInd : pdBaryDir2.m_elementInd;
    }

    public void blendBase(PdBaryDir pdBaryDir, double d, PdBaryDir pdBaryDir2) {
        if (pdBaryDir == null || pdBaryDir2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdBaryDir.m_data.length);
        }
        if (this.m_data.length != pdBaryDir.m_data.length || this.m_data.length != pdBaryDir2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = pdBaryDir.m_data[i] + d * pdBaryDir2.m_data[i];
        }
        this.m_elementInd = d < 0.5 ? pdBaryDir.m_elementInd : pdBaryDir2.m_elementInd;
    }

    public void validate() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.m_data.length; ++n) {
            if (Math.abs(this.m_data[n]) < 1.0E-10) {
                this.m_data[n] = 0.0;
            }
            d += this.m_data[n];
        }
        d /= (double)this.m_data.length;
        n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] - d;
        }
    }

    public void multScalar(PdBaryDir pdBaryDir, double d) {
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = pdBaryDir.m_data[i] * d;
        }
    }

    public void multScalar(double d) {
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] * d;
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        int n = this.m_data.length;
        double[] dArray = (double[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = this.m_data[n2] + pdMatrix.m_data[i][j] * dArray[j];
            }
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PdBaryDir pdBaryDir) {
        if (this == pdBaryDir) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        for (int i = 0; i < pdMatrix.m_iSize; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < pdBaryDir.m_data.length; ++j) {
                int n = i;
                this.m_data[n] = this.m_data[n] + pdMatrix.m_data[i][j] * pdBaryDir.m_data[j];
            }
        }
    }

    public static PdVector getVector(PdVector pdVector, PdBaryDir pdBaryDir, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        int n = pdVector2.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        }
        double[] dArray = pdBaryDir.m_data;
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = dArray[0] * pdVector2.m_data[i] + dArray[1] * pdVector3.m_data[i] + dArray[2] * pdVector4.m_data[i];
        }
        return pdVector;
    }

    public static PdBaryDir getBaryDir(PdBaryDir pdBaryDir, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        return PdBaryDir.getBaryDir(pdBaryDir, pdVector, pdVector2, pdVector3, pdVector4, null);
    }

    public static PdBaryDir getBaryDir(PdBaryDir pdBaryDir, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        int n = pdVector2.getSize();
        if (pdVector5 == null) {
            pdVector5 = new PdVector(n);
        } else if (pdVector5.m_data.length != n) {
            pdVector5.setSize(n);
        }
        pdVector5.add(pdVector, pdVector2);
        PdBary pdBary = new PdBary(3);
        PdBary.getBary(pdBary, pdVector5, pdVector2, pdVector3, pdVector4);
        if (pdBaryDir == null) {
            pdBaryDir = new PdBaryDir(3);
        }
        pdBaryDir.m_data[0] = pdBary.m_data[0] - 1.0;
        pdBaryDir.m_data[1] = pdBary.m_data[1];
        pdBaryDir.m_data[2] = pdBary.m_data[2];
        return pdBaryDir;
    }

    public void sub(PdBary pdBary, PdBary pdBary2) {
        if (pdBary.m_elementInd != pdBary2.m_elementInd) {
            PsDebug.warning("Cannot substract points on different triangles.");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = pdBary.m_data[i] - pdBary2.m_data[i];
        }
        this.m_elementInd = pdBary.m_elementInd;
    }

    public void add(PdBaryDir pdBaryDir) {
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] + pdBaryDir.m_data[i];
        }
    }
}

