/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.object.PsDebug;

public abstract class P_Vector
implements Serializable {
    protected P_VectorAttrib m_attrib;

    public Object clone() {
        P_Vector p_Vector = null;
        try {
            p_Vector = (P_Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (p_Vector == null) {
            return null;
        }
        if (this.m_attrib != null) {
            p_Vector.m_attrib = (P_VectorAttrib)this.m_attrib.clone();
        }
        return p_Vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t" + super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("\t ******* P_Vector ***********\n");
        stringBuffer.append("\t Name Info: ");
        if (this.getName() != null) {
            stringBuffer.append("Name = " + this.getName() + "; ");
        }
        if (this.getDetail() != null) {
            stringBuffer.append("Detail = " + this.getDetail() + "; ");
        }
        if (this.getURL() != null) {
            stringBuffer.append("URL = " + this.getURL());
        }
        stringBuffer.append("\n\t Attr = (" + this.getBits() + ")\n");
        return stringBuffer.toString();
    }

    public String getDetail() {
        if (this.m_attrib == null) {
            return null;
        }
        return this.m_attrib.m_detail;
    }

    public void setDetail(String string) {
        if (this.m_attrib == null) {
            this.m_attrib = new P_VectorAttrib();
        }
        this.m_attrib.m_detail = string;
    }

    public String getName() {
        if (this.m_attrib == null) {
            return null;
        }
        return this.m_attrib.m_name;
    }

    public void setName(String string) {
        if (this.m_attrib == null) {
            this.m_attrib = new P_VectorAttrib();
        }
        this.m_attrib.m_name = string;
    }

    public String getURL() {
        if (this.m_attrib == null) {
            return null;
        }
        return this.m_attrib.m_URL;
    }

    public void setURL(String string) {
        if (this.m_attrib == null) {
            this.m_attrib = new P_VectorAttrib();
        }
        this.m_attrib.m_URL = string;
    }

    public long getBits() {
        if (this.m_attrib == null) {
            return 0L;
        }
        return this.m_attrib.m_bits;
    }

    public void setTag(int n) {
        if (n >= 64) {
            return;
        }
        if (this.m_attrib == null) {
            this.m_attrib = new P_VectorAttrib();
        }
        this.m_attrib.m_bits |= 1L << n;
    }

    public void clearTag(int n) {
        if (n >= 64 || this.m_attrib == null) {
            return;
        }
        this.m_attrib.m_bits &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean hasTag(int n) {
        if (this.m_attrib == null) {
            return false;
        }
        return (this.m_attrib.m_bits & 1L << n) != 0L;
    }

    public static P_Vector[][] clone(P_Vector[][] p_VectorArray) {
        if (p_VectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        P_Vector[][] p_VectorArray2 = (P_Vector[][])p_VectorArray.clone();
        for (int i = 0; i < p_VectorArray.length; ++i) {
            if (p_VectorArray[i] == null) continue;
            p_VectorArray2[i] = P_Vector.clone(p_VectorArray[i]);
        }
        return p_VectorArray2;
    }

    public static P_Vector[] clone(P_Vector[] p_VectorArray) {
        if (p_VectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        P_Vector[] p_VectorArray2 = (P_Vector[])p_VectorArray.clone();
        for (int i = 0; i < p_VectorArray.length; ++i) {
            if (p_VectorArray[i] == null) continue;
            p_VectorArray2[i] = (P_Vector)p_VectorArray[i].clone();
        }
        return p_VectorArray2;
    }

    public void copy(P_Vector p_Vector) {
        if (p_Vector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.m_attrib = p_Vector.m_attrib == null ? null : (P_VectorAttrib)p_Vector.m_attrib.clone();
    }

    public static void invert(Object[] objectArray, int n) {
        if (objectArray == null || n < 2) {
            return;
        }
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            objectArray[i] = objectArray[n - 1 - i];
            objectArray[n - 1 - i] = object;
        }
    }

    protected class P_VectorAttrib {
        protected long m_bits;
        protected String m_name;
        protected String m_detail;
        protected String m_URL;

        protected P_VectorAttrib() {
        }

        public Object clone() {
            P_VectorAttrib p_VectorAttrib = new P_VectorAttrib();
            p_VectorAttrib.m_bits = this.m_bits;
            p_VectorAttrib.m_name = this.m_name;
            p_VectorAttrib.m_detail = this.m_detail;
            p_VectorAttrib.m_URL = this.m_URL;
            return p_VectorAttrib;
        }
    }
}

