/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.expr;

import jv.number.PuComplex;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Variable;

class App1
extends Expr {
    private int m_rator;
    private Expr m_rand;

    protected App1(int n, Expr expr) {
        this.m_rator = n;
        this.m_rand = expr;
        this.setComplex(Expr.isComplex(n, this.m_rand));
    }

    public boolean contains(Variable variable) {
        return this.m_rand.contains(variable);
    }

    public double getValue() {
        if (this.m_rand.isComplex()) {
            PuComplex puComplex = this.m_rand.getComplexValue();
            switch (this.m_rator) {
                case 100: {
                    return puComplex.abs();
                }
                case 125: {
                    return puComplex.argPB();
                }
                case 129: {
                    return puComplex.im();
                }
                case 128: {
                    return puComplex.re();
                }
            }
            throw new RuntimeException("BUG: bad rator, not implemented for complex numbers");
        }
        double d = this.m_rand.getValue();
        switch (this.m_rator) {
            case 100: {
                return Math.abs(d);
            }
            case 125: {
                return 0.0;
            }
            case 101: {
                return Math.acos(d);
            }
            case 102: {
                return Math.asin(d);
            }
            case 103: {
                return Math.atan(d);
            }
            case 105: {
                return Math.ceil(d);
            }
            case 126: {
                return d;
            }
            case 106: {
                return Math.cos(d);
            }
            case 107: {
                return Math.exp(d);
            }
            case 108: {
                return Math.floor(d);
            }
            case 129: {
                return 0.0;
            }
            case 127: {
                if (d == 0.0) {
                    return 0.0;
                }
                return 1.0 / d;
            }
            case 109: {
                return Math.log(d);
            }
            case 110: {
                return -d;
            }
            case 128: {
                return d;
            }
            case 111: {
                return Math.round(d);
            }
            case 112: {
                return Math.sin(d);
            }
            case 113: {
                if (d <= 0.0) {
                    return 0.0;
                }
                return Math.sqrt(d);
            }
            case 114: {
                return Math.tan(d);
            }
            case 115: {
                return 1.0 / Math.tan(d);
            }
            case 104: {
                return Math.atan(1.0 / d);
            }
            case 116: {
                return (Math.exp(d) - Math.exp(-d)) / 2.0;
            }
            case 117: {
                return (Math.exp(d) + Math.exp(-d)) / 2.0;
            }
            case 118: {
                double d2 = Math.exp(d);
                double d3 = Math.exp(-d);
                return (d2 - d3) / (d2 + d3);
            }
            case 119: {
                double d4 = Math.exp(d);
                double d5 = Math.exp(-d);
                return (d4 + d5) / (d4 - d5);
            }
            case 120: {
                return Math.log(d + Math.sqrt(d * d + 1.0));
            }
            case 121: {
                return Math.log(d + Math.sqrt(d * d - 1.0));
            }
            case 122: {
                return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
            }
            case 123: {
                return Math.log((1.0 + d) / (d - 1.0)) / 2.0;
            }
            case 124: {
                if (d < 0.0) {
                    return -1.0;
                }
                if (d > 0.0) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        throw new RuntimeException("BUG: bad rator, not available for real numbers");
    }

    public PuComplex getComplexValue() {
        PuComplex puComplex = this.m_rand.getComplexValue();
        this.m_z.copy(puComplex);
        switch (this.m_rator) {
            case 105: {
                this.m_z.set(Math.ceil(this.m_z.re), Math.ceil(this.m_z.im));
                break;
            }
            case 126: {
                this.m_z.conj();
                break;
            }
            case 106: {
                this.m_z.cos();
                break;
            }
            case 107: {
                this.m_z.exp();
                break;
            }
            case 108: {
                this.m_z.set(Math.floor(this.m_z.re), Math.floor(this.m_z.im));
                break;
            }
            case 127: {
                this.m_z.inv();
                break;
            }
            case 109: {
                this.m_z.logPB();
                break;
            }
            case 110: {
                this.m_z.neg();
                break;
            }
            case 111: {
                this.m_z.set(Math.round(this.m_z.re), Math.round(this.m_z.im));
                break;
            }
            case 112: {
                this.m_z.sin();
                break;
            }
            case 113: {
                this.m_z.sqrt();
                break;
            }
            case 114: {
                this.m_z.tan();
                break;
            }
            case 115: {
                this.m_z.cot();
                break;
            }
            case 116: {
                this.m_z.sinh();
                break;
            }
            case 117: {
                this.m_z.cosh();
                break;
            }
            case 118: {
                this.m_z.tanh();
                break;
            }
            case 119: {
                this.m_z.coth();
                break;
            }
            default: {
                throw new RuntimeException("BUG: bad rator, not implemented for complex numbers");
            }
        }
        return this.m_z;
    }
}

