/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgMapleLoader
extends PgAbstractLoader {
    protected String[] m_axesLabels;
    protected String m_axesStyle;
    protected String m_lightModel;
    protected Vector m_lightColor;
    protected Vector m_lightPosition;
    protected Color m_sceneColor;
    protected double[] m_sceneOrientation;
    protected double m_sceneProjection;
    protected String m_sceneShading;
    protected String m_sceneScaling;
    protected PdVector[] m_sceneView;
    protected String m_sceneStyle;
    protected double m_sceneThickness = 0.0;
    protected String m_sceneTitle;
    protected String m_sceneTitleFont;
    protected Vector m_geomVec;
    protected Vector m_geomColor;
    protected Vector m_geomStyle;
    protected Vector m_geomThickness;
    protected Vector m_geomTitle;
    protected int m_numGeoms;
    protected int m_numKeys;
    private int m_numGeomStep;
    private Vector m_numGeomsPerStep;
    protected double m_transparency = -1.0;
    protected double m_roll = 0.0;

    public PgJvxSrc[][] getAnimations() {
        if (!this.isAnimation() || this.m_numGeomsPerStep == null) {
            return null;
        }
        int n = this.m_numGeomsPerStep.size();
        this.m_animArr = new PgJvxSrc[n][];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Integer n3 = (Integer)this.m_numGeomsPerStep.elementAt(i);
            int n4 = n3;
            this.m_animArr[i] = new PgJvxSrc[n4];
            for (int j = 0; j < n4; ++j) {
                this.m_animArr[i][j] = (PgJvxSrc)this.m_geomVec.elementAt(n2++);
            }
        }
        return this.m_animArr;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgMapleLoader pgMapleLoader = new PgMapleLoader();
        PgJvxSrc[] pgJvxSrcArray = pgMapleLoader.read(bufferedReader);
        if (pgJvxSrcArray != null) {
            for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                if (pgJvxSrcArray[i] == null || pgJvxSrcArray[i].getName() != null) continue;
                pgJvxSrcArray[i].setName(PsUtil.getFileBaseName(string) + "[" + i + "]");
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        Object object;
        this.m_bIsAnimation = false;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.m_geomVec = new Vector();
        this.m_numGeoms = 0;
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        if (this.m_numGeoms == 0) {
            PsDebug.warning("missing geometries");
            return null;
        }
        this.m_geomArr = new PgJvxSrc[this.m_numGeoms];
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = this.m_geomVec.elements();
        while (enumeration.hasMoreElements()) {
            this.m_geomArr[n3] = (PgJvxSrc)enumeration.nextElement();
            if (n2 == 0) {
                n2 = this.m_geomArr[n3].getDimOfVertices();
            } else if (n2 != this.m_geomArr[n3].getDimOfVertices()) {
                n2 = -1;
            }
            switch (this.m_geomArr[n3].getType()) {
                case 33: {
                    if (this.m_transparency != -1.0) {
                        this.m_geomArr[n3].setTransparency(this.m_transparency);
                        this.m_geomArr[n3].showTransparency(true);
                    }
                    this.m_geomArr[n3].assureNeighbours();
                    break;
                }
                case 32: {
                    break;
                }
                case 31: {
                    break;
                }
                case 30: {
                    this.m_geomArr[n3].showVertices(true);
                }
            }
            ++n3;
        }
        if (n2 != 2 && n2 != 3) {
            return this.m_geomArr;
        }
        this.m_displayOption = new PvDisplayOption();
        if (this.m_sceneTitle != null) {
            this.m_displayOption.setName(this.m_sceneTitle);
            this.m_displayOption.setTag(33);
        }
        boolean bl2 = this.m_sceneView != null;
        boolean bl3 = this.m_sceneScaling == null || this.m_sceneScaling.equalsIgnoreCase("UNCONSTRAINED");
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        if (bl2 || bl3) {
            object = new PdVector[this.m_numGeoms];
            PdVector[] pdVectorArray = new PdVector[this.m_numGeoms];
            n = 0;
            if (this.m_bIsAnimation && this.m_animArr != null) {
                for (n3 = 0; n3 < this.m_numKeys; ++n3) {
                    int n4 = this.m_animArr[n3].length;
                    for (int i = 0; i < n4; ++i) {
                        PdVector[] pdVectorArray2 = this.m_animArr[n3][i].getBounds();
                        if (pdVectorArray2 == null) continue;
                        object[n] = pdVectorArray2[0];
                        pdVectorArray[n] = pdVectorArray2[1];
                        ++n;
                    }
                }
            } else {
                for (n3 = 0; n3 < this.m_numGeoms; ++n3) {
                    PdVector[] pdVectorArray3 = this.m_geomArr[n3].getBounds();
                    if (pdVectorArray3 == null) continue;
                    object[n] = pdVectorArray3[0];
                    pdVectorArray[n] = pdVectorArray3[1];
                    ++n;
                }
            }
            if (n > 0) {
                PdVector.min(pdVector, (PdVector[])object, n);
                PdVector.max(pdVector2, pdVectorArray, n);
            } else {
                pdVector.setConstant(-10.0);
                pdVector2.setConstant(10.0);
            }
        }
        this.m_displayOption.setOption(35, bl3);
        this.m_displayOption.setOption(46, bl3);
        object = new PdVector(3);
        if (bl3) {
            ((PdVector)object).setConstant(1.0);
            double d = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                double d2 = !bl2 || this.m_sceneView[n3].getEntry(0) == Double.NEGATIVE_INFINITY ? pdVector2.m_data[n3] - pdVector.m_data[n3] : this.m_sceneView[n3].getEntry(1) - this.m_sceneView[n3].getEntry(0);
                if (Math.abs(d2) > 1.0E-10) {
                    ((PdVector)object).setEntry(n3, d2);
                }
                if (!(d2 > d)) continue;
                d = d2;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                ((PdVector)object).setEntry(n3, d / ((PdVector)object).getEntry(n3));
            }
            this.m_displayOption.setBoxRatio((PdVector)object);
        } else {
            this.m_displayOption.setBoxRatio(null);
        }
        boolean bl4 = bl2;
        if (bl4) {
            n = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.m_sceneView[n3].getEntry(0) > pdVector.m_data[n3] || this.m_sceneView[n3].getEntry(1) < pdVector2.m_data[n3]) {
                    n = 1;
                    continue;
                }
                this.m_sceneView[n3].setEntry(0, pdVector.m_data[n3]);
                this.m_sceneView[n3].setEntry(1, pdVector2.m_data[n3]);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_displayOption.setClipBounds(n3, this.m_sceneView[n3].m_data);
            }
            this.m_displayOption.setOption(36, n != 0);
        }
        this.m_displayOption.setBackgroundColor(Color.white);
        this.m_displayOption.setNumCameras(1);
        if (n2 == 2) {
            this.m_displayOption.setCameraProjection(0, 1);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setCameraPosition(0, new PdVector(0.0, 0.0, 1.0));
            this.m_displayOption.setCurrentCamera(1);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equalsIgnoreCase("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(6);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(6);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(3);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, true);
                this.m_displayOption.setAxesType(3);
            }
        } else if (n2 == 3) {
            PdVector pdVector3;
            double d = 0.0;
            if (this.m_sceneOrientation == null) {
                pdVector3 = new PdVector(0.5, 0.5, 0.7071);
            } else {
                pdVector3 = PgMapleLoader.getPosition(this.m_sceneOrientation[0], this.m_sceneOrientation[1]);
                if (this.m_sceneOrientation[1] == 0.0) {
                    d = 90.0 + this.m_sceneOrientation[0];
                } else if (this.m_sceneOrientation[1] == 180.0) {
                    d = 90.0 - this.m_sceneOrientation[0];
                } else if (this.m_sceneOrientation[1] < 0.0) {
                    d = 180.0;
                }
            }
            if (bl3) {
                for (int i = 0; i < 3; ++i) {
                    pdVector3.setEntry(i, pdVector3.getEntry(i) / ((PdVector)object).getEntry(i));
                }
            }
            this.m_displayOption.setCameraPosition(0, pdVector3);
            this.m_displayOption.setCameraProjection(0, 0);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setEnabledCameraClip(0, false);
            this.m_displayOption.setCameraFieldOfView(0, 4.0 * (this.m_sceneProjection - 1.0) * (this.m_sceneProjection - 1.0));
            this.m_displayOption.setCameraRoll(0, d);
            this.m_displayOption.setCurrentCamera(0);
            this.m_displayOption.setCameraNearClip(0, 0.0);
            this.m_displayOption.setCameraFarClip(0, 0.0);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equalsIgnoreCase("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(2);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(2);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(0);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, false);
                this.m_displayOption.setAxesType(-1);
            }
        }
        this.m_displayOption.setOption(15, false);
        int n5 = this.m_lightColor.size();
        if (n5 > 0 || this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
            this.m_displayOption.setLightingModel(1);
            int n6 = 0;
            double d = 0.2;
            if (this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
                if (this.m_lightModel.equalsIgnoreCase("LIGHT_1")) {
                    n6 = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_2")) {
                    n6 = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_3")) {
                    n6 = 3;
                    d = 0.5;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_4")) {
                    n6 = 1;
                    d = 0.6;
                }
            }
            int n7 = 0;
            this.m_displayOption.setNumLights(n5 + n6 + 1);
            this.m_displayOption.setLightName(n7, "Ambient");
            this.m_displayOption.setLightColor(n7, Color.white);
            this.m_displayOption.setLightIntensity(n7, d);
            this.m_displayOption.setLightType(n7, 0);
            this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(90.0, 0.0));
            this.m_displayOption.setLightReference(n7, 1);
            this.m_displayOption.setLightShading(n7, 1);
            ++n7;
            if (this.m_lightModel != null && !this.m_lightModel.equalsIgnoreCase("none")) {
                if (this.m_lightModel.equalsIgnoreCase("LIGHT_1")) {
                    this.m_displayOption.setLightName(n7, "Green");
                    this.m_displayOption.setLightColor(n7, Color.green);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(90.0, -45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Blue");
                    this.m_displayOption.setLightColor(n7, Color.blue);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(-45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Red");
                    this.m_displayOption.setLightColor(n7, Color.red);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(45.0, 90.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    ++n7;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_2")) {
                    this.m_displayOption.setLightName(n7, "Red");
                    this.m_displayOption.setLightColor(n7, Color.red);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(90.0, 45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Green");
                    this.m_displayOption.setLightColor(n7, Color.green);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Blue");
                    this.m_displayOption.setLightColor(n7, Color.blue);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(-45.0, 90.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    ++n7;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_3")) {
                    this.m_displayOption.setLightName(n7, "Blue");
                    this.m_displayOption.setLightColor(n7, Color.blue);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Green");
                    this.m_displayOption.setLightColor(n7, Color.green);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(45.0, 45.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    this.m_displayOption.setLightName(++n7, "Red");
                    this.m_displayOption.setLightColor(n7, Color.red);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(135.0, 0.0));
                    this.m_displayOption.setLightIntensity(n7, 0.9);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    ++n7;
                } else if (this.m_lightModel.equalsIgnoreCase("LIGHT_4")) {
                    this.m_displayOption.setLightName(n7, "Light-Grey");
                    this.m_displayOption.setLightColor(n7, Color.white);
                    this.m_displayOption.setLightPosition(n7, PgMapleLoader.getLightPosition(60.0, 85.0));
                    this.m_displayOption.setLightIntensity(n7, 0.8);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    ++n7;
                } else {
                    PsDebug.warning("unknown lighting model = " + this.m_lightModel);
                }
            }
            if (n5 > 0) {
                for (n3 = 0; n3 < n5; ++n3) {
                    Color color = (Color)this.m_lightColor.elementAt(n3);
                    this.m_displayOption.setLightName(n7, "Light[" + n7 + "] (" + PdColor.toString(color, ", ") + ")");
                    this.m_displayOption.setLightColor(n7, color);
                    this.m_displayOption.setLightPosition(n7, (PdVector)this.m_lightPosition.elementAt(n3));
                    this.m_displayOption.setLightIntensity(n7, 0.8);
                    this.m_displayOption.setLightReference(n7, 1);
                    this.m_displayOption.setLightShading(n7, 1);
                    this.m_displayOption.setLightType(n7, 1);
                    ++n7;
                }
            }
        } else {
            this.m_displayOption.setLightingModel(0);
        }
        this.m_displayOption.setOption(3, true);
        this.m_displayOption.setAxesLabel(this.m_axesLabels);
        if (this.m_displayOption.getAxesType() != -1) {
            this.m_displayOption.setNumRulers(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                boolean bl5;
                boolean bl6 = bl5 = this.m_axesLabels != null && this.m_axesLabels[n3] != null;
                if (bl5) {
                    this.m_displayOption.setRulerName(n3, this.m_axesLabels[n3]);
                }
                this.m_displayOption.showRulerName(n3, bl5);
                this.m_displayOption.setRulerMode(n3, 0);
                this.m_displayOption.showRuler(n3, true);
                this.m_displayOption.showRulerNumbers(n3, true);
                this.m_displayOption.showRulerHashingsNormal(n3, false);
                this.m_displayOption.showRulerHashingsUp(n3, false);
                this.m_displayOption.showRulerTicksMajor(n3, true);
                this.m_displayOption.showRulerTicksMinor(n3, true);
            }
        }
        return this.m_geomArr;
    }

    private static PdVector getPosition(double d, double d2) {
        PdVector pdVector = new PdVector(Math.cos(d *= Math.PI / 180) * Math.sin(d2 *= Math.PI / 180), Math.sin(d) * Math.sin(d2), Math.cos(d2));
        return pdVector;
    }

    private static PdVector getLightPosition(double d, double d2) {
        PdVector pdVector = new PdVector(Math.sin(d2 *= Math.PI / 180) * Math.sin(d *= Math.PI / 180), Math.cos(d), Math.cos(d2) * Math.sin(d));
        return pdVector;
    }

    protected static boolean makeElementColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumElements();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] < 1.0E-10)) continue;
            dArray[i] = 1.0;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            for (int j = 0; j < n; ++j) {
                float f = (float)((pdVector.m_data[j] - pdVectorArray[0].m_data[j]) / dArray[j]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[j] = f;
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(220, 78 + (int)(fArray[0] * 172.0f), 29 + (int)(fArray[1] * 200.0f));
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    protected static boolean makeElementColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumElements();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = PdColor.blend((double)(1.0f - f2), color, (double)f2, color2);
        }
        return true;
    }

    protected static boolean makeElementColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumElements();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureElementColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        Color[] colorArray = pgJvxSrc.getElementColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public static boolean makePolygonColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumPolygons();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] < 1.0E-10)) continue;
            dArray[i] = 1.0;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            for (int j = 0; j < n; ++j) {
                float f = (float)((pdVector.m_data[j] - pdVectorArray[0].m_data[j]) / dArray[j]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[j] = f;
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    protected static boolean makePolygonColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumPolygons();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n2);
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = PdColor.blend((double)(1.0f - f2), color, (double)f2, color2);
        }
        return true;
    }

    protected static boolean makePolygonColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumPolygons();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        int n3 = Math.min(2, n2 - 1);
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n2);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, pdVectorArray2, piVectorArray[i].m_data);
            float f2 = (float)((pdVector.m_data[n3] - pdVectorArray[0].m_data[n3]) / (double)f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public static boolean makeEdgeColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumEdges();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assurePolygonColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getPolygons();
        Color[] colorArray = pgJvxSrc.getPolygonColors();
        PdVector pdVector = new PdVector(n3);
        n = Math.min(n, n3 - 1);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] < 1.0E-10)) continue;
            dArray[i] = 1.0;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            pdVector.blend(0.5, pdVectorArray2[piVectorArray[i].m_data[0]], 0.5, pdVectorArray2[piVectorArray[i].m_data[1]]);
            for (int j = 0; j < n; ++j) {
                float f = (float)((pdVector.m_data[j] - pdVectorArray[0].m_data[j]) / dArray[j]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[j] = f;
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public static boolean makeVertexColorsFromXYZ(PgJvxSrc pgJvxSrc, int n, PdVector[] pdVectorArray) {
        int n2 = pgJvxSrc.getNumVertices();
        if (n2 == 0) {
            return true;
        }
        int n3 = pgJvxSrc.getDimOfVertices();
        if (n3 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (int i = 0; i < n3; ++i) {
            if (!(dArray[i] < 1.0E-10)) continue;
            dArray[i] = 1.0;
        }
        n = Math.min(n, n3);
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = (float)((pdVectorArray2[i].m_data[j] - pdVectorArray[0].m_data[j]) / dArray[j]);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray[j] = f;
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public static boolean makeVertexColorsFromZ(PgJvxSrc pgJvxSrc, Color color, Color color2, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumVertices();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            float f2 = (float)(pdVectorArray2[i].m_data[n3] - pdVectorArray[0].m_data[n3]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = PdColor.blend((double)(1.0f - f2), color, (double)f2, color2);
        }
        return true;
    }

    public static boolean makeVertexColorsFromZHue(PgJvxSrc pgJvxSrc, PdVector[] pdVectorArray) {
        int n = pgJvxSrc.getNumVertices();
        if (n == 0) {
            return true;
        }
        int n2 = pgJvxSrc.getDimOfVertices();
        if (n2 == 0) {
            return false;
        }
        pgJvxSrc.assureVertexColors();
        PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
        Color[] colorArray = pgJvxSrc.getVertexColors();
        int n3 = Math.min(2, n2 - 1);
        float f = (float)(pdVectorArray[1].m_data[n3] - pdVectorArray[0].m_data[n3]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < n; ++i) {
            float f2 = (float)(pdVectorArray2[i].m_data[n3] - pdVectorArray[0].m_data[n3]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parse(BufferedReader bufferedReader) {
        block17: {
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(40);
            streamTokenizer.ordinaryChar(41);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.ordinaryChar(95);
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.commentChar(35);
            streamTokenizer.parseNumbers();
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            streamTokenizer.quoteChar(96);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            int n = 0;
            int n2 = 0;
            this.m_sceneShading = "XYZ";
            this.m_sceneProjection = 1.0;
            try {
                block12: while (true) {
                    switch (streamTokenizer.nextToken()) {
                        default: {
                            throw new IOException("parsing broke abnormally");
                        }
                        case -1: {
                            PsDebug.notify("\t EOF token = " + streamTokenizer.sval);
                            if (n != 0) {
                                throw new IOException("'}' missing");
                            }
                            if (n2 != 0) {
                                throw new IOException("']' missing");
                            }
                            break block17;
                        }
                        case -3: {
                            if ("PLOT".equalsIgnoreCase(streamTokenizer.sval)) {
                                this.m_geomVec = this.readGraphics(streamTokenizer, 2, this.m_geomVec);
                                if (this.m_geomVec != null) continue block12;
                                throw new IOException("failed reading PLOT");
                            }
                            if ("PLOT3D".equalsIgnoreCase(streamTokenizer.sval)) {
                                this.m_geomVec = this.readGraphics(streamTokenizer, 3, this.m_geomVec);
                                if (this.m_geomVec != null) continue block12;
                                throw new IOException("failed reading PLOT3D");
                            }
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval);
                            continue block12;
                        }
                        case 44: {
                            continue block12;
                        }
                        case 123: {
                            ++n;
                            continue block12;
                        }
                        case 125: {
                            if (--n >= 0) continue block12;
                            throw new IOException("More '}' than '{'");
                        }
                        case 59: {
                            continue block12;
                        }
                        case 91: {
                            ++n2;
                            continue block12;
                        }
                        case 93: {
                            if (--n2 < 0) throw new IOException("More ']' than '['");
                            continue block12;
                        }
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("Exception thrown = " + iOException.toString() + "\n\tparsing broke anormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype);
                return false;
            }
        }
        PsDebug.notify("... finished");
        return true;
    }

    private boolean parsePlotOptions(StreamTokenizer streamTokenizer, int n) throws IOException {
        this.m_geomColor.setSize(n + 1);
        this.m_geomStyle.setSize(n + 1);
        this.m_geomThickness.setSize(n + 1);
        this.m_geomTitle.setSize(n + 1);
        if (streamTokenizer.sval == null) {
            return false;
        }
        if ("COLOUR".equalsIgnoreCase(streamTokenizer.sval) || "COLOR".equalsIgnoreCase(streamTokenizer.sval)) {
            Color[] colorArray = this.parseColor(streamTokenizer, n);
            if (colorArray != null) {
                this.m_geomColor.setElementAt(colorArray, n);
            }
        } else if ("STYLE".equalsIgnoreCase(streamTokenizer.sval)) {
            this.m_geomStyle.setElementAt(PgMapleLoader.parseString(streamTokenizer, "STYLE"), n);
        } else if ("THICKNESS".equalsIgnoreCase(streamTokenizer.sval)) {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d = PuDouble.parseDouble(streamTokenizer);
            this.m_geomThickness.setElementAt(new Double(d), n);
            streamTokenizer.nextToken();
        } else if ("TITLE".equalsIgnoreCase(streamTokenizer.sval)) {
            streamTokenizer.nextToken();
            this.m_geomTitle.setElementAt(PgMapleLoader.parseString(streamTokenizer), n);
            streamTokenizer.nextToken();
        } else if ("SCALING".equalsIgnoreCase(streamTokenizer.sval)) {
            this.m_sceneScaling = PgMapleLoader.parseString(streamTokenizer, "SCALING");
        } else {
            return false;
        }
        streamTokenizer.nextToken();
        return true;
    }

    private void addGeometry(PgJvxSrc pgJvxSrc) {
        ++this.m_numGeomStep;
        ++this.m_numGeoms;
        this.m_geomVec.addElement(pgJvxSrc);
        this.m_geomColor.setSize(this.m_numGeoms);
        this.m_geomStyle.setSize(this.m_numGeoms);
        this.m_geomThickness.setSize(this.m_numGeoms);
        this.m_geomTitle.setSize(this.m_numGeoms);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Vector readGraphics(StreamTokenizer var1_1, int var2_2, Vector var3_3) throws IOException {
        var4_4 = null;
        var5_5 = null;
        var7_6 = "";
        var8_7 = new Vector<PdVector>();
        var9_8 = new Vector<PiVector>();
        var10_9 = new Vector<PiVector>();
        this.m_geomColor = new Vector<E>();
        this.m_geomStyle = new Vector<E>();
        this.m_geomThickness = new Vector<E>();
        this.m_geomTitle = new Vector<E>();
        this.m_lightColor = new Vector<E>();
        this.m_lightPosition = new Vector<E>();
        var11_10 = null;
        var12_11 = -1.0;
        var14_12 = 0;
        var15_13 = 0;
        do {
            var1_1.nextToken();
            if (var1_1.ttype == 41) {
                --var14_12;
                continue;
            }
            if (var1_1.ttype == 40) {
                ++var14_12;
                continue;
            }
            if (var1_1.ttype == 91) {
                ++var15_13;
                continue;
            }
            if (var1_1.ttype == 93) {
                --var15_13;
                if (!this.isAnimation()) continue;
                ++this.m_numKeys;
                this.m_numGeomsPerStep.addElement(new Integer(this.m_numGeomStep));
                this.m_numGeomStep = 0;
                continue;
            }
            if (var1_1.ttype == 44) continue;
            if (var1_1.ttype != -3) {
                throw new IOException("Graphics primitive identifyer expected");
            }
            if ("POLYGONS".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                var18_30 = 0;
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if (var1_1.ttype == 91) {
                        var19_37 = 0;
                        var1_1.nextToken();
                        while (var1_1.ttype != 93) {
                            var17_23 = PgMapleLoader.parsePoint(var1_1, var2_2);
                            var8_7.addElement(var17_23);
                            ++var19_37;
                            var1_1.nextToken();
                        }
                        var16_15 = new PiVector(var19_37);
                        for (var20_38 = 0; var20_38 < var19_37; ++var20_38) {
                            var16_15.setEntry(var20_38, var18_30 + var20_38);
                        }
                        var18_30 += var19_37;
                        var9_8.addElement(var16_15);
                    } else if ("Array".equalsIgnoreCase(var1_1.sval) || "hfarray".equalsIgnoreCase(var1_1.sval)) {
                        while ("Array".equalsIgnoreCase(var1_1.sval)) {
                            var1_1.nextToken();
                            var1_1.nextToken();
                            PgMapleLoader.parseRange(var1_1);
                            var1_1.nextToken();
                            PgMapleLoader.parseRange(var1_1);
                            var1_1.nextToken();
                            var19_37 = 0;
                            var1_1.nextToken();
                            while (var1_1.ttype != 93) {
                                var17_23 = PgMapleLoader.parsePoint(var1_1, var2_2);
                                var8_7.addElement(var17_23);
                                ++var19_37;
                                var1_1.nextToken();
                            }
                            var1_1.nextToken();
                            while (var1_1.ttype != 41) {
                                var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                                var1_1.nextToken();
                            }
                            var16_15 = new PiVector(var19_37);
                            for (var20_38 = 0; var20_38 < var19_37; ++var20_38) {
                                var16_15.setEntry(var20_38, var18_30 + var20_38);
                            }
                            var18_30 += var19_37;
                            var9_8.addElement(var16_15);
                        }
                    } else if (var1_1.ttype != 44) {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                if (var9_8.size() == 0) continue;
                var5_5 = new PgJvxSrc();
                var5_5.setType(33);
                var5_5.setDimOfVertices(var2_2);
                var5_5.setNumVertices(var8_7.size());
                var6_14 = 0;
                var20_39 = var8_7.elements();
                while (var20_39.hasMoreElements()) {
                    var5_5.setVertex(var6_14++, (PdVector)var20_39.nextElement());
                }
                var8_7.removeAllElements();
                var5_5.setDimOfElements(-1);
                var5_5.setNumElements(var9_8.size());
                var6_14 = 0;
                var20_39 = var9_8.elements();
                while (var20_39.hasMoreElements()) {
                    var5_5.setElement(var6_14++, (PiVector)var20_39.nextElement());
                }
                var9_8.removeAllElements();
                this.addGeometry(var5_5);
                continue;
            }
            if ("CURVES".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                var18_31 = 0;
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if (var1_1.ttype == 91) {
                        var19_37 = 0;
                        var1_1.nextToken();
                        while (var1_1.ttype != 93) {
                            var17_24 = PgMapleLoader.parsePoint(var1_1, var2_2);
                            var8_7.addElement(var17_24);
                            ++var19_37;
                            var1_1.nextToken();
                        }
                        var16_16 = new PiVector(var19_37);
                        for (var20_40 = 0; var20_40 < var19_37; ++var20_40) {
                            var16_16.setEntry(var20_40, var18_31 + var20_40);
                        }
                        var18_31 += var19_37;
                        var10_9.addElement(var16_16);
                    } else if ("Array".equalsIgnoreCase(var1_1.sval)) {
                        var1_1.nextToken();
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        var19_37 = 0;
                        var1_1.nextToken();
                        while (var1_1.ttype != 93) {
                            var17_24 = PgMapleLoader.parsePoint(var1_1, var2_2);
                            var8_7.addElement(var17_24);
                            ++var19_37;
                            var1_1.nextToken();
                        }
                        var1_1.nextToken();
                        while (var1_1.ttype != 41) {
                            var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                            var1_1.nextToken();
                        }
                        var16_16 = new PiVector(var19_37);
                        for (var20_40 = 0; var20_40 < var19_37; ++var20_40) {
                            var16_16.setEntry(var20_40, var18_31 + var20_40);
                        }
                        var18_31 += var19_37;
                        var10_9.addElement(var16_16);
                    } else if ("Matrix".equalsIgnoreCase(var1_1.sval)) {
                        var1_1.nextToken();
                        var1_1.nextToken();
                        var20_40 = (int)PgMapleLoader.parseDouble(var1_1);
                        var19_37 = 0;
                        var1_1.nextToken();
                        var2_2 = (int)PgMapleLoader.parseDouble(var1_1);
                        var1_1.nextToken();
                        var1_1.nextToken();
                        for (var21_48 = 0; var21_48 < var20_40; ++var21_48) {
                            var17_24 = PgMapleLoader.parsePoint(var1_1, var2_2);
                            var8_7.addElement(var17_24);
                            ++var19_37;
                            var1_1.nextToken();
                        }
                        var1_1.nextToken();
                        while (var1_1.ttype != 41) {
                            var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                            var1_1.nextToken();
                        }
                        var16_16 = new PiVector(var19_37);
                        for (var21_48 = 0; var21_48 < var19_37; ++var21_48) {
                            var16_16.setEntry(var21_48, var18_31 + var21_48);
                        }
                        var18_31 += var19_37;
                        var10_9.addElement(var16_16);
                    } else {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                var5_5 = new PgJvxSrc();
                var5_5.setType(32);
                var5_5.setDimOfVertices(var2_2);
                var5_5.setNumVertices(var8_7.size());
                var6_14 = 0;
                var20_41 = var8_7.elements();
                while (var20_41.hasMoreElements()) {
                    var5_5.setVertex(var6_14++, (PdVector)var20_41.nextElement());
                }
                var8_7.removeAllElements();
                var5_5.setDimOfPolygons(-1);
                var5_5.setNumPolygons(var10_9.size());
                var6_14 = 0;
                var20_41 = var10_9.elements();
                while (var20_41.hasMoreElements()) {
                    var5_5.setPolygon(var6_14++, (PiVector)var20_41.nextElement());
                }
                var10_9.removeAllElements();
                this.addGeometry(var5_5);
                continue;
            }
            if ("POINTS".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if (var1_1.ttype == 91) {
                        var16_17 = PgMapleLoader.parsePoint(var1_1, var2_2);
                        var8_7.addElement(var16_17);
                    } else {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                var5_5 = new PgJvxSrc();
                var5_5.setType(30);
                var5_5.setDimOfVertices(var2_2);
                var5_5.setNumVertices(var8_7.size());
                var6_14 = 0;
                var17_25 = var8_7.elements();
                while (var17_25.hasMoreElements()) {
                    var5_5.setVertex(var6_14++, (PdVector)var17_25.nextElement());
                }
                var8_7.removeAllElements();
                this.addGeometry(var5_5);
                continue;
            }
            if ("TEXT".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                var16_18 = null;
                var17_26 = null;
                var18_32 = 1;
                var19_37 = 1;
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if (var1_1.ttype == 91) {
                        var16_18 = PgMapleLoader.parsePoint(var1_1, var2_2);
                        var8_7.addElement(var16_18);
                        var1_1.nextToken();
                        if (var1_1.nextToken() == -3 || var1_1.ttype == 34 || var1_1.ttype == 39 || var1_1.ttype == 96) {
                            var17_26 = var1_1.sval;
                            var16_18.setName(var17_26);
                        }
                    } else if (var1_1.ttype == 34 || var1_1.ttype == 39 || var1_1.ttype == 96) {
                        var1_1.nextToken();
                        if (var16_18 != null) {
                            var16_18.setName(var1_1.sval);
                        } else {
                            PsDebug.warning("text position must occur before label, line = " + var1_1.lineno());
                        }
                    } else if (var1_1.ttype == -3 && var1_1.sval.startsWith("ALIGN")) {
                        var1_1.nextToken();
                        if (var1_1.sval.equalsIgnoreCase("ALIGNABOVE")) {
                            var19_37 = 0;
                        } else if (var1_1.sval.equalsIgnoreCase("ALIGNBELOW")) {
                            var19_37 = 2;
                        } else if (var1_1.sval.equalsIgnoreCase("ALIGNLEFT")) {
                            var18_32 = 2;
                        } else if (var1_1.sval.equalsIgnoreCase("ALIGNRIGHT")) {
                            var18_32 = 0;
                        }
                    } else {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                var5_5 = new PgJvxSrc();
                var5_5.setType(30);
                var5_5.setDimOfVertices(var2_2);
                var5_5.setNumVertices(var8_7.size());
                var6_14 = 0;
                var20_42 /* !! */  = var8_7.elements();
                while (var20_42 /* !! */ .hasMoreElements()) {
                    var5_5.setVertex(var6_14++, (PdVector)var20_42 /* !! */ .nextElement());
                }
                var8_7.removeAllElements();
                if (var17_26 != null) {
                    var5_5.setName(var17_26);
                    var5_5.setLabelAttribute(0, 4, 4, var18_32, var19_37, 3);
                    if (this.m_geomColor.size() > this.m_numGeoms) {
                        var20_42 /* !! */  = this.m_geomColor.elementAt(this.m_numGeoms);
                        var21_49 = null;
                        if (var20_42 /* !! */  != null && var20_42 /* !! */  instanceof Color[] && (var22_52 = (Color[])var20_42 /* !! */ ).length == 1) {
                            var21_49 = var22_52[0];
                        }
                        if (var21_49 != null) {
                            var5_5.setLabelColor(5, var21_49);
                            var5_5.setLabelColor(0, var21_49);
                        }
                    }
                }
                var5_5.showIndices(true);
                var5_5.setGlobalVertexSize(0.0);
                this.addGeometry(var5_5);
                continue;
            }
            if ("GRID".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                var16_19 = 0;
                var17_27 = 0;
                var18_33 = 0.0;
                var20_43 = 0.0;
                var22_53 = 0.0;
                var24_54 = 0.0;
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if (var1_1.ttype == -2) {
                        var26_56 /* !! */  = PgMapleLoader.parseRange(var1_1);
                        var18_33 = var26_56 /* !! */ [0];
                        var20_43 = var26_56 /* !! */ [1];
                        var1_1.nextToken();
                        var26_56 /* !! */  = PgMapleLoader.parseRange(var1_1);
                        var22_53 = var26_56 /* !! */ [0];
                        var24_54 = var26_56 /* !! */ [1];
                    } else if ("Array".equalsIgnoreCase(var1_1.sval) || "hfarray".equalsIgnoreCase(var1_1.sval)) {
                        var1_1.nextToken();
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        var26_56 /* !! */  = PgMapleLoader.parse2ArrayOfDoubles(var1_1, var8_7);
                        if (var26_56 /* !! */  != null) {
                            var16_19 = (int)var26_56 /* !! */ [0];
                            var17_27 = (int)var26_56 /* !! */ [1];
                        }
                        var1_1.nextToken();
                        while (var1_1.ttype != 41) {
                            var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                            var1_1.nextToken();
                        }
                    } else if (var1_1.ttype == 91) {
                        var26_56 /* !! */  = PgMapleLoader.parse2ArrayOfDoubles(var1_1, var8_7);
                        if (var26_56 /* !! */  != null) {
                            var16_19 = (int)var26_56 /* !! */ [0];
                            var17_27 = (int)var26_56 /* !! */ [1];
                        }
                    } else {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                if (var16_19 == 0 || var17_27 == 0) continue;
                var6_14 = 0;
                var5_5 = new PgJvxSrc();
                var5_5.setType(33);
                var5_5.setDimOfVertices(3);
                var5_5.setNumVertices(var16_19 * var17_27);
                var26_57 = (var20_43 - var18_33) / (double)(var16_19 - 1);
                var28_59 = (var24_54 - var22_53) / (double)(var17_27 - 1);
                for (var30_61 = 0; var30_61 < var16_19; ++var30_61) {
                    for (var31_62 = 0; var31_62 < var17_27; ++var31_62) {
                        var32_63 = (Double)var8_7.elementAt(var6_14);
                        var5_5.getVertex(var6_14++).set(var18_33 + (double)var30_61 * var26_57, var22_53 + (double)var31_62 * var28_59, var32_63);
                    }
                }
                var8_7.removeAllElements();
                var5_5.setDimOfElements(4);
                var5_5.setNumElements((var16_19 - 1) * (var17_27 - 1));
                var5_5.assureNeighbours();
                var6_14 = 0;
                var30_60 = var5_5.getNeighbours();
                for (var31_62 = 0; var31_62 < var16_19 - 1; ++var31_62) {
                    for (var32_64 = 0; var32_64 < var17_27 - 1; ++var32_64) {
                        if (var31_62 < var16_19 - 2) {
                            var30_60[var6_14].m_data[0] = var6_14 + var17_27 - 1;
                        }
                        if (var32_64 < var17_27 - 2) {
                            var30_60[var6_14].m_data[1] = var6_14 + 1;
                        }
                        if (var31_62 > 0) {
                            var30_60[var6_14].m_data[2] = var6_14 - var17_27 + 1;
                        }
                        if (var32_64 > 0) {
                            var30_60[var6_14].m_data[3] = var6_14 - 1;
                        }
                        var5_5.getElement(var6_14++).set(var31_62 * var17_27 + var32_64, (var31_62 + 1) * var17_27 + var32_64, (var31_62 + 1) * var17_27 + var32_64 + 1, var31_62 * var17_27 + var32_64 + 1);
                    }
                }
                if (this.m_geomTitle.elementAt(this.m_numGeoms) == null) {
                    this.m_geomTitle.setElementAt("Grid[" + this.m_numGeoms + "]", this.m_numGeoms);
                }
                this.addGeometry(var5_5);
                continue;
            }
            if ("MESH".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                var16_20 = 0;
                var17_28 = 0;
                while (var1_1.ttype != 41) {
                    var1_1.nextToken();
                    var1_1.pushBack();
                    if (this.parsePlotOptions(var1_1, this.m_numGeoms)) continue;
                    if ("Array".equalsIgnoreCase(var1_1.sval) || "hfarray".equalsIgnoreCase(var1_1.sval)) {
                        var1_1.nextToken();
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        PgMapleLoader.parseRange(var1_1);
                        var1_1.nextToken();
                        var18_34 = PgMapleLoader.parse2ArrayOfPoints(var1_1, var8_7, var2_2);
                        if (var18_34 != null) {
                            var16_20 = var18_34[0];
                            var17_28 = var18_34[1];
                        }
                        var1_1.nextToken();
                        while (var1_1.ttype != 41) {
                            var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                            var1_1.nextToken();
                        }
                    } else if (var1_1.ttype == 91) {
                        var18_34 = PgMapleLoader.parse2ArrayOfPoints(var1_1, var8_7, var2_2);
                        if (var18_34 != null) {
                            var16_20 = var18_34[0];
                            var17_28 = var18_34[1];
                        }
                    } else {
                        var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                    }
                    var1_1.nextToken();
                }
                if (var16_20 == 0 || var17_28 == 0) continue;
                var5_5 = new PgJvxSrc();
                var5_5.setType(33);
                var5_5.setDimOfVertices(var2_2);
                var5_5.setNumVertices(var8_7.size());
                var6_14 = 0;
                var18_35 = var8_7.elements();
                while (var18_35.hasMoreElements()) {
                    var5_5.setVertex(var6_14++, (PdVector)var18_35.nextElement());
                }
                var8_7.removeAllElements();
                var5_5.setDimOfElements(4);
                var5_5.setNumElements((var16_20 - 1) * (var17_28 - 1));
                var5_5.assureNeighbours();
                var6_14 = 0;
                var18_35 = var5_5.getNeighbours();
                for (var19_37 = 0; var19_37 < var16_20 - 1; ++var19_37) {
                    for (var20_44 = 0; var20_44 < var17_28 - 1; ++var20_44) {
                        if (var19_37 < var16_20 - 2) {
                            var18_35[var6_14].m_data[0] = var6_14 + var17_28 - 1;
                        }
                        if (var20_44 < var17_28 - 2) {
                            var18_35[var6_14].m_data[1] = var6_14 + 1;
                        }
                        if (var19_37 > 0) {
                            var18_35[var6_14].m_data[2] = var6_14 - var17_28 + 1;
                        }
                        if (var20_44 > 0) {
                            var18_35[var6_14].m_data[3] = var6_14 - 1;
                        }
                        var5_5.getElement(var6_14++).set(var19_37 * var17_28 + var20_44, (var19_37 + 1) * var17_28 + var20_44, (var19_37 + 1) * var17_28 + var20_44 + 1, var19_37 * var17_28 + var20_44 + 1);
                    }
                }
                if (this.m_geomTitle.elementAt(this.m_numGeoms) == null) {
                    this.m_geomTitle.setElementAt("Mesh[" + this.m_numGeoms + "]", this.m_numGeoms);
                }
                this.addGeometry(var5_5);
                continue;
            }
            if ("ISOSURFACE".equalsIgnoreCase(var1_1.sval)) {
                PsDebug.warning("JavaView can not parse ISOSURFACE plot yet, line = " + var1_1.lineno());
                var1_1.pushBack();
                var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
                continue;
            }
            if ("ANIMATE".equalsIgnoreCase(var1_1.sval)) {
                this.m_bIsAnimation = true;
                this.m_numGeomsPerStep = new Vector<E>();
                continue;
            }
            if ("AXESLABELS".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_axesLabels = PgMapleLoader.parseAxesLabels(var1_1);
                continue;
            }
            if ("AXESSTYLE".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_axesStyle = PgMapleLoader.parseString(var1_1, "AXESSTYLE");
                continue;
            }
            if ("COLOR".equalsIgnoreCase(var1_1.sval) || "COLOUR".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                var16_21 = this.parseColor(var1_1, -1);
                if (var16_21 != null && var16_21.length == 1) {
                    this.m_sceneColor = var16_21[0];
                    continue;
                }
                ** if (var16_21 != null) goto lbl632
            }
            if ("LIGHT".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                PgMapleLoader.parseLight(var1_1, this.m_lightColor, this.m_lightPosition);
                continue;
            }
            if ("LIGHTMODEL".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_lightModel = PgMapleLoader.parseString(var1_1, "LIGHTMODEL");
                continue;
            }
            if ("ORIENTATION".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneOrientation = PgMapleLoader.parseOrientation(var1_1);
                continue;
            }
            if ("PROJECTION".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneProjection = this.parseProjection(var1_1);
                continue;
            }
            if ("SCALING".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneScaling = PgMapleLoader.parseString(var1_1, "SCALING");
                continue;
            }
            if ("SHADING".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneShading = PgMapleLoader.parseString(var1_1, "SHADING");
                continue;
            }
            if ("STYLE".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneStyle = PgMapleLoader.parseString(var1_1, "STYLE");
                continue;
            }
            if ("SYMBOL".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                var11_10 = PgMapleLoader.parseString(var1_1, "SYMBOL");
                var12_11 = PuDouble.parseDouble(var1_1);
                var1_1.nextToken();
                continue;
            }
            if ("THICKNESS".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                this.m_sceneThickness = PuDouble.parseDouble(var1_1);
                var1_1.nextToken();
                continue;
            }
            if ("TITLE".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                this.m_sceneTitle = PgMapleLoader.parseString(var1_1);
                var1_1.nextToken();
                continue;
            }
            if ("TITLEFONT".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                this.m_sceneTitleFont = PgMapleLoader.parseString(var1_1, "TITLEFONT");
                continue;
            }
            if ("TRANSPARENCY".equalsIgnoreCase(var1_1.sval)) {
                var1_1.nextToken();
                this.m_transparency = PuDouble.parseDouble(var1_1);
                var1_1.nextToken();
                continue;
            }
            if ("VIEW".equalsIgnoreCase(var1_1.sval)) {
                var1_1.pushBack();
                var4_4 = PgMapleLoader.parseView(var1_1);
                continue;
            }
            var1_1.pushBack();
            var7_6 = var7_6 + PgMapleLoader.parseUnknown(var1_1);
lbl-1000:
            // 1 sources

            {
                // empty if block
            }
lbl632:
            // 36 sources

        } while (var14_12 > 0);
        var16_22 = var3_3.size();
        var17_29 = this.m_sceneShading != null;
        var18_36 = null;
        if (var17_29) {
            var18_36 = PdVector.realloc(null, 2, 3);
            var18_36[0].setConstant(1.7976931348623157E308);
            var18_36[1].setConstant(-Infinity);
            var19_37 = 0;
            for (var20_45 = 0; var20_45 < var16_22; ++var20_45) {
                var5_5 = (PgJvxSrc)var3_3.elementAt(var20_45);
                if (var5_5 == null || (var21_50 = var5_5.getAmbientBounds()) == null) continue;
                var18_36[0].min(var21_50[0]);
                var18_36[1].max(var21_50[1]);
                ++var19_37;
            }
            if (var19_37 == 0) {
                var17_29 = false;
            }
        }
        for (var19_37 = 0; var19_37 < var16_22; ++var19_37) {
            var5_5 = (PgJvxSrc)var3_3.elementAt(var19_37);
            if (var5_5 == null) continue;
            var20_46 = (String)this.m_geomTitle.elementAt(var19_37);
            if (var20_46 == null || !var20_46.startsWith("Mesh") && !var20_46.startsWith("Grid")) {
                if (var20_46 != null) {
                    var5_5.showName(true);
                } else {
                    var20_46 = this.m_sceneTitle != null && var16_22 == 1 ? this.m_sceneTitle : (var5_5.getType() == 33 ? "ElementSet[" + var19_37 + "]" : (var5_5.getType() == 32 ? "PolygonSet[" + var19_37 + "]" : (var5_5.getType() == 31 ? "Polygon[" + var19_37 + "]" : (var5_5.getType() == 30 ? "PointSet[" + var19_37 + "]" : "Geometry[" + var19_37 + "]"))));
                }
            }
            var5_5.setName(var20_46);
            var21_51 = this.m_geomColor.elementAt(var19_37);
            var22_52 = null;
            var23_65 = null;
            var24_55 = null;
            if (var21_51 != null) {
                if (var21_51 instanceof String) {
                    var24_55 = (String)var21_51;
                } else {
                    var22_52 = (Color[])var21_51;
                    if (var22_52.length == 1) {
                        var23_65 = var22_52[0];
                    }
                }
            } else {
                var23_65 = this.m_sceneColor;
            }
            if (var24_55 == null && var17_29 && var5_5.getDimOfVertices() == 3) {
                var24_55 = this.m_sceneShading;
            }
            if (var22_52 != null && var22_52.length > 1) {
                if (var5_5.getType() == 33) {
                    if (var22_52.length == var5_5.getNumVertices()) {
                        var5_5.setVertexColors(var22_52);
                        var5_5.showVertexColors(true);
                        var5_5.showElementColorFromVertices(true);
                        var5_5.showElementColors(true);
                    } else if (var22_52.length == var5_5.getNumElements()) {
                        var5_5.setElementColors(var22_52);
                        var5_5.showElementColors(true);
                    }
                } else if (var5_5.getType() == 32) {
                    var5_5.setPolygonColors(var22_52);
                    var5_5.showPolygonColors(true);
                } else if (var5_5.getType() == 31) {
                    var5_5.setPolygonColors(var22_52);
                    var5_5.showEdgeColors(true);
                } else if (var5_5.getType() == 30) {
                    var5_5.setVertexColors(var22_52);
                    var5_5.showVertexColors(true);
                }
            } else if (var23_65 != null) {
                if (var5_5.getType() == 33) {
                    var5_5.setGlobalElementColor(var23_65);
                } else if (var5_5.getType() == 32) {
                    var5_5.setGlobalPolygonColor(var23_65);
                } else if (var5_5.getType() == 31) {
                    var5_5.setGlobalEdgeColor(var23_65);
                } else if (var5_5.getType() == 30) {
                    var5_5.setGlobalVertexColor(var23_65);
                }
            } else if (var24_55 != null) {
                var5_5.showSmoothElementColors(true);
                if (var5_5.getType() == 33) {
                    if (var24_55.equalsIgnoreCase("NONE")) {
                        var5_5.setGlobalElementColor(Color.white);
                        var5_5.showSmoothElementColors(false);
                    } else if (var24_55.equalsIgnoreCase("XYZ") || var24_55.equalsIgnoreCase("XYZSHADING")) {
                        PgMapleLoader.makeElementColorsFromXYZ(var5_5, 3, var18_36);
                        var5_5.showElementColors(true);
                    } else if (var24_55.equalsIgnoreCase("XY") || var24_55.equalsIgnoreCase("XYSHADING")) {
                        PgMapleLoader.makeElementColorsFromXYZ(var5_5, 2, var18_36);
                        var5_5.showElementColors(true);
                    } else if (var24_55.equalsIgnoreCase("Z") || var24_55.equalsIgnoreCase("ZSHADING")) {
                        PgMapleLoader.makeElementColorsFromZ(var5_5, Color.blue, Color.red, var18_36);
                        var5_5.showElementColors(true);
                    } else if (var24_55.equalsIgnoreCase("ZHUE")) {
                        PgMapleLoader.makeElementColorsFromZHue(var5_5, var18_36);
                        var5_5.showElementColors(true);
                    } else if (var24_55.equalsIgnoreCase("ZGREYSCALE") || var24_55.equalsIgnoreCase("ZGRAYSCALE")) {
                        PgMapleLoader.makeElementColorsFromZ(var5_5, Color.black, Color.white, var18_36);
                        var5_5.showElementColors(true);
                    } else {
                        PsDebug.warning("Scene shading = " + var24_55 + " is not supported yet");
                    }
                } else if (var5_5.getType() == 32) {
                    if (var24_55.equalsIgnoreCase("NONE")) {
                        var5_5.setGlobalPolygonColor(Color.black);
                        var5_5.showSmoothElementColors(false);
                    } else if (var24_55.equalsIgnoreCase("XYZ") || var24_55.equalsIgnoreCase("XYZSHADING")) {
                        PgMapleLoader.makePolygonColorsFromXYZ(var5_5, 3, var18_36);
                        var5_5.showPolygonColors(true);
                        PgMapleLoader.makeVertexColorsFromXYZ(var5_5, 3, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("XY") || var24_55.equalsIgnoreCase("XYSHADING")) {
                        PgMapleLoader.makePolygonColorsFromXYZ(var5_5, 2, var18_36);
                        var5_5.showPolygonColors(true);
                        PgMapleLoader.makeVertexColorsFromXYZ(var5_5, 2, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("Z") || var24_55.equalsIgnoreCase("ZSHADING")) {
                        PgMapleLoader.makePolygonColorsFromZ(var5_5, Color.blue, Color.red, var18_36);
                        var5_5.showPolygonColors(true);
                        PgMapleLoader.makeVertexColorsFromZ(var5_5, Color.blue, Color.red, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("ZHUE")) {
                        PgMapleLoader.makePolygonColorsFromZHue(var5_5, var18_36);
                        var5_5.showPolygonColors(true);
                        PgMapleLoader.makeVertexColorsFromZHue(var5_5, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("ZGREYSCALE") || var24_55.equalsIgnoreCase("ZGRAYSCALE")) {
                        PgMapleLoader.makePolygonColorsFromZ(var5_5, Color.black, Color.white, var18_36);
                        var5_5.showPolygonColors(true);
                        PgMapleLoader.makeVertexColorsFromZ(var5_5, Color.blue, Color.red, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else {
                        PsDebug.warning("Scene shading = " + var24_55 + " is not supported yet");
                    }
                } else if (var5_5.getType() == 31) {
                    PgMapleLoader.makeEdgeColorsFromXYZ(var5_5, 3, var18_36);
                    var5_5.showEdgeColors(true);
                } else if (var5_5.getType() == 30) {
                    if (var24_55.equalsIgnoreCase("NONE")) {
                        var5_5.showSmoothElementColors(false);
                    } else if (var24_55.equalsIgnoreCase("XYZ") || var24_55.equalsIgnoreCase("XYZSHADING")) {
                        PgMapleLoader.makeVertexColorsFromXYZ(var5_5, 3, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("XY") || var24_55.equalsIgnoreCase("XYSHADING")) {
                        PgMapleLoader.makeVertexColorsFromXYZ(var5_5, 2, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("Z") || var24_55.equalsIgnoreCase("ZSHADING")) {
                        PgMapleLoader.makeVertexColorsFromZ(var5_5, Color.blue, Color.red, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("ZHUE")) {
                        PgMapleLoader.makeVertexColorsFromZHue(var5_5, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else if (var24_55.equalsIgnoreCase("ZGREYSCALE") || var24_55.equalsIgnoreCase("ZGRAYSCALE")) {
                        PgMapleLoader.makeVertexColorsFromZ(var5_5, Color.black, Color.white, var18_36);
                        var5_5.showElementColorFromVertices(true);
                    } else {
                        PsDebug.warning("Scene shading = " + var24_55 + " is not supported yet");
                    }
                }
            }
            var25_66 = (String)this.m_geomStyle.elementAt(var19_37);
            if (var25_66 == null) {
                var25_66 = this.m_sceneStyle;
            }
            if (var5_5.getType() == 33) {
                var5_5.showElements(true);
                var5_5.showEdges(true);
                var5_5.showVertices(false);
                if (var25_66 == null || var25_66.equalsIgnoreCase("PATCH") || var25_66.equalsIgnoreCase("PATCHCONTOUR")) {
                    var5_5.showVertices(false);
                } else if (var25_66.equalsIgnoreCase("HIDDEN")) {
                    var5_5.setGlobalElementColor(Color.white);
                    var5_5.showVertices(false);
                    if (var23_65 != null) {
                        var5_5.setGlobalEdgeColor(var23_65);
                    }
                } else if (var25_66.equalsIgnoreCase("PATCHNOGRID")) {
                    var5_5.showEdges(false);
                } else if (var25_66.equalsIgnoreCase("LINE") || var25_66.equalsIgnoreCase("WIREFRAME") || var25_66.equalsIgnoreCase("CONTOUR")) {
                    var5_5.showElements(false);
                    if (var23_65 != null) {
                        var5_5.setGlobalEdgeColor(var23_65);
                    }
                } else if (var25_66.equalsIgnoreCase("POINT")) {
                    var5_5.showElements(false);
                    var5_5.showEdges(false);
                    var5_5.showVertices(true);
                    if (var23_65 != null) {
                        var5_5.setGlobalVertexColor(var23_65);
                    }
                }
            } else if (var5_5.getType() == 32) {
                var5_5.showPolygons(true);
                var5_5.showVertices(false);
                if (var25_66 != null && !var25_66.equalsIgnoreCase("LINE") && var25_66.equalsIgnoreCase("POINT")) {
                    var5_5.showPolygons(false);
                    var5_5.showVertices(true);
                    if (var23_65 != null) {
                        var5_5.setGlobalVertexColor(var23_65);
                    }
                }
            } else if (var5_5.getType() == 31) {
                var5_5.showPolygons(true);
                var5_5.showVertices(false);
                if (var25_66 != null && !var25_66.equalsIgnoreCase("LINE") && var25_66.equalsIgnoreCase("POINT")) {
                    var5_5.showPolygons(false);
                    var5_5.showVertices(true);
                    if (var23_65 != null) {
                        var5_5.setGlobalVertexColor(var23_65);
                    }
                }
            } else if (var5_5.getType() == 30) {
                var5_5.showVertices(true);
                if (var25_66 != null && !var25_66.equalsIgnoreCase("POINT")) {
                    var5_5.showVertices(false);
                }
            }
            if (var11_10 != null && var12_11 != -1.0) {
                var5_5.setGlobalVertexSize(var12_11 / 3.0 + 1.0);
            }
            var26_58 = (Double)this.m_geomThickness.elementAt(var19_37);
            var27_67 = this.m_sceneThickness;
            if (var26_58 != null) {
                var27_67 = var26_58;
            }
            if (!(var27_67 > 0.0)) continue;
            if (var5_5.getType() == 33) {
                var5_5.setGlobalEdgeSize(var27_67);
                continue;
            }
            if (var5_5.getType() == 32) {
                var5_5.setGlobalPolygonSize(var27_67);
                continue;
            }
            if (var5_5.getType() == 31) {
                var5_5.setGlobalEdgeSize(var27_67);
                continue;
            }
            if (var5_5.getType() != 30) continue;
            var5_5.setGlobalVertexSize(var27_67);
        }
        if (var4_4 != null) {
            this.m_sceneView = PdVector.realloc(null, 3, 2);
            for (var19_37 = 0; var19_37 < 3; ++var19_37) {
                this.m_sceneView[var19_37].set(-Infinity, 1.7976931348623157E308);
            }
            var19_37 = var4_4.length;
            if (var19_37 == 1) {
                if (var4_4[0] != null) {
                    this.m_sceneView[2].set(var4_4[0][0], var4_4[0][1]);
                }
            } else {
                for (var20_47 = 0; var20_47 < var19_37; ++var20_47) {
                    if (var4_4[var20_47] == null) continue;
                    this.m_sceneView[var20_47].set(var4_4[var20_47][0], var4_4[var20_47][1]);
                }
            }
        }
        return var3_3;
    }

    private static void parseLight(StreamTokenizer streamTokenizer, Vector vector, Vector vector2) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = new double[2];
        for (int i = 0; i < 2; ++i) {
            dArray[i] = PuDouble.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        PdVector pdVector = PgMapleLoader.getLightPosition(dArray[0], dArray[1]);
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray[i] = (float)PuDouble.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        Color color = new Color(fArray[0], fArray[1], fArray[2]);
        vector2.addElement(pdVector);
        vector.addElement(color);
    }

    private static double[] parseOrientation(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = new double[2];
        dArray[0] = PuDouble.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        dArray[1] = PuDouble.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        return dArray;
    }

    private double parseProjection(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double d = 1.0;
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            d = PuDouble.parseDouble(streamTokenizer);
        } else if (streamTokenizer.sval != null) {
            if (streamTokenizer.sval.equalsIgnoreCase("ORTHOGONAL")) {
                d = 1.0;
            } else if (streamTokenizer.sval.equalsIgnoreCase("NORMAL")) {
                d = 0.5;
            } else if (streamTokenizer.sval.equalsIgnoreCase("FISHEYE")) {
                d = 0.0;
            }
        } else {
            PsDebug.warning("error in PROJECTION at" + streamTokenizer.lineno());
            return 1.0;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 44) {
            this.m_sceneOrientation = new double[2];
            this.m_sceneOrientation[0] = d;
            this.m_sceneOrientation[1] = PuDouble.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            d = PuDouble.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        return d;
    }

    private static Color[] parseColorArray(StreamTokenizer streamTokenizer, int n) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = PgMapleLoader.parseRange(streamTokenizer);
        int n2 = (int)dArray[1];
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 91) {
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = PuDouble.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
            }
            streamTokenizer.nextToken();
            String string = "";
            while (streamTokenizer.ttype != 41) {
                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                streamTokenizer.nextToken();
            }
            if (n2 == 3) {
                return new Color[]{new Color((float)dArray2[0], (float)dArray2[1], (float)dArray2[2])};
            }
            return new Color[]{Color.white};
        }
        streamTokenizer.pushBack();
        double[] dArray3 = PgMapleLoader.parseRange(streamTokenizer);
        int n3 = (int)dArray3[1];
        streamTokenizer.nextToken();
        Color[] colorArray = new Color[n2];
        float[] fArray = new float[n3];
        streamTokenizer.nextToken();
        for (int i = 0; i < n2; ++i) {
            streamTokenizer.nextToken();
            for (int j = 0; j < n3; ++j) {
                fArray[j] = (float)PuDouble.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
            }
            colorArray[i] = n3 == 3 ? new Color(fArray[0], fArray[1], fArray[2]) : Color.white;
            streamTokenizer.nextToken();
        }
        streamTokenizer.nextToken();
        String string = "";
        while (streamTokenizer.ttype != 41) {
            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
            streamTokenizer.nextToken();
        }
        return colorArray;
    }

    private static double[][] parseView(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double[] dArray = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in xBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray};
        }
        double[] dArray2 = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray2 = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in yBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray, dArray2};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray, dArray2};
        }
        double[] dArray3 = null;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            dArray3 = PgMapleLoader.parseDoubleRange(streamTokenizer);
        } else if (streamTokenizer.sval == null || !streamTokenizer.sval.equalsIgnoreCase("DEFAULT")) {
            PsDebug.warning("error in zBnds in VIEW at" + streamTokenizer.lineno());
            return new double[][]{dArray, dArray2, dArray3};
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new double[][]{dArray, dArray2, dArray3};
        }
        PsDebug.warning("expected closing ')' in VIEW at" + streamTokenizer.lineno());
        return new double[][]{dArray, dArray2, dArray3};
    }

    private static double[] parseDoubleRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PuDouble.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        double d2 = PuDouble.parseDouble(streamTokenizer);
        return new double[]{d, d2};
    }

    private static double[] parseRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PuDouble.parseDouble(streamTokenizer);
        double d2 = PuDouble.parseDouble(streamTokenizer);
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            streamTokenizer.pushBack();
            double d3 = PuDouble.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                streamTokenizer.pushBack();
                double d4 = PuDouble.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                d2 = 10.0 * d3 + d4;
            } else {
                d2 = d2 == 0.0 ? 10.0 * d3 : 10.0 * d2 + d3;
            }
        } else {
            d2 *= 10.0;
        }
        streamTokenizer.pushBack();
        return new double[]{d, d2};
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector pdVector = new PdVector(n);
        streamTokenizer.nextToken();
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = PgMapleLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
        }
        return pdVector;
    }

    private static double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        double d;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -3) {
            d = 1000.0;
            if (streamTokenizer.sval.equalsIgnoreCase("Float")) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 45) {
                    streamTokenizer.nextToken();
                    d = -1000.0;
                }
                streamTokenizer.nextToken();
            } else {
                streamTokenizer.pushBack();
                PgMapleLoader.parseUnknown(streamTokenizer);
            }
        } else {
            streamTokenizer.pushBack();
            d = PuDouble.parseDouble(streamTokenizer);
        }
        return d;
    }

    private Color[] parseColor(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        Color[] colorArray;
        Serializable serializable;
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.sval == null) {
            streamTokenizer.pushBack();
            streamTokenizer.pushBack();
            streamTokenizer.pushBack();
            PgMapleLoader.parseUnknown(streamTokenizer);
            PsDebug.warning("failed parsing color at " + streamTokenizer.lineno());
            return null;
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        if (streamTokenizer.sval.equalsIgnoreCase("RGB")) {
            streamTokenizer.nextToken();
            serializable = new PdColor();
            ((PdColor)serializable).setSize(3);
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.sval != null && streamTokenizer.sval.equalsIgnoreCase("Array")) {
                colorArray = PgMapleLoader.parseColorArray(streamTokenizer, 1);
                for (n2 = 0; n2 < colorArray.length; ++n2) {
                    vector.addElement(colorArray[n2]);
                }
                streamTokenizer.nextToken();
            } else if (streamTokenizer.ttype == -2) {
                int n3 = 3;
                for (n2 = 0; n2 < n3; ++n2) {
                    ((PdColor)serializable).setEntry(n2, PuDouble.parseDouble(streamTokenizer));
                    streamTokenizer.nextToken();
                }
                vector.addElement(((PdColor)serializable).getColor());
                if (streamTokenizer.ttype == 44) {
                    while (streamTokenizer.ttype != 41) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            ((PdColor)serializable).setEntry(n2, PuDouble.parseDouble(streamTokenizer));
                            streamTokenizer.nextToken();
                        }
                        vector.addElement(((PdColor)serializable).getColor());
                    }
                }
            }
        } else if (streamTokenizer.sval.equalsIgnoreCase("HUE")) {
            streamTokenizer.nextToken();
            serializable = PdColor.hsv2rgb((int)(PuDouble.parseDouble(streamTokenizer) * 255.0), 255, 255);
            streamTokenizer.nextToken();
            vector.addElement(serializable);
            if (streamTokenizer.ttype == 44) {
                while (streamTokenizer.ttype != 41) {
                    vector.addElement(PdColor.hsv2rgb((int)(PuDouble.parseDouble(streamTokenizer) * 255.0), 255, 255));
                    streamTokenizer.nextToken();
                }
            }
        } else {
            if (streamTokenizer.sval.equalsIgnoreCase("NONE") || streamTokenizer.sval.equalsIgnoreCase("XYZ") || streamTokenizer.sval.equalsIgnoreCase("XY") || streamTokenizer.sval.equalsIgnoreCase("Z") || streamTokenizer.sval.equalsIgnoreCase("ZGREYSCALE") || streamTokenizer.sval.equalsIgnoreCase("ZGRAYSCALE") || streamTokenizer.sval.equalsIgnoreCase("ZHUE") || streamTokenizer.sval.equalsIgnoreCase("XYZSHADING") || streamTokenizer.sval.equalsIgnoreCase("XYSHADING") || streamTokenizer.sval.equalsIgnoreCase("ZSHADING")) {
                if (n == -1) {
                    this.m_sceneShading = streamTokenizer.sval;
                } else {
                    this.m_geomColor.setElementAt(streamTokenizer.sval, n);
                }
                streamTokenizer.nextToken();
                return null;
            }
            PsDebug.warning("failed parse color at " + streamTokenizer.lineno(), (Object)(", unknown option " + streamTokenizer.sval));
        }
        int n4 = vector.size();
        if (n4 == 0) {
            return null;
        }
        colorArray = new Color[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            colorArray[n2] = (Color)vector.elementAt(n2);
        }
        return colorArray;
    }

    private static String[] parseAxesLabels(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        String string = PgMapleLoader.parseString(streamTokenizer);
        streamTokenizer.nextToken();
        String string2 = PgMapleLoader.parseString(streamTokenizer);
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 41) {
            return new String[]{string, string2};
        }
        int n = 2;
        String string3 = "";
        while (streamTokenizer.ttype == 44) {
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("FONT")) {
                PgMapleLoader.parseUnknown(streamTokenizer);
                streamTokenizer.nextToken();
                continue;
            }
            if (streamTokenizer.ttype == -3 && (streamTokenizer.sval.equalsIgnoreCase("DEFAULT") || streamTokenizer.sval.equalsIgnoreCase("HORIZONTAL") || streamTokenizer.sval.equalsIgnoreCase("VERTICAL"))) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                continue;
            }
            string3 = PgMapleLoader.parseString(streamTokenizer);
            ++n;
            streamTokenizer.nextToken();
        }
        if (streamTokenizer.ttype == 41) {
            if (n == 2) {
                return new String[]{string, string2};
            }
            return new String[]{string, string2, string3};
        }
        throw new IOException("unable to parse axesLabels.");
    }

    private static String parseString(StreamTokenizer streamTokenizer, String string) throws IOException {
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        String string2 = streamTokenizer.sval;
        streamTokenizer.nextToken();
        return string2;
    }

    private static String parseString(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        int n = 0;
        int n2 = 0;
        streamTokenizer.ordinaryChar(48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.nextToken();
        while (!(streamTokenizer.ttype == 41 && n <= 0 || streamTokenizer.ttype == 44 && n <= 0 && n2 <= 0)) {
            if (streamTokenizer.ttype == -1 || streamTokenizer.ttype == 10) {
                streamTokenizer.parseNumbers();
                throw new IOException("')' missing end of string, premature end of file.");
            }
            if (streamTokenizer.ttype == 40) {
                string = string + "(";
                ++n;
            } else if (streamTokenizer.ttype == 41) {
                string = string + ")";
                --n;
            } else {
                string = streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == 96 ? string + streamTokenizer.sval : (streamTokenizer.ttype == -2 ? string + Double.toString(PuDouble.parseDouble(streamTokenizer)) : (streamTokenizer.ttype == 94 ? string + "^" : (streamTokenizer.ttype == 42 ? string + "*" : (streamTokenizer.ttype == 43 ? string + "+" : (streamTokenizer.ttype == 45 ? string + "-" : (streamTokenizer.ttype == 46 ? string + "." : (streamTokenizer.ttype == 47 ? string + "/" : (streamTokenizer.ttype == 58 ? string + ":" : (streamTokenizer.ttype == 59 ? string + ";" : (streamTokenizer.ttype == 60 ? string + "<" : (streamTokenizer.ttype == 61 ? string + "=" : (streamTokenizer.ttype == 62 ? string + ">" : (streamTokenizer.ttype == 63 ? string + "?" : (streamTokenizer.ttype == 64 ? string + "@" : (streamTokenizer.ttype == 33 ? string + "!" : (streamTokenizer.ttype == 35 ? string + "#" : (streamTokenizer.ttype == 36 ? string + "$" : (streamTokenizer.ttype == 37 ? string + "%" : (streamTokenizer.ttype == 38 ? string + "&" : (streamTokenizer.ttype == 123 ? string + "{" : (streamTokenizer.ttype == 125 ? string + "}" : (streamTokenizer.ttype == 126 ? string + "~" : (streamTokenizer.ttype == 169 ? string + "\u00a9" : string + " ")))))))))))))))))))))));
            }
            streamTokenizer.nextToken();
        }
        streamTokenizer.pushBack();
        streamTokenizer.parseNumbers();
        return string;
    }

    private static String parseUnknown(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        streamTokenizer.nextToken();
        string = streamTokenizer.sval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41) {
            streamTokenizer.pushBack();
        } else if (streamTokenizer.ttype != 40) {
            int n = 0;
            int n2 = 0;
            while ((streamTokenizer.ttype != 44 || n > 0 || n2 > 0) && n >= 0 && n2 >= 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 40) {
                    string = string + "(";
                    ++n;
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    string = string + ")";
                    --n;
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                    ++n2;
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                    --n2;
                    continue;
                }
                if (streamTokenizer.ttype != -1) continue;
                throw new IOException("premature end of file.");
            }
            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41 || streamTokenizer.ttype == 93) {
                streamTokenizer.pushBack();
            }
        } else {
            int n = 1;
            string = string + "(";
            while (n != 0) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1) {
                    throw new IOException("')' missing, premature end of file.");
                }
                if (streamTokenizer.ttype == 40) {
                    ++n;
                    string = string + "(";
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    --n;
                    string = string + ")";
                    continue;
                }
                if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 39) {
                    string = string + streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype == -2) {
                    streamTokenizer.pushBack();
                    string = string + Double.toString(PuDouble.parseDouble(streamTokenizer));
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                    continue;
                }
                if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                    continue;
                }
                if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                    continue;
                }
                if (streamTokenizer.ttype != 94) continue;
                string = string + "^";
            }
        }
        return string;
    }

    private static int[] parse2ArrayOfDoubles(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        int n = 0;
        int n2 = 0;
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 93) {
            streamTokenizer.nextToken();
            ++n;
            int n3 = n2;
            n2 = 0;
            while (streamTokenizer.ttype != 93) {
                ++n2;
                Double d = new Double(PuDouble.parseDouble(streamTokenizer));
                vector.addElement(d);
                streamTokenizer.nextToken();
            }
            if (n > 1 && n3 != n2) {
                throw new IOException("numVLines differ");
            }
            streamTokenizer.nextToken();
        }
        return new int[]{n, n2};
    }

    private static int[] parse2ArrayOfPoints(StreamTokenizer streamTokenizer, Vector vector, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        streamTokenizer.nextToken();
        while (streamTokenizer.ttype != 93) {
            streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if (streamTokenizer.ttype == 91) {
                ++n2;
                int n4 = n3;
                n3 = 0;
                streamTokenizer.nextToken();
                while (streamTokenizer.ttype != 93) {
                    PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                    vector.addElement(pdVector);
                    ++n3;
                    streamTokenizer.nextToken();
                }
                if (n2 > 1 && n4 != n3) {
                    throw new IOException("numVLines differ");
                }
            } else {
                PgMapleLoader.parseUnknown(streamTokenizer);
            }
            streamTokenizer.nextToken();
        }
        return new int[]{n2, n3};
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        int n2;
        int n3;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry");
            return false;
        }
        this.m_numGeoms = pgJvxSrcArray.length;
        for (int i = 0; i < this.m_numGeoms; ++i) {
            if (pgJvxSrcArray[i] != null) continue;
            PsDebug.warning("missing geometry[" + i + "]");
            return false;
        }
        PgJvxSrc pgJvxSrc = null;
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#    File Format           = Maple Graphics MPL\n");
        writer.write("#    Date                  = " + new Date().toString() + "\n");
        writer.write("#    Number of Geometries  = " + this.m_numGeoms + "\n");
        for (n3 = 0; n3 < this.m_numGeoms; ++n3) {
            pgJvxSrc = pgJvxSrcArray[n3];
            writer.write("#    Geometry[" + String.valueOf(n3) + "]           = " + pgJvxSrc.getName() + "\n");
            n2 = pgJvxSrc.getNumVertices();
            writer.write("#    Number of Vertices    = " + n2 + "\n");
            int n4 = pgJvxSrc.getNumElements();
            if (n4 > 0) {
                writer.write("#    Number of Elements    = " + n4 + "\n");
            }
            if ((n = pgJvxSrc.getNumPolygons()) <= 0) continue;
            writer.write("#    Number of Polygons    = " + n + "\n");
        }
        writer.write("# End of Header\n");
        n3 = pgJvxSrcArray[0].getDimOfVertices();
        if (n3 == 3) {
            writer.write("PLOT3D(");
        } else {
            writer.write("PLOT(");
        }
        n2 = 1;
        if (pgJvxSrcArray[0].isShowingName()) {
            writer.write("TITLE(\"" + pgJvxSrcArray[0].getName() + "\")");
            n2 = 0;
        }
        String string = null;
        for (n = 0; n < this.m_numGeoms; ++n) {
            String string2;
            int n5;
            int n6;
            int n7;
            Object object;
            pgJvxSrc = pgJvxSrcArray[n];
            if (pgJvxSrc.getDimOfVertices() != pgJvxSrcArray[0].getDimOfVertices()) {
                PsDebug.warning("found geometries with different dimension in same scene,geometries incompatible with first geometry are skipped");
                continue;
            }
            if (n2 != 0) {
                n2 = 0;
            } else {
                writer.write(",\n");
            }
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            String string3 = null;
            Color[] colorArray = null;
            int n8 = pgJvxSrc.getNumVertices();
            int n9 = pgJvxSrc.getNumElements();
            int n10 = pgJvxSrc.getNumPolygons();
            if (n10 > 0) {
                writer.write("CURVES(");
                object = pgJvxSrc.getPolygons();
                for (n7 = 0; n7 < n10; ++n7) {
                    if (n7 > 0) {
                        writer.write(",\n");
                    }
                    writer.write("[");
                    n6 = object[n7].getSize();
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (n5 > 0) {
                            writer.write(",");
                        }
                        string2 = PgMapleLoader.writeVertex(pdVectorArray[object[n7].m_data[n5]]);
                        writer.write(string2);
                    }
                    writer.write("]");
                }
                writer.write(",\n");
                if (pgJvxSrc.isShowingPolygonColors()) {
                    colorArray = pgJvxSrc.getPolygonColors();
                    PgMapleLoader.writeColors(writer, colorArray, n10);
                } else {
                    string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                    writer.write(string3);
                }
                if (pgJvxSrc.getGlobalPolygonSize() > 1.0) {
                    writer.write(",THICKNESS(" + (int)pgJvxSrc.getGlobalPolygonSize() + ")");
                }
                string = pgJvxSrc.isShowingPolygons() ? "PATCH" : "POINT";
                if (this.m_numGeoms > 1) {
                    writer.write(",STYLE(" + string + ")");
                }
                writer.write(")");
            } else if (n9 > 0) {
                writer.write("POLYGONS(");
                object = pgJvxSrc.getElements();
                for (n7 = 0; n7 < n9; ++n7) {
                    if (n7 > 0) {
                        writer.write(",\n");
                    }
                    writer.write("[");
                    n6 = object[n7].getSize();
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (n5 > 0) {
                            writer.write(",");
                        }
                        string2 = PgMapleLoader.writeVertex(pdVectorArray[object[n7].m_data[n5]]);
                        writer.write(string2);
                    }
                    writer.write("]");
                }
                writer.write(",\n");
                if (pgJvxSrc.isShowingElementColors()) {
                    colorArray = pgJvxSrc.getElementColors();
                    PgMapleLoader.writeColors(writer, colorArray, n9);
                } else if (pgJvxSrc.isShowingElements()) {
                    string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                    writer.write(string3);
                } else if (!pgJvxSrc.isShowingElements()) {
                    string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalEdgeColor());
                    writer.write(string3);
                }
                if (pgJvxSrc.getGlobalEdgeSize() > 1.0) {
                    writer.write(",THICKNESS(" + (int)pgJvxSrc.getGlobalEdgeSize() + ")");
                }
                string = pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges() ? "PATCH" : (pgJvxSrc.isShowingElements() && !pgJvxSrc.isShowingEdges() ? "PATCHNOGRID" : (!pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges() ? "LINE" : "POINT"));
                if (this.m_numGeoms > 1) {
                    writer.write(",STYLE(" + string + ")");
                }
                writer.write(")");
            }
            if (n8 <= 0 || !pgJvxSrc.isShowingVertices()) continue;
            if (n10 > 0 || n9 > 0) {
                writer.write(",\n");
            }
            writer.write("POINTS(");
            for (n7 = 0; n7 < n8; ++n7) {
                if (n7 > 0) {
                    writer.write(",\n");
                }
                object = PgMapleLoader.writeVertex(pdVectorArray[n7]);
                writer.write((String)object);
            }
            writer.write(",\n");
            if (pgJvxSrc.isShowingVertexColors()) {
                colorArray = pgJvxSrc.getVertexColors();
                PgMapleLoader.writeColors(writer, colorArray, n8);
            } else {
                string3 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalVertexColor());
                writer.write(string3);
            }
            if (pgJvxSrc.getGlobalVertexSize() > 1.0) {
                writer.write(",SYMBOL(CIRCLE," + 2 * (int)pgJvxSrc.getGlobalVertexSize() + ")");
            } else {
                writer.write(",SYMBOL(CIRCLE)");
            }
            writer.write(")");
        }
        if (this.m_numGeoms == 1 && string != null) {
            writer.write(",STYLE(" + string + ")");
        }
        writer.write(",SCALING(CONSTRAINED)");
        if (n3 == 3) {
            writer.write(",LIGHTMODEL(LIGHT_3)");
        }
        writer.write(");");
        return true;
    }

    private static boolean writeColors(Writer writer, Color[] colorArray, int n) throws IOException {
        if (colorArray == null || colorArray.length < n) {
            PsDebug.warning("missing colors");
            return false;
        }
        writer.write("COLOUR(RGB");
        for (int i = 0; i < n; ++i) {
            writer.write(",\n" + String.valueOf((float)colorArray[i].getRed() / 255.0f) + "," + String.valueOf((float)colorArray[i].getGreen() / 255.0f) + "," + String.valueOf((float)colorArray[i].getBlue() / 255.0f));
        }
        writer.write(")");
        return true;
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("COLOUR(RGB,");
        stringBuffer.append(String.valueOf((float)color.getRed() / 255.0f) + ", " + String.valueOf((float)color.getGreen() / 255.0f) + ", " + String.valueOf((float)color.getBlue() / 255.0f) + ")");
        return stringBuffer.toString();
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("[" + String.valueOf((float)pdVector.m_data[0]));
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",");
            if (Math.abs(pdVector.m_data[i]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[i]);
                continue;
            }
            stringBuffer.append(0.0f);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

