/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;

public final class PSGr
extends Graphics {
    private static final boolean NOTIFY = false;
    private static float PS_ZOOM = 1.0f;
    public static final int CLONE = 49;
    protected static final int XOFFSET = 10;
    protected static final int YOFFSET = 10;
    protected static final int PAGEWIDTH = 574;
    protected static final int PAGEHEIGHT = 772;
    protected static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int CHARSPERROW = 72;
    protected StringBuffer m_buffer = new StringBuffer();
    protected Color m_currCol = Color.black;
    protected Color m_backCol = Color.white;
    protected Font m_font = new Font("Helvetica", 0, 12);
    protected Rectangle m_clipRect = new Rectangle(0, 0, 574, 772);
    protected Graphics m_graphics;
    protected int[] m_bndBox;
    protected String m_geomName;
    protected double m_scale = 1.0;

    public PSGr(Graphics graphics, String string, int n, int n2) {
        this.m_graphics = graphics;
        this.m_geomName = string;
        double d = 1.0;
        if (n > 574) {
            d = (float)n / 574.0f;
        }
        double d2 = 1.0;
        if (n2 > 772) {
            d2 = (float)n2 / 772.0f;
        }
        this.m_scale = Math.max(d, d2);
        this.boundingBox(0, 0, (int)((double)n / this.m_scale), (int)((double)n2 / this.m_scale));
        this.emitProlog();
    }

    public PSGr(Graphics graphics, int n) {
        this.m_graphics = graphics;
        if (n != 49) {
            this.emitProlog();
        }
    }

    public String toString() {
        return this.m_buffer.toString();
    }

    public void setZoom(float f) {
        PS_ZOOM = f;
    }

    public Graphics create() {
        PSGr pSGr = new PSGr(this.m_graphics, 49);
        pSGr.m_font = this.m_font;
        pSGr.m_clipRect = this.m_clipRect;
        pSGr.m_currCol = this.m_currCol;
        return pSGr;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.setClip(0, 0, n3, n4);
        return graphics;
    }

    public void translate(int n, int n2) {
        this.print(n + " " + n2 + " t\n");
    }

    public void boundingBox(int n, int n2, int n3, int n4) {
        this.m_bndBox = new int[]{n, 0, n3, n4 - n2};
    }

    private void emitBoundingBox() {
        if (this.m_bndBox == null) {
            return;
        }
        this.println("%%BoundingBox: " + (this.m_bndBox[0] + 10) + " " + (this.m_bndBox[1] + 10) + " " + (this.m_bndBox[2] + 10) + " " + (this.m_bndBox[3] + 10));
    }

    public void scale(float f, float f2) {
        this.print(f + " " + f2 + " s\n");
    }

    public Color getColor() {
        return this.m_currCol;
    }

    public void setBackground(Color color) {
        this.m_backCol = color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.m_currCol = color;
        }
        this.print((float)((double)this.m_currCol.getRed() / 255.0));
        this.print(" ");
        this.print((float)((double)this.m_currCol.getGreen() / 255.0));
        this.print(" ");
        this.print((float)((double)this.m_currCol.getBlue() / 255.0));
        this.print(" c\n");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        System.err.println("Warning: PSGr does not support XOR mode");
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        String string;
        if (font == null) {
            return;
        }
        this.m_font = font;
        String string2 = font.getName();
        if (string2.equals("SansSerif")) {
            string2 = "Helvetica";
        } else if (string2.equals("Monospaced")) {
            string2 = "Courier";
        }
        int n = font.getStyle();
        if (string2.equals("Symbol")) {
            string = "Symbol";
        } else if (string2.startsWith("Times") || string2.startsWith("Serif")) {
            string = "Times-";
            switch (n) {
                case 0: {
                    string = string + "Roman";
                    break;
                }
                case 1: {
                    string = string + "Bold";
                    break;
                }
                case 2: {
                    string = string + "Italic";
                    break;
                }
                case 3: {
                    string = string + "BoldItalic";
                }
            }
        } else if (string2.startsWith("Helvetica") || string2.equals("Courier")) {
            string = string2;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    string = string + "-Bold";
                    break;
                }
                case 2: {
                    string = string + "-Oblique";
                    break;
                }
                case 3: {
                    string = string + "-BoldOblique";
                }
            }
        } else {
            string = "Courier";
        }
        this.print("/" + string + " findfont ");
        this.println(font.getSize() + " scalefont setfont");
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.m_graphics.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.m_clipRect;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        int n5 = (int)((float)n / PS_ZOOM);
        int n6 = (int)((float)n2 / PS_ZOOM);
        int n7 = (int)((float)n3 / PS_ZOOM);
        int n8 = (int)((float)n4 / PS_ZOOM);
        n6 = this.transformY(n6);
        this.m_clipRect = new Rectangle(n5, n6, n7, n8);
        this.print("initclip ");
        this.print(n5 + " " + n6 + " m ");
        this.print(n5 + n7 + " " + n6 + " l ");
        this.print(n5 + n7 + " " + (n6 - n8) + " l ");
        this.print(n5 + " " + (n6 - n8) + " l ");
        this.print("closepath eoclip newpath\n");
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        float f = (float)n / PS_ZOOM;
        float f2 = (float)n2 / PS_ZOOM;
        float f3 = (float)n3 / PS_ZOOM;
        float f4 = (float)n4 / PS_ZOOM;
        f2 = this.transformY(f2);
        f4 = this.transformY(f4);
        this.print(f + " " + f2 + " m " + f3 + " " + f4 + " l s\n");
    }

    protected void doRect(int n, int n2, int n3, int n4, boolean bl) {
        float f = (float)n / PS_ZOOM;
        float f2 = (float)n2 / PS_ZOOM;
        float f3 = (float)n3 / PS_ZOOM;
        float f4 = (float)n4 / PS_ZOOM;
        f2 = this.transformY(f2);
        this.print(f + " " + f2 + " m " + (f + f3) + " " + f2 + " l ");
        this.print(f + f3 + " " + (f2 - f4) + " l ");
        this.print(f + " " + (f2 - f4) + " l " + f + " " + f2 + " l ");
        if (bl) {
            this.print("e\n");
        } else {
            this.print("s\n");
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.doRect(n, n2, n3, n4, true);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.doRect(n, n2, n3, n4, false);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.print("g ");
        Color color = this.getColor();
        this.setColor(this.m_backCol);
        this.doRect(n, n2, n3, n4, true);
        this.setColor(color);
        this.print("grestore\n");
    }

    private void doRoundRect(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        float f = (float)n / PS_ZOOM;
        float f2 = (float)n2 / PS_ZOOM;
        float f3 = (float)n3 / PS_ZOOM;
        float f4 = (float)n4 / PS_ZOOM;
        float f5 = (float)n6 / PS_ZOOM;
        f2 = this.transformY(f2);
        this.print(f + f5);
        this.print(" " + f2 + " m\n");
        this.print(f + f3);
        this.print(" " + f2 + " ");
        this.print(f + f3);
        this.print(" ");
        this.print(f2 - f4);
        this.print(" " + f5 + " arcto\n");
        this.print("4 {pop} repeat\n");
        this.print(f + f3);
        this.print(" ");
        this.print(f2 - f4);
        this.print(" " + f + " ");
        this.print(f2 - f4);
        this.print(" " + f5 + " arcto\n");
        this.print("4 {pop} repeat\n");
        this.print(f);
        this.print(" ");
        this.print(f2 - f4);
        this.print(" " + f + " " + f2 + " " + f5 + " arcto\n");
        this.print("4 {pop} repeat\n");
        this.print(f + " " + f2 + " ");
        this.print(f + f3);
        this.print(" " + f2 + " ");
        this.print(f5 + " arcto\n");
        this.print("4 {pop} repeat\n");
        if (bl) {
            this.print("e\n");
        } else {
            this.print("s\n");
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + (int)(1.0f * PS_ZOOM), n2, n + n3 - (int)(1.0f * PS_ZOOM), n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + (int)(1.0f * PS_ZOOM), n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(n + (int)(1.0f * PS_ZOOM), n2 + (int)(1.0f * PS_ZOOM), n3 - (int)(2.0f * PS_ZOOM), n4 - (int)(2.0f * PS_ZOOM));
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4 - (int)(1.0f * PS_ZOOM));
        this.drawLine(n + (int)(1.0f * PS_ZOOM), n2, n + n3 - (int)(2.0f * PS_ZOOM), n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + (int)(1.0f * PS_ZOOM), n2 + n4 - (int)(1.0f * PS_ZOOM), n + n3 - (int)(1.0f * PS_ZOOM), n2 + n4 - (int)(1.0f * PS_ZOOM));
        this.drawLine(n + n3 - (int)(1.0f * PS_ZOOM), n2, n + n3 - (int)(1.0f * PS_ZOOM), n2 + n4 - (int)(1.0f * PS_ZOOM));
        this.setColor(color);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.doArc(n, n2, n3, n4, 0, 360, false);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.doArc(n, n2, n3, n4, 0, 360, true);
    }

    private void doArc(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        float f = (float)n / PS_ZOOM;
        float f2 = (float)n2 / PS_ZOOM;
        float f3 = (float)n3 / PS_ZOOM;
        float f4 = (float)n4 / PS_ZOOM;
        f2 = this.transformY(f2);
        this.print("g ");
        float f5 = f + f3 / 2.0f;
        float f6 = f2 - f4 / 2.0f;
        this.print(f5);
        this.print(" ");
        this.print(f6);
        this.print(" t ");
        float f7 = f4 / f3;
        this.print(1.0);
        this.print(" ");
        this.print(f7);
        this.print(" s ");
        if (bl) {
            this.print("0 0 m ");
        }
        float f8 = n5 + n6;
        this.print("0 0 ");
        this.print(f3 / 2.0f);
        this.print(" ");
        this.print(n5);
        this.print(" ");
        this.print(f8);
        if (bl) {
            this.print(" ac\n");
        } else {
            this.print(" as\n");
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doArc(n, n2, n3, n4, n5, n6, false);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doArc(n, n2, n3, n4, n5, n6, true);
    }

    private void doPoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n < 2) {
            return;
        }
        this.print((float)nArray[0] / PS_ZOOM + " " + this.transformY((float)nArray2[0] / PS_ZOOM) + " m ");
        for (int i = 1; i < n; ++i) {
            this.print((float)nArray[i] / PS_ZOOM + " " + this.transformY((float)nArray2[i] / PS_ZOOM) + " l ");
        }
        if (bl) {
            this.println("e");
        } else {
            this.print((float)nArray[0] / PS_ZOOM + " " + this.transformY((float)nArray2[0] / PS_ZOOM) + " l ");
            this.println("s");
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, false);
    }

    public void drawPolygon(Polygon polygon) {
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, true);
    }

    public void fillPolygon(Polygon polygon) {
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    public void drawString(String string, int n, int n2) {
        this.print((float)n / PS_ZOOM + " ");
        this.print(this.transformY((float)n2 / PS_ZOOM));
        this.print(" m (" + string + ") w s\n");
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        float f = (float)n / PS_ZOOM;
        float f2 = (float)n2 / PS_ZOOM;
        float f3 = (float)n3 / PS_ZOOM;
        float f4 = (float)n4 / PS_ZOOM;
        this.println("%doImage");
        f2 = this.transformY(f2);
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        int[] nArray = PsImage.getPixels(image);
        if (nArray == null) {
            PsDebug.warning("failed to get pixels of image during PS export.");
            return false;
        }
        this.println("g");
        this.println("% build a temporary dictionary");
        this.println("20 dict begin");
        this.emitColorImageProlog(n5);
        this.println("% lower left corner");
        this.print(f);
        this.print(" ");
        this.print(f2);
        this.println(" translate");
        if (f4 == 0.0f || f3 == 0.0f) {
            f4 = n6;
            f3 = n5;
        }
        this.println("% size of image");
        this.print(f3);
        this.print(" ");
        this.print(f4);
        this.println(" scale");
        this.print(n5);
        this.print(" ");
        this.print(n6);
        this.println(" 8");
        this.print("[");
        this.print(n5);
        this.print(" 0 0 -");
        this.print(n6);
        this.print(" 0 ");
        this.print(0);
        this.println("]");
        this.println("{currentfile pix readhexstring pop}");
        this.println("false 3 colorimage");
        this.println("");
        char[] cArray = new char[73];
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = 0;
            if (color == null) {
                for (n11 = 0; n11 < n5; ++n11) {
                    if ((n10 = ((n9 = nArray[n7++]) & 0xFF000000) >> 24) == 0) {
                        for (n8 = 0; n8 < 6; ++n8) {
                            cArray[n12++] = HEXCHAR[15];
                        }
                    } else {
                        cArray[n12++] = HEXCHAR[(n9 & 0xF00000) >> 20];
                        cArray[n12++] = HEXCHAR[(n9 & 0xF0000) >> 16];
                        cArray[n12++] = HEXCHAR[(n9 & 0xF000) >> 12];
                        cArray[n12++] = HEXCHAR[(n9 & 0xF00) >> 8];
                        cArray[n12++] = HEXCHAR[(n9 & 0xF0) >> 4];
                        cArray[n12++] = HEXCHAR[n9 & 0xF];
                    }
                    if (n12 < 72) continue;
                    String string = String.copyValueOf(cArray, 0, n12);
                    this.println(string);
                    n12 = 0;
                }
            } else {
                this.println("%FalseColor");
                for (n11 = 0; n11 < n5; ++n11) {
                    n9 = color.getGreen() << 16 + color.getBlue() << 8 + color.getRed();
                    n10 = this.m_currCol.getGreen() << 16 + this.m_currCol.getBlue() << 8 + this.m_currCol.getRed();
                    n8 = nArray[n7++] == 1 ? n10 : n9;
                    cArray[n12++] = HEXCHAR[n8 & 0xF0];
                    cArray[n12++] = HEXCHAR[n8 & 0xF];
                    cArray[n12++] = HEXCHAR[n8 & 0xF000];
                    cArray[n12++] = HEXCHAR[n8 & 0xF00];
                    cArray[n12++] = HEXCHAR[n8 & 0xF00000];
                    cArray[n12++] = HEXCHAR[n8 & 0xF0000];
                    if (n12 < 72) continue;
                    String string = String.copyValueOf(cArray, 0, n12);
                    this.println(string);
                    n12 = 0;
                }
            }
            if (n12 == 0) continue;
            String string = String.copyValueOf(cArray, 0, n12);
            this.println(string);
        }
        this.println("");
        this.println("end");
        this.println("grestore");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.println("%drawImage-1");
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.println("%drawImage-2");
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.println("%drawImage-3");
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.println("%drawImage-4");
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public void dispose() {
        this.flush();
    }

    public void finalize() {
        this.dispose();
    }

    protected int transformY(int n) {
        return (int)((double)this.m_bndBox[3] * this.m_scale) - n;
    }

    protected float transformY(float f) {
        return (float)((double)this.m_bndBox[3] * this.m_scale - (double)f);
    }

    protected void emitProlog() {
        this.println("%!PS-Adobe-3.0 EPSF-3.0");
        if (this.m_geomName != null) {
            this.println("%%Title:   " + this.m_geomName);
        } else {
            this.println("%%Title:   JavaView Image");
        }
        this.println("%%Date:    " + new Date().toString());
        this.println("%%Creator: JavaView v." + PsConfig.getVersion() + " PostScript Export");
        this.println("%%JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage());
        this.println("%%by " + PsConfig.getAuthors());
        this.println("%%PostScript filter based on: PSGr Java PostScript Context");
        this.println("%%PSGr is (C) 1996 Ernest Friedman-Hill and Sandia National Labs");
        this.emitBoundingBox();
        this.println("%%EndComments");
        this.println("%%BeginProlog");
        this.println(String.valueOf(10) + " " + String.valueOf(10) + " translate");
        this.println("%%Modify scaling when including in TeX:");
        this.println(String.valueOf((float)(1.0 / this.m_scale)) + " " + String.valueOf((float)(1.0 / this.m_scale)) + " scale");
        this.setFont(this.m_font);
        this.println("/c {setrgbcolor} bind def");
        this.println("/e {eofill} bind def");
        this.println("/g {gsave} bind def");
        this.println("/l {lineto} bind def");
        this.println("/m {moveto} bind def");
        this.println("/s {stroke} bind def");
        this.println("/t {translate} bind def");
        this.println("/w {show} bind def");
        this.println("/ac {arc closepath eofill grestore} bind def");
        this.println("/as {arc stroke grestore} bind def");
        this.println("%%EndProlog");
        this.println("%Uncomment the following to edit the width of lines.");
        this.println("% 1.0 setlinewidth");
    }

    protected void emitColorImageProlog(int n) {
        this.println("% Color picture stuff, lifted from XV's PS files");
        this.println("% define string to hold a scanline's worth of data");
        this.print("/pix ");
        this.print(n * 3);
        this.println(" string def");
        this.println("% define space for color conversions");
        this.print("/grays ");
        this.print(n);
        this.println(" string def  % space for gray scale line");
        this.println("/npixls 0 def");
        this.println("/rgbindx 0 def");
        this.println("% define 'colorimage' if it isn't defined");
        this.println("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.println("%     via xgrab)");
        this.println("/colorimage where   % do we know about 'colorimage'?");
        this.println("{ pop }           % yes: pop off the 'dict' returned");
        this.println("{                 % no:  define one");
        this.println("/colortogray {  % define an RGB->I function");
        this.println("/rgbdata exch store    % call input 'rgbdata'");
        this.println("rgbdata length 3 idiv");
        this.println("/npixls exch store");
        this.println("/rgbindx 0 store");
        this.println("0 1 npixls 1 sub {");
        this.println("grays exch");
        this.println("rgbdata rgbindx       get 20 mul    % Red");
        this.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.println("put");
        this.println("/rgbindx rgbindx 3 add store");
        this.println("} for");
        this.println("grays 0 npixls getinterval");
        this.println("} bind def");
        this.println("");
        this.println("% Utility procedure for colorimage operator.");
        this.println("% This procedure takes two procedures off the");
        this.println("% stack and merges them into a single procedure.");
        this.println("");
        this.println("/mergeprocs { % def");
        this.println("dup length");
        this.println("3 -1 roll");
        this.println("dup");
        this.println("length");
        this.println("dup");
        this.println("5 1 roll");
        this.println("3 -1 roll");
        this.println("add");
        this.println("array cvx");
        this.println("dup");
        this.println("3 -1 roll");
        this.println("0 exch");
        this.println("putinterval");
        this.println("dup");
        this.println("4 2 roll");
        this.println("putinterval");
        this.println("} bind def");
        this.println("");
        this.println("/colorimage { % def");
        this.println("pop pop     % remove 'false 3' operands");
        this.println("{colortogray} mergeprocs");
        this.println("image");
        this.println("} bind def");
        this.println("} ifelse          % end of 'false' case");
    }

    public void gsave() {
        this.println("gsave");
    }

    public void grestore() {
        this.println("grestore");
    }

    public void emitThis(String string) {
        this.println(string);
    }

    public Shape getClip() {
        System.err.println("Warning: PSGr does not support clip");
        return null;
    }

    public void setClip(Shape shape) {
        System.err.println("Warning: PSGr does not support clip");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        System.err.println("Warning: PSGr does not support partial drawImage methods");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        System.err.println("Warning: PSGr does not support partial drawImage methods");
        return true;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        System.err.println("Warning: PSGr does not support clip rectangle");
        this.setClip(n, n2, n3, n4);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(nArray, nArray2, n);
    }

    public void print(String string) {
        this.m_buffer.append(string);
    }

    public void println(String string) {
        this.m_buffer.append(string + "\n");
    }

    public void print(int n) {
        this.m_buffer.append(String.valueOf(n));
    }

    public void print(float f) {
        this.m_buffer.append(String.valueOf(f));
    }

    public void print(double d) {
        this.m_buffer.append(String.valueOf(d));
    }

    public void println(int n) {
        this.m_buffer.append(String.valueOf(n) + "\n");
    }

    public void println(float f) {
        this.m_buffer.append(String.valueOf(f) + "\n");
    }

    public void println(double d) {
        this.m_buffer.append(String.valueOf(d) + "\n");
    }

    public void flush() {
    }
}

