/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.geom.PgTetraSet;
import jv.geom.PgTexture;
import jv.number.PdArray_IP;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsSlotLayout;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgTetraSet_TP
extends PsPanel
implements ActionListener,
ItemListener,
WindowListener {
    protected PgTetraSet m_tetraSet;
    protected CheckboxGroup m_gTypeMode;
    protected Checkbox m_cTetraTex;
    protected Checkbox m_cVertexTex;
    protected Panel m_pNumTextures;
    protected PdArray_IP m_texturePanel;
    protected int m_maxVisibleVectors = 5;
    protected int m_maxVisibleDim = 5;
    protected static String[] m_vertexHeader = new String[]{"0", "1", "2", "3", "4", "5"};
    protected static String[] m_tetraHeader = new String[]{"0", "1", "2"};
    protected PsPanel m_pTexture;
    protected PsMultiLineLabel m_lNotice;
    protected Button m_bClose;
    protected Checkbox m_cShowTexture;
    protected Button m_bShowDomain;
    protected Checkbox m_cShowMesh;
    protected Checkbox m_cSyncSelect;
    protected Checkbox m_cSyncLabels;
    protected PvDisplayIf m_display;
    protected PgTetraSet m_texGeom;
    protected PgTetraSet m_imgGeom;
    private boolean m_bUpdateFromHere = false;
    private boolean m_bDomainMode;
    private Color m_colorDomainMode;
    protected PuInteger m_tetraInd;
    private PsPanel m_pTetraSlider;
    static /* synthetic */ Class class$jv$geom$PgTetraSet_TP;

    public PgTetraSet_TP() {
        if (this.getClass() == (class$jv$geom$PgTetraSet_TP == null ? (class$jv$geom$PgTetraSet_TP = PgTetraSet_TP.class$("jv.geom.PgTetraSet_TP")) : class$jv$geom$PgTetraSet_TP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        this.m_bDomainMode = false;
        Panel panel = new Panel(new PsSlotLayout(2));
        Component component = this.getTitle("", PsConfig.getFont(3));
        panel.add("1", component);
        this.m_cShowTexture = new Checkbox(PsConfig.getMessage(true, 24000, "Enable Texture"));
        this.m_cShowTexture.addItemListener(this);
        panel.add("1", this.m_cShowTexture);
        this.add(panel);
        component = new PsPanel(new GridLayout(1, 2));
        this.add(component);
        ((PsPanel)component).addSubTitle(PsConfig.getMessage(24035));
        Panel panel2 = new PsPanel(new GridLayout(1, 2));
        this.m_gTypeMode = new CheckboxGroup();
        this.m_cVertexTex = new Checkbox(PsConfig.getMessage(24036), this.m_gTypeMode, true);
        this.m_cVertexTex.addItemListener(this);
        panel2.add(this.m_cVertexTex);
        this.m_cTetraTex = new Checkbox(PsConfig.getMessage(true, 24000, "Tetrahedron"), this.m_gTypeMode, false);
        this.m_cTetraTex.addItemListener(this);
        panel2.add(this.m_cTetraTex);
        this.m_gTypeMode.setSelectedCheckbox(this.m_cVertexTex);
        this.m_cTetraTex.setEnabled(false);
        ((Container)component).add(panel2);
        this.m_texturePanel = new PdArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_texturePanel.setNumOfEntries(0, 2);
        this.m_texturePanel.setHeader(m_vertexHeader);
        this.m_texturePanel.setParent(this);
        this.add(this.m_texturePanel);
        this.m_pTetraSlider = new PsPanel();
        this.m_tetraInd = new PuInteger(PsConfig.getMessage(true, 24000, "Tetrahedron Index"), this);
        this.add(this.m_pTetraSlider);
        panel2 = new Panel(new PsSlotLayout(5));
        PsPanel psPanel = new PsPanel(new BorderLayout());
        Component component2 = psPanel.getTitle(PsConfig.getMessage(24037), PsConfig.getFont(3));
        psPanel.add(component2, "North");
        panel2.add("1", psPanel);
        component2 = new PsPanel(new GridLayout(2, 2));
        this.m_cSyncLabels = new Checkbox(PsConfig.getMessage(true, 24000, "Sync Labels"));
        this.m_cSyncLabels.setState(false);
        this.m_cSyncLabels.addItemListener(this);
        ((Container)component2).add(this.m_cSyncLabels);
        this.m_cShowMesh = new Checkbox(PsConfig.getMessage(24040));
        this.m_cShowMesh.setEnabled(false);
        this.m_cShowMesh.setState(true);
        this.m_cShowMesh.addItemListener(this);
        ((Container)component2).add(this.m_cShowMesh);
        this.m_cSyncSelect = new Checkbox(PsConfig.getMessage(true, 24000, "Sync Selection"));
        this.m_cSyncSelect.setState(true);
        this.m_cSyncSelect.addItemListener(this);
        ((Container)component2).add(this.m_cSyncSelect);
        this.m_bShowDomain = new Button(PsConfig.getMessage(24038));
        this.m_bShowDomain.setEnabled(false);
        this.m_bShowDomain.addActionListener(this);
        ((Container)component2).add(this.m_bShowDomain);
        panel2.add("4", component2);
        this.add(panel2);
        this.m_pTexture = new PsPanel();
        this.m_pTexture.setInsetSize(4);
        this.m_lNotice = new PsMultiLineLabel("\n" + PsConfig.getMessage(24041));
        this.m_pTexture.add(this.m_lNotice);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_tetraSet = (PgTetraSet)psUpdateIf;
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_tetraSet == null) {
            PsDebug.warning("missing tetraSet");
            return true;
        }
        if (this.m_bUpdateFromHere) {
            return true;
        }
        if (object == this.m_tetraSet) {
            this.setTitle(PsConfig.getMessage(24042) + ": " + this.m_tetraSet.getName());
            PsPanel.setState(this.m_cShowTexture, this.m_tetraSet.m_bShowTetraTexture);
            boolean bl = this.m_tetraSet.hasVertexTextures();
            boolean bl2 = this.m_tetraSet.hasTetraTextures();
            Checkbox checkbox = this.m_cVertexTex;
            Checkbox checkbox2 = this.m_cTetraTex;
            if (this.m_tetraSet.m_tetraTexture != null) {
                checkbox = this.m_cTetraTex;
                checkbox2 = this.m_cVertexTex;
            }
            if (this.m_gTypeMode.getSelectedCheckbox() != checkbox) {
                this.m_gTypeMode.setSelectedCheckbox(checkbox);
                checkbox.setEnabled(true);
                checkbox2.setEnabled(false);
            }
            if (bl || bl2) {
                PsPanel.setState(this.m_cVertexTex, bl);
                PsPanel.setState(this.m_cTetraTex, bl2);
                this.updateTextureGeometry(this.m_tetraSet);
                if (this.m_texGeom != null) {
                    this.m_bUpdateFromHere = true;
                    this.m_texGeom.update(null);
                    this.m_bUpdateFromHere = false;
                }
                int n = this.m_tetraSet.getDimOfTextures();
                if (this.m_cVertexTex.getState()) {
                    if (this.m_pTetraSlider.getComponentCount() != 0) {
                        this.m_pTetraSlider.removeAll();
                        this.m_pTetraSlider.validate();
                        this.validate();
                    }
                    this.m_texturePanel.setVector(this.m_tetraSet.getVertexTextures(), m_vertexHeader, this.m_tetraSet.getNumVertices(), n);
                } else if (this.m_cTetraTex.getState()) {
                    if (this.m_pTetraSlider.getComponentCount() == 0) {
                        this.m_pTetraSlider.add(this.m_tetraInd.getInfoPanel());
                        this.m_pTetraSlider.add(this.m_tetraInd.getInfoPanel());
                        this.m_pTetraSlider.validate();
                        this.validate();
                    }
                    this.m_tetraInd.setBounds(0, this.m_tetraSet.getNumTetras() - 1, 1, 5);
                    this.m_tetraInd.updatePanels(this.m_tetraInd);
                    int n2 = this.m_tetraInd.getValue();
                    int n3 = this.m_tetraSet.getTetra(n2).getSize();
                    this.m_texturePanel.setVector(this.m_tetraSet.getTetraTexture(n2), m_vertexHeader, n3, n);
                }
            } else if (this.m_pTetraSlider.getComponentCount() != 0) {
                this.m_pTetraSlider.removeAll();
                this.m_pTetraSlider.validate();
            }
            PsPanel.setEnabled(this.m_cShowTexture, bl || bl2);
            PsPanel.setEnabled(this.m_texturePanel, bl || bl2);
            PsPanel.setEnabled(this.m_pTetraSlider, bl || bl2);
            PgTexture pgTexture = this.m_tetraSet.getTexture();
            if (pgTexture != null) {
                PsPanel psPanel = pgTexture.getInfoPanel();
                if (this.m_pTexture.getComponentCount() > 0 && this.m_pTexture.getComponent(0) != psPanel) {
                    this.m_pTexture.removeAll();
                }
                if (this.m_pTexture.getComponentCount() == 0) {
                    this.m_pTexture.add(psPanel);
                    this.validate();
                }
                if (this.m_imgGeom != null) {
                    this.m_imgGeom.setTexture(pgTexture);
                }
                psPanel.update(pgTexture);
            } else {
                if (this.m_bDomainMode) {
                    this.closeDomainMode();
                }
                if (this.m_pTexture.getComponentCount() > 0 && this.m_pTexture.getComponent(0) != this.m_lNotice) {
                    this.m_pTexture.removeAll();
                    this.m_pTexture.add(this.m_lNotice);
                    this.validate();
                }
            }
            if (this.m_texGeom != null && this.m_imgGeom != null) {
                this.syncImageGeometry(this.m_texGeom.getBounds());
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            boolean bl3 = pgTexture != null && pgTexture.getImage() != null && (bl || bl2);
            bl3 = true;
            PsPanel.setEnabled(this.m_bShowDomain, bl3);
            PsPanel.setEnabled(this.m_cShowMesh, bl3);
            PsPanel.setEnabled(this.m_cSyncLabels, bl3);
            PsPanel.setEnabled(this.m_cSyncSelect, bl3);
            return super.update(object);
        }
        if (object == this.m_texGeom) {
            PdVector[] pdVectorArray = this.m_texGeom.getVertices();
            if (this.m_cVertexTex.getState()) {
                this.m_tetraSet.setVertexTextures(pdVectorArray);
            } else {
                PdVector[][] pdVectorArray2 = this.m_tetraSet.getTetraTextures();
                int n = this.m_tetraSet.getNumTetras();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    int n5 = pdVectorArray2[i].length;
                    for (int j = 0; j < n5; ++j) {
                        pdVectorArray2[i][j].copy(pdVectorArray[n4]);
                        ++n4;
                    }
                }
            }
            this.syncGeometrySelect(this.m_cSyncSelect.getState());
            this.m_texturePanel.update(this);
            if (this.m_texGeom != null && this.m_imgGeom != null && this.syncImageGeometry(this.m_texGeom.getBounds())) {
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            this.m_bUpdateFromHere = true;
            this.m_tetraSet.update(this);
            this.m_bUpdateFromHere = false;
            return true;
        }
        if (object == this.m_texturePanel) {
            if (this.m_cVertexTex.getState()) {
                this.m_texGeom.setVertices(this.m_tetraSet.getVertexTextures());
            } else {
                PdVector[][] pdVectorArray = this.m_tetraSet.getTetraTextures();
                int n = this.m_tetraSet.getNumTetras();
                int n6 = this.m_tetraInd.getValue();
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    int n8 = pdVectorArray[i].length;
                    if (i == n6) {
                        for (int j = 0; j < n8; ++j) {
                            this.m_texGeom.setVertex(n7, pdVectorArray[i][j]);
                            ++n7;
                        }
                        continue;
                    }
                    n7 += n8;
                }
            }
            this.m_bUpdateFromHere = true;
            this.m_texGeom.update(null);
            this.m_bUpdateFromHere = false;
            if (this.m_texGeom != null && this.m_imgGeom != null && this.syncImageGeometry(this.m_texGeom.getBounds())) {
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            this.syncGeometrySelect(this.m_cSyncSelect.getState());
            this.m_bUpdateFromHere = true;
            this.m_tetraSet.update(this);
            this.m_bUpdateFromHere = false;
            return true;
        }
        if (object == this.m_tetraInd) {
            int n = this.m_tetraInd.getValue();
            int n9 = this.m_tetraSet.getTetra(n).getSize();
            this.m_texturePanel.setVector(this.m_tetraSet.getTetraTexture(n), m_vertexHeader, n9, this.m_tetraSet.getDimOfTextures());
        }
        return super.update(object);
    }

    protected void updateTextureGeometry(PgTetraSet pgTetraSet) {
        if (!(pgTetraSet.hasVertexTextures() && this.m_cVertexTex.getState() || pgTetraSet.hasTetraTextures() && this.m_cTetraTex.getState())) {
            this.m_texGeom = null;
            return;
        }
        if (this.m_texGeom == null) {
            this.m_texGeom = new PgTetraSet(3);
            this.m_texGeom.setParent(this);
        }
        this.m_texGeom.setName(PsConfig.getMessage(15002) + " " + pgTetraSet.getName());
        this.m_texGeom.setDimOfVertices(pgTetraSet.getDimOfTextures());
        if (pgTetraSet.hasVertexTextures() && this.m_cVertexTex.getState()) {
            this.m_texGeom.showVertexTexture(true);
            this.m_texGeom.showTetraTexture(false);
            this.m_texGeom.setNumVertices(pgTetraSet.getNumVertices());
            this.m_texGeom.setVertices(pgTetraSet.getVertexTextures());
            this.m_texGeom.copyConnectivity(pgTetraSet);
        } else if (pgTetraSet.hasTetraTextures() && this.m_cTetraTex.getState()) {
            this.m_texGeom.showVertexTexture(false);
            this.m_texGeom.showTetraTexture(true);
            int n = pgTetraSet.getNumTetraIndices();
            int n2 = pgTetraSet.getNumTetras();
            this.m_texGeom.setNumVertices(n);
            this.m_texGeom.setNumTetras(n2);
            PiVector[] piVectorArray = this.m_texGeom.getTetras();
            PiVector.copy(piVectorArray, 0, pgTetraSet.getTetras(), 0, n2);
            PiVector.setConstant(this.m_texGeom.m_neighbour, -1);
            this.m_texGeom.assureTetraTextures();
            PdVector[][] pdVectorArray = pgTetraSet.getTetraTextures();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    this.m_texGeom.setVertex(n3, pdVectorArray[i][j]);
                    piVectorArray[i].m_data[j] = n3++;
                }
            }
        }
        this.syncTextureLabels(this.m_cSyncLabels.getState());
        this.syncTextureSelect(this.m_cSyncSelect.getState());
    }

    private boolean syncImageGeometry(PdVector[] pdVectorArray) {
        PdVector[] pdVectorArray2 = PdVector.realloc(null, 2, 3);
        for (int i = 0; i < 2; ++i) {
            pdVectorArray2[0].setEntry(i, Math.floor(pdVectorArray[0].getEntry(i)));
            pdVectorArray2[1].setEntry(i, Math.ceil(pdVectorArray[1].getEntry(i)));
        }
        PdVector[] pdVectorArray3 = this.m_imgGeom.getBounds();
        if (PdVector.sqrDist(pdVectorArray2[0], pdVectorArray3[0]) < 1.0E-10 && PdVector.sqrDist(pdVectorArray2[1], pdVectorArray3[1]) < 1.0E-10) {
            return false;
        }
        this.m_imgGeom.computePlane(20, 20, pdVectorArray2[0].getEntry(0), pdVectorArray2[0].getEntry(1), pdVectorArray2[1].getEntry(0), pdVectorArray2[1].getEntry(1));
        this.m_imgGeom.assureVertexTextures();
        this.m_imgGeom.setVertexTextures(this.m_imgGeom.getVertices());
        return true;
    }

    private void syncTextureLabels(boolean bl) {
        if (bl) {
            this.m_texGeom.showVertexLabels(this.m_tetraSet.isShowingVertexLabels());
            this.m_texGeom.showVertices(this.m_tetraSet.isShowingVertexLabels());
            this.m_texGeom.showTetraLabels(this.m_tetraSet.isShowingTetraLabels());
        } else {
            this.m_texGeom.showVertexLabels(false);
            this.m_texGeom.showVertices(false);
            this.m_texGeom.showTetraLabels(false);
        }
    }

    private void syncTextureSelect(boolean bl) {
        if (!bl) {
            return;
        }
        PdVector[] pdVectorArray = this.m_tetraSet.getVertices();
        PdVector[] pdVectorArray2 = this.m_texGeom.getVertices();
        if (this.m_cVertexTex.getState()) {
            PdVector[] pdVectorArray3 = this.m_tetraSet.getVertexTextures();
            int n = this.m_texGeom.getNumVertices();
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray[i].hasTag(1)) {
                    pdVectorArray2[i].setTag(1);
                } else {
                    pdVectorArray2[i].clearTag(1);
                }
                if (pdVectorArray[i].hasTag(1)) {
                    pdVectorArray3[i].setTag(1);
                    continue;
                }
                pdVectorArray3[i].clearTag(1);
            }
        } else {
            PiVector[] piVectorArray = this.m_tetraSet.getTetras();
            PdVector[][] pdVectorArray4 = this.m_tetraSet.getTetraTextures();
            int n = this.m_tetraSet.getNumTetras();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = piVectorArray[i].getSize();
                for (int j = 0; j < n3; ++j) {
                    int n4 = piVectorArray[i].getEntry(j);
                    if (pdVectorArray[n4].hasTag(1)) {
                        pdVectorArray2[n2].setTag(1);
                    } else {
                        pdVectorArray2[n2].clearTag(1);
                    }
                    if (pdVectorArray[n4].hasTag(1)) {
                        pdVectorArray4[i][j].setTag(1);
                    } else {
                        pdVectorArray4[i][j].clearTag(1);
                    }
                    ++n2;
                }
            }
        }
    }

    private void syncGeometrySelect(boolean bl) {
        if (!bl) {
            return;
        }
        int n = this.m_tetraSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_tetraSet.getVertices();
        PdVector[] pdVectorArray2 = this.m_texGeom.getVertices();
        if (this.m_cVertexTex.getState()) {
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray2[i].hasTag(1)) {
                    pdVectorArray[i].setTag(1);
                    continue;
                }
                pdVectorArray[i].clearTag(1);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].clearTag(1);
            }
            PiVector[] piVectorArray = this.m_tetraSet.getTetras();
            PdVector[][] pdVectorArray3 = this.m_tetraSet.getTetraTextures();
            int n2 = this.m_tetraSet.getNumTetras();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    int n5 = piVectorArray[i].getEntry(j);
                    if (pdVectorArray2[n3].hasTag(1)) {
                        pdVectorArray[n5].setTag(1);
                    }
                    if (pdVectorArray2[n3].hasTag(1)) {
                        pdVectorArray3[i][j].setTag(1);
                    } else {
                        pdVectorArray3[i][j].clearTag(1);
                    }
                    ++n3;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bClose) {
            this.closeDomainMode();
        } else if (object == this.m_bShowDomain) {
            if (!this.m_bDomainMode) {
                this.m_bDomainMode = true;
                this.m_colorDomainMode = this.m_bShowDomain.getBackground();
                this.m_bShowDomain.setBackground(Color.red);
                this.m_bShowDomain.setLabel(PsConfig.getMessage(true, 24000, "Close ..."));
                this.updateTextureGeometry(this.m_tetraSet);
                this.m_texGeom.showVertexTexture(false);
                this.m_texGeom.setTexture(null);
                this.m_texGeom.showTetraTexture(false);
                this.m_texGeom.showTetras(false);
                this.m_texGeom.showEdges(true);
                this.m_imgGeom = new PgTetraSet(2);
                this.m_imgGeom.setName(PsConfig.getMessage(15003) + " " + this.m_tetraSet.getName());
                this.m_imgGeom.showEdges(false);
                this.m_imgGeom.showVertexTexture(true);
                if (this.m_tetraSet.getTexture() != null) {
                    this.m_imgGeom.setTexture((PgTexture)this.m_tetraSet.getTexture().clone());
                }
                if (this.syncImageGeometry(this.m_texGeom.getBounds())) {
                    this.m_bUpdateFromHere = true;
                    this.m_imgGeom.update(null);
                    this.m_bUpdateFromHere = false;
                }
                PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
                this.m_display = pvViewerIf.newDisplay(PsConfig.getMessage(15004), true, false);
                this.m_display.setLightingModel(0);
                this.m_display.setGridIncrements(0, new PdVector(1.0, 1.0));
                Frame frame = this.m_display.getFrame();
                frame.addWindowListener(this);
                frame.setMenuBar(null);
                Panel panel = new Panel(new FlowLayout());
                this.m_bClose = new Button(PsConfig.getMessage(24140));
                this.m_bClose.addActionListener(this);
                panel.add(this.m_bClose);
                frame.add((Component)panel, "South");
                frame.validate();
                this.m_display.addGeometry(this.m_texGeom);
                this.m_display.addGeometry(this.m_imgGeom);
                this.m_display.setBackgroundColor(Color.red);
                this.m_display.setDrawingOrder(2, this.m_imgGeom);
                this.m_display.setEnabledZBuffer(true);
                this.m_display.selectCamera(0);
                ((Component)frame).setVisible(true);
            } else {
                this.closeDomainMode();
            }
        }
    }

    private void closeDomainMode() {
        this.m_bDomainMode = false;
        this.m_bShowDomain.setBackground(this.m_colorDomainMode);
        this.m_bShowDomain.setLabel(PsConfig.getMessage(24038));
        if (this.m_display == null) {
            return;
        }
        PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
        if (pvViewerIf.hasDisplay(this.m_display)) {
            pvViewerIf.removeDisplay(this.m_display);
        }
        this.m_display = null;
        this.m_texGeom = null;
        this.m_imgGeom = null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        PsDebug.notify("entered");
        if (object == this.m_cShowTexture) {
            PsDebug.notify("switch show texture");
            boolean bl = this.m_cShowTexture.getState();
            if (bl) {
                this.assureTexture();
            }
            if (this.m_tetraSet.hasVertexTextures()) {
                this.m_tetraSet.showVertexTexture(bl);
            } else if (this.m_tetraSet.hasTetraTextures()) {
                this.m_tetraSet.showTetraTexture(bl);
            }
            this.m_tetraSet.update(this.m_tetraSet);
            return;
        }
        if (object == this.m_cVertexTex) {
            this.m_tetraSet.showVertexTexture(this.m_cVertexTex.getState());
        } else if (object == this.m_cTetraTex) {
            this.m_tetraSet.showTetraTexture(this.m_cTetraTex.getState());
        } else if (object == this.m_cSyncLabels) {
            this.syncTextureLabels(this.m_cSyncLabels.getState());
            if (this.m_texGeom != null) {
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else if (object == this.m_cSyncSelect) {
            this.syncTextureSelect(this.m_cSyncSelect.getState());
            this.m_texturePanel.update(this);
            if (this.m_texGeom != null) {
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else if (object == this.m_cShowMesh) {
            if (this.m_texGeom != null) {
                this.m_texGeom.setVisible(this.m_cShowMesh.getState());
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else {
            return;
        }
        this.m_tetraSet.update(this);
    }

    private boolean assureTexture() {
        Object object;
        boolean bl;
        PgTexture pgTexture = this.m_tetraSet.getTexture();
        boolean bl2 = bl = pgTexture == null;
        if (pgTexture == null) {
            pgTexture = new PgTexture();
        }
        if (pgTexture.getImageName() == null) {
            object = PsConfig.getInstBase();
            if (PuString.isEmpty((String)object)) {
                object = PsConfig.getCodeBase();
            }
            pgTexture.setImageName((String)object + PsConfig.getJavaViewLogo());
        }
        if (pgTexture.getImage() == null && (object = pgTexture.loadImage(null)) == null) {
            PsDebug.warning("loading default texture failed, use texture panel.");
        }
        if (bl) {
            this.m_tetraSet.setTexture(pgTexture);
        }
        return true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        this.closeDomainMode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

