/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuProj;
import jv.vecmath.PuVectorGeom;

public class PgPointSet
extends PgGeometry {
    protected boolean m_bEnabledIndexLabels;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected int m_dimOfColors;
    protected PgTexture m_texture;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected PdVector[] m_vertexTexture;
    protected PuDouble m_shininess;
    protected PdColor m_specularColor;
    protected PuDouble m_transparency;
    protected boolean m_bShowTransparency;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected PdVector m_vertexSize;
    protected boolean m_bShowVertexSizes;
    protected int m_dimOfVectors;
    protected int m_numVectorFields;
    protected Vector m_vectorField;
    protected PgVectorField m_selectedVectorField;
    protected boolean m_bShowSingleVectorField;
    protected boolean m_bShowVectorFields;
    protected boolean m_bShowVectorArrows;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected boolean m_bShowVertexOutline;
    protected PuDouble m_globalVertexSize;
    protected boolean m_bShowVertexColors;
    protected PdColor m_globalVertexColor;
    protected PdColor m_globalVertexTagColor;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected PuDouble m_globalVertexNormalLength;
    protected PuDouble m_globalVertexNormalSize;
    protected PdColor m_globalVertexNormalColor;
    protected Vector m_geomItem;
    protected boolean m_bUpdateSender = false;
    static /* synthetic */ Class class$jv$geom$PgPointSet;

    public PgPointSet() {
        this(3);
    }

    public PgPointSet(int n) {
        super(n);
        this.setType(30);
        this.setTag(4);
        this.setTag(5);
        this.setTag(8);
        this.setTag(9);
        this.setTag(20);
        this.addGeometryItem("Name");
        this.addGeometryItem("Vertex");
        this.setDimOfSimplex(0);
        this.m_dimOfVectors = n;
        this.m_vertex = new PdVector[0];
        this.m_globalVertexSize = new PuDouble(PsConfig.getMessage(24043), this);
        this.m_globalVertexColor = new PdColor(PsConfig.getMessage(24036), this);
        this.m_globalVertexTagColor = new PdColor(PsConfig.getMessage(24044), this);
        this.m_globalVertexNormalLength = new PuDouble(PsConfig.getMessage(24045), this);
        this.m_globalVertexNormalSize = new PuDouble(PsConfig.getMessage(24046), this);
        this.m_globalVertexNormalColor = new PdColor(PsConfig.getMessage(24047), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage(24048), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage(24049), this);
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage(24050), this);
        this.m_shininess = new PuDouble(PsConfig.getMessage(24368), this);
        this.m_specularColor = new PdColor(PsConfig.getMessage(24369), this);
        this.m_transparency = new PuDouble(PsConfig.getMessage(24034), this);
        this.m_bShowVectorColors = false;
        if (this.getClass() == (class$jv$geom$PgPointSet == null ? (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")) : class$jv$geom$PgPointSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_dimOfColors = 3;
        this.m_vertexColor = null;
        this.m_bShowVertexColors = false;
        this.m_vertexTexture = null;
        this.m_texture = null;
        this.m_bEnabledIndexLabels = true;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.setMaxNumVertices(0);
        this.m_globalVertexColor.setColor(Color.red);
        this.m_globalVertexTagColor.setColor(Color.magenta);
        this.m_bShowVertices = true;
        this.m_bShowTaggedVertices = true;
        this.m_bShowVertexOutline = true;
        this.m_vertexSize = null;
        this.m_bShowVertexSizes = false;
        this.m_globalVertexSize.setDefBounds(0.0, 50.0, 1.0, 5.0);
        this.m_globalVertexSize.setDefValue(2.0);
        this.m_globalVertexSize.init();
        this.m_vertexNormal = null;
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_globalVertexNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalVertexNormalSize.setDefValue(1.0);
        this.m_globalVertexNormalSize.init();
        this.m_globalVertexNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVertexNormalLength.setDefValue(0.5);
        this.m_globalVertexNormalLength.init();
        this.m_globalVertexNormalColor.setColor(Color.yellow);
        this.m_shininess.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_shininess.setDefValue(10.0);
        this.m_shininess.init();
        this.m_specularColor.setColor(Color.white);
        this.m_bShowTransparency = false;
        this.m_transparency.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_transparency.setDefValue(0.4);
        this.m_transparency.init();
        this.m_numVectorFields = 0;
        this.m_vectorField = null;
        this.m_selectedVectorField = null;
        this.m_bShowSingleVectorField = false;
        this.m_bShowVectorFields = true;
        this.m_bShowVectorArrows = false;
        this.m_globalVectorSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.init();
        this.m_globalVectorLength.setDefValue(1.0);
        this.m_globalVectorLength.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_bShowVertexTexture = false;
        this.m_dimOfTextures = 2;
    }

    public void addGeometryItem(String string) {
        if (this.m_geomItem == null) {
            this.m_geomItem = new Vector();
        }
        this.m_geomItem.addElement(string);
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 50: {
                this.showVertices(bl);
                break;
            }
            default: {
                super.setState(n, bl);
            }
        }
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setEnabledInstanceSharing(PsJavaView.m_bInstanceSharing);
        pgJvxSrc.setType(30);
        pgJvxSrc.showIndices(this.isShowingIndices());
        pgJvxSrc.setEnabledIndexLabels(this.isEnabledIndexLabels());
        pgJvxSrc.showVertexLabels(this.isShowingVertexLabels());
        pgJvxSrc.showTaggedVertices(this.isShowingTaggedVertices());
        pgJvxSrc.showVertices(this.isShowingVertices());
        pgJvxSrc.showVertexOutline(this.isShowingVertexOutline());
        pgJvxSrc.setDimOfVertices(this.getDimOfVertices());
        pgJvxSrc.setNumVertices(this.getNumVertices());
        pgJvxSrc.setVertices(this.getVertices());
        if (this.hasVertexColors()) {
            pgJvxSrc.showVertexColors(this.isShowingVertexColors());
            pgJvxSrc.setVertexColors(this.getVertexColors());
        } else {
            pgJvxSrc.showVertexColors(false);
        }
        pgJvxSrc.setGlobalVertexColor(this.getGlobalVertexColor());
        pgJvxSrc.setGlobalVertexTagColor(this.getGlobalVertexTagColor());
        if (this.hasVertexNormals()) {
            pgJvxSrc.showVertexNormals(this.isShowingVertexNormals());
            pgJvxSrc.setVertexNormals(this.getVertexNormals());
        } else {
            pgJvxSrc.showVertexNormals(false);
        }
        pgJvxSrc.showVertexNormalArrow(this.isShowingVertexNormalArrow());
        pgJvxSrc.setGlobalVertexNormalColor(this.getGlobalVertexNormalColor());
        pgJvxSrc.setGlobalVertexNormalLength(this.getGlobalVertexNormalLength());
        pgJvxSrc.setGlobalVertexNormalSize(this.getGlobalVertexNormalSize());
        if (this.getGlobalVertexNormalColor() != null) {
            pgJvxSrc.setGlobalElementNormalColor(this.getGlobalVertexNormalColor());
        }
        pgJvxSrc.setGlobalElementNormalLength(this.getGlobalVertexNormalLength());
        pgJvxSrc.setGlobalElementNormalSize(this.getGlobalVertexNormalSize());
        if (this.hasVertexSizes()) {
            pgJvxSrc.showVertexSizes(this.isShowingVertexSizes());
            pgJvxSrc.setVertexSizes(this.getVertexSizes());
        } else {
            pgJvxSrc.showVertexSizes(false);
        }
        pgJvxSrc.setGlobalVertexSize(this.getGlobalVertexSize());
        pgJvxSrc.setShininess(this.getShininess());
        if (this.getSpecularColor() != null) {
            pgJvxSrc.setSpecularColor(this.getSpecularColor());
        }
        pgJvxSrc.showTransparency(this.isShowingTransparency());
        pgJvxSrc.setTransparency(this.getTransparency());
        if (this.m_texture != null) {
            pgJvxSrc.setTextureImage(this.m_texture.getImage());
            pgJvxSrc.setTextureImageName(this.m_texture.getImageName());
            pgJvxSrc.setBlendingMode(this.m_texture.getBlendingMode());
            pgJvxSrc.setFilterType(this.m_texture.getFilterType());
            pgJvxSrc.setTextureSide(this.m_texture.getTextureSide());
            pgJvxSrc.setTextureImageBnd(this.m_texture.getTextureImageBnd());
            pgJvxSrc.setTextureTiling(this.m_texture.getTiling());
        }
        if (this.hasVertexTextures()) {
            pgJvxSrc.showVertexTexture(this.isShowingVertexTexture());
            pgJvxSrc.setVertexTextures(this.getVertexTextures());
        } else {
            pgJvxSrc.showVertexTexture(false);
        }
        PgVectorField[] pgVectorFieldArray = this.getVectorFieldsSorted();
        if (pgVectorFieldArray != null) {
            int n = pgVectorFieldArray.length;
            pgJvxSrc.setNumVectorFields(n);
            pgJvxSrc.showVectorFields(this.isShowingVectorFields());
            for (int i = 0; i < n; ++i) {
                pgJvxSrc.showVectorField(i, pgVectorFieldArray[i].isVisible());
                pgJvxSrc.setVectorFieldName(i, pgVectorFieldArray[i].getName());
                if (pgVectorFieldArray[i].getBasedOn() == 0) {
                    pgJvxSrc.setVectorElementBased(i, false);
                } else {
                    pgJvxSrc.setVectorElementBased(i, true);
                }
                pgJvxSrc.setNumVectors(i, pgVectorFieldArray[i].getNumVectors(), pgVectorFieldArray[i].getDimOfVertices());
                pgJvxSrc.setVectors(i, pgVectorFieldArray[i].getVectors());
                pgJvxSrc.setVectorColors(i, pgVectorFieldArray[i].getVectorColors());
                boolean bl = pgVectorFieldArray[i].isShowingIndividualMaterial();
                pgJvxSrc.showVectorFieldMaterials(i, bl);
                if (bl) {
                    pgJvxSrc.showVectorArrows(i, pgVectorFieldArray[i].isShowingVectorArrows());
                    pgJvxSrc.setGlobalVectorSize(i, pgVectorFieldArray[i].getGlobalVectorSize());
                    pgJvxSrc.setGlobalVectorLength(i, pgVectorFieldArray[i].getGlobalVectorLength());
                    pgJvxSrc.setGlobalVectorColor(i, pgVectorFieldArray[i].getGlobalVectorColor());
                    pgJvxSrc.showVectorColors(i, pgVectorFieldArray[i].isShowingVectorColors());
                    continue;
                }
                pgJvxSrc.showVectorArrows(i, this.isShowingVectorArrows());
                pgJvxSrc.setGlobalVectorSize(i, this.getGlobalVectorSize());
                pgJvxSrc.setGlobalVectorLength(i, this.getGlobalVectorLength());
                pgJvxSrc.setGlobalVectorColor(i, this.getGlobalVectorColor());
                pgJvxSrc.showVectorColors(i, this.isShowingVectorColors());
            }
        }
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        if (pgJvxSrc == null) {
            PsDebug.warning("Argument is null.");
            return;
        }
        super.setJvx(pgJvxSrc);
        this.showIndices(pgJvxSrc.isShowingIndices());
        this.setEnabledIndexLabels(pgJvxSrc.isEnabledIndexLabels());
        this.showVertexLabels(pgJvxSrc.isShowingVertexLabels());
        this.showVertexOutline(pgJvxSrc.isShowingVertexOutline());
        this.showTaggedVertices(pgJvxSrc.isShowingTaggedVertices());
        this.showVertices(pgJvxSrc.isShowingVertices());
        this.setNumVertices(pgJvxSrc.getNumVertices());
        this.setVertices(pgJvxSrc.getVertices());
        if (pgJvxSrc.getGlobalVertexColor() != null) {
            this.setGlobalVertexColor(pgJvxSrc.getGlobalVertexColor());
        }
        if (pgJvxSrc.getGlobalVertexTagColor() != null) {
            this.setGlobalVertexTagColor(pgJvxSrc.getGlobalVertexTagColor());
        }
        this.setVertexColors(pgJvxSrc.getVertexColors());
        this.showVertexColors(pgJvxSrc.isShowingVertexColors());
        this.showVertexNormals(pgJvxSrc.isShowingVertexNormals());
        this.showVertexNormalArrow(pgJvxSrc.isShowingVertexNormalArrow());
        this.setVertexNormals(pgJvxSrc.getVertexNormals());
        this.showVertexSizes(pgJvxSrc.isShowingVertexSizes());
        this.setVertexSizes(pgJvxSrc.getVertexSizes());
        this.setGlobalVertexSize(pgJvxSrc.getGlobalVertexSize());
        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
            this.setGlobalVertexNormalColor(pgJvxSrc.getGlobalVertexNormalColor());
        }
        this.setGlobalVertexNormalLength(pgJvxSrc.getGlobalVertexNormalLength());
        this.setGlobalVertexNormalSize(pgJvxSrc.getGlobalVertexNormalSize());
        this.setShininess(pgJvxSrc.getShininess());
        if (pgJvxSrc.getSpecularColor() != null) {
            this.setSpecularColor(pgJvxSrc.getSpecularColor());
        }
        this.showTransparency(pgJvxSrc.isShowingTransparency());
        this.setTransparency(pgJvxSrc.getTransparency());
        if (pgJvxSrc.getTextureImage() != null || pgJvxSrc.getTextureImageName() != null) {
            if (this.m_texture == null) {
                this.setTexture(new PgTexture());
            }
            if (pgJvxSrc.getTextureImage() != null) {
                this.m_texture.setImage(pgJvxSrc.getTextureImage());
            }
            if (pgJvxSrc.getTextureImageName() != null) {
                this.m_texture.setImageName(pgJvxSrc.getTextureImageName());
            }
            this.m_texture.setBlendingMode(pgJvxSrc.getBlendingMode());
            this.m_texture.setFilterType(pgJvxSrc.getFilterType());
            this.m_texture.setTextureSide(pgJvxSrc.getTextureSide());
            this.m_texture.setTextureImageBnd(pgJvxSrc.getTextureImageBnd());
            this.m_texture.setTiling(pgJvxSrc.getTextureTiling());
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            this.assureVertexTextures();
        }
        this.setVertexTextures(pgJvxSrc.getVertexTextures());
        this.showVertexTexture(pgJvxSrc.isShowingVertexTexture());
        if (pgJvxSrc.getNumVectorFields() > 0) {
            this.removeAllVectorFields();
            int n = pgJvxSrc.getNumVectorFields();
            this.showVectorFields(pgJvxSrc.isShowingVectorFields());
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                PgVectorField pgVectorField = new PgVectorField(pgJvxSrc.getDimOfVectors(i));
                pgVectorField.setName(pgJvxSrc.getVectorFieldName(i));
                this.addVectorField(pgVectorField);
                pgVectorField.setVisible(pgJvxSrc.isShowingVectorField(i));
                boolean bl2 = pgJvxSrc.isShowingVectorFieldMaterials(i);
                pgVectorField.showIndividualMaterial(bl2);
                if (bl2) {
                    pgVectorField.showVectorArrows(pgJvxSrc.isShowingVectorArrows(i));
                    pgVectorField.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(i));
                    pgVectorField.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(i));
                    if (pgJvxSrc.getGlobalVectorColor(i) != null) {
                        pgVectorField.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(i));
                    }
                    pgVectorField.showVectorColors(pgJvxSrc.isShowingVectorColors(i));
                } else {
                    if (!bl) {
                        bl = true;
                        this.showVectorArrows(pgJvxSrc.isShowingVectorArrows(i));
                        this.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(i));
                        this.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(i));
                        if (pgJvxSrc.getGlobalVectorColor(i) != null) {
                            this.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(i));
                        }
                    }
                    pgVectorField.showVectorArrows(this.isShowingVectorArrows());
                    pgVectorField.setGlobalVectorSize(this.getGlobalVectorSize());
                    pgVectorField.setGlobalVectorLength(this.getGlobalVectorLength());
                    if (this.getGlobalVectorColor() != null) {
                        pgVectorField.setGlobalVectorColor(this.getGlobalVectorColor());
                    }
                    pgVectorField.showVectorColors(this.isShowingVectorColors());
                }
                if (pgJvxSrc.isVectorElementBased(i)) continue;
                PdVector[] pdVectorArray = pgJvxSrc.getVectors(i);
                if (pdVectorArray == null) {
                    PsDebug.warning("missing vectors in vector field[" + i + "].");
                    return;
                }
                int n2 = pdVectorArray.length;
                pgVectorField.setGeometry(this);
                pgVectorField.setBasedOn(0);
                pgVectorField.setNumVectors(n2);
                pgVectorField.setVectorColors(pgJvxSrc.getVectorFieldColors(i));
                pgVectorField.setVectors(pdVectorArray);
            }
        }
    }

    public Object clone() {
        PgPointSet pgPointSet = (PgPointSet)super.clone();
        if (pgPointSet == null) {
            return null;
        }
        pgPointSet.m_globalVertexSize = (PuDouble)this.m_globalVertexSize.clone();
        pgPointSet.m_globalVertexSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexColor = (PdColor)this.m_globalVertexColor.clone();
        pgPointSet.m_globalVertexColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexTagColor = (PdColor)this.m_globalVertexTagColor.clone();
        pgPointSet.m_globalVertexTagColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalLength = (PuDouble)this.m_globalVertexNormalLength.clone();
        pgPointSet.m_globalVertexNormalLength.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalSize = (PuDouble)this.m_globalVertexNormalSize.clone();
        pgPointSet.m_globalVertexNormalSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalColor = (PdColor)this.m_globalVertexNormalColor.clone();
        pgPointSet.m_globalVertexNormalColor.setParent(pgPointSet);
        pgPointSet.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        pgPointSet.m_globalVectorSize.setParent(pgPointSet);
        pgPointSet.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        pgPointSet.m_globalVectorLength.setParent(pgPointSet);
        pgPointSet.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        pgPointSet.m_globalVectorColor.setParent(pgPointSet);
        pgPointSet.m_shininess = (PuDouble)this.m_shininess.clone();
        pgPointSet.m_shininess.setParent(pgPointSet);
        pgPointSet.m_specularColor = (PdColor)this.m_specularColor.clone();
        pgPointSet.m_specularColor.setParent(pgPointSet);
        pgPointSet.m_transparency = (PuDouble)this.m_transparency.clone();
        pgPointSet.m_transparency.setParent(pgPointSet);
        if (this.m_texture != null) {
            pgPointSet.m_texture = (PgTexture)this.m_texture.clone();
            pgPointSet.m_texture.setParent(pgPointSet);
        }
        if (this.m_vertexTexture != null) {
            pgPointSet.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_vertex != null) {
            pgPointSet.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            pgPointSet.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexNormal != null) {
            pgPointSet.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vertexSize != null) {
            pgPointSet.m_vertexSize = (PdVector)this.m_vertexSize.clone();
        }
        if (this.m_vectorField != null) {
            pgPointSet.m_vectorField = null;
            pgPointSet.m_numVectorFields = 0;
            pgPointSet.m_selectedVectorField = null;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField != null) {
                    PgVectorField pgVectorField2 = (PgVectorField)pgVectorField.clone();
                    pgPointSet.addVectorField(pgVectorField2);
                    pgVectorField2.setGeometry(pgPointSet);
                    if (this.m_selectedVectorField != pgVectorField) continue;
                    pgPointSet.selectVectorField(pgVectorField2);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return pgPointSet;
    }

    public void copy(PsObject psObject) {
        PgVectorField pgVectorField;
        PgVectorField pgVectorField2;
        int n;
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPointSet)) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)psObject;
        this.m_dimOfVectors = pgPointSet.m_dimOfVectors;
        this.m_dimOfColors = pgPointSet.m_dimOfColors;
        this.m_dimOfTextures = pgPointSet.m_dimOfTextures;
        this.m_bEnabledIndexLabels = pgPointSet.m_bEnabledIndexLabels;
        this.m_bShowIndices = pgPointSet.m_bShowIndices;
        this.m_bShowVertexLabels = pgPointSet.m_bShowVertexLabels;
        this.m_bShowVertexOutline = pgPointSet.m_bShowVertexOutline;
        this.m_bShowVertexTexture = pgPointSet.m_bShowVertexTexture;
        this.m_bShowTransparency = pgPointSet.m_bShowTransparency;
        this.m_bShowVectorFields = pgPointSet.m_bShowVectorFields;
        this.m_bShowVectorArrows = pgPointSet.m_bShowVectorArrows;
        this.m_bShowVectorColors = pgPointSet.m_bShowVectorColors;
        this.m_bShowVertices = pgPointSet.m_bShowVertices;
        this.m_bShowTaggedVertices = pgPointSet.m_bShowTaggedVertices;
        this.m_bShowVertexColors = pgPointSet.m_bShowVertexColors;
        this.m_bShowVertexNormals = pgPointSet.m_bShowVertexNormals;
        this.m_bShowVertexNormalArrow = pgPointSet.m_bShowVertexNormalArrow;
        this.m_globalVertexColor.copy(pgPointSet.m_globalVertexColor);
        this.m_globalVertexTagColor.copy(pgPointSet.m_globalVertexTagColor);
        this.m_globalVertexSize.copy(pgPointSet.m_globalVertexSize);
        this.m_globalVertexNormalColor.copy(pgPointSet.m_globalVertexNormalColor);
        this.m_globalVertexNormalLength.copy(pgPointSet.m_globalVertexNormalLength);
        this.m_globalVertexNormalSize.copy(pgPointSet.m_globalVertexNormalSize);
        this.m_globalVectorColor.copy(pgPointSet.m_globalVectorColor);
        this.m_globalVectorLength.copy(pgPointSet.m_globalVectorLength);
        this.m_globalVectorSize.copy(pgPointSet.m_globalVectorSize);
        this.m_shininess.copy(pgPointSet.m_shininess);
        this.m_specularColor.copy(pgPointSet.m_specularColor);
        this.m_transparency.copy(pgPointSet.m_transparency);
        this.setNumVertices(pgPointSet.getNumVertices());
        if (this.m_dim == pgPointSet.getDimOfVertices()) {
            PdVector.copy(this.m_vertex, 0, pgPointSet.getVertices(), 0, this.m_numVertices);
        }
        if (pgPointSet.m_vertexColor != null) {
            this.assureVertexColors();
            PdColor.copy(this.m_vertexColor, 0, pgPointSet.getVertexColors(), 0, this.m_numVertices);
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, 0, pgPointSet.getVertexNormals(), 0, this.m_numVertices);
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.copy(0, pgPointSet.getVertexSizes(), 0, this.m_numVertices);
        } else {
            this.m_vertexSize = null;
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, 0, pgPointSet.getVertexTextures(), 0, this.m_numVertices);
        } else {
            this.m_vertexTexture = null;
        }
        this.setTexture(pgPointSet.m_texture);
        this.setDimOfVectors(pgPointSet.getDimOfVectors());
        int n2 = this.getNumVectorFields();
        int n3 = pgPointSet.getNumVectorFields();
        int n4 = Math.min(n2, n3);
        for (n = 0; n < n4; ++n) {
            pgVectorField2 = pgPointSet.getVectorField(n);
            pgVectorField = this.getVectorField(n);
            pgVectorField.copy(pgVectorField2);
            if (pgPointSet.m_selectedVectorField != pgVectorField2) continue;
            this.m_selectedVectorField = pgVectorField;
        }
        for (n = n2; n < n3; ++n) {
            pgVectorField2 = pgPointSet.getVectorField(n);
            pgVectorField = (PgVectorField)pgVectorField2.clone();
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setGeometry(this);
            }
            this.addVectorField(pgVectorField);
            if (pgPointSet.m_selectedVectorField != pgVectorField2) continue;
            this.m_selectedVectorField = pgVectorField;
        }
        for (n = n2 - 1; n >= n3; --n) {
            this.removeVectorField(this.getVectorField(n3));
        }
    }

    public void copySelect(PsObject psObject, PiVector piVector) {
        PgVectorField pgVectorField;
        PgVectorField pgVectorField2;
        int n;
        int n2;
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPointSet)) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)psObject;
        this.m_bEnabledIndexLabels = pgPointSet.m_bEnabledIndexLabels;
        this.m_bShowIndices = pgPointSet.m_bShowIndices;
        this.m_bShowVertexLabels = pgPointSet.m_bShowVertexLabels;
        this.m_bShowVertexOutline = pgPointSet.m_bShowVertexOutline;
        this.m_bShowVertexTexture = pgPointSet.m_bShowVertexTexture;
        this.m_bShowTransparency = pgPointSet.m_bShowTransparency;
        this.m_bShowVectorFields = pgPointSet.m_bShowVectorFields;
        this.m_bShowVectorArrows = pgPointSet.m_bShowVectorArrows;
        this.m_bShowVectorColors = pgPointSet.m_bShowVectorColors;
        this.m_bShowVertices = pgPointSet.m_bShowVertices;
        this.m_bShowTaggedVertices = pgPointSet.m_bShowTaggedVertices;
        this.m_bShowVertexColors = pgPointSet.m_bShowVertexColors;
        this.m_bShowVertexNormals = pgPointSet.m_bShowVertexNormals;
        this.m_bShowVertexNormalArrow = pgPointSet.m_bShowVertexNormalArrow;
        this.m_globalVertexColor.copy(pgPointSet.m_globalVertexColor);
        this.m_globalVertexTagColor.copy(pgPointSet.m_globalVertexTagColor);
        this.m_globalVertexSize.copy(pgPointSet.m_globalVertexSize);
        this.m_globalVertexNormalColor.copy(pgPointSet.m_globalVertexNormalColor);
        this.m_globalVertexNormalLength.copy(pgPointSet.m_globalVertexNormalLength);
        this.m_globalVertexNormalSize.copy(pgPointSet.m_globalVertexNormalSize);
        this.m_globalVectorColor.copy(pgPointSet.m_globalVectorColor);
        this.m_globalVectorLength.copy(pgPointSet.m_globalVectorLength);
        this.m_globalVectorSize.copy(pgPointSet.m_globalVectorSize);
        this.m_shininess.copy(pgPointSet.m_shininess);
        this.m_specularColor.copy(pgPointSet.m_specularColor);
        this.m_transparency.copy(pgPointSet.m_transparency);
        this.m_dimOfVectors = pgPointSet.m_dimOfVectors;
        this.m_dimOfColors = pgPointSet.m_dimOfColors;
        this.m_dimOfTextures = pgPointSet.m_dimOfTextures;
        int n3 = 0;
        if (piVector == null || (n3 = piVector.getSize()) == 0) {
            this.setNumVertices(n3);
            return;
        }
        this.setNumVertices(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.setVertex(n2, pgPointSet.getVertex(piVector.m_data[n2]));
        }
        if (pgPointSet.m_vertexColor != null) {
            this.assureVertexColors();
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                this.setVertexColor(n2, pgPointSet.getVertexColor(piVector.m_data[n2]));
            }
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                this.setVertexNormal(n2, pgPointSet.getVertexNormal(piVector.m_data[n2]));
            }
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexSize != null) {
            this.assureVertexSizes();
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                this.setVertexSize(n2, pgPointSet.getVertexSize(piVector.m_data[n2]));
            }
        } else {
            this.m_vertexSize = null;
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                this.setVertexTexture(n2, pgPointSet.getVertexTexture(piVector.m_data[n2]));
            }
        } else {
            this.m_vertexTexture = null;
        }
        this.setTexture(pgPointSet.m_texture);
        this.setDimOfVectors(pgPointSet.getDimOfVectors());
        n2 = this.getNumVectorFields();
        int n4 = pgPointSet.getNumVectorFields();
        int n5 = Math.min(n2, n4);
        for (n = 0; n < n5; ++n) {
            pgVectorField2 = pgPointSet.getVectorField(n);
            pgVectorField = this.getVectorField(n);
            pgVectorField.copy(pgVectorField2);
            if (pgPointSet.m_selectedVectorField != pgVectorField2) continue;
            this.m_selectedVectorField = pgVectorField;
        }
        for (n = n2; n < n4; ++n) {
            pgVectorField2 = pgPointSet.getVectorField(n);
            pgVectorField = (PgVectorField)pgVectorField2.clone();
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setGeometry(this);
            }
            this.addVectorField(pgVectorField);
            if (pgPointSet.m_selectedVectorField != pgVectorField2) continue;
            this.m_selectedVectorField = pgVectorField;
        }
        for (n = n2 - 1; n >= n4; --n) {
            this.removeVectorField(this.getVectorField(n4));
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPointSet ***********\n");
        stringBuffer.append("\t m_numVertices = " + this.m_numVertices + " (max = " + this.m_maxNumVertices + ")\n");
        stringBuffer.append("\t ******* m_vertex *******\n");
        if (this.m_vertex != null && this.m_numVertices > 0) {
            for (n = 0; n < this.m_numVertices; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertex[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_vertex = null\n");
        }
        stringBuffer.append("\t ******* m_vertexNormal *******\n");
        if (this.m_vertexNormal != null && this.m_numVertices > 0) {
            for (n = 0; n < this.m_numVertices; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexNormal[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_vertexNormal = null\n");
        }
        stringBuffer.append("\t ******* m_vertexTexture *******\n");
        if (this.m_vertexTexture != null && this.m_numVertices > 0) {
            for (n = 0; n < this.m_numVertices; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexTexture[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_vertexTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_bUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalVertexSize) {
            return super.update(null);
        }
        if (object == this.m_globalVertexColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalSize) {
            return super.update(null);
        }
        if (object == this.m_globalVectorColor) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                    if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                    pgVectorFieldArray[i].setGlobalVectorColor(this.m_globalVectorColor.getColor());
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalVectorLength) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                    if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                    pgVectorFieldArray[i].setGlobalVectorLength(this.m_globalVectorLength.getValue());
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalVectorSize) {
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                    if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                    pgVectorFieldArray[i].setGlobalVectorSize(this.m_globalVectorSize.getValue());
                }
            }
            return super.update(null);
        }
        if (object == this.m_shininess) {
            return super.update(null);
        }
        if (object == this.m_specularColor) {
            return super.update(null);
        }
        if (object == this.m_transparency) {
            return super.update(null);
        }
        if (object == this.m_texture) {
            return super.update(this);
        }
        if (object == this) {
            PsDebug.notify("called with event=this");
            if (this.getNumVectorFields() > 0) {
                PgVectorField[] pgVectorFieldArray = this.getVectorFields();
                for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                    this.m_bUpdateSender = true;
                    pgVectorFieldArray[i].update(this);
                    this.m_bUpdateSender = false;
                }
            }
            if (this.m_texture != null) {
                this.m_bUpdateSender = true;
                this.m_texture.update(this.m_texture);
                this.m_bUpdateSender = false;
            }
            return super.update(this);
        }
        PsDebug.notify("called with event=this");
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                if (object != pgVectorFieldArray[i]) continue;
                this.m_bUpdateSender = true;
                super.update(this);
                this.m_bUpdateSender = false;
                return true;
            }
        }
        return super.update(object);
    }

    public PgTexture getTexture() {
        return this.m_texture;
    }

    public void setTexture(PgTexture pgTexture) {
        if (pgTexture == null) {
            this.m_texture = null;
            return;
        }
        if (this.m_texture == null) {
            this.m_texture = new PgTexture();
            this.m_texture.setName(PsConfig.getMessage(15005) + " " + this.getName());
            this.m_texture.setParent(this);
        }
        this.m_texture.copy(pgTexture);
    }

    public void removeTexture() {
        this.setTexture(null);
        this.setVertexTextures(null);
        this.showVertexTexture(false);
    }

    public String getTextureImageName() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImageName();
    }

    public void setTextureImageName(String string) {
        if (string == null) {
            PsDebug.warning("missing texture file name");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImageName(string);
    }

    public Image getTextureImage() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImage();
    }

    public void setTextureImage(Image image) {
        if (image == null) {
            PsDebug.warning("missing texture image");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImage(image);
    }

    public double getShininess() {
        return this.m_shininess.getValue();
    }

    public void setShininess(double d) {
        this.m_shininess.setValue(d);
    }

    public Color getSpecularColor() {
        return this.m_specularColor.getColor();
    }

    public void setSpecularColor(Color color) {
        this.m_specularColor.setColor(color);
    }

    public boolean isShowingTransparency() {
        return this.m_bShowTransparency;
    }

    public void showTransparency(boolean bl) {
        this.m_bShowTransparency = bl;
    }

    public double getTransparency() {
        return this.m_transparency.getValue();
    }

    public void setTransparency(double d) {
        this.m_transparency.setValue(d);
    }

    public boolean applyModelingMatrix() {
        if (!super.applyModelingMatrix()) {
            return false;
        }
        if (this.m_numVertices > 0) {
            int n;
            int n2;
            PdVector pdVector = new PdVector(3);
            PdVector pdVector2 = new PdVector(3);
            int n3 = Math.min(3, this.m_dim);
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                pdVector.copyArray(this.m_vertex[n2]);
                pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, true);
                for (n = 0; n < n3; ++n) {
                    this.m_vertex[n2].m_data[n] = pdVector2.m_data[n];
                }
            }
            if (this.hasVertexNormals()) {
                for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                    pdVector.copyArray(this.m_vertexNormal[n2]);
                    pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                    this.m_vertexNormal[n2].copyArray(pdVector2);
                }
            }
            n2 = this.getNumVectorFields();
            for (n = 0; n < n2; ++n) {
                PgVectorField pgVectorField = this.getVectorField(n);
                if (pgVectorField == null) continue;
                pgVectorField.applyModelingMatrix();
            }
        }
        this.m_modelMatrix.setIdentity();
        return true;
    }

    public boolean applyAmbientMatrix() {
        if (!super.applyAmbientMatrix()) {
            return false;
        }
        if (this.m_numVertices > 0) {
            PdVector pdVector = new PdVector(this.m_dim);
            for (int i = 0; i < this.m_numVertices; ++i) {
                pdVector.leftMultAffin(this.m_ambientMatrix, this.m_vertex[i], true);
                this.m_vertex[i].copyArray(pdVector);
            }
        }
        this.m_ambientMatrix.setIdentity();
        this.m_ambientInvMatrix.setIdentity();
        return true;
    }

    public boolean projectFromAmbientSpace() {
        super.projectFromAmbientSpace();
        int n = this.m_dim;
        if (this.m_ambientProj != 0) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                PdVector pdVector = this.m_vertex[i];
                if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                    if (this.m_ambientProj == 1) {
                        PuProj.stereographic(pdVector, pdVector);
                        continue;
                    }
                    PsDebug.warning("unknown projection type");
                    continue;
                }
                if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                    if (this.m_ambientProj == 2) {
                        PuProj.lorentz2Klein(pdVector, pdVector);
                        continue;
                    }
                    if (this.m_ambientProj == 1) {
                        PuProj.lorentz2Poincare(pdVector, pdVector);
                        continue;
                    }
                    if (this.m_ambientProj == 3) {
                        PuProj.lorentz2Uhm(pdVector, pdVector);
                        continue;
                    }
                    PsDebug.warning("unknown projection type");
                    continue;
                }
                PsDebug.warning("unknown ambient space");
            }
            this.setAmbientProjection(0);
            n = Math.min(this.m_dim - 1, 3);
        } else {
            n = Math.min(this.m_dim, 3);
        }
        if (n != this.m_dim) {
            this.setDimOfVertices(n);
        }
        if (this.m_dim == 1) {
            this.setAmbientSpace(0);
        } else if (this.m_dim == 2) {
            this.setAmbientSpace(1);
        } else {
            this.setAmbientSpace(3);
        }
        if (this.hasVertexNormals()) {
            this.makeVertexNormals();
        }
        return true;
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = super.getBounds();
        if (this.m_numVertices > 0) {
            PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
            PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
            for (int i = this.m_dim; i < 3; ++i) {
                pdVectorArray[0].m_data[i] = 0.0;
                pdVectorArray[1].m_data[i] = 0.0;
            }
        }
        return pdVectorArray;
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getAmbientBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        return pdVectorArray;
    }

    public PdVector getCenterOfBndBox() {
        PdVector pdVector = new PdVector(this.m_dim);
        if (this.m_numVertices == 0) {
            return pdVector;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return pdVector;
        }
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        return pdVector;
    }

    public void setCenterOfBndBox(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        PdVector pdVector2 = this.getCenterOfBndBox();
        if (pdVector2 == null) {
            PsDebug.warning("missing current center");
            return;
        }
        PdVector pdVector3 = PdVector.subNew(pdVector, pdVector2);
        this.translate(pdVector3);
    }

    public PdVector getCenterOfGravity() {
        if (this.m_dim < 0) {
            return null;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(0.0);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector.add(this.m_vertex[i]);
        }
        pdVector.multScalar(1.0 / (double)this.m_numVertices);
        return pdVector;
    }

    public void setDimOfVertices(int n) {
        int n2;
        for (n2 = 0; n2 < this.m_maxNumVertices; ++n2) {
            this.m_vertex[n2].setSize(n);
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_maxNumVertices; ++n2) {
                this.m_vertexNormal[n2].setSize(n);
            }
        }
        this.setDimOfVectors(n);
        super.setDimOfVertices(n);
    }

    public final int getNumVertices() {
        return this.m_numVertices;
    }

    public final int getMaxNumVertices() {
        return this.m_maxNumVertices;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public PdVector getVertex(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index out of range, index = " + String.valueOf(n));
            return null;
        }
        return this.m_vertex[n];
    }

    public Color getVertexColor(int n) {
        if (this.m_vertexColor == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[n];
    }

    public PdVector getVertexNormal(int n) {
        if (this.m_vertexNormal == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexNormal[n];
    }

    public double getVertexSize(int n) {
        if (this.m_vertexSize == null || n < 0 || n >= this.m_numVertices) {
            return 0.0;
        }
        return this.m_vertexSize.getEntry(n);
    }

    public PdVector getVertexTexture(int n) {
        if (this.m_vertexTexture == null || n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexTexture[n];
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor.getColor();
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor.getColor();
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize.getValue();
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor.getColor();
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength.getValue();
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize.getValue();
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor.setColor(color);
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor.setColor(color);
    }

    public void setGlobalVertexSize(double d) {
        this.m_globalVertexSize.setValue(d);
    }

    public void setGlobalVertexSize(int n) {
        this.setGlobalVertexSize((double)n);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor.setColor(color);
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalVertexNormalLength.setValue(d);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize.setValue(d);
    }

    public void setGlobalVectorLength(double d) {
        this.m_globalVectorLength.setValue(d);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                pgVectorFieldArray[i].setGlobalVectorLength(d);
            }
        }
    }

    public void setGlobalVectorSize(double d) {
        this.m_globalVectorSize.setValue(d);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                pgVectorFieldArray[i].setGlobalVectorSize(d);
            }
        }
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
        if (this.getNumVectorFields() > 0) {
            PgVectorField[] pgVectorFieldArray = this.getVectorFields();
            for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                if (pgVectorFieldArray[i].isShowingIndividualMaterial()) continue;
                pgVectorFieldArray[i].setGlobalVectorColor(color);
            }
        }
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public PdVector getVertexSizes() {
        return this.m_vertexSize;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public boolean isEnabledIndexLabels() {
        return this.m_bEnabledIndexLabels;
    }

    public boolean isDefaultLabelEnabled() {
        return this.isEnabledIndexLabels();
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public boolean isShowingTaggedVertices() {
        return this.m_bShowTaggedVertices;
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public boolean isShowingVertexSizes() {
        return this.m_bShowVertexSizes;
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public boolean isShowingVectorField() {
        return this.m_bShowVectorFields;
    }

    public boolean isShowingVectorFields() {
        return this.m_bShowVectorFields;
    }

    public boolean isShowingSingleVectorField() {
        return this.m_bShowSingleVectorField;
    }

    public boolean isShowingVectorArrow() {
        return this.isShowingVectorArrows();
    }

    public boolean isShowingVectorArrows() {
        return this.m_bShowVectorArrows;
    }

    public boolean isShowingVectorColors() {
        return this.m_bShowVectorColors;
    }

    public boolean isShowingVertexOutline() {
        return this.m_bShowVertexOutline;
    }

    public void showVertexOutline(boolean bl) {
        this.m_bShowVertexOutline = bl;
    }

    public void setEnabledIndexLabels(boolean bl) {
        this.m_bEnabledIndexLabels = bl;
    }

    public void setDefaultLabelEnabled(boolean bl) {
        this.setEnabledIndexLabels(bl);
    }

    public void showIndices(boolean bl) {
        this.m_bShowIndices = bl;
    }

    public void showVertexLabels(boolean bl) {
        this.m_bShowVertexLabels = bl;
    }

    public void showVertices(boolean bl) {
        this.m_bShowVertices = bl;
    }

    public void showTaggedVertices(boolean bl) {
        this.m_bShowTaggedVertices = bl;
    }

    public void showVertexColors(boolean bl) {
        this.m_bShowVertexColors = bl;
    }

    public void showVertexNormals(boolean bl) {
        this.m_bShowVertexNormals = bl;
    }

    public void showVertexNormalArrow(boolean bl) {
        this.m_bShowVertexNormalArrow = bl;
    }

    public void showVertexSizes(boolean bl) {
        this.m_bShowVertexSizes = bl;
    }

    public void showVertexTexture(boolean bl) {
        this.m_bShowVertexTexture = bl;
    }

    public void showVectorField(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public void showVectorFields(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public void showSingleVectorField(boolean bl) {
        this.m_bShowSingleVectorField = bl;
        if (!bl) {
            return;
        }
        if (this.getNumVectorFields() == 0) {
            return;
        }
        if (this.m_selectedVectorField == null) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField;
            pgVectorField.setVisible((pgVectorField = (PgVectorField)enumeration.nextElement()) == this.m_selectedVectorField);
        }
    }

    public void showVectorArrow(boolean bl) {
        this.showVectorArrows(bl);
    }

    public void showVectorArrows(boolean bl) {
        if (this.m_bShowVectorArrows == bl) {
            return;
        }
        this.m_bShowVectorArrows = bl;
        if (this.getNumVectorFields() == 0) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
            if (pgVectorField.isShowingIndividualMaterial()) continue;
            pgVectorField.showVectorArrows(bl);
        }
    }

    public void showVectorColors(boolean bl) {
        this.m_bShowVectorColors = bl;
    }

    public boolean makeVertexNormals() {
        this.assureVertexNormals();
        if (this.getClass() != (class$jv$geom$PgPointSet == null ? (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")) : class$jv$geom$PgPointSet)) {
            return true;
        }
        return true;
    }

    public void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumVertices = n;
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, n, this.m_dim);
        for (int i = 0; i < n; ++i) {
            this.m_vertex[i].clearTag(2);
        }
        this.m_maxNumVertices = n;
        if (this.m_vertexColor != null) {
            this.assureVertexColors();
        }
        if (this.m_vertexNormal != null) {
            this.assureVertexNormals();
        }
        if (this.m_vertexSize != null) {
            this.assureVertexSizes();
        }
        if (this.m_vertexTexture != null) {
            this.assureVertexTextures();
        }
        if (this.m_maxNumVertices < this.m_numVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
        if (this.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, n, this.m_dimOfTextures);
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 0) continue;
                pgVectorField.setMaxNumVectors(this.m_maxNumVertices);
            }
        }
    }

    public void setNumVertices(int n) {
        if (this.m_numVertices == n) {
            return;
        }
        if (n > this.m_maxNumVertices || n < this.m_maxNumVertices / 2 && n < this.m_maxNumVertices - 100) {
            this.setMaxNumVertices(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numVertices = n;
            return;
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 0) continue;
                pgVectorField.setNumVectors(n);
            }
        }
        this.m_numVertices = n;
    }

    public int getDimOfColors() {
        return this.m_dimOfColors;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        if (this.m_dimOfColors == n) {
            return;
        }
        this.m_dimOfColors = n;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        this.m_dimOfVectors = n;
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            PgVectorField pgVectorField = (PgVectorField)this.m_vectorField.elementAt(i);
            pgVectorField.setDimOfVectors(n);
        }
    }

    public int getDimOfTextures() {
        return this.m_dimOfTextures;
    }

    public void setDimOfTextures(int n) {
        if (n == this.m_dimOfTextures) {
            return;
        }
        this.m_dimOfTextures = n;
        if (this.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
    }

    public boolean hasVertexColors() {
        return this.m_vertexColor != null && this.m_vertexColor.length == this.m_maxNumVertices;
    }

    public boolean hasVertexNormals() {
        return this.m_vertexNormal != null && this.m_vertexNormal.length == this.m_maxNumVertices;
    }

    public boolean hasVertexSizes() {
        return this.m_vertexSize != null && this.m_vertexSize.getSize() == this.m_maxNumVertices;
    }

    public boolean hasVertexTextures() {
        return this.m_vertexTexture != null && this.m_vertexTexture.length == this.m_maxNumVertices;
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void assureVertexSizes() {
        if (this.m_vertexSize == null) {
            this.m_vertexSize = new PdVector(this.m_maxNumVertices);
            this.m_vertexSize.setConstant(this.m_globalVertexSize.getValue());
        } else if (this.m_vertexSize.getSize() != this.m_maxNumVertices) {
            this.m_vertexSize.setSize(this.m_maxNumVertices);
        }
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        ((PgJvxSrc)((Object)pvGeometryIf)).setEnabledInstanceSharing(PsJavaView.m_bInstanceSharing);
        pvGeometryIf.setState(80, this.isShowingIndices());
        pvGeometryIf.setState(81, this.isShowingVertexLabels());
        pvGeometryIf.setState(85, this.isEnabledIndexLabels());
        pvGeometryIf.setState(50, this.m_bShowVertices);
        pvGeometryIf.setState(51, this.m_bShowTaggedVertices);
        pvGeometryIf.setState(99, this.m_bShowVertexOutline);
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        pvGeometryIf.setState(91, this.m_bShowVertexColors);
        if (this.m_globalVertexColor != null) {
            pvGeometryIf.setGlobalVertexColor(this.m_globalVertexColor.getColor());
        }
        if (this.m_globalVertexTagColor != null) {
            pvGeometryIf.setGlobalVertexTagColor(this.m_globalVertexTagColor.getColor());
        }
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setState(60, this.m_bShowVertexNormals);
        pvGeometryIf.setState(61, this.m_bShowVertexNormalArrow);
        pvGeometryIf.setVertexNormals(this.m_vertexNormal);
        if (this.m_globalVertexNormalSize != null) {
            pvGeometryIf.setGlobalVertexNormalSize(this.m_globalVertexNormalSize.getValue());
        }
        if (this.m_globalVertexNormalLength != null) {
            pvGeometryIf.setGlobalVertexNormalLength(this.m_globalVertexNormalLength.getValue());
        }
        if (this.m_globalVertexNormalColor != null) {
            pvGeometryIf.setGlobalVertexNormalColor(this.m_globalVertexNormalColor.getColor());
        }
        pvGeometryIf.setState(76, this.m_bShowVertexSizes);
        pvGeometryIf.setVertexSizes(this.m_vertexSize);
        if (this.m_globalVertexSize != null) {
            pvGeometryIf.setGlobalVertexSize(this.m_globalVertexSize.getValue());
        }
        pvGeometryIf.setState(71, this.m_bShowVertexTexture);
        if (this.m_texture != null && this.m_texture.getImage() != null) {
            pvGeometryIf.setTexture(this.m_texture.getPixels(), this.m_texture.getWidth(), this.m_texture.getHeight(), this.m_texture.getWidthTiling(), this.m_texture.getHeightTiling(), this.m_texture.getPeriodic(), this.m_texture.getBlendingMode(), this.m_texture.getFilterType(), this.m_texture.getTextureSide());
        } else {
            pvGeometryIf.setTexture(null, -1, -1, 1, 1, 3, 0, 0, 3);
        }
        pvGeometryIf.setVertexTextures(this.m_vertexTexture);
        pvGeometryIf.setShininess(this.m_shininess.getValue());
        pvGeometryIf.setSpecularColor(this.m_specularColor.getColor());
        pvGeometryIf.setState(75, this.m_bShowTransparency);
        pvGeometryIf.setTransparency(this.m_transparency.getValue());
        pvGeometryIf.setNumVectorFields(this.m_numVectorFields);
        pvGeometryIf.showVectorFields(this.m_bShowVectorFields);
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            PgVectorField pgVectorField = this.getVectorField(i);
            pgVectorField.setIndex(i);
            pgVectorField.paint(pvGeometryIf);
            if (pgVectorField.m_bShowIndividualMaterial) continue;
            pvGeometryIf.showVectorColors(i, this.m_bShowVectorColors);
            pvGeometryIf.showVectorArrows(i, this.m_bShowVectorArrows);
            pvGeometryIf.setGlobalVectorColor(i, this.m_globalVectorColor.getColor());
            pvGeometryIf.setGlobalVectorLength(i, this.m_globalVectorLength.getValue());
            pvGeometryIf.setGlobalVectorSize(i, this.m_globalVectorSize.getValue());
        }
    }

    public void clearTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].clearTag(n2);
    }

    public boolean hasTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_vertex[n].hasTag(n2);
    }

    public void setTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].setTag(n2);
    }

    public int hasVertex(PdVector pdVector, double d) {
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].equals(pdVector, d)) continue;
            return i;
        }
        return -1;
    }

    public int hasVertex(PdVector pdVector) {
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].equals(pdVector)) continue;
            return i;
        }
        return -1;
    }

    public int addVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        int n = this.m_numVertices;
        if (n == this.m_maxNumVertices) {
            this.setMaxNumVertices((int)((double)(n + 1) * 1.2));
        }
        this.setNumVertices(n + 1);
        this.setVertex(n, pdVector);
        return n;
    }

    public int[] removeVertex(int n) {
        this.m_vertex[n].setTag(2);
        return this.removeMarkedVertices();
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if ((pdVectorArray == null || pdVectorArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        if (pdVectorArray[0] == null || pdVectorArray[0].getSize() != this.getDimOfVertices()) {
            PsDebug.warning("wrong dimension at least of first argument vertex.");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertex = pdVectorArray;
            if (this.m_maxNumVertices != pdVectorArray.length) {
                this.setMaxNumVertices(pdVectorArray.length);
            }
            return;
        }
        PdVector.copy(this.m_vertex, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public int[] getMarkedVertices() {
        PiVector piVector = this.getMarkedVertices(1);
        if (piVector == null) {
            return null;
        }
        return piVector.m_data;
    }

    public PiVector getMarkedVertices(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(n)) continue;
            ++n2;
        }
        PiVector piVector = new PiVector(n2);
        int n3 = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(n)) continue;
            piVector.setEntry(n3++, i);
        }
        return piVector;
    }

    public int[] removeMarkedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        int n4 = 0;
        int[] nArray = new int[this.m_numVertices];
        for (n = 0; n < this.m_numVertices; ++n) {
            nArray[n] = this.m_vertex[n].hasTag(2) ? n3 : n2;
        }
        n4 = 0;
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray[n] != n2) continue;
            nArray[n] = n4++;
        }
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray[n] == n3 || nArray[n] >= n) continue;
            this.m_vertex[nArray[n]].setSize(this.m_vertex[n].getSize());
            this.m_vertex[nArray[n]].copy(this.m_vertex[n]);
        }
        if (this.m_vertexColor != null) {
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_vertexColor[nArray[n]] = this.m_vertexColor[n];
            }
        }
        if (this.m_vertexNormal != null) {
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_vertexNormal[nArray[n]].setSize(this.m_vertexNormal[n].getSize());
                this.m_vertexNormal[nArray[n]].copy(this.m_vertexNormal[n]);
            }
        }
        if (this.m_vertexSize != null) {
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_vertexSize.setEntry(nArray[n], this.m_vertexSize.getEntry(n));
            }
        }
        if (this.m_vertexTexture != null) {
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_vertexTexture[nArray[n]] = PdVector.copyNew(this.m_vertexTexture[n]);
            }
        }
        int n5 = this.getNumVectorFields();
        for (n = 0; n < n5; ++n) {
            PgVectorField pgVectorField = this.getVectorField(n);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (int i = 0; i < this.m_numVertices; ++i) {
                if (nArray[i] == n3 || nArray[i] >= i) continue;
                pgVectorField.setVector(nArray[i], pgVectorField.getVector(i));
            }
            pgVectorField.setNumVectors(n4);
        }
        PsDebug.notify("number of deleted vertexs = " + (this.m_numVertices - n4));
        this.setNumVertices(n4);
        this.setMaxNumVertices(n4);
        return nArray;
    }

    public void removeVertexColors() {
        this.setVertexColors(null);
    }

    public void setVertexColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vertexColor = null;
            return;
        }
        if (colorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexColor = colorArray;
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, colorArray, 0, this.m_numVertices);
    }

    public void removeVertexNormals() {
        this.setVertexNormals(null);
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexNormal = pdVectorArray;
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void removeVertexSizes() {
        this.setVertexSizes(null);
    }

    public void setVertexSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_vertexSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexSize = pdVector;
            return;
        }
        this.assureVertexSizes();
        this.m_vertexSize.copy(0, pdVector, 0, this.m_numVertices);
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexTexture = pdVectorArray;
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numVertices) {
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    public void setVertex(int n, double d) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 1) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d);
    }

    public void setVertex(int n, double d, double d2) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2);
    }

    public void setVertex(int n, double d, double d2, double d3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2, d3);
    }

    public void setVertexColor(int n, Color color) {
        if (n < 0 || color == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || n >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[n] = color;
    }

    public void setVertexNormal(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexNormal == null || n >= this.m_vertexNormal.length) {
            this.assureVertexNormals();
        }
        this.m_vertexNormal[n].copy(pdVector);
    }

    public void setVertexSize(int n, double d) {
        if (n < 0 || d < 0.0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexSize == null || n >= this.m_vertexSize.getSize()) {
            this.assureVertexSizes();
        }
        this.m_vertexSize.setEntry(n, d);
    }

    public void setVertexTexture(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexTexture == null || n >= this.m_vertexTexture.length) {
            this.assureVertexTextures();
        }
        this.m_vertexTexture[n].copy(pdVector);
    }

    public int addVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        if (this.m_vectorField == null) {
            this.m_vectorField = new Vector();
            this.m_numVectorFields = 0;
        }
        if (this.m_vectorField.contains(pgVectorField)) {
            return this.m_vectorField.indexOf(pgVectorField);
        }
        this.m_vectorField.addElement(pgVectorField);
        pgVectorField.setParent(this);
        if (!pgVectorField.isShowingIndividualMaterial()) {
            pgVectorField.showVectorArrows(this.isShowingVectorArrows());
        }
        if (this.m_selectedVectorField == null) {
            this.m_selectedVectorField = pgVectorField;
        }
        if (this.isShowingSingleVectorField() && pgVectorField != this.m_selectedVectorField) {
            pgVectorField.setVisible(false);
        }
        return this.m_numVectorFields++;
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public int getIndexOfVectorField(PgVectorField pgVectorField) {
        if (this.m_vectorField == null) {
            return -1;
        }
        return this.m_vectorField.indexOf(pgVectorField);
    }

    public PgVectorField getVectorField(String string) {
        if (this.m_vectorField == null) {
            return null;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
            if (!string.equals(pgVectorField.getName())) continue;
            return pgVectorField;
        }
        return null;
    }

    public PgVectorField getVectorField(int n) {
        if (this.m_vectorField == null || n >= this.m_numVectorFields) {
            PsDebug.warning("index of vector field out of range, index = " + String.valueOf(n));
            return null;
        }
        return (PgVectorField)this.m_vectorField.elementAt(n);
    }

    protected PgVectorField[] getVectorFields() {
        if (this.m_vectorField == null) {
            return null;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[this.m_numVectorFields];
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            pgVectorFieldArray[i] = (PgVectorField)this.m_vectorField.elementAt(i);
        }
        return pgVectorFieldArray;
    }

    private PgVectorField[] getVectorFieldsSorted() {
        if (this.m_vectorField == null) {
            return null;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[this.m_numVectorFields];
        int n = 0;
        if (this.m_selectedVectorField != null && this.m_numVectorFields > 0) {
            pgVectorFieldArray[n++] = this.m_selectedVectorField;
        }
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            PgVectorField pgVectorField = (PgVectorField)this.m_vectorField.elementAt(i);
            if (pgVectorField == this.m_selectedVectorField) continue;
            pgVectorFieldArray[n++] = pgVectorField;
        }
        return pgVectorFieldArray;
    }

    protected Vector getVectorField() {
        return this.m_vectorField;
    }

    public boolean removeVectorField(PgGeometryIf pgGeometryIf) {
        if (this.m_vectorField == null) {
            return true;
        }
        if (!this.m_vectorField.removeElement(pgGeometryIf)) {
            return false;
        }
        pgGeometryIf.setParent(null);
        if (--this.m_numVectorFields == 0) {
            this.m_vectorField = null;
            this.m_selectedVectorField = null;
        } else if (this.m_selectedVectorField == pgGeometryIf) {
            this.selectVectorField((PgVectorField)this.m_vectorField.firstElement());
        }
        return true;
    }

    public void removeAllVectorFields() {
        if (this.m_vectorField == null) {
            return;
        }
        Enumeration enumeration = this.m_vectorField.elements();
        while (enumeration.hasMoreElements()) {
            ((PsObject)enumeration.nextElement()).setParent(null);
        }
        this.m_vectorField.removeAllElements();
        this.m_vectorField = null;
        this.m_numVectorFields = 0;
        this.m_selectedVectorField = null;
    }

    public int removeHiddenVectorFields() {
        PgVectorField[] pgVectorFieldArray = this.getVectorFields();
        if (pgVectorFieldArray == null || pgVectorFieldArray.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < pgVectorFieldArray.length; ++i) {
            if (pgVectorFieldArray[i].isVisible()) continue;
            ++n;
            this.removeVectorField(pgVectorFieldArray[i]);
        }
        return n;
    }

    public PgVectorField getSelectedVectorField() {
        return this.m_selectedVectorField;
    }

    public int selectVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning("Missing argument");
            return -1;
        }
        int n = this.getIndexOfVectorField(pgVectorField);
        if (n < 0) {
            PsDebug.warning("Missing vector field = " + pgVectorField.getName());
            return n;
        }
        if (pgVectorField == this.m_selectedVectorField) {
            return n;
        }
        if (this.isShowingSingleVectorField() && this.m_selectedVectorField != null) {
            this.m_selectedVectorField.setVisible(false);
            pgVectorField.setVisible(true);
        }
        this.m_selectedVectorField = pgVectorField;
        return n;
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        int n2 = pgPolygon.getNumVertices();
        this.setNumVertices(n * n2);
        double d = 0.0;
        if (n > 1) {
            d = Math.PI * 2 / (-1.0 + (double)n);
        }
        int n3 = 0;
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        for (int i = 0; i < n; ++i) {
            double d2 = d * (double)i;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            for (int j = 0; j < n2; ++j) {
                this.m_vertex[n3].m_data[0] = pdVectorArray[j].m_data[0];
                this.m_vertex[n3].m_data[1] = d4 * pdVectorArray[j].m_data[1];
                this.m_vertex[n3].m_data[2] = d3 * pdVectorArray[j].m_data[1];
                ++n3;
            }
        }
        if (pgPolygon.hasVertexColors()) {
            this.assureVertexColors();
            Color[] colorArray = pgPolygon.getVertexColors();
            n3 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.m_vertexColor[n3] = colorArray[j];
                    ++n3;
                }
            }
        }
        if (pgPolygon.hasVertexNormals()) {
            this.assureVertexNormals();
            PdVector[] pdVectorArray2 = pgPolygon.getVertexNormals();
            n3 = 0;
            for (int i = 0; i < n; ++i) {
                double d5 = d * (double)i;
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                for (int j = 0; j < n2; ++j) {
                    this.m_vertexNormal[n3].m_data[0] = pdVectorArray2[j].m_data[0];
                    this.m_vertexNormal[n3].m_data[1] = d7 * pdVectorArray2[j].m_data[1];
                    this.m_vertexNormal[n3].m_data[2] = d6 * pdVectorArray2[j].m_data[1];
                    ++n3;
                }
            }
        }
        if (pgPolygon.hasVertexSizes()) {
            this.assureVertexSizes();
            PdVector pdVector = pgPolygon.getVertexSizes();
            n3 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.m_vertexSize.setEntry(n3, pdVector.getEntry(j));
                    ++n3;
                }
            }
        }
    }

    public void computeCone(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = d2 / (-1.0 + (double)n2);
            d5 = d / (-1.0 + (double)n2);
        }
        int n3 = 0;
        double d6 = 0.0;
        double d7 = Math.sqrt(d * d + d2 * d2);
        double d8 = d2 / d7;
        double d9 = d / d7;
        for (int i = 0; i < n; ++i) {
            double d10 = Math.sin(d6);
            double d11 = Math.cos(d6);
            double d12 = -d2 / 2.0;
            double d13 = d;
            for (int j = 0; j < n2; ++j) {
                this.m_vertex[n3].m_data[0] = d13 * d11;
                this.m_vertex[n3].m_data[1] = d13 * d10;
                this.m_vertex[n3].m_data[2] = d12;
                d12 += d4;
                d13 -= d5;
                this.m_vertexNormal[n3].m_data[0] = d11 * d8;
                this.m_vertexNormal[n3].m_data[1] = d10 * d8;
                this.m_vertexNormal[n3].m_data[2] = d9;
                ++n3;
            }
            d6 += d3;
        }
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = d2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            double d8 = -d2 / 2.0;
            for (int j = 0; j < n2; ++j) {
                this.m_vertex[n3].m_data[0] = d * d7;
                this.m_vertex[n3].m_data[1] = d * d6;
                this.m_vertex[n3].m_data[2] = d8;
                d8 += d4;
                this.m_vertexNormal[n3].m_data[0] = d7;
                this.m_vertexNormal[n3].m_data[1] = d6;
                this.m_vertexNormal[n3].m_data[2] = 0.0;
                ++n3;
            }
            d5 += d3;
        }
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = d / (-1.0 + (double)n);
        double d3 = Math.PI * 2 / (-1.0 + (double)n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = d2 * (double)i;
            for (int j = 0; j < n2; ++j) {
                double d5 = d3 * (double)j;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d4 * Math.cos(d5);
                this.m_vertex[n3].m_data[1] = d4 * Math.sin(d5);
                ++n3;
            }
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
        } else {
            this.setVertexNormals(null);
        }
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d5 = (d3 - d) / (-1.0 + (double)n);
        double d6 = (d4 - d2) / (-1.0 + (double)n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d7 = d5 * (double)i;
            for (int j = 0; j < n2; ++j) {
                double d8 = d6 * (double)j;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d + d7;
                this.m_vertex[n3].m_data[1] = d2 + d8;
                ++n3;
            }
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
        } else {
            this.setVertexNormals(null);
        }
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = d2 * (double)i;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            for (int j = 0; j < n2; ++j) {
                double d7 = -1.5707963267948966 + d3 * (double)j;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                this.m_vertex[n3].m_data[0] = d * d6 * d9;
                this.m_vertex[n3].m_data[1] = d * d5 * d9;
                this.m_vertex[n3].m_data[2] = d * d8;
                this.m_vertexNormal[n3].m_data[0] = d6 * d9;
                this.m_vertexNormal[n3].m_data[1] = d5 * d9;
                this.m_vertexNormal[n3].m_data[2] = d8;
                ++n3;
            }
        }
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = Math.PI * 2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d5 = d3 * (double)i;
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            for (int j = 0; j < n2; ++j) {
                double d8 = Math.PI + d4 * (double)j;
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                this.m_vertex[n3].m_data[0] = d7 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[1] = d6 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[2] = d2 * d9;
                this.m_vertexNormal[n3].m_data[0] = d7 * d10;
                this.m_vertexNormal[n3].m_data[1] = d6 * d10;
                this.m_vertexNormal[n3].m_data[2] = d9;
                ++n3;
            }
        }
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = (1.0 + d * Math.PI) / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = 2.141592653589793 + d2 * (double)i;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            for (int j = 0; j < n2; ++j) {
                double d7 = d3 * (double)j;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                double d10 = Math.exp(d4 * Math.log(1.3)) * d8;
                this.m_vertex[n3].m_data[0] = d10 * d6 * d8;
                this.m_vertex[n3].m_data[1] = d10 * d5 * d8;
                this.m_vertex[n3].m_data[2] = d10 * d9;
                ++n3;
            }
        }
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        Serializable serializable;
        int n;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometryIf;
        if (this.m_numVectorFields == pgPointSet.m_numVectorFields) {
            for (n = 0; n < this.m_numVectorFields; ++n) {
                PgVectorField pgVectorField = this.getVectorField(n);
                serializable = pgPointSet.getVectorField(n);
                pgVectorField.merge((PgGeometryIf)((Object)serializable));
            }
        }
        n = this.m_numVertices;
        int n2 = this.m_numVertices + pgPointSet.m_numVertices;
        this.setNumVertices(n2);
        PdVector.copy(this.m_vertex, n, pgPointSet.m_vertex, 0, pgPointSet.m_numVertices);
        serializable = this.getGlobalVertexColor();
        Color color = pgPointSet.getGlobalVertexColor();
        boolean bl2 = ((Color)serializable).getRGB() != color.getRGB() || this.hasVertexColors() || pgPointSet.hasVertexColors();
        boolean bl3 = ((Color)serializable).getRGB() == color.getRGB() && !this.isShowingVertexColors() && !pgPointSet.isShowingVertexColors();
        boolean bl4 = bl2 && !this.hasVertexColors();
        boolean bl5 = bl = bl2 && !pgPointSet.hasVertexColors();
        if (!bl3) {
            this.showVertexColors(true);
        }
        if (bl2) {
            int n3;
            this.assureVertexColors();
            if (bl4) {
                for (n3 = 0; n3 < n; ++n3) {
                    this.setVertexColor(n3, (Color)serializable);
                }
            }
            if (bl) {
                for (n3 = n; n3 < n2; ++n3) {
                    this.setVertexColor(n3, color);
                }
            } else {
                PdColor.copy(this.m_vertexColor, n, pgPointSet.m_vertexColor, 0, pgPointSet.m_numVertices);
            }
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, n, pgPointSet.m_vertexNormal, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.copy(n, pgPointSet.m_vertexSize, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, n, pgPointSet.m_vertexTexture, 0, pgPointSet.m_numVertices);
        }
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPointSet) || !(pgGeometry2 instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        PgPointSet pgPointSet2 = (PgPointSet)pgGeometry2;
        if (pgPointSet.m_numVertices == 0) {
            PsDebug.warning("missing vertices of first argument");
            return false;
        }
        if (pgPointSet.m_numVertices != pgPointSet2.m_numVertices) {
            PsDebug.warning("unequal number of vertices of a and b");
            return false;
        }
        double d4 = Math.abs(d);
        PgPointSet pgPointSet3 = d4 > (d3 = Math.abs(d2)) ? pgPointSet : pgPointSet2;
        this.m_dimOfVectors = pgPointSet3.m_dimOfVectors;
        this.m_dimOfColors = pgPointSet3.m_dimOfColors;
        this.m_dimOfTextures = pgPointSet3.m_dimOfTextures;
        this.m_bEnabledIndexLabels = pgPointSet3.m_bEnabledIndexLabels;
        this.m_bShowIndices = pgPointSet3.m_bShowIndices;
        this.m_bShowVertexLabels = pgPointSet3.m_bShowVertexLabels;
        this.m_bShowVertexOutline = pgPointSet3.m_bShowVertexOutline;
        this.m_bShowVertexTexture = pgPointSet3.m_bShowVertexTexture;
        this.m_bShowTransparency = pgPointSet3.m_bShowTransparency;
        this.m_bShowVectorFields = pgPointSet3.m_bShowVectorFields;
        this.m_bShowVectorArrows = pgPointSet3.m_bShowVectorArrows;
        this.m_bShowVectorColors = pgPointSet3.m_bShowVectorColors;
        this.m_bShowVertices = pgPointSet3.m_bShowVertices;
        this.m_bShowTaggedVertices = pgPointSet3.m_bShowTaggedVertices;
        this.m_bShowVertexColors = pgPointSet3.m_bShowVertexColors;
        this.m_bShowVertexNormals = pgPointSet3.m_bShowVertexNormals;
        this.m_bShowVertexNormalArrow = pgPointSet3.m_bShowVertexNormalArrow;
        this.m_globalVertexColor.blend(d4, pgPointSet.m_globalVertexColor, d3, pgPointSet2.m_globalVertexColor);
        this.m_globalVertexTagColor.blend(d4, pgPointSet.m_globalVertexTagColor, d3, pgPointSet2.m_globalVertexTagColor);
        this.m_globalVertexSize.blend(d4, pgPointSet.m_globalVertexSize, d3, pgPointSet2.m_globalVertexSize);
        this.m_globalVertexNormalColor.blend(d4, pgPointSet.m_globalVertexNormalColor, d3, pgPointSet2.m_globalVertexNormalColor);
        this.m_globalVertexNormalLength.blend(d4, pgPointSet.m_globalVertexNormalLength, d3, pgPointSet2.m_globalVertexNormalLength);
        this.m_globalVertexNormalSize.blend(d4, pgPointSet.m_globalVertexNormalSize, d3, pgPointSet2.m_globalVertexNormalSize);
        this.m_globalVectorColor.blend(d4, pgPointSet.m_globalVectorColor, d3, pgPointSet2.m_globalVectorColor);
        this.m_globalVectorLength.blend(d4, pgPointSet.m_globalVectorLength, d3, pgPointSet2.m_globalVectorLength);
        this.m_globalVectorSize.blend(d4, pgPointSet.m_globalVectorSize, d3, pgPointSet2.m_globalVectorSize);
        this.m_shininess.blend(d4, pgPointSet.m_shininess, d3, pgPointSet2.m_shininess);
        this.m_specularColor.blend(d4, pgPointSet.m_specularColor, d3, pgPointSet2.m_specularColor);
        this.m_transparency.blend(d4, pgPointSet.m_transparency, d3, pgPointSet2.m_transparency);
        this.setNumVertices(pgPointSet3.m_numVertices);
        if (pgPointSet.m_vertex != null && pgPointSet2.m_vertex != null) {
            for (n = 0; n < this.m_numVertices; ++n) {
                this.m_vertex[n].blend(d, pgPointSet.m_vertex[n], d2, pgPointSet2.m_vertex[n]);
            }
        }
        if (pgPointSet.m_vertexColor != null && pgPointSet2.m_vertexColor != null) {
            this.assureVertexColors();
            for (n = 0; n < this.m_numVertices; ++n) {
                this.m_vertexColor[n] = PdColor.blend(d4, pgPointSet.m_vertexColor[n], d3, pgPointSet2.m_vertexColor[n]);
            }
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null && pgPointSet2.m_vertexNormal != null) {
            this.assureVertexNormals();
            for (n = 0; n < this.m_numVertices; ++n) {
                this.m_vertexNormal[n].blend(d4, pgPointSet.m_vertexNormal[n], d3, pgPointSet2.m_vertexNormal[n]);
                this.m_vertexNormal[n].normalize();
            }
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexSize != null && pgPointSet2.m_vertexSize != null) {
            this.assureVertexSizes();
            this.m_vertexSize.blend(d4, pgPointSet.m_vertexSize, d3, pgPointSet2.m_vertexSize);
        } else {
            this.m_vertexSize = null;
        }
        if (this.m_texture == null && (pgPointSet.m_texture != null || pgPointSet2.m_texture != null)) {
            this.setTexture(new PgTexture());
        }
        if (this.m_texture != null) {
            this.m_texture.blend(d, pgPointSet.m_texture, d2, pgPointSet2.m_texture);
        }
        if (pgPointSet.m_vertexTexture != null && pgPointSet2.m_vertexTexture != null) {
            this.assureVertexTextures();
            for (n = 0; n < this.m_numVertices; ++n) {
                this.m_vertexTexture[n].blend(d4, pgPointSet.m_vertexTexture[n], d3, pgPointSet2.m_vertexTexture[n]);
            }
        } else {
            this.m_vertexTexture = null;
        }
        if (pgPointSet.getNumVectorFields() == pgPointSet2.getNumVectorFields()) {
            int n2 = pgPointSet.getNumVectorFields();
            if (this.getNumVectorFields() != n2) {
                this.removeAllVectorFields();
            }
            for (n = 0; n < n2; ++n) {
                PgVectorField pgVectorField = pgPointSet.getVectorField(n);
                PgVectorField pgVectorField2 = pgPointSet2.getVectorField(n);
                PgVectorField pgVectorField3 = this.getVectorField(n);
                if (pgVectorField3 == null) {
                    pgVectorField3 = new PgVectorField(this.m_dim, pgVectorField.getBasedOn());
                    this.addVectorField(pgVectorField3);
                }
                pgVectorField3.blend(d, pgVectorField, d2, pgVectorField2);
            }
        }
        return true;
    }

    public void flipOrientation() {
        if (this.m_vertexNormal != null) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                this.m_vertexNormal[i].multScalar(-1.0);
            }
        }
    }

    public void projectToSphere(PdVector pdVector, double d) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector2.sub(this.m_vertex[i], pdVector);
            pdVector2.setLength(d);
            this.m_vertex[i].add(pdVector, pdVector2);
        }
    }

    public void translate(PdVector pdVector) {
        for (int i = 0; i < this.m_numVertices; ++i) {
            this.m_vertex[i].add(pdVector);
        }
        if (this.m_center != null) {
            this.m_center.add(pdVector);
        }
    }

    public void scale(double d) {
        if (this.m_center != null) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                this.m_vertex[i].blend(1.0 - d, this.m_center, d, this.m_vertex[i]);
            }
        } else {
            for (int i = 0; i < this.m_numVertices; ++i) {
                this.m_vertex[i].multScalar(d);
            }
        }
    }

    public void scale(double d, PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector2.sub(this.m_vertex[i], pdVector);
            this.m_vertex[i].blendBase(pdVector, d, pdVector2);
        }
    }

    public boolean makeColorFromVectorLength() {
        if (this.getNumVectorFields() == 0) {
            PsDebug.warning("missing vector field.");
            return false;
        }
        PgVectorField pgVectorField = this.getSelectedVectorField();
        if (pgVectorField == null) {
            PsDebug.warning("missing selected vector field.");
            return false;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vectors.");
            return false;
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector pdVector = new PdVector(this.m_numVertices);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector.m_data[i] = pdVectorArray[i].length();
        }
        float f = (float)pdVector.min();
        float f2 = (float)pdVector.max() - f;
        for (int i = 0; i < this.m_numVertices; ++i) {
            float f3 = ((float)pdVector.m_data[i] - f) / f2;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[i] = Color.getHSBColor(f3, 1.0f, 1.0f);
        }
        this.setVertexColors(colorArray);
        return true;
    }

    public boolean makeVertexColorsFromXYZ() {
        if (this.m_numVertices == 0) {
            return true;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        int n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)(pdVectorArray[1].m_data[i] - pdVectorArray[0].m_data[i]);
            if (!((double)fArray[i] < 1.0E-10)) continue;
            fArray[i] = 1.0f;
        }
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.m_numVertices; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = (float)(this.m_vertex[i].m_data[j] - pdVectorArray[0].m_data[j]) / fArray[j];
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray2[j] = f;
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray2[0], 1.0f - fArray2[0], 0.0f);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray2[0], fArray2[1], (1.0f - fArray2[0]) * (1.0f - fArray2[1]));
                continue;
            }
            if (n < 3) continue;
            colorArray[i] = new Color(fArray2[0], fArray2[1], fArray2[2]);
        }
        return true;
    }

    public boolean makeVertexColorsFromZ() {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        float f2 = (float)pdVectorArray[0].getEntry(n);
        for (int i = 0; i < this.m_numVertices; ++i) {
            float f3 = (float)(this.m_vertex[i].getEntry(n) - (double)f2) / f;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[i] = new Color(f3, 0.0f, 1.0f - f3);
        }
        return true;
    }

    public boolean makeVertexColorsFromZHue() {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        float f2 = (float)pdVectorArray[0].getEntry(n);
        for (int i = 0; i < this.m_numVertices; ++i) {
            float f3 = (float)(this.m_vertex[i].getEntry(n) - (double)f2) / f;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f3), 1.0f, 1.0f));
        }
        return true;
    }

    public boolean makeVertexColorsFromNormal() {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("dimension of vertices must be equal to three, dim =" + this.m_dim);
            return false;
        }
        boolean bl = this.hasVertexNormals();
        if (!bl) {
            this.assureVertexNormals();
            this.makeVertexNormals();
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector pdVector = new PdVector(3);
        double[] dArray = pdVector.m_data;
        PdVector pdVector2 = new PdVector(1.0, 0.0, 0.0);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
        for (int i = 0; i < this.m_numVertices; ++i) {
            double[] dArray2 = this.m_vertexNormal[i].m_data;
            dArray[0] = 0.7071068 * dArray2[0] - 0.7071068 * dArray2[1];
            dArray[1] = 0.7071068 * dArray2[0] + 0.7071068 * dArray2[1];
            double d = dArray[1];
            dArray[1] = 0.57735 * d + 0.81649 * dArray2[2];
            dArray[2] = -0.81649 * d + 0.57735 * dArray2[2];
            d = dArray[1];
            dArray[0] = 0.7071068 * dArray2[0] + 0.7071068 * d;
            dArray[1] = -0.7071068 * dArray2[0] + 0.7071068 * d;
            int n = pdVector.indexOfAbsMax();
            float f = (float)Math.abs(pdVector.m_data[n]);
            colorArray[i] = new Color((1.0f + (float)dArray[0] / f) / 2.0f, (1.0f + (float)dArray[1] / f) / 2.0f, (1.0f + (float)dArray[2] / f) / 2.0f);
        }
        if (!bl) {
            this.removeVertexNormals();
        }
        return true;
    }

    public void makeQuadrVertexTexture(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.assureVertexTextures();
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d3 = d * (double)i;
            for (int j = 0; j < n2; ++j) {
                double d4 = d2 * (double)j;
                this.m_vertexTexture[n3].m_data[0] = d3;
                this.m_vertexTexture[n3].m_data[1] = d4;
                ++n3;
            }
        }
    }

    public boolean makeVertexTextureFromBndBox(int n, int n2) {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 2) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        if (n >= this.m_dim) {
            n = this.m_dim - 1;
        }
        if (n2 >= this.m_dim) {
            n2 = this.m_dim - 1;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray2 = this.getVertexTextures();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector.sub(this.m_vertex[i], pdVectorArray[0]);
            pdVectorArray2[i].m_data[0] = pdVector.m_data[n] / dArray[n];
            pdVectorArray2[i].m_data[1] = pdVector.m_data[n2] / dArray[n2];
        }
        return true;
    }

    public boolean makeVertexTextureFromUV(int n, int n2, int n3) {
        if (this.m_numVertices != n * n2) {
            PsDebug.warning("Product of u- and v-lines does not match numVertices.");
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            double d = (double)i / ((double)n - 1.0);
            for (int j = 0; j < n2; ++j) {
                double d2 = (double)j / ((double)n2 - 1.0);
                if (n3 == 0) {
                    pdVectorArray[n4].m_data[0] = d;
                    pdVectorArray[n4].m_data[1] = d2;
                } else if (n3 == 1) {
                    pdVectorArray[n4].m_data[0] = d2;
                    pdVectorArray[n4].m_data[1] = d;
                }
                ++n4;
            }
        }
        return true;
    }

    public boolean makeVertexTextureFromCylinder(PdVector pdVector, PdVector pdVector2) {
        double d;
        int n;
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        if (pdVector2 == null || pdVector2.getSize() != this.m_dim) {
            PsDebug.warning("Missing axis or wrong dimension.");
            return false;
        }
        if (Math.abs(pdVector2.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("Axis direction does not have unit length.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector3 = new PdVector(this.m_dim);
        double d2 = Double.MAX_VALUE;
        double d3 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < this.m_numVertices; ++n) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            if (d < d2) {
                d2 = d;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        for (n = 0; n < this.m_numVertices; ++n) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            double[] dArray = pdVector3.m_data;
            double d4 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d4 = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d4 = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d4 = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d4 = -1.5707963267948966;
            }
            pdVectorArray[n].set(0.25 + d4 / 2.0 / Math.PI, (d - d2) / (d3 - d2));
        }
        return true;
    }

    public boolean makeVertexTextureFromSphere(PdVector pdVector) {
        if (this.m_numVertices == 0) {
            return true;
        }
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector2 = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVector2.sub(this.m_vertex[i], pdVector);
            pdVector2.normalize();
            double[] dArray = pdVector2.m_data;
            double d = 0.0;
            double d2 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d = -1.5707963267948966;
            }
            d2 = Math.asin(dArray[2]);
            pdVectorArray[i].set(0.25 + d / 2.0 / Math.PI, 0.5 + d2 / Math.PI);
        }
        return true;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        Object object;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgPointSet pgPointSet = (PgPointSet)super.reflect(pdMatrix, bl, bl2);
        PdVector[] pdVectorArray = this.getVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertices();
        for (int i = 0; i < this.m_numVertices; ++i) {
            pdVectorArray2[i].leftMultAffin(pdMatrix, pdVectorArray[i], true);
        }
        if (this.hasVertexNormals()) {
            PdVector[] pdVectorArray3 = this.getVertexNormals();
            object = pgPointSet.getVertexNormals();
            for (int i = 0; i < this.m_numVertices; ++i) {
                object[i].leftMultAffin(pdMatrix, pdVectorArray3[i], false);
                if (!bl2) {
                    object[i].multScalar(-1.0);
                }
                object[i].normalize();
            }
        }
        if (this.m_vectorField != null) {
            pgPointSet.m_vectorField = null;
            pgPointSet.m_numVectorFields = 0;
            pgPointSet.m_selectedVectorField = null;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                object = (PgVectorField)enumeration.nextElement();
                if (object != null) {
                    PgVectorField pgVectorField = (PgVectorField)((PgVectorField)object).reflect(pdMatrix, bl, bl2);
                    pgPointSet.addVectorField(pgVectorField);
                    pgVectorField.setGeometry(pgPointSet);
                    if (this.m_selectedVectorField != object) continue;
                    pgPointSet.selectVectorField(pgVectorField);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return pgPointSet;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector.getSize() != 3 || pdVector2 == null || pdVector2.getSize() != 3) {
            PsDebug.warning("missing or wrong dimension of ray");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PgGeometry.convertWorldToModel(this, pdVector, pdVector2, pdVector3, pdVector4);
        pdVector4.normalize();
        int n = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (this.m_dim != 3) {
                pdVector5.copyArray(this.m_vertex[i]);
            } else {
                pdVector5 = this.m_vertex[i];
            }
            d = PuVectorGeom.distOfPointToLine(pdVector5, pdVector3, pdVector4);
            if (d >= d2) continue;
            d2 = d;
            n = i;
        }
        if (n == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(this.m_vertex[n]);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(d2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        return pvPickEvent;
    }

    public int getEulerCharacteristic() {
        int[] nArray = this.getFVector();
        int n = nArray[0];
        int n2 = -1;
        for (int i = 1; i < nArray.length; ++i) {
            n += n2 * nArray[i];
            n2 = -n2;
        }
        return n;
    }

    public int[] getFVector() {
        return new int[]{this.getNumVertices()};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

