/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.object.PsConfig;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public final class PgEdgeStar
extends PiVector {
    protected int m_maxValence;
    protected int m_valence = 0;
    protected int[] m_elementInd;
    protected int[] m_neighbourLocInd;

    public PgEdgeStar() {
        super(0);
    }

    public PgEdgeStar(int n, int n2) {
        super(n, n2);
        this.setMaxValence(2);
    }

    public void copy(PiVector piVector) {
        if (piVector == null) {
            return;
        }
        this.setSize(piVector.getSize());
        super.copy(piVector);
        if (!(piVector instanceof PgEdgeStar)) {
            return;
        }
        PgEdgeStar pgEdgeStar = (PgEdgeStar)piVector;
        this.setValence(pgEdgeStar.getValence());
        for (int i = 0; i < this.m_valence; ++i) {
            this.m_elementInd[i] = pgEdgeStar.m_elementInd[i];
            this.m_neighbourLocInd[i] = pgEdgeStar.m_neighbourLocInd[i];
        }
    }

    public Object clone() {
        PgEdgeStar pgEdgeStar = (PgEdgeStar)super.clone();
        if (pgEdgeStar == null) {
            return null;
        }
        if (this.m_elementInd != null) {
            pgEdgeStar.m_elementInd = (int[])this.m_elementInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgEdgeStar.m_neighbourLocInd = (int[])this.m_neighbourLocInd.clone();
        }
        return pgEdgeStar;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PgEdgeStar ***********\n");
        stringBuffer.append("\t " + PsConfig.getMessage(33001) + " = " + this.m_valence + "\n");
        if (this.m_valence > 0) {
            int n;
            stringBuffer.append("\t " + PsConfig.getMessage(33002) + " = [" + this.m_elementInd[0]);
            for (n = 1; n < this.m_valence; ++n) {
                stringBuffer.append(", " + this.m_elementInd[n]);
            }
            stringBuffer.append("]\n");
            stringBuffer.append("\t " + PsConfig.getMessage(33003) + " = [" + this.m_neighbourLocInd[0]);
            for (n = 1; n < this.m_valence; ++n) {
                stringBuffer.append(", " + this.m_neighbourLocInd[n]);
            }
            stringBuffer.append("]\n");
        }
        return stringBuffer.toString();
    }

    public int getValence() {
        return this.m_valence;
    }

    public void setValence(int n) {
        if (this.m_valence == n) {
            return;
        }
        if (n > this.m_maxValence) {
            this.setMaxValence(n * 150 / 100 + 3);
        }
        this.m_valence = n;
    }

    public void setMaxValence(int n) {
        if (this.m_maxValence == n) {
            return;
        }
        this.m_maxValence = n;
        if (this.m_maxValence < this.m_valence) {
            this.m_valence = this.m_maxValence;
        }
        this.m_elementInd = PuData.realloc(this.m_elementInd, this.m_maxValence);
        this.m_neighbourLocInd = PuData.realloc(this.m_neighbourLocInd, this.m_maxValence);
    }

    public void addElement(int n, int n2) {
        this.setValence(this.m_valence + 1);
        this.m_elementInd[this.m_valence - 1] = n;
        this.m_neighbourLocInd[this.m_valence - 1] = n2;
    }

    public int getEdgeInd(int n) {
        return this.getVertexInd(n);
    }

    public int getVertexInd(int n) {
        return this.getEntry(n);
    }

    public int[] getElements() {
        return this.getElementInd();
    }

    public int[] getElementInd() {
        return this.m_elementInd;
    }

    public int getElementInd(int n) {
        if (n >= 0 && n < this.m_valence) {
            return this.m_elementInd[n];
        }
        return -1;
    }

    public void setElementInd(int n, int n2) {
        this.m_elementInd[n] = n2;
    }

    public int[] getNeighbourLocIndices() {
        return this.m_neighbourLocInd;
    }

    public int[] getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public int getNeighbourLocInd(int n) {
        return this.m_neighbourLocInd[n];
    }

    public void setNeighbourLocInd(int n, int n2) {
        this.m_neighbourLocInd[n] = n2;
    }
}

