/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsObject;
import jv.rsrc.PsJavaView;

public class PsAnimation
extends PsObject
implements Runnable {
    public static final int FORWARD = 0;
    public static final int REWIND = 1;
    public static final int FAST_FORWARD = 2;
    public static final int FAST_REWIND = 3;
    public static final int ONE_WAY = 0;
    public static final int LOOP = 1;
    public static final int BACK_FORTH = 2;
    public static final int INTERPOL_NONE = 0;
    public static final int INTERPOL_LINEAR = 1;
    protected Vector m_dynamicList;
    protected boolean m_modal;
    protected double m_globalTime;
    protected PuDouble m_currentTime;
    protected int m_speedType;
    private double m_timeIncr;
    private long m_sleepInterval;
    protected int m_repeat;
    protected boolean m_syncFlag = true;
    protected boolean m_enableKeys = false;
    protected int m_interpolType;
    protected int[] m_position;
    protected transient PsDialog m_animDialog;
    protected transient Thread m_thread;
    static /* synthetic */ Class class$jv$anim$PsAnimation;

    public PsAnimation() {
        this.setTag(4);
        this.m_currentTime = new PuDouble(PsConfig.getMessage(24000), this);
        this.m_currentTime.setDefBounds(0.0, 100.0, 1.0, 5.0);
        this.m_currentTime.setDefValue(0.0);
        if (this.getClass() == (class$jv$anim$PsAnimation == null ? (class$jv$anim$PsAnimation = PsAnimation.class$("jv.anim.PsAnimation")) : class$jv$anim$PsAnimation)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_modal = false;
        this.m_interpolType = 1;
        this.m_speedType = 0;
        this.m_repeat = 2;
        this.m_syncFlag = true;
        this.m_dynamicList = null;
        this.m_globalTime = 0.0;
        this.m_sleepInterval = 50L;
        this.m_currentTime.init();
    }

    public boolean addTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            this.m_dynamicList = new Vector();
        } else if (this.hasTimeListener(psTimeListenerIf)) {
            PsDebug.warning("name = " + psTimeListenerIf.getName() + " of listener already used.");
            return false;
        }
        this.m_dynamicList.addElement(psTimeListenerIf);
        psTimeListenerIf.setAnimation(this);
        return true;
    }

    public boolean hasTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.contains(psTimeListenerIf);
    }

    public boolean removeTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.removeElement(psTimeListenerIf);
    }

    public long getSleepInterval() {
        return this.m_sleepInterval;
    }

    public void setSleepInterval(long l) {
        this.m_sleepInterval = l;
    }

    public void setTimeInterval(double d, double d2, double d3, double d4) {
        this.m_currentTime.setBounds(d, d2, d3, d4);
    }

    public void setTimeInterval(double d, double d2) {
        this.m_currentTime.setBounds(d, d2);
    }

    public double getMinTime() {
        return this.m_currentTime.getMin();
    }

    public double getMaxTime() {
        return this.m_currentTime.getMax();
    }

    public double getTimeStepIncr() {
        return this.m_currentTime.getLineIncr();
    }

    public void setTimeStepIncr(double d) {
        this.m_currentTime.setLineIncr(d);
    }

    public double getTimePageIncr() {
        return this.m_currentTime.getPageIncr();
    }

    public void setTimePageIncr(double d) {
        this.m_currentTime.setPageIncr(d);
    }

    public double getTime() {
        return this.m_currentTime.getValue();
    }

    public void setTime(double d) {
        if (d == this.m_currentTime.getValue()) {
            return;
        }
        this.m_globalTime = d;
        if (!this.m_syncFlag) {
            return;
        }
        boolean bl = this.setTime(new PsTimeEvent(this.m_globalTime));
        if (bl) {
            this.m_currentTime.setValue(this.m_globalTime);
        }
    }

    public void synchronize(boolean bl) {
        if (this.m_syncFlag == bl) {
            return;
        }
        this.m_syncFlag = bl;
        if (this.m_syncFlag) {
            this.setTime(this.m_globalTime);
        }
    }

    protected boolean setTime(PsTimeEvent psTimeEvent) {
        PsDebug.notify("time = " + psTimeEvent.getTime());
        if (this.m_dynamicList == null) {
            return true;
        }
        Enumeration enumeration = this.m_dynamicList.elements();
        while (enumeration.hasMoreElements()) {
            PsTimeListenerIf psTimeListenerIf = (PsTimeListenerIf)enumeration.nextElement();
            psTimeListenerIf.setTime(psTimeEvent);
        }
        return true;
    }

    public boolean update(Object object) {
        if (object == this.m_currentTime) {
            double d;
            this.m_globalTime = d = this.m_currentTime.getValue();
            return this.setTime(new PsTimeEvent(this.m_globalTime));
        }
        if (object == this.m_animDialog) {
            return true;
        }
        return super.update(object);
    }

    public void enableKeys(boolean bl) {
        if (this.m_enableKeys == bl) {
            return;
        }
        this.m_enableKeys = bl;
        this.updatePanels(this);
    }

    public PsDialog getAnimationPanel() {
        if (this.m_animDialog != null) {
            return this.m_animDialog;
        }
        this.m_animDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24001), false);
        if (this.m_animDialog == null) {
            PsDebug.warning("failed allocating animation dialog.");
            return null;
        }
        this.m_animDialog.add((Component)this.getInfoPanel(), "Center");
        this.m_animDialog.add((Component)this.m_animDialog.getBottomButtons(16), "South");
        this.m_animDialog.pack();
        int[] nArray = this.m_position;
        if (nArray == null) {
            nArray = PsJavaView.getWindowSize(5);
        }
        this.m_animDialog.setLocation(nArray[0], nArray[1]);
        this.m_animDialog.setSize(nArray[2], nArray[3]);
        this.m_animDialog.setParent(this);
        this.m_animDialog.update(this);
        return this.m_animDialog;
    }

    public boolean hasAnimationPanel() {
        return this.m_animDialog != null;
    }

    public void setAnimationPanel(PsDialog psDialog) {
        this.m_animDialog = psDialog;
    }

    public void setPosition(int[] nArray) {
        if (nArray == null || nArray.length < 4) {
            PsDebug.warning("missing or incomplete position");
            return;
        }
        if (this.m_position == null) {
            this.m_position = new int[4];
        }
        for (int i = 0; i < 4; ++i) {
            this.m_position[i] = nArray[i];
        }
        if (this.m_animDialog != null) {
            this.m_animDialog.setLocation(this.m_position[0], this.m_position[1]);
            this.m_animDialog.setSize(this.m_position[2], this.m_position[3]);
        }
    }

    public int getInterpolType() {
        return this.m_interpolType;
    }

    public void setInterpolType(int n) {
        this.m_interpolType = n;
    }

    public int getRepeat() {
        return this.m_repeat;
    }

    public void setRepeat(int n) {
        this.m_repeat = n;
    }

    public void setSpeedType(int n) {
        this.m_speedType = n;
        switch (this.m_speedType) {
            case 0: {
                this.m_timeIncr = this.m_currentTime.getLineIncr();
                break;
            }
            case 1: {
                this.m_timeIncr = -this.m_currentTime.getLineIncr();
                break;
            }
            case 2: {
                this.m_timeIncr = this.m_currentTime.getPageIncr();
                break;
            }
            case 3: {
                this.m_timeIncr = -this.m_currentTime.getPageIncr();
            }
        }
    }

    public boolean isModal() {
        return this.m_modal;
    }

    public void setModal(boolean bl) {
        this.m_modal = bl;
    }

    public boolean isRunning() {
        return this.m_thread != null;
    }

    public void start(int n) {
        this.setSpeedType(n);
        this.start();
    }

    public synchronized void start() {
        this.setSpeedType(this.m_speedType);
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, PsConfig.getProgram() + ": " + PsConfig.getMessage(12000));
            this.m_thread.start();
        }
        if (this.m_modal) {
            try {
                while (this.m_thread != null) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
            if (this.m_modal) {
                this.notifyAll();
            }
        }
    }

    public void run() {
        while (this.m_thread != null) {
            double d = this.m_currentTime.getValue();
            if ((d += this.m_timeIncr) > this.m_currentTime.getMax() - 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMax());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    d = d < this.m_currentTime.getMax() + 1.0E-10 ? this.m_currentTime.getMax() : this.m_currentTime.getMin();
                } else if (this.m_repeat == 2) {
                    d = this.m_currentTime.getMax();
                    this.m_timeIncr *= -1.0;
                }
            } else if (d < this.m_currentTime.getMin() + 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMin());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    d = d > this.m_currentTime.getMin() - 1.0E-10 ? this.m_currentTime.getMin() : this.m_currentTime.getMax();
                } else if (this.m_repeat == 2) {
                    d = this.m_currentTime.getMin();
                    this.m_timeIncr *= -1.0;
                }
            }
            this.setTime(d);
            PsDebug.notify("current time = " + d);
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

