/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.ArrayList;
import org.ddogleg.struct.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class TestLinkedList {
    @Test
    public void reset() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        alg.pushHead(1);
        alg.pushHead(2);
        alg.reset();
        Assert.assertEquals((long)2L, (long)alg.available.size());
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertTrue((null == alg.first ? 1 : 0) != 0);
        Assert.assertTrue((null == alg.last ? 1 : 0) != 0);
        this.checkList(alg);
    }

    @Test
    public void isEmpty() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        Assert.assertTrue((boolean)alg.isEmpty());
        alg.pushHead(1);
        Assert.assertFalse((boolean)alg.isEmpty());
        alg.reset();
        Assert.assertTrue((boolean)alg.isEmpty());
    }

    @Test
    public void getElement() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushTail(1);
        LinkedList.Element e1 = alg.pushTail(2);
        LinkedList.Element e2 = alg.pushTail(2);
        Assert.assertTrue((e0 == alg.getElement(0, true) ? 1 : 0) != 0);
        Assert.assertTrue((e1 == alg.getElement(1, true) ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.getElement(2, true) ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.getElement(0, false) ? 1 : 0) != 0);
        Assert.assertTrue((e1 == alg.getElement(1, false) ? 1 : 0) != 0);
        Assert.assertTrue((e0 == alg.getElement(2, false) ? 1 : 0) != 0);
    }

    @Test
    public void pushHead() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushHead(1);
        Assert.assertEquals((long)1L, (long)alg.size);
        this.checkList(alg);
        LinkedList.Element e1 = alg.pushHead(2);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertTrue((e1 == alg.first ? 1 : 0) != 0);
        Assert.assertTrue((e0 == alg.last ? 1 : 0) != 0);
        this.checkList(alg);
        LinkedList.Element e2 = alg.pushHead(3);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertTrue((e2 == alg.first ? 1 : 0) != 0);
        Assert.assertTrue((e0 == alg.last ? 1 : 0) != 0);
        this.checkList(alg);
    }

    @Test
    public void pushTail() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushTail(1);
        Assert.assertEquals((long)1L, (long)alg.size);
        this.checkList(alg);
        LinkedList.Element e1 = alg.pushTail(2);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertTrue((e0 == alg.first ? 1 : 0) != 0);
        Assert.assertTrue((e1 == alg.last ? 1 : 0) != 0);
        this.checkList(alg);
        LinkedList.Element e2 = alg.pushTail(3);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertTrue((e0 == alg.first ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.last ? 1 : 0) != 0);
        this.checkList(alg);
    }

    @Test
    public void insertAfter() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushHead(1);
        LinkedList.Element e1 = alg.insertAfter(e0, 2);
        Assert.assertTrue((e0.next == e1 ? 1 : 0) != 0);
        Assert.assertTrue((e1.previous == e0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)alg.size);
        this.checkList(alg);
        LinkedList.Element e2 = alg.insertAfter(e1, 2);
        Assert.assertTrue((e1.next == e2 ? 1 : 0) != 0);
        Assert.assertTrue((e2.previous == e1 ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.last ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)alg.size);
        this.checkList(alg);
    }

    @Test
    public void insertBefore() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushHead(1);
        LinkedList.Element e1 = alg.insertBefore(e0, 2);
        Assert.assertTrue((e0.previous == e1 ? 1 : 0) != 0);
        Assert.assertTrue((e1.next == e0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)alg.size);
        this.checkList(alg);
        LinkedList.Element e2 = alg.insertBefore(e1, 2);
        Assert.assertTrue((e1.previous == e2 ? 1 : 0) != 0);
        Assert.assertTrue((e2.next == e1 ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.first ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)alg.size);
        this.checkList(alg);
    }

    @Test
    public void swap() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushTail(1);
        LinkedList.Element e1 = alg.pushTail(2);
        alg.swap(e0, e1);
        Assert.assertTrue((alg.first == e1 ? 1 : 0) != 0);
        Assert.assertTrue((alg.last == e0 ? 1 : 0) != 0);
        this.checkList(alg);
        alg.swap(e0, e1);
        Assert.assertTrue((alg.first == e0 ? 1 : 0) != 0);
        Assert.assertTrue((alg.last == e1 ? 1 : 0) != 0);
        this.checkList(alg);
        LinkedList.Element e2 = alg.pushTail(3);
        alg.swap(e0, e1);
        Assert.assertTrue((alg.first == e1 ? 1 : 0) != 0);
        Assert.assertTrue((alg.last == e2 ? 1 : 0) != 0);
        this.checkList(alg);
        alg.swap(e0, e1);
        Assert.assertTrue((alg.first == e0 ? 1 : 0) != 0);
        this.checkList(alg);
        alg.swap(e1, e2);
        Assert.assertTrue((alg.last == e1 ? 1 : 0) != 0);
        this.checkList(alg);
        alg.swap(e1, e2);
        Assert.assertTrue((alg.last == e2 ? 1 : 0) != 0);
        this.checkList(alg);
        LinkedList.Element e3 = alg.pushTail(4);
        alg.swap(e0, e2);
        Assert.assertTrue((alg.first == e2 ? 1 : 0) != 0);
        Assert.assertTrue((alg.last == e3 ? 1 : 0) != 0);
        this.checkList(alg);
        alg.swap(e0, e2);
        this.checkList(alg);
        Assert.assertTrue((alg.first == e0 ? 1 : 0) != 0);
        Assert.assertTrue((alg.last == e3 ? 1 : 0) != 0);
    }

    @Test
    public void remove() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        LinkedList.Element e0 = alg.pushTail(1);
        alg.remove(e0);
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
        e0 = alg.pushTail(1);
        LinkedList.Element e1 = alg.pushTail(2);
        alg.remove(e1);
        Assert.assertTrue((e0 == alg.first ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
        e1 = alg.pushTail(2);
        alg.remove(e0);
        Assert.assertTrue((e1 == alg.first ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
        e0 = alg.pushHead(1);
        LinkedList.Element e2 = alg.pushTail(3);
        alg.remove(e1);
        Assert.assertTrue((e0 == alg.first ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
    }

    @Test
    public void removeHead() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        alg.pushHead(1);
        Assert.assertTrue((boolean)alg.removeHead().equals(1));
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
        alg.pushTail(1);
        alg.pushTail(2);
        Assert.assertTrue((boolean)alg.removeHead().equals(1));
        Assert.assertEquals((long)1L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
    }

    @Test
    public void removeTail() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        alg.pushHead(1);
        Assert.assertTrue((boolean)alg.removeTail().equals(1));
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
        alg.pushTail(1);
        alg.pushTail(2);
        Assert.assertTrue((boolean)alg.removeTail().equals(2));
        Assert.assertEquals((long)1L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.available.size());
        this.checkList(alg);
    }

    @Test
    public void find() {
        LinkedList<Object> alg = new LinkedList<Object>();
        Assert.assertTrue((null == alg.find(1) ? 1 : 0) != 0);
        LinkedList.Element e1 = alg.pushHead(1);
        Assert.assertTrue((null == alg.find(4) ? 1 : 0) != 0);
        Assert.assertTrue((e1 == alg.find(e1.object) ? 1 : 0) != 0);
        LinkedList.Element e2 = alg.pushHead(2);
        Assert.assertTrue((null == alg.find(4) ? 1 : 0) != 0);
        Assert.assertTrue((e2 == alg.find(e2.object) ? 1 : 0) != 0);
        Assert.assertTrue((e1 == alg.find(e1.object) ? 1 : 0) != 0);
    }

    @Test
    public void getHead() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        Assert.assertTrue((null == alg.getHead() ? 1 : 0) != 0);
        LinkedList.Element e = alg.pushHead(1);
        Assert.assertTrue((e == alg.getHead() ? 1 : 0) != 0);
    }

    @Test
    public void getTail() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        Assert.assertTrue((null == alg.getHead() ? 1 : 0) != 0);
        LinkedList.Element e = alg.pushHead(1);
        Assert.assertTrue((e == alg.getTail() ? 1 : 0) != 0);
        e = alg.pushTail(2);
        Assert.assertTrue((e == alg.getTail() ? 1 : 0) != 0);
    }

    @Test
    public void addAll_List() {
        LinkedList alg = new LinkedList();
        ArrayList<Integer> list0 = new ArrayList<Integer>();
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        alg.addAll(list0);
        Assert.assertEquals((long)0L, (long)alg.size);
        this.checkList(alg);
        list0.add(1);
        alg.addAll(list0);
        Assert.assertEquals((long)1L, (long)alg.size);
        this.checkList(alg);
        alg.addAll(list1);
        Assert.assertEquals((long)1L, (long)alg.size);
        this.checkList(alg);
        list1.add(2);
        list1.add(3);
        alg.addAll(list1);
        Assert.assertEquals((long)3L, (long)alg.size);
        this.checkList(alg);
        Assert.assertTrue((Integer.valueOf(1) == alg.getHead().object ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf(3) == alg.getTail().object ? 1 : 0) != 0);
    }

    @Test
    public void addAll_array() {
        LinkedList<Integer> alg = new LinkedList<Integer>();
        Integer[] array0 = new Integer[]{};
        alg.addAll(array0, 0, 0);
        Assert.assertEquals((long)0L, (long)alg.size);
        this.checkList(alg);
        array0 = new Integer[3];
        for (int i = 0; i < array0.length; ++i) {
            array0[i] = i;
        }
        alg.addAll(array0, 1, 1);
        Assert.assertEquals((long)1L, (long)alg.size);
        Assert.assertTrue((Integer.valueOf(1) == alg.getHead().object ? 1 : 0) != 0);
        this.checkList(alg);
        alg.addAll(array0, 0, 3);
        Assert.assertEquals((long)4L, (long)alg.size);
        Assert.assertTrue((Integer.valueOf(1) == alg.getHead().object ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf(0) == alg.getElement((int)1, (boolean)true).object ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf(1) == alg.getElement((int)2, (boolean)true).object ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf(2) == alg.getElement((int)3, (boolean)true).object ? 1 : 0) != 0);
        this.checkList(alg);
    }

    @Test
    public void requestNew() {
        LinkedList alg = new LinkedList();
        LinkedList.Element e0 = alg.requestNew();
        Assert.assertTrue((e0 != null ? 1 : 0) != 0);
        LinkedList.Element e1 = alg.requestNew();
        Assert.assertTrue((e1 != null ? 1 : 0) != 0);
        Assert.assertTrue((e1 != e0 ? 1 : 0) != 0);
        alg.available.add(e0);
        LinkedList.Element e2 = alg.requestNew();
        Assert.assertTrue((e2 == e0 ? 1 : 0) != 0);
        LinkedList.Element e3 = alg.requestNew();
        Assert.assertTrue((e3 != null ? 1 : 0) != 0);
        Assert.assertTrue((e3 != e0 ? 1 : 0) != 0);
        Assert.assertTrue((e3 != e1 ? 1 : 0) != 0);
        Assert.assertTrue((e3 != e2 ? 1 : 0) != 0);
    }

    protected void checkList(LinkedList list) {
        for (int i = 0; i < list.available.size(); ++i) {
            LinkedList.Element e = (LinkedList.Element)list.available.get(i);
            Assert.assertTrue((null == e.previous ? 1 : 0) != 0);
            Assert.assertTrue((null == e.next ? 1 : 0) != 0);
            Assert.assertTrue((null == e.object ? 1 : 0) != 0);
        }
        if (list.size == 0) {
            Assert.assertTrue((null == list.first ? 1 : 0) != 0);
            Assert.assertTrue((null == list.last ? 1 : 0) != 0);
        } else {
            ArrayList<LinkedList.Element> forwards = new ArrayList<LinkedList.Element>();
            ArrayList<LinkedList.Element> backwards = new ArrayList<LinkedList.Element>();
            LinkedList.Element e = list.first;
            while (e != null) {
                forwards.add(e);
                e = e.next;
                if (forwards.size() <= list.size()) continue;
                Assert.fail((String)"too many elements in forward direction");
            }
            e = list.last;
            while (e != null) {
                backwards.add(e);
                e = e.previous;
                if (backwards.size() <= list.size()) continue;
                Assert.fail((String)"too many elements in forward direction");
            }
            Assert.assertEquals((long)forwards.size(), (long)backwards.size());
            Assert.assertEquals((long)forwards.size(), (long)list.size());
            for (int i = 0; i < forwards.size(); ++i) {
                int j = forwards.size() - 1 - i;
                Assert.assertTrue((forwards.get(i) == backwards.get(j) ? 1 : 0) != 0);
            }
        }
    }
}

