/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.Random;
import org.ddogleg.solver.FitQuadratic3by3;
import org.junit.Assert;
import org.junit.Test;

public class TestFitQuadratic3by3 {
    Random rand = new Random(234L);

    @Test
    public void impulseAtZero() {
        FitQuadratic3by3 alg = new FitQuadratic3by3();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                alg.setValue(j, i, 2.0);
            }
        }
        alg.setValue(0, 0, 5.0);
        alg.process();
        Assert.assertEquals((double)0.0, (double)alg.getDeltaX(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)alg.getDeltaY(), (double)1.0E-8);
    }

    @Test
    public void skewedX() {
        FitQuadratic3by3 alg = new FitQuadratic3by3();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                alg.setValue(j, i, 2.0);
            }
        }
        alg.setValue(0, 0, 5.0);
        alg.setValue(-1, 0, 4.0);
        alg.process();
        Assert.assertTrue((alg.getDeltaX() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((alg.getDeltaX() >= -1.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)alg.getDeltaY(), (double)1.0E-8);
    }

    @Test
    public void skewedY() {
        FitQuadratic3by3 alg = new FitQuadratic3by3();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                alg.setValue(j, i, 2.0);
            }
        }
        alg.setValue(0, 0, 5.0);
        alg.setValue(0, -1, 4.0);
        alg.process();
        Assert.assertTrue((alg.getDeltaY() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((alg.getDeltaY() >= -1.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)alg.getDeltaX(), (double)1.0E-8);
    }
}

