/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.List;
import java.util.Random;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.junit.Assert;
import org.junit.Test;

public abstract class GeneralPolynomialRootReal {
    Random rand = new Random(234L);

    @Test
    public void rootsSmallReal() {
        for (int numCoef = 2; numCoef < 6; ++numCoef) {
            Polynomial poly = new Polynomial(numCoef);
            for (int trial = 0; trial < 20; ++trial) {
                for (int i = 0; i < numCoef; ++i) {
                    poly.c[i] = 10.0 * (this.rand.nextDouble() - 0.5);
                }
                List<Double> roots = this.computeRealRoots(poly);
                for (double d : roots) {
                    Assert.assertEquals((double)0.0, (double)poly.evaluate(d), (double)1.0E-8);
                }
                int expectedRoots = PolynomialOps.countRealRoots(poly);
                Assert.assertTrue((roots.size() == expectedRoots ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void rootsLargeReal() {
        for (int numCoef = 10; numCoef < 15; ++numCoef) {
            Polynomial poly = new Polynomial(numCoef);
            for (int trial = 0; trial < 20; ++trial) {
                for (int i = 0; i < numCoef; ++i) {
                    poly.c[i] = 2000.0 * (this.rand.nextDouble() - 0.5);
                }
                List<Double> roots = this.computeRealRoots(poly);
                for (double d : roots) {
                    Assert.assertEquals((double)0.0, (double)poly.evaluate(d), (double)1.0E-8);
                }
                int expectedRoots = PolynomialOps.countRealRoots(poly);
                Assert.assertTrue((roots.size() == expectedRoots ? 1 : 0) != 0);
            }
        }
    }

    public abstract List<Double> computeRealRoots(Polynomial var1);
}

