/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.rand;

import java.util.Random;
import org.ddogleg.rand.MultivariateGaussianDraw;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.junit.Assert;
import org.junit.Test;

public class TestMultivariateGaussianDraw {
    public static int N = 6000;

    @Test
    public void testStatistics() {
        DenseMatrix64F orig_x = new DenseMatrix64F(new double[][]{{4.0}, {-2.0}});
        DenseMatrix64F orig_P = new DenseMatrix64F(new double[][]{{6.0, -2.0}, {-2.0, 10.0}});
        MultivariateGaussianDraw dist = new MultivariateGaussianDraw(new Random(65261L), orig_x, orig_P);
        DenseMatrix64F[] draws = new DenseMatrix64F[N];
        for (int i = 0; i < N; ++i) {
            DenseMatrix64F x = new DenseMatrix64F(2, 1);
            draws[i] = dist.next(x);
        }
        double[] raw_comp_x = new double[2];
        for (int i = 0; i < N; ++i) {
            raw_comp_x[0] = raw_comp_x[0] + draws[i].get(0, 0);
            raw_comp_x[1] = raw_comp_x[1] + draws[i].get(1, 0);
        }
        raw_comp_x[0] = raw_comp_x[0] / (double)N;
        raw_comp_x[1] = raw_comp_x[1] / (double)N;
        Assert.assertEquals((double)4.0, (double)raw_comp_x[0], (double)0.1);
        Assert.assertEquals((double)-2.0, (double)raw_comp_x[1], (double)0.1);
        DenseMatrix64F comp_P = new DenseMatrix64F(2, 2);
        DenseMatrix64F temp = new DenseMatrix64F(2, 1);
        for (int i = 0; i < N; ++i) {
            temp.set(0, 0, draws[i].get(0, 0) - raw_comp_x[0]);
            temp.set(1, 0, draws[i].get(1, 0) - raw_comp_x[1]);
            CommonOps.multAddTransB(temp, temp, comp_P);
        }
        CommonOps.scale(1.0 / (double)N, comp_P);
        MatrixFeatures.isIdentical(comp_P, orig_P, 0.3);
    }
}

