/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.impl.NumericalJacobianFB;
import org.junit.Assert;
import org.junit.Test;

public class TestNumericalJacobianFB {
    double tol = 1.0E-16;

    @Test
    public void simple() {
        SimpleFunction f = new SimpleFunction();
        NumericalJacobianFB alg = new NumericalJacobianFB(f);
        double[] output = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        alg.process(new double[]{2.0, 3.0, 7.0}, output);
        Assert.assertEquals((double)3.0, (double)output[0], (double)this.tol);
        Assert.assertEquals((double)-36.0, (double)output[1], (double)this.tol);
        Assert.assertEquals((double)0.0, (double)output[2], (double)this.tol);
        Assert.assertEquals((double)3.0, (double)output[3], (double)this.tol);
        Assert.assertEquals((double)2.0, (double)output[4], (double)this.tol);
        Assert.assertEquals((double)1.0, (double)output[5], (double)this.tol);
    }

    private static class SimpleFunction
    implements FunctionNtoM {
        private SimpleFunction() {
        }

        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public int getNumOfOutputsM() {
            return 2;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            double x3 = input[2];
            output[0] = 3.0 * x1 - 6.0 * x2 * x2;
            output[1] = x1 * x2 + x3;
        }
    }
}

