/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import java.util.List;
import org.ddogleg.optimization.EvaluateLineSearchMore94;
import org.ddogleg.optimization.LineSearchEvaluator;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.impl.LineSearchMore94;
import org.ddogleg.optimization.impl.TrivialQuadraticDerivStoS;
import org.ddogleg.optimization.impl.TrivialQuadraticStoS;
import org.ddogleg.optimization.wrap.Individual_to_CoupledDerivative;
import org.junit.Assert;
import org.junit.Test;

public class TestLineSearchMore94 {
    EvaluateLineSearchMore94 eval = new EvaluateLineSearchMore94(false);

    @Test
    public void checkBasic() {
        double expected = 10.0;
        TrivialQuadraticStoS f = new TrivialQuadraticStoS(expected);
        TrivialQuadraticDerivStoS d = new TrivialQuadraticDerivStoS(expected);
        LineSearchMore94 alg = new LineSearchMore94().setConvergence(1.0E-4, 0.1, 0.001);
        alg.setFunction(new Individual_to_CoupledDerivative(f, d));
        double valueZero = f.process(0.0);
        double derivZero = d.process(0.0);
        double initValue = f.process(1.0);
        alg.init(valueZero, derivZero, initValue, 1.0, 0.0, 100.0);
        Assert.assertTrue((boolean)UtilOptimize.process(alg, 50));
        double foundLoose = alg.getStep();
        alg = new LineSearchMore94().setConvergence(1.0E-5, 1.0E-6, 0.001);
        alg.setFunction(new Individual_to_CoupledDerivative(f, d));
        alg.init(valueZero, derivZero, initValue, 1.0, 0.0, 100.0);
        Assert.assertTrue((boolean)UtilOptimize.process(alg, 50));
        Assert.assertTrue((alg.getWarning() == null ? 1 : 0) != 0);
        double foundTight = alg.getStep();
        Assert.assertTrue((Math.abs(foundTight - expected) < Math.abs(foundLoose - expected) ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)foundTight, (double)1.0E-5);
    }

    @Test
    public void compareMore1() {
        List<LineSearchEvaluator.Results> results = this.eval.more1();
        TestLineSearchMore94.testResults(results.get(0), 6, 1.365);
        TestLineSearchMore94.testResults(results.get(1), 3, 1.4413720790892741);
        TestLineSearchMore94.testResults(results.get(2), 1, 10.0);
        TestLineSearchMore94.testResults(results.get(3), 4, 36.88760696396662);
    }

    @Test
    public void compareMore2() {
        List<LineSearchEvaluator.Results> results = this.eval.more2();
        TestLineSearchMore94.testResults(results.get(0), 12, 1.596);
        TestLineSearchMore94.testResults(results.get(1), 8, 1.596);
        TestLineSearchMore94.testResults(results.get(2), 8, 1.596);
        TestLineSearchMore94.testResults(results.get(3), 11, 1.596);
    }

    @Test
    public void compareMore3() {
        List<LineSearchEvaluator.Results> results = this.eval.more3();
        TestLineSearchMore94.testResults(results.get(0), 12, 1.0);
        TestLineSearchMore94.testResults(results.get(1), 12, 1.0);
        TestLineSearchMore94.testResults(results.get(2), 10, 1.0);
        TestLineSearchMore94.testResults(results.get(3), 13, 1.0);
    }

    @Test
    public void compareMore4() {
        List<LineSearchEvaluator.Results> results = this.eval.more4();
        TestLineSearchMore94.testResults(results.get(0), 4, 0.085);
        TestLineSearchMore94.testResults(results.get(1), 1, 0.1);
        TestLineSearchMore94.testResults(results.get(2), 3, 0.34910461641724727);
        TestLineSearchMore94.testResults(results.get(3), 4, 0.8294012431694555);
    }

    @Test
    public void compareMore5() {
        List<LineSearchEvaluator.Results> results = this.eval.more5();
        TestLineSearchMore94.testResults(results.get(0), 6, 0.0750108706000682);
        TestLineSearchMore94.testResults(results.get(1), 3, 0.07751042197802416);
        TestLineSearchMore94.testResults(results.get(2), 7, 0.07314201106899357);
        TestLineSearchMore94.testResults(results.get(3), 8, 0.07615927320140908);
    }

    @Test
    public void compareMore6() {
        List<LineSearchEvaluator.Results> results = this.eval.more6();
        TestLineSearchMore94.testResults(results.get(0), 13, 0.9279032286385813);
        TestLineSearchMore94.testResults(results.get(1), 11, 0.9261500138380063);
        TestLineSearchMore94.testResults(results.get(2), 8, 0.9247816734322059);
        TestLineSearchMore94.testResults(results.get(3), 11, 0.9243979067550705);
    }

    public static void testResults(LineSearchEvaluator.Results r, int n, double step) {
        Assert.assertEquals((long)r.numIterations, (long)n);
        Assert.assertEquals((double)r.x, (double)step, (double)0.01);
    }
}

