/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.CallCounterNtoM;
import org.ddogleg.optimization.CallCounterNtoMxN;
import org.ddogleg.optimization.NonlinearResults;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.funcs.EvalFuncBadlyScaledBrown;
import org.ddogleg.optimization.funcs.EvalFuncHelicalValley;
import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.funcs.EvalFuncPowell;
import org.ddogleg.optimization.funcs.EvalFuncRosenbrock;
import org.ddogleg.optimization.funcs.EvalFuncRosenbrockMod;
import org.ddogleg.optimization.funcs.EvalFuncTrigonometric;
import org.ddogleg.optimization.funcs.EvalFuncVariablyDimensioned;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.impl.NumericalJacobianForward;

public abstract class UnconstrainedLeastSquaresEvaluator {
    boolean verbose = true;
    boolean printSummary;
    int maxIteration = 500;

    protected UnconstrainedLeastSquaresEvaluator(boolean verbose, boolean printSummary) {
        this.verbose = verbose;
        this.printSummary = printSummary;
    }

    protected abstract UnconstrainedLeastSquares createSearch(double var1);

    private NonlinearResults performTest(FunctionNtoM func, FunctionNtoMxN deriv, double[] initial, double[] optimal, double minimValue) {
        int iter;
        if (deriv == null) {
            deriv = new NumericalJacobianForward(func);
        }
        CallCounterNtoM f = new CallCounterNtoM(func);
        CallCounterNtoMxN d = new CallCounterNtoMxN(deriv);
        UnconstrainedLeastSquares alg = this.createSearch(minimValue);
        alg.setFunction(f, d);
        alg.initialize(initial, 1.0E-10, 1.0E-20);
        double initialError = alg.getFunctionValue();
        for (iter = 0; iter < this.maxIteration && !alg.iterate(); ++iter) {
            if (!this.verbose || !alg.isUpdated()) continue;
            double error = alg.getFunctionValue();
            System.out.println("  error = " + error);
        }
        if (this.verbose) {
            System.out.println("*** total iterations = " + iter);
        }
        double[] found = alg.getParameters();
        double finalError = alg.getFunctionValue();
        if (this.printSummary) {
            double dist = Double.NaN;
            if (optimal != null) {
                dist = 0.0;
                for (int i = 0; i < func.getNumOfInputsN(); ++i) {
                    dist += Math.pow(found[i] - optimal[i], 2.0);
                }
                dist = Math.sqrt(dist);
            }
            System.out.printf("value{ init %7.1e final = %7.2e} optimal %7.1e count f = %2d d = %2d\n", initialError, finalError, dist, f.count, d.count);
        }
        NonlinearResults ret = new NonlinearResults();
        ret.numFunction = f.count;
        ret.numGradient = d.count;
        ret.f = finalError;
        ret.x = found;
        return ret;
    }

    private NonlinearResults performTest(EvalFuncLeastSquares func) {
        double[] initial = func.getInitial();
        return this.performTest(func.getFunction(), func.getJacobian(), initial, func.getOptimal(), 0.0);
    }

    public NonlinearResults helicalValley() {
        return this.performTest(new EvalFuncHelicalValley());
    }

    public NonlinearResults rosenbrock() {
        return this.performTest(new EvalFuncRosenbrock());
    }

    public NonlinearResults rosenbrockMod(double lambda) {
        return this.performTest(new EvalFuncRosenbrockMod(lambda));
    }

    public NonlinearResults variably() {
        return this.performTest(new EvalFuncVariablyDimensioned(10));
    }

    public NonlinearResults trigonometric() {
        return this.performTest(new EvalFuncTrigonometric(10));
    }

    public NonlinearResults badlyScaledBrown() {
        return this.performTest(new EvalFuncBadlyScaledBrown());
    }

    public NonlinearResults powell() {
        return this.performTest(new EvalFuncPowell());
    }
}

