/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.CallCounterStoS;
import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.functions.FunctionStoS;
import org.ddogleg.optimization.wrap.Individual_to_CoupledDerivative;

public abstract class LineSearchEvaluator {
    boolean verbose;

    protected LineSearchEvaluator(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract LineSearch createSearch();

    private Results performTest(FunctionStoS func, FunctionStoS deriv, double initStep, double minStep, double maxStep) {
        CallCounterStoS f = new CallCounterStoS(func);
        CallCounterStoS d = new CallCounterStoS(deriv);
        LineSearch alg = this.createSearch();
        alg.setFunction(new Individual_to_CoupledDerivative(f, d));
        double valueZero = func.process(0.0);
        double derivZero = deriv.process(0.0);
        double valueInit = func.process(initStep);
        alg.init(valueZero, derivZero, valueInit, initStep, minStep, maxStep);
        for (int i = 0; i < 50 && !alg.iterate(); ++i) {
        }
        double found = alg.getStep();
        double foundDeriv = deriv.process(found);
        if (this.verbose) {
            System.out.printf("step{ init %4.1e final = %6.3f} deriv %9.2e  count f = %2d d = %2d\n", initStep, found, foundDeriv, f.count, d.count);
        }
        Results ret = new Results();
        ret.numIterations = d.count;
        ret.deriv = foundDeriv;
        ret.f = func.process(found);
        ret.deriv = foundDeriv;
        ret.x = found;
        return ret;
    }

    private List<Results> process(FunctionStoS f, FunctionStoS g, double ... initSteps) {
        ArrayList<Results> results = new ArrayList<Results>();
        for (double step : initSteps) {
            results.add(this.performTest(f, g, step, 0.0, Double.POSITIVE_INFINITY));
        }
        return results;
    }

    private List<Results> processMore(FunctionStoS f, FunctionStoS g, double ... initSteps) {
        ArrayList<Results> results = new ArrayList<Results>();
        for (double step : initSteps) {
            double maxStep = 4.0 * Math.max(1.0, step);
            results.add(this.performTest(f, g, step, 0.0, maxStep));
        }
        return results;
    }

    public List<Results> fletcher1() {
        FletcherFunction1 f = new FletcherFunction1();
        FletcherDerivative1 g = new FletcherDerivative1();
        return this.process(f, g, 0.1, 1.0);
    }

    public List<Results> more1() {
        MoreFunction1 f = new MoreFunction1(2.0);
        MoreDerivative1 g = new MoreDerivative1(2.0);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public List<Results> more2() {
        MoreFunction2 f = new MoreFunction2(0.004);
        MoreDerivative2 g = new MoreDerivative2(0.004);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public List<Results> more3() {
        MoreFunction3 f = new MoreFunction3(39.0, 0.01);
        MoreDerivative3 g = new MoreDerivative3(39.0, 0.01);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public List<Results> more4() {
        MoreFunction4 f = new MoreFunction4(0.001, 0.001);
        MoreDerivative4 g = new MoreDerivative4(0.001, 0.001);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public List<Results> more5() {
        MoreFunction4 f = new MoreFunction4(0.01, 0.001);
        MoreDerivative4 g = new MoreDerivative4(0.01, 0.001);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public List<Results> more6() {
        MoreFunction4 f = new MoreFunction4(0.001, 0.01);
        MoreDerivative4 g = new MoreDerivative4(0.001, 0.01);
        return this.processMore(f, g, 0.001, 0.1, 10.0, 1000.0);
    }

    public static class Results {
        public int numIterations;
        public double f;
        public double deriv;
        public double x;
    }

    private static class MoreDerivative4
    implements FunctionStoS {
        double b1;
        double b2;

        private MoreDerivative4(double b1, double b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        @Override
        public double process(double x) {
            double t1 = this.gamma(this.b1);
            double t2 = this.gamma(this.b2);
            return -t1 * ((1.0 - x) / Math.sqrt(Math.pow(1.0 - x, 2.0) + this.b2 * this.b2)) + t2 * (x / Math.sqrt(x * x + this.b1 * this.b1));
        }

        private double gamma(double b) {
            return Math.sqrt(1.0 + b * b) - b;
        }
    }

    private static class MoreFunction4
    implements FunctionStoS {
        double b1;
        double b2;

        private MoreFunction4(double b1, double b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        @Override
        public double process(double x) {
            double t1 = this.gamma(this.b1);
            double t2 = this.gamma(this.b2);
            double f = t1 * Math.sqrt(Math.pow(1.0 - x, 2.0) + this.b2 * this.b2) + t2 * Math.sqrt(x * x + this.b1 * this.b1);
            return f;
        }

        private double gamma(double b) {
            return Math.sqrt(1.0 + b * b) - b;
        }
    }

    private static class MoreDerivative3
    implements FunctionStoS {
        double l;
        double beta;

        private MoreDerivative3(double l, double beta) {
            this.l = l;
            this.beta = beta;
        }

        @Override
        public double process(double input) {
            double right = (1.0 - this.beta) * Math.cos(this.l * Math.PI * input / 2.0);
            return this.func(input) + right;
        }

        private double func(double input) {
            if (input <= 1.0 - this.beta) {
                return -1.0;
            }
            if (input >= 1.0 + this.beta) {
                return 1.0;
            }
            return 1.0 / this.beta * (input - 1.0);
        }
    }

    private static class MoreFunction3
    implements FunctionStoS {
        double l;
        double beta;

        private MoreFunction3(double l, double beta) {
            this.l = l;
            this.beta = beta;
        }

        @Override
        public double process(double input) {
            double right = 2.0 * (1.0 - this.beta) / (this.l * Math.PI) * Math.sin(this.l * Math.PI * input / 2.0);
            return this.func(input) + right;
        }

        private double func(double input) {
            if (input <= 1.0 - this.beta) {
                return 1.0 - input;
            }
            if (input >= 1.0 + this.beta) {
                return input - 1.0;
            }
            return 1.0 / (2.0 * this.beta) * Math.pow(input - 1.0, 2.0) + this.beta / 2.0;
        }
    }

    private static class MoreDerivative2
    implements FunctionStoS {
        double beta;

        private MoreDerivative2(double beta) {
            this.beta = beta;
        }

        @Override
        public double process(double x) {
            double t = x + this.beta;
            return 5.0 * Math.pow(t, 4.0) - 8.0 * Math.pow(t, 3.0);
        }
    }

    private static class MoreFunction2
    implements FunctionStoS {
        double beta;

        private MoreFunction2(double beta) {
            this.beta = beta;
        }

        @Override
        public double process(double x) {
            double t = x + this.beta;
            return Math.pow(t, 5.0) - 2.0 * Math.pow(t, 4.0);
        }
    }

    private static class MoreDerivative1
    implements FunctionStoS {
        double beta;

        private MoreDerivative1(double beta) {
            this.beta = beta;
        }

        @Override
        public double process(double x) {
            return (x * x - this.beta) / Math.pow(x * x + this.beta, 2.0);
        }
    }

    private static class MoreFunction1
    implements FunctionStoS {
        double beta;

        private MoreFunction1(double beta) {
            this.beta = beta;
        }

        @Override
        public double process(double input) {
            return -input / (input * input + this.beta);
        }
    }

    private static class FletcherDerivative1
    implements FunctionStoS {
        private FletcherDerivative1() {
        }

        @Override
        public double process(double alpha) {
            return 400.0 * Math.pow(alpha, 3.0) - 2.0 * (1.0 - alpha);
        }
    }

    private static class FletcherFunction1
    implements FunctionStoS {
        private FletcherFunction1() {
        }

        @Override
        public double process(double alpha) {
            return 100.0 * Math.pow(alpha, 4.0) + Math.pow(1.0 - alpha, 2.0);
        }
    }
}

