/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.nn.BenchmarkNearestNeighbor;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;

public class BenchmarkNearestNeighborCorrect {
    int dimen;
    List<double[]> cloud;
    List<double[]> searchSet;
    double[][] solutions;
    double maxDistance;
    NnData result = new NnData();
    NearestNeighbor exhaustive = FactoryNearestNeighbor.exhaustive();

    private double computeCorrectness(NearestNeighbor alg) {
        alg.init(this.dimen);
        alg.setPoints(this.cloud, null);
        int numCorrect = 0;
        for (int i = 0; i < this.searchSet.size(); ++i) {
            double[] p = this.searchSet.get(i);
            if (!alg.findNearest(p, this.maxDistance, this.result) || this.solutions[i] != this.result.point) continue;
            ++numCorrect;
        }
        return 100.0 * (double)numCorrect / (double)this.searchSet.size();
    }

    public List<Subject> createAlg() {
        ArrayList<Subject> ret = new ArrayList<Subject>();
        ret.add(new Subject(FactoryNearestNeighbor.kdtree(200), "kdtree P "));
        ret.add(new Subject(FactoryNearestNeighbor.kdRandomForest(200, 20, 5, 23423432L), "K-D Random Forest"));
        ret.add(new Subject(FactoryNearestNeighbor.kdtree(500), "kdtree P "));
        ret.add(new Subject(FactoryNearestNeighbor.kdtree(1000), "kdtree P "));
        ret.add(new Subject(FactoryNearestNeighbor.kdtree(2000), "kdtree P "));
        return ret;
    }

    public void evaluateDataSet(int dimen, int cloudSize, int searchSize) {
        Random rand = new Random(234L);
        this.dimen = dimen;
        this.cloud = BenchmarkNearestNeighbor.createData(rand, cloudSize, dimen);
        this.searchSet = BenchmarkNearestNeighbor.createData(rand, searchSize, dimen);
        this.solutions = new double[searchSize][];
        this.maxDistance = 10.0;
        System.out.println("Computing solutions");
        this.exhaustive.init(dimen);
        this.exhaustive.setPoints(this.cloud, null);
        for (int i = 0; i < searchSize; ++i) {
            this.exhaustive.findNearest(this.searchSet.get(i), this.maxDistance, this.result);
            this.solutions[i] = this.result.point;
        }
        System.out.println("K = " + dimen + "  cloud = " + cloudSize);
        for (Subject alg : this.createAlg()) {
            System.out.printf("%20s = %4.1f\n", alg.name, this.computeCorrectness(alg.alg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BenchmarkNearestNeighborCorrect app = new BenchmarkNearestNeighborCorrect();
        app.evaluateDataSet(10, 100000, 1000);
        app.evaluateDataSet(20, 100000, 1000);
        app.evaluateDataSet(60, 100000, 1000);
        try {
            BenchmarkNearestNeighborCorrect benchmarkNearestNeighborCorrect = app;
            synchronized (benchmarkNearestNeighborCorrect) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Subject {
        public String name;
        public NearestNeighbor alg;

        private Subject(NearestNeighbor alg, String name) {
            this.name = name;
            this.alg = alg;
        }
    }
}

