/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.GenericModelMatcherTests;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.distance.StatisticalDistance;
import org.ddogleg.fitting.modelset.distance.StatisticalDistanceModelMatcher;

public class TestStatisticalDistanceModelMatcher
extends GenericModelMatcherTests {
    public TestStatisticalDistanceModelMatcher() {
        this.configure(0.9, 0.1, false);
    }

    @Override
    public ModelMatcher<double[], Double> createModelMatcher(ModelManager<double[]> manager, DistanceFromModel<double[], Double> distance, ModelGenerator<double[], Double> generator, ModelFitter<double[], Double> fitter, int minPoints, double fitThreshold) {
        return new StatisticalDistanceModelMatcher<double[], Double>(5, 0.0, 0.0, 10000.0, minPoints, StatisticalDistance.PERCENTILE, 0.95, manager, fitter, distance, new ArrayCodec());
    }

    private static class ArrayCodec
    implements ModelCodec<double[]> {
        private ArrayCodec() {
        }

        @Override
        public void decode(double[] input, double[] outputModel) {
            System.arraycopy(outputModel, 0, input, 0, input.length);
        }

        @Override
        public void encode(double[] model, double[] param) {
            System.arraycopy(model, 0, param, 0, model.length);
        }

        @Override
        public int getParamLength() {
            return 1;
        }
    }
}

