/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import org.ddogleg.fitting.modelset.distance.DistanceFromMeanModel;
import org.ddogleg.fitting.modelset.distance.FitByMeanStatistics;
import org.ddogleg.fitting.modelset.distance.PointIndex;
import org.junit.Assert;
import org.junit.Test;

public class TestFitByMeanStatistics {
    Random rand = new Random(234L);

    @Test
    public void metric_and_prune() {
        LinkedList inliers = new LinkedList();
        for (int i = 0; i < 200; ++i) {
            inliers.add(new PointIndex<Double>(Double.valueOf(i), i));
        }
        Collections.shuffle(inliers, this.rand);
        FitByMeanStatistics<double[], Double> fit = new FitByMeanStatistics<double[], Double>(1.0);
        fit.init(new DistanceFromMeanModel(), inliers);
        fit.computeStatistics();
        Assert.assertEquals((double)99.5, (double)fit.getErrorMetric(), (double)1.0E-8);
        fit.prune();
        Assert.assertEquals((long)158L, (long)inliers.size());
    }
}

