/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelManagerDefault;

public class BenchmarkModelManager {
    public static final int N = 10;
    List<Data> list = new ArrayList<Data>();
    Data src = new Data();

    public void init() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.src.d[i] = (double)i + 3.1;
        }
        for (i = 0; i < 10000; ++i) {
            this.list.add(new Data());
        }
    }

    public long perform(ModelManager<Data> mm, int numTrials) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < numTrials; ++i) {
            for (int j = 0; j < this.list.size(); ++j) {
                mm.copyModel(this.src, this.list.get(j));
            }
        }
        return System.currentTimeMillis() - start;
    }

    public static void main(String[] args) {
        BenchmarkModelManager benchmark = new BenchmarkModelManager();
        benchmark.init();
        int trial = 10000;
        System.out.println("Specialized = " + benchmark.perform(new Specialized(), trial));
        System.out.println("Default     = " + benchmark.perform(new ModelManagerDefault<Data>(Data.class), trial));
    }

    public static class Data {
        double[] d = new double[10];

        public void set(Data a) {
            System.arraycopy(a.d, 0, this.d, 0, 10);
        }
    }

    public static class Specialized
    implements ModelManager<Data> {
        @Override
        public Data createModelInstance() {
            return new Data();
        }

        @Override
        public void copyModel(Data src, Data dst) {
            dst.set(src);
        }
    }
}

