/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.FactoryClustering;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;

public class ExampleClustering {
    public static boolean gaussian = true;
    public static Random rand = new Random();
    public static boolean clicked = false;

    public static List<double[]> createCluster(double x, double y, double width, int N) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (int i = 0; i < N; ++i) {
            double[] p = new double[2];
            if (gaussian) {
                p[0] = rand.nextGaussian() * width / 3.0 + x;
                p[1] = rand.nextGaussian() * width / 3.0 + y;
            } else {
                p[0] = rand.nextDouble() * width - width / 2.0 + x;
                p[1] = rand.nextDouble() * width - width / 2.0 + y;
            }
            points.add(p);
        }
        return points;
    }

    public static void main(String[] args) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.addAll(ExampleClustering.createCluster(5.0, 7.0, 2.0, 100));
        points.addAll(ExampleClustering.createCluster(1.0, 2.0, 1.0, 120));
        points.addAll(ExampleClustering.createCluster(4.0, 5.0, 1.5, 300));
        Collections.shuffle(points);
        StandardKMeans_F64 cluster = FactoryClustering.kMeans_F64(null, 1000, 100, 1.0E-8);
        cluster.init(2, rand.nextLong());
        Gui gui = new Gui(points);
        JFrame frame = new JFrame();
        frame.add((Component)gui, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        while (true) {
            cluster.process(points, 3);
            AssignCluster<double[]> assignment = cluster.getAssignment();
            gui.update(assignment);
            while (!clicked) {
                Thread.yield();
            }
            clicked = false;
        }
    }

    public static class Gui
    extends JPanel
    implements MouseListener {
        AssignCluster<double[]> assignment;
        List<double[]> points;
        Color[] colors;

        public Gui(List<double[]> points) {
            this.points = points;
            this.setPreferredSize(new Dimension(300, 300));
            this.setBackground(Color.WHITE);
            this.addMouseListener(this);
        }

        public synchronized void update(AssignCluster<double[]> assignment) {
            this.assignment = assignment;
            this.colors = new Color[assignment.getNumberOfClusters()];
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i] = new Color(rand.nextInt() | 0x80808);
            }
            this.repaint();
        }

        @Override
        public synchronized void paintComponent(Graphics g) {
            if (this.assignment == null) {
                return;
            }
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            double scaleX = (double)this.getWidth() / 10.0;
            double scaleY = (double)this.getHeight() / 10.0;
            for (int i = 0; i < this.points.size(); ++i) {
                double[] p = this.points.get(i);
                int x = (int)(p[0] * scaleX + 0.5);
                int y = (int)(p[1] * scaleY + 0.5);
                g2.setColor(this.colors[this.assignment.assign(p)]);
                g2.fillOval(x - 2, y - 2, 5, 5);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            clicked = true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

