/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.ArrayList;
import org.ddogleg.clustering.gmm.AssignGmm_F64;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ejml.ops.MatrixFeatures;
import org.junit.Assert;
import org.junit.Test;

public class TestAssignGmm_F64 {
    @Test
    public void assign() {
        ArrayList<GaussianGmm_F64> clusters = new ArrayList<GaussianGmm_F64>();
        clusters.add(TestAssignGmm_F64.createGaussian(2.0, 1.0));
        clusters.add(TestAssignGmm_F64.createGaussian(10.0, 2.0));
        AssignGmm_F64 alg = new AssignGmm_F64(clusters);
        Assert.assertEquals((long)0L, (long)alg.assign(new double[]{3.0}));
        Assert.assertEquals((long)1L, (long)alg.assign(new double[]{9.0}));
    }

    @Test
    public void assign_soft() {
        ArrayList<GaussianGmm_F64> clusters = new ArrayList<GaussianGmm_F64>();
        clusters.add(TestAssignGmm_F64.createGaussian(2.0, 1.0));
        clusters.add(TestAssignGmm_F64.createGaussian(4.0, 1.0));
        AssignGmm_F64 alg = new AssignGmm_F64(clusters);
        double[] fit = new double[2];
        alg.assign(new double[]{3.0}, fit);
        Assert.assertEquals((double)0.5, (double)fit[0], (double)1.0E-8);
        Assert.assertEquals((double)0.5, (double)fit[1], (double)1.0E-8);
        alg.assign(new double[]{3.5}, fit);
        Assert.assertTrue((fit[0] < fit[1] ? 1 : 0) != 0);
    }

    @Test
    public void copy() {
        ArrayList<GaussianGmm_F64> clusters = new ArrayList<GaussianGmm_F64>();
        clusters.add(TestAssignGmm_F64.createGaussian(2.0, 1.0));
        clusters.add(TestAssignGmm_F64.createGaussian(10.0, 2.0));
        AssignGmm_F64 original = new AssignGmm_F64(clusters);
        AssignGmm_F64 copy = (AssignGmm_F64)original.copy();
        Assert.assertEquals((long)original.getNumberOfClusters(), (long)copy.getNumberOfClusters());
        for (int i = 0; i < original.getNumberOfClusters(); ++i) {
            GaussianGmm_F64 c;
            GaussianGmm_F64 o = original.mixture.get(i);
            Assert.assertTrue((o != (c = copy.mixture.get(i)) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)MatrixFeatures.isIdentical(o.mean, c.mean, 1.0E-8));
            Assert.assertTrue((boolean)MatrixFeatures.isIdentical(o.covariance, c.covariance, 1.0E-8));
            Assert.assertTrue((o.weight == c.weight ? 1 : 0) != 0);
        }
    }

    public static GaussianGmm_F64 createGaussian(double mean, double var) {
        GaussianGmm_F64 ret = new GaussianGmm_F64(1);
        ret.mean.set(0, 0, mean);
        ret.covariance.set(0, 0, var);
        ret.weight = 2.0;
        return ret;
    }
}

