/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.FactoryClustering;
import org.ddogleg.clustering.KMeansInitializers;
import org.ddogleg.struct.GrowQueue_I32;

public class BenchmarkStabilityInitialization {
    Random rand = new Random(234L);
    List<double[]> points = new ArrayList<double[]>();
    List<double[]> centers = new ArrayList<double[]>();
    GrowQueue_I32 membership = new GrowQueue_I32();
    GrowQueue_I32 clusterSize = new GrowQueue_I32();
    int totalClusters = 0;

    public void addCluster(double x, double y, double sigmaX, double sigmaY, int N) {
        this.centers.add(new double[]{x, y});
        for (int i = 0; i < N; ++i) {
            double[] p = new double[]{x + this.rand.nextGaussian() * sigmaX, y + this.rand.nextGaussian() * sigmaY};
            this.points.add(p);
            this.membership.add(this.totalClusters);
        }
        ++this.totalClusters;
        this.clusterSize.add(N);
    }

    public void bencharkAll() {
        this.addCluster(10.0, 12.0, 1.0, 2.0, 200);
        this.addCluster(-1.0, 5.0, 0.5, 0.2, 500);
        this.addCluster(5.0, 7.0, 0.3, 0.3, 100);
        System.out.println("Lower errors the better....\n");
        this.evaluate(FactoryClustering.kMeans_F64(KMeansInitializers.STANDARD, 1000, 1000, 1.0E-8));
        this.evaluate(FactoryClustering.kMeans_F64(KMeansInitializers.PLUS_PLUS, 1000, 1000, 1.0E-8));
        this.evaluate(FactoryClustering.gaussianMixtureModelEM_F64(1000, 1000, 1.0E-8));
    }

    public void evaluate(ComputeClusters<double[]> clusterer) {
        clusterer.init(2, 32454325L);
        int numTrials = 500;
        double totalSizeError = 0.0;
        for (int i = 0; i < numTrials; ++i) {
            clusterer.process(this.points, 3);
            AssignCluster<double[]> assign = clusterer.getAssignment();
            int[] counts = new int[this.totalClusters];
            for (int j = 0; j < this.points.size(); ++j) {
                int found;
                int n = found = assign.assign(this.points.get(j));
                counts[n] = counts[n] + 1;
            }
            totalSizeError += this.computeSizeError(assign, counts);
        }
        System.out.println("average size error = " + totalSizeError / (double)numTrials);
    }

    private double computeSizeError(AssignCluster<double[]> assign, int[] counts) {
        double error = 0.0;
        for (int i = 0; i < this.totalClusters; ++i) {
            int closest = assign.assign(this.centers.get(i));
            int foundSize = counts[closest];
            int expectedSize = this.clusterSize.get(i);
            error += (double)Math.abs(foundSize - expectedSize);
        }
        return error / (double)this.totalClusters;
    }

    public static void main(String[] args) {
        BenchmarkStabilityInitialization app = new BenchmarkStabilityInitialization();
        app.bencharkAll();
    }
}

