/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroDate;
import com.mhuss.AstroLib.DateConversionData;
import com.mhuss.AstroLib.TimeOps;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class DateOps {
    final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final int GREGORIAN = 0;
    public static final int JULIAN = 1;
    private static final long E_JULIAN_GREGORIAN = 1721060L;

    public static long dmyToDay(int day, int month, int year, int calendar) {
        DateConversionData dcd = new DateConversionData(year);
        long jd = 0L;
        if (DateOps.getCalendarData(dcd, calendar)) {
            jd = dcd.yearEndDays;
            for (int i = 0; i < month - 1; ++i) {
                jd += (long)dcd.monthDays[i];
            }
            jd += (long)(day - 1);
        }
        return jd;
    }

    public static long dmyToDay(int day, int month, int year) {
        return DateOps.dmyToDay(day, month, year, 0);
    }

    public static long dmyToDay(AstroDate d) {
        return DateOps.dmyToDay(d.day, d.month, d.year, 0);
    }

    public static double dmyToDoubleDay(AstroDate d) {
        return d.second / 86400.0 - 0.5 + (double)DateOps.dmyToDay(d.day, d.month, d.year, 0);
    }

    static void dayToDmy(long jd, AstroDate d, int calendar) {
        d.day = -1;
        switch (calendar) {
            case 0: 
            case 1: {
                d.year = (int)((jd - 1721060L) / 365L);
                break;
            }
            default: {
                return;
            }
        }
        DateConversionData dcd = new DateConversionData(d.year);
        do {
            if (!DateOps.getCalendarData(dcd, calendar)) {
                return;
            }
            if (dcd.yearEndDays > jd) {
                --d.year;
            }
            if (dcd.nextYearEndDays <= jd) {
                // empty if block
            }
            dcd.year = ++d.year;
        } while (dcd.yearEndDays > jd || dcd.nextYearEndDays <= jd);
        long currJd = dcd.yearEndDays;
        d.month = -1;
        for (int i = 0; i < 13; ++i) {
            d.day = (int)(jd - currJd);
            if (d.day < dcd.monthDays[i]) {
                d.month = i + 1;
                ++d.day;
                return;
            }
            currJd += (long)dcd.monthDays[i];
        }
    }

    static void dayToDmy(long jd, AstroDate d) {
        DateOps.dayToDmy(jd, d, 0);
    }

    static void dayToDmy(double jd, AstroDate d, int calendar) {
        DateOps.dayToDmy((long)jd, d, calendar);
        d.second = (jd - Math.floor(jd)) * 86400.0;
    }

    static void dayToDmy(double jd, AstroDate d) {
        DateOps.dayToDmy(jd, d, 0);
    }

    public static long calendarToDay(Calendar cal) {
        return DateOps.dmyToDay(cal.get(5), cal.get(2) + 1, cal.get(1));
    }

    public static double calendarToDoubleDay(Calendar cal) {
        double hours = (double)cal.get(11) + (double)cal.get(12) / 60.0 + (double)cal.get(13) / 3600.0 - (double)TimeOps.tzOffset(cal);
        return (double)DateOps.calendarToDay(cal) + hours / 24.0 - 0.5;
    }

    public static double nowToDoubleDay() {
        return DateOps.calendarToDoubleDay(new GregorianCalendar());
    }

    public static long nowToDay() {
        return DateOps.calendarToDay(new GregorianCalendar());
    }

    public static long dstStart(int year) {
        long jdStart = DateOps.dmyToDay(1, 4, year);
        while (6L != jdStart % 7L) {
            ++jdStart;
        }
        return jdStart;
    }

    public static long dstEnd(int year) {
        long jdEnd = DateOps.dmyToDay(31, 10, year);
        while (6L != jdEnd % 7L) {
            --jdEnd;
        }
        return jdEnd;
    }

    private static void getJulGregYearData(DateConversionData dcd, boolean julian) {
        if (dcd.year >= 0) {
            dcd.yearEndDays = dcd.year * 365 + dcd.year / 4;
            if (!julian) {
                dcd.yearEndDays += (long)(-dcd.year) / 100L + (long)dcd.year / 400L;
            }
        } else {
            dcd.yearEndDays = dcd.year * 365 + (dcd.year - 3) / 4;
            if (!julian) {
                dcd.yearEndDays += (long)(-(dcd.year - 99) / 100 + (dcd.year - 399) / 400);
            }
        }
        if (julian) {
            dcd.yearEndDays -= 2L;
        }
        if (0 == dcd.year % 4 && (0 != dcd.year % 100 || 0 == dcd.year % 400 || julian)) {
            dcd.monthDays[1] = 29;
            --dcd.yearEndDays;
        }
        dcd.yearEndDays += 1721061L;
    }

    private static boolean getCalendarData(DateConversionData dcd, int calendar) {
        boolean isOk = true;
        switch (calendar) {
            case 0: 
            case 1: {
                DateOps.getJulGregYearData(dcd, 1 == calendar);
                break;
            }
            default: {
                isOk = false;
            }
        }
        if (isOk) {
            dcd.nextYearEndDays = dcd.yearEndDays;
            for (int i = 0; i < 13; ++i) {
                dcd.nextYearEndDays += (long)dcd.monthDays[i];
            }
        }
        return isOk;
    }

    public static void main(String[] args) {
        System.out.println("DateOps Test");
        GregorianCalendar utc = new GregorianCalendar(new SimpleTimeZone(0, "UTC"));
        int month = utc.get(2) + 1;
        int day = utc.get(5);
        int year = utc.get(1);
        int hour = utc.get(11);
        int minute = utc.get(12);
        int seconds = utc.get(13);
        AstroDate astroDateUTC = new AstroDate(day, month, year, hour, minute, seconds);
        double julianDay_AstroDate = astroDateUTC.jd() - (double)TimeOps.tzOffset(utc) / 24.0;
        System.out.println("For current date in Greenwich:\njulianDay_AstroDate = " + julianDay_AstroDate);
        double julianDay_DateOps = DateOps.calendarToDoubleDay(utc);
        System.out.println("julianDay_DateOps = " + julianDay_DateOps);
        System.out.println("julianDay_DateOps - julianDay_AstroDate = " + (julianDay_DateOps - julianDay_AstroDate) * 24.0 + " hours");
        GregorianCalendar now = new GregorianCalendar();
        month = now.get(2) + 1;
        day = now.get(5);
        year = now.get(1);
        hour = now.get(11);
        minute = now.get(12);
        seconds = now.get(13);
        AstroDate astroDateNow = new AstroDate(day, month, year, hour, minute, seconds);
        julianDay_AstroDate = astroDateNow.jd() - (double)TimeOps.tzOffset(now) / 24.0;
        System.out.println("For current date local TZ:\njulianDay_AstroDate = " + julianDay_AstroDate);
        julianDay_DateOps = DateOps.calendarToDoubleDay(now);
        System.out.println("julianDay_DateOps = " + julianDay_DateOps);
        System.out.println("julianDay_DateOps - julianDay_AstroDate = " + (julianDay_DateOps - julianDay_AstroDate) * 24.0 + " hours");
        AstroDate astroDate = new AstroDate();
        julianDay_AstroDate = astroDate.jd();
        System.out.println("\nFor J2000:\njulianDay_AstroDate = " + julianDay_AstroDate);
        System.out.println("julianDay_DateOps = " + DateOps.dmyToDay(astroDate));
        System.out.println("TimeOps.tzOffset() = " + TimeOps.tzOffset());
    }
}

