/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dtrmm;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;

public class DposvTest {
    public static void main(String[] args) {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            DposvTest.dposvTest(args);
        }
    }

    public static void dposvTest(String[] args) {
        int j;
        int i;
        if (args.length != 4) {
            System.out.print(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DposvTest N LDA NRHS LDB with \n - N : the size of the matrix \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the RHS B \n");
            System.exit(1);
        }
        int N = Integer.parseInt(args[0]);
        int LDA = Integer.parseInt(args[1]);
        int NRHS = Integer.parseInt(args[2]);
        int LDB = Integer.parseInt(args[3]);
        double[] A1 = new double[LDA * N];
        double[] A2 = new double[LDA * N];
        double[] B1 = new double[LDB * NRHS];
        double[] B2 = new double[LDB * NRHS];
        Dplasma.plasma_Init(N, N, NRHS);
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            A1[LDA * i + i] = A1[LDA * i + i] + (double)N;
            A2[LDA * i + i] = A1[LDA * i + i];
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = A1[LDA * i + j];
                A1[LDA * j + i] = d;
                A2[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < NRHS; ++j) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
            }
        }
        Dplasma.plasma_DPOSV(121, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        int uplo = 121;
        double eps = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOSV ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int info_factorization = DposvTest.check_factorization(N, A1, A2, LDA, uplo, eps);
        int info_solution = DposvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOSV ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOSV ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            A1[LDA * i + i] = A1[LDA * i + i] + (double)N;
            A2[LDA * i + i] = A1[LDA * i + i];
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = A1[LDA * i + j];
                A1[LDA * j + i] = d;
                A2[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < NRHS; ++j) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
            }
        }
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DPOTRF(121, N, A2, 0, LDA);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DPOTRS(121, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        uplo = 121;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOTRF + DPOTRS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_factorization = DposvTest.check_factorization(N, A1, A2, LDA, uplo, eps);
        info_solution = DposvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DPOTRS ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DPOTRS ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            A1[LDA * i + i] = A1[LDA * i + i] + (double)N;
            A2[LDA * i + i] = A1[LDA * i + i];
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                double d = A1[LDA * i + j];
                A1[LDA * j + i] = d;
                A2[LDA * j + i] = d;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < NRHS; ++j) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
            }
        }
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DPOTRF(122, N, A2, 0, LDA);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DTRSM(141, 122, 111, 131, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DTRSM(141, 122, 112, 131, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        uplo = 122;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DPOTRF + DTRSM + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_factorization = DposvTest.check_factorization(N, A1, A2, LDA, uplo, eps);
        info_solution = DposvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DTRSM + DTRSM ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DPOTRF + DTRSM + DTRSM ... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_factorization(int N, double[] A1, double[] A2, int LDA, int uplo, double eps) {
        int info_factorization;
        String norm = "I";
        double[] Residual = new double[N * N];
        double[] L1 = new double[N * N];
        double[] L2 = new double[N * N];
        double[] work = new double[N];
        double alpha = 1.0;
        Dlacpy.dlacpy((String)"ALL", (int)N, (int)N, (double[])A1, (int)0, (int)LDA, (double[])Residual, (int)0, (int)N);
        if (uplo == 121) {
            Dlacpy.dlacpy((String)Dplasma.lapack_const(121), (int)N, (int)N, (double[])A2, (int)0, (int)LDA, (double[])L1, (int)0, (int)N);
            Dlacpy.dlacpy((String)Dplasma.lapack_const(121), (int)N, (int)N, (double[])A2, (int)0, (int)LDA, (double[])L2, (int)0, (int)N);
            Dtrmm.dtrmm((String)"L", (String)"U", (String)"T", (String)"N", (int)N, (int)N, (double)alpha, (double[])L1, (int)0, (int)N, (double[])L2, (int)0, (int)N);
        } else {
            Dlacpy.dlacpy((String)Dplasma.lapack_const(122), (int)N, (int)N, (double[])A2, (int)0, (int)LDA, (double[])L1, (int)0, (int)N);
            Dlacpy.dlacpy((String)Dplasma.lapack_const(122), (int)N, (int)N, (double[])A2, (int)0, (int)LDA, (double[])L2, (int)0, (int)N);
            Dtrmm.dtrmm((String)"R", (String)"L", (String)"T", (String)"N", (int)N, (int)N, (double)alpha, (double[])L1, (int)0, (int)N, (double[])L2, (int)0, (int)N);
        }
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                Residual[j * N + i] = L2[j * N + i] - Residual[j * N + i];
            }
        }
        double Rnorm = Dlange.dlange((String)norm, (int)N, (int)N, (double[])Residual, (int)0, (int)N, (double[])work, (int)0);
        double Anorm = Dlange.dlange((String)norm, (int)N, (int)N, (double[])A1, (int)0, (int)LDA, (double[])work, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Cholesky Factorization \n");
        System.out.print(String.format("-- ||L'L-A||_oo/(||A||_oo.N.eps) = %e \n", Rnorm / (Anorm * (double)N * eps)));
        if (Rnorm / (Anorm * (double)N * eps) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            info_factorization = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            info_factorization = 0;
        }
        return info_factorization;
    }

    private static int check_solution(int N, int NRHS, double[] A1, int LDA, double[] B1, double[] B2, int LDB, double eps) {
        int info_solution;
        String norm = "I";
        double[] work = new double[N];
        double alpha = 1.0;
        double beta = -1.0;
        double Xnorm = Dlange.dlange((String)norm, (int)N, (int)NRHS, (double[])B2, (int)0, (int)LDB, (double[])work, (int)0);
        double Anorm = Dlange.dlange((String)norm, (int)N, (int)N, (double[])A1, (int)0, (int)LDA, (double[])work, (int)0);
        double Bnorm = Dlange.dlange((String)norm, (int)N, (int)NRHS, (double[])B1, (int)0, (int)LDB, (double[])work, (int)0);
        Dgemm.dgemm((String)"N", (String)"N", (int)N, (int)NRHS, (int)N, (double)alpha, (double[])A1, (int)0, (int)LDA, (double[])B2, (int)0, (int)LDB, (double)beta, (double[])B1, (int)0, (int)LDB);
        double Rnorm = Dlange.dlange((String)norm, (int)N, (int)NRHS, (double[])B1, (int)0, (int)LDB, (double[])work, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps)));
        if (Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            info_solution = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            info_solution = 0;
        }
        return info_solution;
    }
}

