/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public abstract class JaVertex
extends JaObject {
    private float stroke;

    public JaVertex() {
        this.setRelw(2);
        this.setRelh(2);
        this.setStroke(1.0f);
        this.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
    }

    public final float getStroke() {
        return this.stroke;
    }

    public final void setStroke(float newStroke) {
        this.stroke = newStroke;
    }

    public final JaObject copy(JaVertex temp) {
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertex && ((JaVertex)comp).getX() == this.getX() && ((JaVertex)comp).getY() == this.getY() && ((JaVertex)comp).getColor().equals(this.getColor()) && ((JaVertex)comp).getStroke() == this.getStroke() && ((JaVertex)comp).getRelw() == this.getRelw() && ((JaVertex)comp).getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int l2 = 4;
        if (editmode == 50 || editmode == 52) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
            }
            if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
            }
            if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
            }
            if (this.getRelw() <= 0 && this.getRelh() > 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
            }
            return 0;
        }
        if (editmode == 51) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 14;
                }
            } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 12;
                }
            } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 13;
                }
            } else if (this.getRelw() <= 0 && this.getRelh() > 0 && clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int l2 = 4;
        int lm1 = 7;
        if (this.getRelw() > 0 && this.getRelh() >= 0 || this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawRect(x - l2, y - l2, 8, 8);
            g2.drawRect(x + w - l2, y + h - l2, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(x - l2 + 1, y - l2 + 1, lm1, lm1);
                g2.fillRect(x + w - l2 + 1, y + h - l2 + 1, lm1, lm1);
            }
        }
        if (this.getRelw() <= 0 && this.getRelh() > 0 || this.getRelw() >= 0 && this.getRelh() < 0) {
            g2.drawRect(x - l2, y + h - l2, 8, 8);
            g2.drawRect(x + w - l2, y - l2, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(x - l2 + 1, y + h - l2 + 1, lm1, lm1);
                g2.fillRect(x + w - l2 + 1, y - l2 + 1, lm1, lm1);
            }
        }
    }

    @Override
    public final void drawVisualAid(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int lp4 = 12;
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            g2.drawLine(x - lp4, y, x + lp4, y);
            g2.drawLine(x, y - lp4, x, y + lp4);
        } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
            g2.drawLine(x + w - lp4, y, x + w + lp4, y);
            g2.drawLine(x + w, y - lp4, x + w, y + lp4);
        } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawLine(x + w, y + h - lp4, x + w, y + h + lp4);
            g2.drawLine(x + w - lp4, y + h, x + w + lp4, y + h);
        } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
            g2.drawLine(x - lp4, y + h, x + lp4, y + h);
            g2.drawLine(x, y + h - lp4, x, y + h + lp4);
        }
    }

    @Override
    public final String latexWidth() {
        String thisValue = Float.toString(this.getStroke() / 2.0f);
        String base = "\\SetWidth{";
        String closing = "}";
        String lineWidth = base.concat(thisValue.concat(closing));
        return lineWidth;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    protected Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        Point2D.Float centerPoint = new Point2D.Float();
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        }
        return centerPoint;
    }

    protected float getLaTexRadius(float scaleFactor) {
        float length = (float)Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        return length /= scaleFactor;
    }

    @Override
    public abstract void jaxoDraw(VectorGraphics var1, boolean var2);

    @Override
    public abstract String latexCommand(float var1, Dimension var2);

    @Override
    public abstract boolean editPanel();
}

