/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaLoopObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaGlLoop
extends JaLoopObject {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaGlLoop temp = (JaGlLoop)this.copy(new JaGlLoop());
        temp.setAmp(this.getAmp());
        temp.setFreq(this.getFreq());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaGlLoop && super.isCopy(comp) && ((JaGlLoop)comp).getAmp() == this.getAmp() && ((JaGlLoop)comp).getFreq() == this.getFreq()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        int i;
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        float boh = 0.6f;
        int angamp = 180;
        if (this.getAmp() < 0) {
            angamp = -180;
        }
        int a = Math.abs(this.getAmp());
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        if (length < 5.0) {
            length = 0.0;
        }
        length = 2.0 * length * Math.PI;
        int n = (int)(length / (double)this.getFreq() / (double)boh);
        float ts = (float)(length / (double)boh / (double)n);
        Arc2D.Float arc = new Arc2D.Float();
        if (this.getDoubleLine()) {
            for (i = 0; i < n; ++i) {
                ((Arc2D)arc).setArc((float)i * ts * boh, (float)(-a / 2) + this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)i * ts * boh, (float)(-a / 2) - this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                gp.append(arc, false);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, (float)(-a / 2) + this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, (float)(-a / 2) - this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, angamp, 0);
                gp.append(arc, false);
            }
        } else {
            for (i = 0; i < n; ++i) {
                ((Arc2D)arc).setArc((float)i * ts * boh, -a / 2, ts, a, 180.0, angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, -a / 2, ts * (1.0f - boh), a, 0.0, angamp, 0);
                gp.append(arc, true);
            }
        }
        gp = this.conformalGP(gp, length, Math.PI * 2);
        gp = this.transl(gp, 0.3183098861837907);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale);
        Point2D angles = this.getLaTexAngles();
        float amplitude = this.getLaTexAmplitude(2.0f * scale);
        float windings = this.getLaTexWindingNumber(1.0f);
        String command = "";
        String base = "\\GlueArc";
        if ((int)radius == 0) {
            command = "%";
        } else if (this.getDoubleLine()) {
            float offSet = this.getDLSeparation() / scale;
            String command1 = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius + offSet) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
            String command2 = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius - offSet) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
            command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        } else {
            command = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + "){" + D_FORMAT.format(amplitude) + "}{" + D_FORMAT.format(windings) + "}";
        }
        return command;
    }

    @Override
    protected final Point2D getLaTexAngles() {
        int eAngle;
        Point2D.Float anglesPoint = new Point2D.Float();
        int offset = 0;
        if (this.getRelw() == 0) {
            int n = 90;
        }
        int sAngle = (int)Math.round(Math.atan2(this.getRelh(), this.getRelw()) * 180.0 / Math.PI);
        if (this.getRelw() <= 0 && this.getRelh() > 0 || this.getRelw() >= 0 && this.getRelh() < 0) {
            sAngle = -sAngle - offset;
            eAngle = sAngle + 360;
            ((Point2D)anglesPoint).setLocation(sAngle, eAngle);
        }
        if (this.getRelw() > 0 && this.getRelh() >= 0 || this.getRelw() < 0 && this.getRelh() <= 0) {
            sAngle = -sAngle + offset;
            eAngle = sAngle + 360;
            ((Point2D)anglesPoint).setLocation(sAngle, eAngle);
        }
        return anglesPoint;
    }

    private float getLaTexAmplitude(float scaleFactor) {
        float a = (float)this.getAmp() / scaleFactor;
        return a;
    }

    private float getLaTexWindingNumber(float scaleFactor) {
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        float n = (float)(length * 2.0 * Math.PI / (double)this.getFreq() / (double)0.7f);
        return n /= scaleFactor;
    }

    private Point2D conformal(float px, float py, double length, double angle) {
        float nx = (float)(length / 2.0 * (1.0 + Math.exp((double)py * angle / length) * Math.cos((double)px * angle / length)));
        float ny = (float)(-length / 2.0 * Math.exp((double)py * angle / length) * Math.sin((double)(-px) * angle / length));
        return new Point2D.Float(nx, ny);
    }

    private GeneralPath conformalGP(GeneralPath gpp, double length, double angle) {
        GeneralPath gp2 = new GeneralPath();
        FlatteningPathIterator pi = new FlatteningPathIterator(gpp.getPathIterator(null), 0.05);
        float[] segm = new float[6];
        float corr = 1.0f - 20.0f / (float)length;
        gp2.moveTo(0.0f, 0.0f);
        while (!pi.isDone()) {
            int type = pi.currentSegment(segm);
            float px1 = (float)this.conformal(segm[0], segm[1], length, angle).getX();
            float py1 = (float)this.conformal(segm[0], segm[1], length, angle).getY();
            float px2 = (float)this.conformal(segm[2], segm[3], length, angle).getX();
            float py2 = (float)this.conformal(segm[2], segm[3], length, angle).getY();
            float px3 = (float)this.conformal(segm[4], segm[5], length, angle).getX();
            float py3 = (float)this.conformal(segm[4], segm[5], length, angle).getY();
            if (type == 0) {
                gp2.moveTo(px1, py1);
            } else if (type == 1) {
                gp2.lineTo(px1, py1);
            } else if (type == 2) {
                px1 = (float)this.conformal(segm[0], corr * segm[1], length, angle).getX();
                py1 = (float)this.conformal(segm[0], corr * segm[1], length, angle).getY();
                gp2.quadTo(px1, py1, px2, py2);
            } else if (type == 3) {
                gp2.curveTo(px1, py1, px2, py2, px3, py3);
            } else {
                gp2.closePath();
            }
            pi.next();
        }
        return gp2;
    }
}

