/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import jhplot.jadraw.JaAxes;
import jplot.DataArray;
import jplot.GPoints;
import jplot.PlotPoint;
import org.freehep.graphics2d.VectorGraphics;

class DrawGraph_2D {
    private static Line2D line = new Line2D.Float();
    private static Rectangle2D.Double rect = new Rectangle2D.Double();
    private static final int X = 0;
    private static final int Y = 1;
    private static double histoWidth;
    private static int[] xpolUP;
    private static int[] ypolUP;
    private static int[] xpolDW;
    private static int[] ypolDW;
    private static int[] xpolUPsys;
    private static int[] ypolUPsys;
    private static int[] xpolDWsys;
    private static int[] ypolDWsys;
    private static int NtotPoly;

    DrawGraph_2D() {
    }

    public static void draw(JaAxes ja, VectorGraphics g2, DataArray da) {
        int m;
        int[] ypol;
        Color cold;
        float scalingFrame = 1.0f;
        double a = ja.topMargin + ja.axisLength[1];
        double zeroX = ja.toX(0.0);
        double zeroY = ja.toY(0.0);
        double cXmin = ja.leftMargin;
        double cXmax = ja.leftMargin + ja.axisLength[0];
        double cYmin = ja.topMargin + ja.axisLength[1];
        double cYmax = ja.topMargin;
        double dashCounter1 = 0.0;
        double dashCounter2 = 0.0;
        Vector<PlotPoint> points = ja.getPoints(da);
        if (points.size() == 0) {
            return;
        }
        int NtotPoly = points.size();
        if (da.getErrorsFill()) {
            xpolUP = new int[NtotPoly];
            ypolUP = new int[NtotPoly];
            xpolDW = new int[NtotPoly];
            ypolDW = new int[NtotPoly];
        }
        if (da.getErrorsFillSys()) {
            xpolUPsys = new int[NtotPoly];
            ypolUPsys = new int[NtotPoly];
            xpolDWsys = new int[NtotPoly];
            ypolDWsys = new int[NtotPoly];
        }
        BasicStroke lineSolidStroke = new BasicStroke(da.getPenWidth() * scalingFrame);
        BasicStroke lineStroke = new BasicStroke(da.getPenWidth() * scalingFrame);
        if (da.getDashLength() > 0.0f) {
            float[] dashPattern = new float[]{da.getDashLength(), 0.5f * da.getDashLength()};
            float dashPhase = 0.0f;
            lineStroke = new BasicStroke(da.getPenWidth() * scalingFrame, 0, 2, 2.0f, dashPattern, dashPhase);
        }
        g2.setColor(da.getColor());
        if (da.drawLine()) {
            g2.setStroke((Stroke)da.getStroke());
        }
        PlotPoint prev = new PlotPoint(0.0, 0.0);
        int i = 1;
        Enumeration<PlotPoint> e2 = points.elements();
        while (e2.hasMoreElements()) {
            block55: {
                PlotPoint pp;
                block51: {
                    block53: {
                        double minDist;
                        block54: {
                            block52: {
                                double xup_prev;
                                double xlow_prev;
                                double dd;
                                double XupS;
                                double XlowS;
                                double Xup;
                                double Xlow;
                                double YlowS;
                                double Yup;
                                double Ylow;
                                double XupTic;
                                double XlowTic;
                                int sl;
                                block50: {
                                    double YupS;
                                    pp = e2.nextElement();
                                    histoWidth = pp.getXright() - pp.getXleft();
                                    if (histoWidth / 2.0 < (double)(sl = (int)da.getErrTicSize())) {
                                        sl = 0;
                                    }
                                    float size = da.getSymbolSize();
                                    XlowTic = pp.getX() - (double)sl;
                                    if (XlowTic <= cXmin) {
                                        XlowTic = pp.getX();
                                    }
                                    if ((XupTic = pp.getX() + (double)sl) >= cXmax) {
                                        XupTic = pp.getX();
                                    }
                                    if ((Ylow = pp.getYlower()) > cYmin) {
                                        Ylow = cYmin - 1.0;
                                    }
                                    if (Ylow < cYmax) {
                                        Ylow = cYmax + 1.0;
                                    }
                                    if ((Yup = pp.getYupper()) < cYmax) {
                                        Yup = cYmax + 1.0;
                                    }
                                    if ((YlowS = pp.getYlowerSys()) > cYmin) {
                                        YlowS = cYmin - 1.0;
                                    }
                                    if ((YupS = pp.getYupperSys()) < cYmax) {
                                        YupS = cYmax + 1.0;
                                    }
                                    if ((Xlow = pp.getXleft()) < cXmin) {
                                        Xlow = cXmin + 1.0;
                                    }
                                    if ((Xup = pp.getXright()) > cXmax) {
                                        Xup = cXmax - 1.0;
                                    }
                                    if ((XlowS = pp.getXleftSys()) < cXmin) {
                                        XlowS = cXmin + 1.0;
                                    }
                                    if ((XupS = pp.getXrightSys()) > cXmax) {
                                        XupS = cXmax - 1.0;
                                    }
                                    if (da.drawSymbol() && i % da.getPointFrequency() == 0) {
                                        g2.setStroke((Stroke)lineSolidStroke);
                                        if (da.getErrorsY()) {
                                            g2.setPaint((Paint)da.getColorErrorsY());
                                            g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * scalingFrame));
                                            g2.drawLine(pp.getX(), Ylow, pp.getX(), pp.getY() + 0.5 * (double)size);
                                            if (da.getErrorsFill()) {
                                                DrawGraph_2D.xpolDW[i - 1] = (int)pp.getX();
                                                DrawGraph_2D.ypolDW[i - 1] = (int)Ylow;
                                            }
                                            g2.drawLine(pp.getX(), pp.getY() - 0.5 * (double)size, pp.getX(), Yup);
                                            if (da.getErrorsFill()) {
                                                DrawGraph_2D.xpolUP[i - 1] = (int)pp.getX();
                                                DrawGraph_2D.ypolUP[i - 1] = (int)Yup;
                                            }
                                            g2.drawLine(XlowTic, Ylow, XupTic, Ylow);
                                            g2.drawLine(XlowTic, Yup, XupTic, Yup);
                                        }
                                        if (da.getErrorsSysY()) {
                                            g2.setPaint((Paint)da.getColorErrorsSysY());
                                            g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * scalingFrame));
                                            g2.drawLine(pp.getX(), YlowS, pp.getX(), Ylow);
                                            if (da.getErrorsFillSys()) {
                                                DrawGraph_2D.xpolDWsys[i - 1] = (int)pp.getX();
                                                DrawGraph_2D.ypolDWsys[i - 1] = (int)YlowS;
                                            }
                                            g2.drawLine(pp.getX(), Yup, pp.getX(), YupS);
                                            if (da.getErrorsFillSys()) {
                                                DrawGraph_2D.xpolUPsys[i - 1] = (int)pp.getX();
                                                DrawGraph_2D.ypolUPsys[i - 1] = (int)YupS;
                                            }
                                        }
                                        if (da.getErrorsX()) {
                                            g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * scalingFrame));
                                            g2.setPaint((Paint)da.getColorErrorsX());
                                            g2.drawLine(Xlow, pp.getY(), pp.getX() - 0.5 * (double)size, pp.getY());
                                            g2.drawLine(pp.getX() + 0.5 * (double)size, pp.getY(), Xup, pp.getY());
                                            g2.drawLine(Xlow, pp.getY() - (double)sl, Xlow, pp.getY() + (double)sl);
                                            g2.drawLine(Xup, pp.getY() - (double)sl, Xup, pp.getY() + (double)sl);
                                        }
                                        if (da.getErrorsSysX()) {
                                            g2.setPaint((Paint)da.getColorErrorsSysX());
                                            g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * scalingFrame));
                                            g2.drawLine(XlowS, pp.getY(), Xlow, pp.getY());
                                            g2.drawLine(Xup, pp.getY(), XupS, pp.getY());
                                        }
                                        g2.setStroke((Stroke)lineSolidStroke);
                                        g2.setPaint((Paint)da.getColor());
                                        GPoints.drawPointType(da.getSymbol(), (Graphics2D)g2, pp.getX(), pp.getY(), size);
                                    }
                                    g2.setStroke((Stroke)lineSolidStroke);
                                    if (da.getGraphStyle() != 2) break block50;
                                    g2.drawLine(pp.getX(), pp.getY(), pp.getX(), zeroY);
                                    break block51;
                                }
                                if (da.getGraphStyle() != 1) break block52;
                                double xlow = pp.getXleft();
                                double xup = pp.getXright();
                                double hW = histoWidth;
                                if (xlow < cXmin) {
                                    dd = cXmin - xlow;
                                    xlow = cXmin;
                                    hW = histoWidth - dd;
                                }
                                if (xup > cXmax) {
                                    dd = xup - cXmax;
                                    xup = cXmax;
                                    hW = histoWidth - dd;
                                }
                                if ((xlow_prev = prev.getXleft()) < cXmin) {
                                    double dd2 = cXmin - xlow_prev;
                                    xlow_prev = cXmin;
                                    hW = histoWidth - dd2;
                                }
                                if ((xup_prev = prev.getXright()) > cXmax) {
                                    double dd3 = xup_prev - cXmax;
                                    xup_prev = cXmax;
                                    hW = histoWidth - dd3;
                                }
                                g2.setStroke((Stroke)lineSolidStroke);
                                if (da.getDashLength() > 0.0f) {
                                    g2.setStroke((Stroke)lineStroke);
                                }
                                if (da.fill()) {
                                    g2.setPaint((Paint)da.getFillColor());
                                    AlphaComposite c = AlphaComposite.getInstance(3, da.getFillColorTransparency());
                                    g2.setComposite((Composite)c);
                                    g2.fillRect(xlow, pp.getY(), histoWidth, cYmin - pp.getY());
                                    AlphaComposite c1 = AlphaComposite.getInstance(3, 1.0f);
                                    g2.setComposite((Composite)c1);
                                }
                                if (da.isBarShown()) {
                                    rect.setRect(xlow, pp.getY(), histoWidth, cYmin - pp.getY());
                                    g2.setStroke((Stroke)lineSolidStroke);
                                    g2.setColor(da.getColor());
                                    g2.draw((Shape)rect);
                                }
                                g2.setPaint((Paint)da.getColor());
                                g2.drawLine(xlow, pp.getY(), xup, pp.getY());
                                if (i > 1) {
                                    g2.drawLine(xlow, prev.getY(), xlow, pp.getY());
                                }
                                if (i == 1) {
                                    g2.drawLine(xlow, cYmin, xlow, pp.getY());
                                }
                                if (i == points.size()) {
                                    g2.drawLine(xup, cYmin, xup, pp.getY());
                                }
                                if (da.getErrorsY()) {
                                    g2.setPaint((Paint)da.getColorErrorsY());
                                    g2.drawLine(pp.getX(), Ylow, pp.getX(), Yup);
                                    if (da.getErrorsFill()) {
                                        DrawGraph_2D.xpolDW[i - 1] = (int)pp.getX();
                                        DrawGraph_2D.ypolDW[i - 1] = (int)Ylow;
                                        DrawGraph_2D.xpolUP[i - 1] = (int)pp.getX();
                                        DrawGraph_2D.ypolUP[i - 1] = (int)Yup;
                                    }
                                    g2.drawLine(XlowTic, Ylow, XupTic, Ylow);
                                    g2.drawLine(XlowTic, Yup, XupTic, Yup);
                                }
                                if (da.getErrorsSysY()) {
                                    g2.setPaint((Paint)da.getColorErrorsSysY());
                                    g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * scalingFrame));
                                    g2.drawLine(pp.getX(), YlowS, pp.getX(), Ylow);
                                    g2.drawLine(pp.getX(), Ylow, pp.getX(), YlowS);
                                }
                                if (da.getErrorsX()) {
                                    g2.setPaint((Paint)da.getColorErrorsX());
                                    g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * scalingFrame));
                                    g2.drawLine(Xlow, pp.getY(), Xup, pp.getY());
                                    g2.drawLine(Xlow, pp.getY() - (double)sl, Xlow, pp.getY() + (double)sl);
                                    g2.drawLine(Xup, pp.getY() - (double)sl, Xup, pp.getY() + (double)sl);
                                }
                                if (da.getErrorsSysX()) {
                                    g2.setPaint((Paint)da.getColorErrorsSysX());
                                    g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * scalingFrame));
                                    g2.drawLine(XlowS, pp.getY(), Xlow, pp.getY());
                                    g2.drawLine(Xup, pp.getY(), XupS, pp.getY());
                                }
                                break block51;
                            }
                            if (i <= 1 || !da.drawLine() || prev.liftPen()) break block51;
                            g2.setStroke((Stroke)lineStroke);
                            if (!(da.getDashLength() > 0.0f) || da.getType() != 101 && da.getType() != 102) break block53;
                            minDist = Math.sqrt((pp.getX() - prev.getX()) * (pp.getX() - prev.getX()) + (pp.getY() - prev.getY()) * (pp.getY() - prev.getY()));
                            if (da.getType() != 101) break block54;
                            if (minDist < (double)(da.getDashLength() * 2.0f)) break block55;
                            g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                        }
                        if (da.getType() != 102 || !((dashCounter1 += minDist) > (double)(da.getDashLength() * 2.0f))) break block51;
                        g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                        dashCounter2 += minDist;
                        if (!(dashCounter2 > (double)(da.getDashLength() * 2.0f))) break block51;
                        dashCounter1 = 0.0;
                        dashCounter2 = 0.0;
                        break block55;
                    }
                    g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                }
                prev = pp;
            }
            ++i;
        }
        int NP = 2 * NtotPoly + 1;
        if (da.getErrorsFillSys()) {
            cold = g2.getColor();
            Composite com_old = g2.getComposite();
            g2.setColor(da.getColorErrorsFillSys());
            AlphaComposite c = AlphaComposite.getInstance(3, da.getErrorFillColorTranspSys());
            g2.setComposite((Composite)c);
            int[] xpol = new int[NP];
            ypol = new int[NP];
            for (int m2 = 0; m2 < NtotPoly; ++m2) {
                xpol[m2] = xpolUPsys[m2];
                ypol[m2] = ypolUPsys[m2];
            }
            int mm = NtotPoly;
            for (m = NtotPoly - 1; m >= 0; --m) {
                xpol[mm] = xpolDWsys[m];
                ypol[mm] = ypolDWsys[m];
                ++mm;
            }
            xpol[NtotPoly * 2] = xpol[0];
            ypol[NtotPoly * 2] = ypol[0];
            for (m = 1; m < NP; ++m) {
            }
            g2.fillPolygon(xpol, ypol, NP);
            g2.setComposite(com_old);
            g2.setColor(cold);
        }
        if (da.getErrorsFill()) {
            cold = g2.getColor();
            Composite com_old = g2.getComposite();
            g2.setColor(da.getColorErrorsFill());
            AlphaComposite c = AlphaComposite.getInstance(3, da.getErrorFillColorTransp());
            g2.setComposite((Composite)c);
            int[] xpol = new int[NP];
            ypol = new int[NP];
            for (int m3 = 0; m3 < NtotPoly; ++m3) {
                xpol[m3] = xpolUP[m3];
                ypol[m3] = ypolUP[m3];
            }
            int mm = NtotPoly;
            for (m = NtotPoly - 1; m >= 0; --m) {
                xpol[mm] = xpolDW[m];
                ypol[mm] = ypolDW[m];
                ++mm;
            }
            xpol[NtotPoly * 2] = xpol[0];
            ypol[NtotPoly * 2] = ypol[0];
            for (m = 1; m < NP; ++m) {
            }
            g2.fillPolygon(xpol, ypol, NP);
            g2.setComposite(com_old);
            g2.setColor(cold);
        }
    }

    static {
        NtotPoly = 0;
    }
}

