/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import graph.RTextLine;
import japlot.Global;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaAxes;
import org.freehep.graphics2d.VectorGraphics;

class DrawAxesTics {
    private static Line2D line = new Line2D.Float();
    private static Rectangle2D.Double rect = new Rectangle2D.Double();
    private static final int X = 0;
    private static final int Y = 1;
    protected static final float xSep = 5.0f;
    protected static final float ySep = 3.0f;

    DrawAxesTics() {
    }

    public static void drawAxes(JaAxes ja, VectorGraphics g2, GeneralPath gp) {
        g2.setColor(ja.getColor());
        g2.setStroke((Stroke)new BasicStroke(ja.getStroke()));
        if (ja.isShow(0) && ja.isShow(1) && ja.isShowMirror(0) && ja.isShowMirror(1)) {
            rect.setRect(ja.leftMargin, ja.topMargin, ja.axisLength[0], ja.axisLength[1]);
            if (gp != null) {
                gp.append(rect, false);
            } else {
                g2.draw((Shape)rect);
            }
        } else {
            if (ja.isShow(0)) {
                line.setLine(ja.leftMargin, ja.bottomMargin, ja.rightMargin, ja.bottomMargin);
                if (gp != null) {
                    gp.append(line, false);
                } else {
                    g2.draw((Shape)line);
                }
            }
            if (ja.isShowMirror(0)) {
                line.setLine(ja.leftMargin, ja.topMargin, ja.rightMargin, ja.topMargin);
                if (gp != null) {
                    gp.append(line, false);
                } else {
                    g2.draw((Shape)line);
                }
            }
            if (ja.isShow(1)) {
                line.setLine(ja.leftMargin, ja.bottomMargin, ja.leftMargin, ja.topMargin);
                if (gp != null) {
                    gp.append(line, false);
                } else {
                    g2.draw((Shape)line);
                }
            }
            if (ja.isShowMirror(1)) {
                line.setLine(ja.rightMargin, ja.bottomMargin, ja.rightMargin, ja.topMargin);
                if (gp != null) {
                    gp.append(line, false);
                } else {
                    g2.draw((Shape)line);
                }
            }
        }
    }

    public static void redraw(JaAxes ja, VectorGraphics g2) {
        double tt;
        double tdic;
        int j;
        double tt2;
        double tdic2;
        double sepa;
        double d;
        int i;
        double xLabelHeight;
        g2.setColor(ja.getColor());
        g2.setStroke((Stroke)new BasicStroke(ja.getStroke()));
        DrawAxesTics.drawAxes(ja, g2, null);
        double subticLengthX = Global.fromX((float)ja.subticLength[0]);
        double subticLengthY = Global.fromY((float)ja.subticLength[1]);
        double ticLengthX = Global.fromX((float)ja.ticLength[0]);
        double ticLengthY = Global.fromY((float)ja.ticLength[1]);
        double labelSpaceX = Global.fromX((float)ja.getLabelSpace(0));
        double labelSpaceY = Global.fromY((float)ja.getLabelSpace(1));
        FontMetrics fmX = g2.getFontMetrics(ja.getLabelFont());
        double yLabelHeight = xLabelHeight = (double)fmX.getHeight();
        int NticLogX = ja.getSubTicksNumber(0) - 1;
        int NticLogY = ja.getSubTicksNumber(1) - 1;
        int xRot = 1;
        int yRot = 1;
        if (ja.getRotateTicks(0)) {
            xRot = -1;
        }
        if (ja.getRotateTicks(1)) {
            yRot = -1;
        }
        double x_end = ja.rightMargin;
        double y_end = ja.topMargin;
        if (ja.getAxesArrow(0) != 0) {
            x_end = ja.rightMargin - 1.0;
            y_end = ja.topMargin + 1.0;
        }
        if (ja.isTicksLabels(0)) {
            for (i = 0; i < ja.getTicksNE(0); ++i) {
                int m;
                double t1;
                int Ntics;
                d = ja.toX(ja.ticNumber[0][i]);
                if (ja.getSubTicksNumber(0) > 0 && i < ja.getTicksNE(0) - 1) {
                    sepa = ja.ticNumber[0][i + 1] - ja.ticNumber[0][i];
                    Ntics = ja.getSubTicksNumber(0);
                    tdic2 = ja.ticNumber[0][i];
                    tt2 = sepa / (double)Ntics;
                    if (ja.isLogScale(0)) {
                        Ntics = NticLogX;
                        tt2 = sepa / (double)Ntics;
                    }
                    for (j = 1; j < Ntics; ++j) {
                        t1 = ja.toX(tdic2 += tt2);
                        if (!(t1 >= ja.leftMargin) || !(t1 <= x_end)) continue;
                        line.setLine(t1, ja.bottomMargin - (double)xRot * subticLengthX, t1, ja.bottomMargin);
                        g2.draw((Shape)line);
                    }
                }
                if (d >= ja.leftMargin && d <= x_end) {
                    line.setLine(d, ja.bottomMargin - (double)xRot * ticLengthX, d, ja.bottomMargin);
                    g2.draw((Shape)line);
                }
                if (ja.isShowMirror(0)) {
                    if (ja.getSubTicksNumber(0) > 0 && i < ja.getTicksNE(0) - 1) {
                        sepa = ja.ticNumber[0][i + 1] - ja.ticNumber[0][i];
                        Ntics = ja.getSubTicksNumber(0);
                        tdic2 = ja.ticNumber[0][i];
                        tt2 = sepa / (double)Ntics;
                        if (ja.isLogScale(0)) {
                            Ntics = NticLogX;
                            tt2 = sepa / (double)Ntics;
                        }
                        for (j = 1; j < Ntics; ++j) {
                            t1 = ja.toX(tdic2 += tt2);
                            if (!(t1 >= ja.leftMargin) || !(t1 <= ja.rightMargin)) continue;
                            line.setLine(t1, ja.topMargin + (double)xRot * subticLengthX, t1, ja.topMargin);
                            g2.draw((Shape)line);
                        }
                    }
                    if (d >= ja.leftMargin && d <= ja.rightMargin) {
                        line.setLine(d, ja.topMargin + (double)xRot * ticLengthX, d, ja.topMargin);
                        g2.draw((Shape)line);
                    }
                }
                if (!ja.isLogScale(0) && i == ja.getTicksNE(0) - 1) {
                    tdic = ja.ticNumber[0][i];
                    double sepa2 = ja.ticNumber[0][i] - ja.ticNumber[0][i - 1];
                    tt = sepa2 / (double)ja.getSubTicksNumber(0);
                    for (m = 0; m < ja.getSubTicksNumber(0); ++m) {
                        double t12 = ja.toX(tdic += tt);
                        if (!(t12 >= ja.leftMargin) || !(t12 <= ja.rightMargin)) continue;
                        line.setLine(t12, ja.bottomMargin - (double)xRot * subticLengthX, t12, ja.bottomMargin);
                        g2.draw((Shape)line);
                        if (!ja.isShowMirror(0)) continue;
                        line.setLine(t12, ja.topMargin + (double)xRot * subticLengthX, t12, ja.topMargin);
                        g2.draw((Shape)line);
                    }
                }
                if (!ja.isLogScale(0) && i == 0) {
                    tdic = ja.ticNumber[0][i];
                    double sepa3 = ja.ticNumber[0][i + 1] - ja.ticNumber[0][i];
                    tt = sepa3 / (double)ja.getSubTicksNumber(0);
                    for (m = 0; m < ja.getSubTicksNumber(0); ++m) {
                        double t13 = ja.toX(tdic -= tt);
                        if (!(t13 >= ja.leftMargin) || !(t13 <= ja.rightMargin)) continue;
                        line.setLine(t13, ja.bottomMargin - (double)xRot * subticLengthX, t13, ja.bottomMargin);
                        g2.draw((Shape)line);
                        if (!ja.isShowMirror(0)) continue;
                        line.setLine(t13, ja.topMargin + (double)xRot * subticLengthX, t13, ja.topMargin);
                        g2.draw((Shape)line);
                    }
                }
                if (!ja.isTicksLabels(0)) continue;
                double ifix = 0.0;
                double ifih = 0.0;
                if (ja.ticLabel[0][i].indexOf("^") > -1) {
                    ifix = -0.35 * (double)fmX.stringWidth(ja.ticLabel[0][i]);
                    ifih = 0.2 * xLabelHeight + labelSpaceX;
                }
                if (ja.isLogScale(0) && (ja.ticLabel[0][i].equals("1") || ja.ticLabel[0][i].equals("10"))) {
                    ifih = ifih + 0.2 * xLabelHeight + labelSpaceX;
                }
                double x1 = d - (ifix += 0.5 * (double)fmX.stringWidth(ja.ticLabel[0][i]));
                double y1 = ja.bottomMargin + xLabelHeight + ifih;
                if (!(d >= ja.leftMargin) || !(d <= ja.rightMargin)) continue;
                RTextLine text = new RTextLine();
                text.setFont(ja.getLabelFont());
                text.setColor(ja.getLabelColor());
                text.setText(ja.ticLabel[0][i]);
                text.draw(g2, (int)x1, (int)y1);
            }
        }
        if (ja.isTicksLabels(1)) {
            for (i = 0; i < ja.getTicksNE(1); ++i) {
                d = ja.toY(ja.ticNumber[1][i]);
                if (ja.getSubTicksNumber(1) > 0 && i < ja.getTicksNE(1) - 1) {
                    sepa = ja.ticNumber[1][i + 1] - ja.ticNumber[1][i];
                    int Ntics = ja.getSubTicksNumber(1);
                    tdic2 = ja.ticNumber[1][i];
                    tt2 = sepa / (double)Ntics;
                    if (ja.isLogScale(1)) {
                        Ntics = NticLogY;
                        tt2 = sepa / (double)Ntics;
                    }
                    for (j = 1; j < Ntics; ++j) {
                        double t1 = ja.toY(tdic2 += tt2);
                        if (!(t1 >= ja.topMargin) || !(t1 <= ja.bottomMargin)) continue;
                        line.setLine(ja.leftMargin, t1, ja.leftMargin + (double)yRot * subticLengthY, t1);
                        g2.draw((Shape)line);
                    }
                }
                if (d >= y_end && d <= ja.bottomMargin) {
                    line.setLine(ja.leftMargin, d, ja.leftMargin + (double)yRot * ticLengthY, d);
                    g2.draw((Shape)line);
                }
                if (ja.isShowMirror(1)) {
                    if (ja.getSubTicksNumber(1) > 0 && i < ja.getTicksNE(1) - 1) {
                        sepa = ja.ticNumber[1][i + 1] - ja.ticNumber[1][i];
                        int Ntics = ja.getSubTicksNumber(1);
                        tdic2 = ja.ticNumber[1][i];
                        tt2 = sepa / (double)Ntics;
                        if (ja.isLogScale(1)) {
                            Ntics = NticLogY;
                            tt2 = sepa / (double)Ntics;
                        }
                        for (j = 1; j < Ntics; ++j) {
                            double t1 = ja.toY(tdic2 += tt2);
                            if (!(t1 >= ja.topMargin) || !(t1 <= ja.bottomMargin)) continue;
                            line.setLine(ja.rightMargin - (double)yRot * subticLengthY, t1, ja.rightMargin, t1);
                            g2.draw((Shape)line);
                        }
                    }
                    if (!ja.isLogScale(1) && i == ja.getTicksNE(1) - 1) {
                        tdic = ja.ticNumber[1][i];
                        double sepa4 = ja.ticNumber[1][ja.getTicksNE(1) - 2] - ja.ticNumber[1][i];
                        tt = sepa4 / (double)ja.getSubTicksNumber(1);
                        for (int m = 0; m < ja.getSubTicksNumber(1); ++m) {
                            double t1 = ja.toY(tdic -= tt);
                            if (!(t1 >= ja.topMargin) || !(t1 <= ja.bottomMargin)) continue;
                            line.setLine(ja.leftMargin, t1, ja.leftMargin + (double)yRot * subticLengthY, t1);
                            g2.draw((Shape)line);
                            if (!ja.isShowMirror(1)) continue;
                            line.setLine(ja.rightMargin - (double)yRot * subticLengthY, t1, ja.rightMargin, t1);
                            g2.draw((Shape)line);
                        }
                    }
                    if (!ja.isLogScale(1) && i == 0) {
                        tdic = ja.ticNumber[1][i];
                        double sepa5 = ja.ticNumber[1][i + 1] - ja.ticNumber[1][i];
                        tt = sepa5 / (double)ja.getSubTicksNumber(1);
                        for (int m = 0; m < ja.getSubTicksNumber(1); ++m) {
                            double t1 = ja.toY(tdic -= tt);
                            if (!(t1 >= ja.topMargin) || !(t1 <= ja.bottomMargin)) continue;
                            line.setLine(ja.leftMargin, t1, ja.leftMargin + (double)yRot * subticLengthY, t1);
                            g2.draw((Shape)line);
                            if (!ja.isShowMirror(1)) continue;
                            line.setLine(ja.rightMargin - (double)yRot * subticLengthY, t1, ja.rightMargin, t1);
                            g2.draw((Shape)line);
                        }
                    }
                    if (d >= y_end && d <= ja.bottomMargin) {
                        line.setLine(ja.rightMargin - (double)yRot * ticLengthY, d, ja.rightMargin, d);
                        g2.draw((Shape)line);
                    }
                }
                if (!ja.isTicksLabels(1)) continue;
                double ifih = 0.0;
                if (ja.isLogScale(1)) {
                    if (ja.ticLabel[1][i].indexOf("^") > -1) {
                        ifih = 0.5 * (double)fmX.stringWidth(ja.ticLabel[1][i]);
                    } else if (ja.ticLabel[1][i].equalsIgnoreCase("1")) {
                        ifih = -0.75 * (double)fmX.stringWidth(ja.ticLabel[1][i]);
                    } else if (ja.ticLabel[1][i].equalsIgnoreCase("10")) {
                        ifih = -0.5 * (double)fmX.stringWidth(ja.ticLabel[1][i]);
                    }
                }
                double x2 = 0.0;
                if (ja.ticLabel[1][i] != null) {
                    x2 = ja.leftMargin - (double)fmX.stringWidth(ja.ticLabel[1][i]) - 5.0 + ifih - labelSpaceY;
                }
                double y2 = d + 0.25 * yLabelHeight;
                if (!(d >= ja.topMargin) || !(d <= ja.bottomMargin)) continue;
                RTextLine text = new RTextLine();
                text.setFont(ja.getLabelFont());
                text.setColor(ja.getLabelColor());
                text.setText(ja.ticLabel[1][i]);
                text.draw(g2, (int)x2, (int)y2);
            }
        }
    }

    private static void mess(String s, double d) {
        System.out.println("Debug: " + s + Double.toString(d));
    }

    private static void mess(String s, int d) {
        System.out.println("Debug: " + s + Integer.toString(d));
    }

    private static void mess(String s) {
        System.out.println("Debug: " + s);
    }
}

