/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoZoom {
    private Graphics g;
    private Image background;
    private Image tmpImage;
    private int imageWidth;
    private int imageHeight;
    private int canvasWidth;
    private int canvasHeight;
    private int zoomWindowX = 0;
    private int zoomWindowY = 0;
    private int zoomWindowWidth;
    private int zoomWindowHeight;
    private int zoomFactor;

    public final void setZoomFactor(int zf) {
        this.zoomFactor = zf;
    }

    public final int getZoomFactor() {
        return this.zoomFactor;
    }

    public final void setZoomWindowWidth(int zwWidth) {
        this.zoomWindowWidth = zwWidth;
    }

    public final int getZoomWindowWidth() {
        return this.zoomWindowWidth;
    }

    public final void setZoomWindowHeight(int zwHeight) {
        this.zoomWindowHeight = zwHeight;
    }

    public final int getZoomWindowHeight() {
        return this.zoomWindowHeight;
    }

    public final void setImageWidth(int iWidth) {
        this.imageWidth = iWidth;
    }

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final void setImageHeight(int iHeight) {
        this.imageHeight = iHeight;
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    public final void setCanvasWidth(int cWidth) {
        this.canvasWidth = cWidth;
    }

    public final int getCanvasWidth() {
        return this.canvasWidth;
    }

    public final void setCanvasHeight(int cHeight) {
        this.canvasHeight = cHeight;
    }

    public final int getCanvasHeight() {
        return this.canvasHeight;
    }

    public final void setZoomWindowX(int x) {
        this.zoomWindowX = x;
    }

    public final int getZoomWindowX() {
        return this.zoomWindowX;
    }

    public final void setZoomWindowY(int y) {
        this.zoomWindowY = y;
    }

    public final int getZoomWindowY() {
        return this.zoomWindowY;
    }

    public final void setBackground(Image bg) {
        this.background = bg;
    }

    public final void setTmpImage() {
        if (this.tmpImage == null) {
            this.createTmpImage();
        } else {
            Graphics gTmp = this.tmpImage.getGraphics();
            gTmp.drawImage(this.background, 0, 0, null);
        }
    }

    public final Image getBackground() {
        return this.background;
    }

    public final void setGraphics(Graphics gr) {
        this.g = gr;
    }

    public final Graphics getGraphics() {
        return this.g;
    }

    public final void drawZoomWindow() {
        Graphics g2 = this.g.create();
        if (this.tmpImage == null) {
            this.createTmpImage();
        }
        Graphics gTmp = this.tmpImage.getGraphics();
        gTmp.clipRect(this.zoomWindowX, this.zoomWindowY, this.zoomWindowWidth, this.zoomWindowHeight);
        gTmp.drawImage(this.background, (1 - this.zoomFactor) * (this.zoomWindowX + this.zoomWindowWidth / 2), (1 - this.zoomFactor) * (this.zoomWindowY + this.zoomWindowHeight / 2), this.imageWidth * this.zoomFactor, this.imageHeight * this.zoomFactor, null);
        gTmp.setColor(JaxoColor.BLACK);
        gTmp.drawRect(this.zoomWindowX, this.zoomWindowY, this.zoomWindowWidth - 1, this.zoomWindowHeight - 1);
        gTmp.setClip(null);
        g2.drawImage(this.tmpImage, 0, 0, null);
    }

    public final void eraseZoomWindow() {
        VectorGraphics g2 = VectorGraphics.create((Graphics)this.g);
        Graphics gTmp = this.tmpImage.getGraphics();
        gTmp.clipRect(this.zoomWindowX, this.zoomWindowY, this.zoomWindowWidth, this.zoomWindowHeight);
        gTmp.drawImage(this.background, 0, 0, null);
        gTmp.setClip(null);
        g2.drawImage(this.tmpImage, 0, 0, null);
    }

    public final void adjustZoomWindow(int oldX, int oldY, int newX, int newY) {
        Graphics gTmp = this.tmpImage.getGraphics();
        if (newX <= oldX && newY <= oldY) {
            gTmp.clipRect(newX + this.zoomWindowWidth, oldY, oldX - newX, newY + this.zoomWindowHeight - oldY);
            gTmp.drawImage(this.background, 0, 0, null);
            gTmp.setClip(null);
            gTmp.clipRect(oldX, newY + this.zoomWindowHeight, this.zoomWindowWidth, oldY - newY);
            gTmp.drawImage(this.background, 0, 0, null);
        } else if (newX > oldX && newY <= oldY) {
            gTmp.clipRect(oldX, oldY, newX - oldX, newY + this.zoomWindowHeight - oldY);
            gTmp.drawImage(this.background, 0, 0, null);
            gTmp.setClip(null);
            gTmp.clipRect(oldX, newY + this.zoomWindowHeight, this.zoomWindowWidth, oldY - newY);
            gTmp.drawImage(this.background, 0, 0, null);
        } else if (newX > oldX && newY > oldY) {
            gTmp.clipRect(oldX, oldY, this.zoomWindowWidth, newY - oldY);
            gTmp.drawImage(this.background, 0, 0, null);
            gTmp.setClip(null);
            gTmp.clipRect(oldX, newY, newX - oldX, oldY + this.zoomWindowHeight - newY);
            gTmp.drawImage(this.background, 0, 0, null);
        } else {
            gTmp.clipRect(oldX, oldY, this.zoomWindowWidth, newY - oldY);
            gTmp.drawImage(this.background, 0, 0, null);
            gTmp.setClip(null);
            gTmp.clipRect(newX + this.zoomWindowWidth, newY, oldX - newX, oldY + this.zoomWindowHeight - newY);
            gTmp.drawImage(this.background, 0, 0, null);
        }
    }

    public final void dragZoomWindow(int eX, int eY) {
        int oldX = this.zoomWindowX;
        int oldY = this.zoomWindowY;
        int newX = eX - this.zoomWindowWidth / 2;
        int newY = eY - this.zoomWindowHeight / 2;
        this.adjustZoomWindow(oldX, oldY, newX, newY);
        this.zoomWindowX = newX;
        this.zoomWindowY = newY;
        if (this.zoomWindowX > this.canvasWidth - this.zoomWindowWidth / 2) {
            this.zoomWindowX = this.canvasWidth - this.zoomWindowWidth / 2;
        } else if (this.zoomWindowX < -this.zoomWindowWidth / 2) {
            this.zoomWindowX = -this.zoomWindowWidth / 2;
        }
        if (this.zoomWindowY > this.canvasHeight - this.zoomWindowHeight / 2) {
            this.zoomWindowY = this.canvasHeight - this.zoomWindowHeight / 2;
        } else if (this.zoomWindowY < -this.zoomWindowHeight / 2) {
            this.zoomWindowY = -this.zoomWindowHeight / 2;
        }
        this.drawZoomWindow();
    }

    private void createTmpImage() {
        VectorGraphics g2D = VectorGraphics.create((Graphics)this.g);
        BufferedImage bimage = g2D.getDeviceConfiguration().createCompatibleImage(this.imageWidth, this.imageHeight, 1);
        this.tmpImage = bimage;
        Graphics gTmp = this.tmpImage.getGraphics();
        gTmp.drawImage(this.background, 0, 0, null);
    }
}

