/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaObject;

public class JaxoVertexT3OptionsPanel
extends JPanel
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaObject theVertexT3;
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private String sVertexT3;
    private Icon theIcon;
    private ImageIcon colorFillPreviewIcon;
    private JButton colorFillbt;
    private JPanel colorFillPanel;
    private TitledBorder colorFillPanelTitle;
    private Color newFillColor;
    private Image colorFillPreview;
    private int newWidth;
    private int newHeight;
    private int newRelWidth;
    private int newRelHeight;
    private int newXin;
    private int newYin;
    private double newLength;
    private boolean changed = false;

    public JaxoVertexT3OptionsPanel(JaObject vertexT3) {
        this.theVertexT3 = vertexT3;
        this.sVertexT3 = this.language.getString("Vertex_parameters");
        this.theIcon = new ImageIcon(JaxoVertexT3OptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT3.png"));
        this.newWidth = this.theVertexT3.getSize().width;
        this.newHeight = this.theVertexT3.getSize().height;
        this.newRelWidth = this.theVertexT3.getRelSize().width;
        this.newRelHeight = this.theVertexT3.getRelSize().height;
        this.getCenter(this.theVertexT3.getX(), this.theVertexT3.getY(), this.newRelWidth, this.newRelHeight);
        this.newLength = Math.sqrt(this.newWidth * this.newWidth + this.newHeight * this.newHeight);
        this.newFillColor = this.theVertexT3.getColor();
        this.colorFillPreview = this.getChooserImage(this.newFillColor);
        this.colorFillPreviewIcon = new ImageIcon(this.colorFillPreview);
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("X: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Y: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel prad = new JPanel();
        prad.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelrad = new SpinnerNumberModel(Math.round(this.newLength), 0.0, (double)((int)Math.round(Math.sqrt(this.d.width * this.d.width + this.d.height * this.d.height))), 1.0);
        JLabel rad = new JLabel(this.language.getString("Radius"), 4);
        prad.add(rad);
        JSpinner sprad = new JSpinner(modelrad);
        prad.add(sprad);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 0, 5, 5);
        prad.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(prad, sc);
        dimSPanel.add((Component)prad, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Center/Radius"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        this.colorFillbt = new JButton(this.colorFillPreviewIcon);
        this.colorFillbt.addActionListener(this);
        this.colorFillPanel = new JPanel();
        this.colorFillPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Color"));
        this.colorFillPanel.setBorder(this.colorFillPanelTitle);
        this.colorFillPanel.add(this.colorFillbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.colorFillPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorFillPanel, c);
        this.add((Component)this.colorFillPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sVertexT3, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            if (this.newFillColor != null) {
                this.theVertexT3.setColor(this.newFillColor);
            }
            this.newXin = modelXin.getNumber().intValue();
            this.newYin = modelYin.getNumber().intValue();
            this.newLength = modelrad.getNumber().floatValue();
            this.setBox(this.newLength, this.newRelWidth, this.newRelHeight);
            this.newWidth = Math.abs(this.newRelWidth);
            this.newHeight = Math.abs(this.newRelHeight);
            this.theVertexT3.setRelWAndH(this.newRelWidth, this.newRelHeight);
            this.setNewCenter(this.newXin, this.newYin, this.newRelWidth, this.newRelHeight);
            this.theVertexT3.setX(this.newXin);
            this.theVertexT3.setY(this.newYin);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorFillbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newFillColor = colorChooser.color(this.newFillColor, false);
            if (this.newFillColor != null) {
                this.colorFillPreviewIcon = new ImageIcon(this.getChooserImage(this.newFillColor));
                this.colorFillbt.setIcon(this.colorFillPreviewIcon);
            }
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private void getCenter(int x, int y, int relw, int relh) {
        if (relw > 0 && relh >= 0) {
            this.newXin = x;
            this.newYin = y;
        }
        if (relw < 0 && relh <= 0) {
            this.newXin = x + Math.abs(relw);
            this.newYin = y + Math.abs(relh);
        }
        if (relw >= 0 && relh < 0) {
            this.newXin = x;
            this.newYin = y + Math.abs(relh);
        }
        if (relw <= 0 && relh > 0) {
            this.newXin = x + Math.abs(relw);
            this.newYin = y;
        }
    }

    private void setNewCenter(int xin, int yin, int relw, int relh) {
        if (this.newRelWidth > 0 && this.newRelHeight >= 0) {
            this.newXin = xin;
            this.newYin = yin;
        }
        if (this.newRelWidth < 0 && this.newRelHeight <= 0) {
            this.newXin = xin + relw;
            this.newYin = yin + relh;
        }
        if (this.newRelWidth >= 0 && this.newRelHeight < 0) {
            this.newXin = xin;
            this.newYin = yin + relh;
        }
        if (this.newRelWidth <= 0 && this.newRelHeight > 0) {
            this.newXin = xin + relw;
            this.newYin = yin;
        }
    }

    private void setBox(double length, int relw, int relh) {
        double theta = Math.atan2(relh, relw);
        this.newRelHeight = (int)Math.round(length * Math.sin(theta));
        this.newRelWidth = (int)Math.round(length * Math.cos(theta));
    }
}

