/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class JaxoToolBar
extends JToolBar
implements ActionListener {
    private static final String[] TOOLBAR_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/filenew.png", "japlot/jaxodraw/icons/folderclose.png", "japlot/jaxodraw/icons/closecb.png", "japlot/jaxodraw/icons/filesave.png", "japlot/jaxodraw/icons/filesaveas.png", "japlot/jaxodraw/icons/fileimport.png", "japlot/jaxodraw/icons/fileexport.png", "japlot/jaxodraw/icons/fileprint.png", "japlot/jaxodraw/icons/texpreview.png", "japlot/jaxodraw/icons/watchModeOff.png", "japlot/jaxodraw/icons/paste.png"};
    private static final int N_OF_TB_BUTTONS = TOOLBAR_BUTTON_ICONS.length;
    private static final String[] TOOLBAR_BUTTON_RO_ICONS = new String[]{"japlot/jaxodraw/icons/filenewro.png", "japlot/jaxodraw/icons/folderopen.png", "japlot/jaxodraw/icons/closecbro.png", "japlot/jaxodraw/icons/filesavero.png", "japlot/jaxodraw/icons/filesaveasro.png", "japlot/jaxodraw/icons/fileimportro.png", "japlot/jaxodraw/icons/fileexportro.png", "japlot/jaxodraw/icons/fileprintro.png", "japlot/jaxodraw/icons/texpreviewro.png", "japlot/jaxodraw/icons/watchModeOn.png", "japlot/jaxodraw/icons/pastero.png"};
    private static final int[] TOOLBAR_MODES = new int[]{70, 71, 78, 72, 73, 81, 75, 76, 77, 0, 46};
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JButton[] toolbarButtons = new JButton[N_OF_TB_BUTTONS];
    private JButton usrGuideButton = new JButton();
    private String[] toolbarTips = new String[]{this.language.getString("New"), this.language.getString("Open"), this.language.getString("Close"), this.language.getString("Save"), this.language.getString("Save_as"), this.language.getString("Import"), this.language.getString("Export"), this.language.getString("Print"), this.language.getString("Latex_Preview"), this.language.getString("Watch_file_mode"), this.language.getString("Paste")};
    private Border raisedetched = BorderFactory.createEtchedBorder(0);
    private ImageIcon watchModeOnIcon = new ImageIcon(JaxoToolBar.class.getClassLoader().getResource("japlot/jaxodraw/icons/watchModeOn.png"));
    private ImageIcon watchModeOffIcon = new ImageIcon(JaxoToolBar.class.getClassLoader().getResource("japlot/jaxodraw/icons/watchModeOff.png"));

    public JaxoToolBar(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(3));
        this.setFloatable(false);
        this.setBorderPainted(true);
        this.setBorder(this.raisedetched);
        this.setLayout(new BorderLayout());
        for (int i = 0; i < N_OF_TB_BUTTONS; ++i) {
            this.toolbarButtons[i] = new JButton();
            this.toolbarButtons[i].setIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource(TOOLBAR_BUTTON_ICONS[i])));
            this.toolbarButtons[i].setRolloverIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource(TOOLBAR_BUTTON_RO_ICONS[i])));
            this.toolbarButtons[i].setPressedIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource(TOOLBAR_BUTTON_RO_ICONS[i])));
            this.toolbarButtons[i].setToolTipText(this.toolbarTips[i]);
            this.toolbarButtons[i].addActionListener(this);
            this.toolbarButtons[i].setMinimumSize(new Dimension(28, 28));
            this.toolbarButtons[i].setPreferredSize(new Dimension(28, 28));
            this.toolbarButtons[i].setBorderPainted(false);
            this.toolbarButtons[i].setRolloverEnabled(true);
            this.toolbarButtons[i].setFocusPainted(false);
            this.toolbarButtons[i].setContentAreaFilled(false);
            toolBarPanel.add(this.toolbarButtons[i]);
        }
        this.usrGuideButton.setIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource("japlot/jaxodraw/icons/info.png")));
        this.usrGuideButton.setRolloverIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource("japlot/jaxodraw/icons/inforo.png")));
        this.usrGuideButton.setPressedIcon(new ImageIcon(JaxoToolBar.class.getClassLoader().getResource("japlot/jaxodraw/icons/inforo.png")));
        this.usrGuideButton.setToolTipText(this.language.getString("User_guide"));
        this.usrGuideButton.addActionListener(this);
        this.usrGuideButton.setMinimumSize(new Dimension(28, 28));
        this.usrGuideButton.setPreferredSize(new Dimension(28, 28));
        this.usrGuideButton.setBorderPainted(false);
        this.usrGuideButton.setRolloverEnabled(true);
        this.usrGuideButton.setFocusPainted(false);
        this.usrGuideButton.setContentAreaFilled(false);
        this.add((Component)toolBarPanel, "West");
        this.add((Component)this.usrGuideButton, "East");
        this.setRollover(true);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.usrGuideButton) {
            this.thePanel.helpEvent();
        } else if (evt.getSource() == this.toolbarButtons[9]) {
            if (this.thePanel.isWatchMode()) {
                this.toolbarButtons[9].setIcon(this.watchModeOffIcon);
            } else {
                this.toolbarButtons[9].setIcon(this.watchModeOnIcon);
            }
            this.thePanel.setWatchMode(!this.thePanel.isWatchMode());
        } else {
            for (int i = 0; i < N_OF_TB_BUTTONS; ++i) {
                if (evt.getSource() != this.toolbarButtons[i]) continue;
                this.thePanel.fileEvent(TOOLBAR_MODES[i]);
            }
        }
    }

    public final int getnTBbts() {
        return N_OF_TB_BUTTONS;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.toolbarButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.toolbarButtons[i].setBorder(border);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.toolbarTips[0] = this.language.getString("New");
        this.toolbarTips[1] = this.language.getString("Open");
        this.toolbarTips[2] = this.language.getString("Close");
        this.toolbarTips[3] = this.language.getString("Save");
        this.toolbarTips[4] = this.language.getString("Save_as");
        this.toolbarTips[5] = this.language.getString("Import");
        this.toolbarTips[6] = this.language.getString("Export");
        this.toolbarTips[7] = this.language.getString("Print");
        this.toolbarTips[8] = this.language.getString("Latex_Preview");
        this.toolbarTips[9] = this.language.getString("Watch_file_mode");
        this.toolbarTips[10] = this.language.getString("Paste");
        for (int i = 0; i < N_OF_TB_BUTTONS; ++i) {
            this.toolbarButtons[i].setToolTipText(this.toolbarTips[i]);
        }
        this.usrGuideButton.setToolTipText(this.language.getString("User_guide"));
    }
}

