/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaBlob;
import jhplot.jadraw.JaBox;
import jhplot.jadraw.JaFArc;
import jhplot.jadraw.JaFLine;
import jhplot.jadraw.JaFLoop;
import jhplot.jadraw.JaGArc;
import jhplot.jadraw.JaGLine;
import jhplot.jadraw.JaGLoop;
import jhplot.jadraw.JaGlArc;
import jhplot.jadraw.JaGlLine;
import jhplot.jadraw.JaGlLoop;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaPArc;
import jhplot.jadraw.JaPLine;
import jhplot.jadraw.JaPLoop;
import jhplot.jadraw.JaSArc;
import jhplot.jadraw.JaSLine;
import jhplot.jadraw.JaSLoop;
import jhplot.jadraw.JaText;
import jhplot.jadraw.JaVertexT1;
import jhplot.jadraw.JaVertexT2;
import jhplot.jadraw.JaVertexT3;
import jhplot.jadraw.JaVertexT4;
import jhplot.jadraw.JaVertexT5;
import jhplot.jadraw.JaVertexT6;
import jhplot.jadraw.JaZigZagLine;

public final class JaxoStaticCanvasMethods {
    private static int nofclicks;
    private static final String[] SYSTEM_FONTS;
    private static int vertexType;
    private static ResourceBundle language;
    private static int[] points;
    private static boolean pointsON;

    private JaxoStaticCanvasMethods() {
    }

    public static JaObject createNewObject(int type, int xin, int yin) {
        JaObject newob = null;
        if (type == 30) {
            newob = JaxoStaticCanvasMethods.newBox(xin, yin);
        } else if (type == 31) {
            newob = JaxoStaticCanvasMethods.newBlob(xin, yin);
        } else if (type == 32) {
            newob = JaxoStaticCanvasMethods.newVertex(xin, yin);
        } else if (type == 33) {
            newob = JaxoStaticCanvasMethods.newZigZagLine(xin, yin);
        } else if (type == 34) {
            newob = JaxoStaticCanvasMethods.newPSText(xin, yin);
        } else if (type == 35) {
            newob = JaxoStaticCanvasMethods.newLatexText(xin, yin);
        } else if (type == 12) {
            newob = JaxoStaticCanvasMethods.newPLine(xin, yin);
        } else if (type == 14) {
            newob = JaxoStaticCanvasMethods.newPArc(xin, yin);
        } else if (type == 13) {
            newob = JaxoStaticCanvasMethods.newPLoop(xin, yin);
        } else if (type == 15) {
            newob = JaxoStaticCanvasMethods.newGlLine(xin, yin);
        } else if (type == 17) {
            newob = JaxoStaticCanvasMethods.newGlArc(xin, yin);
        } else if (type == 16) {
            newob = JaxoStaticCanvasMethods.newGlLoop(xin, yin);
        } else if (type == 3) {
            newob = JaxoStaticCanvasMethods.newFLine(xin, yin);
        } else if (type == 4) {
            newob = JaxoStaticCanvasMethods.newFLoop(xin, yin);
        } else if (type == 5) {
            newob = JaxoStaticCanvasMethods.newFArc(xin, yin);
        } else if (type == 6) {
            newob = JaxoStaticCanvasMethods.newSLine(xin, yin);
        } else if (type == 7) {
            newob = JaxoStaticCanvasMethods.newSLoop(xin, yin);
        } else if (type == 8) {
            newob = JaxoStaticCanvasMethods.newSArc(xin, yin);
        } else if (type == 9) {
            newob = JaxoStaticCanvasMethods.newGLine(xin, yin);
        } else if (type == 10) {
            newob = JaxoStaticCanvasMethods.newGLoop(xin, yin);
        } else if (type == 11) {
            newob = JaxoStaticCanvasMethods.newGArc(xin, yin);
        }
        return newob;
    }

    public static void setNofClicks(int clicks) {
        nofclicks = clicks;
    }

    public static void setLanguage(ResourceBundle lang) {
        language = lang;
    }

    public static void setPoints(int[] newPoints) {
        points = newPoints;
    }

    public static void setPointsON(boolean on) {
        pointsON = on;
    }

    public static void setVertexType(int type) {
        vertexType = type;
    }

    public static String[] getSystemFonts() {
        return SYSTEM_FONTS;
    }

    public static boolean getPointsON() {
        return pointsON;
    }

    public static int[] getPoints() {
        return points;
    }

    public static JaObject newBox(int xin, int yin) {
        JaBox newBox = new JaBox();
        newBox.setX(xin);
        newBox.setY(yin);
        newBox.setStroke(JaxoPrefs.getFloatPref(200));
        newBox.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newBox.setFillColor(JaxoStaticCanvasMethods.getDefaultFillColor());
        return newBox;
    }

    public static JaObject newBlob(int xin, int yin) {
        JaBlob newBlob = new JaBlob();
        newBlob.setX(xin);
        newBlob.setY(yin);
        newBlob.setRotAngle(0);
        newBlob.setStroke(JaxoPrefs.getFloatPref(200));
        newBlob.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newBlob.setFillColor(JaxoStaticCanvasMethods.getDefaultFillColor());
        return newBlob;
    }

    public static JaObject newVertex(int xin, int yin) {
        JaObject newob = null;
        if (vertexType == 36) {
            JaVertexT1 newVertexT1 = new JaVertexT1();
            newVertexT1.setX(xin);
            newVertexT1.setY(yin);
            newVertexT1.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newob = newVertexT1;
        } else if (vertexType == 37) {
            JaVertexT2 newVertexT2 = new JaVertexT2();
            newVertexT2.setX(xin);
            newVertexT2.setY(yin);
            newVertexT2.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newVertexT2.setStroke(JaxoPrefs.getFloatPref(200));
            newVertexT2.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newVertexT2.setFillColor(JaxoColor.WHITE);
            newob = newVertexT2;
        } else if (vertexType == 38) {
            JaVertexT3 newVertexT3 = new JaVertexT3();
            newVertexT3.setX(xin);
            newVertexT3.setY(yin);
            newVertexT3.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newob = newVertexT3;
        } else if (vertexType == 39) {
            JaVertexT4 newVertexT4 = new JaVertexT4();
            newVertexT4.setX(xin);
            newVertexT4.setY(yin);
            newVertexT4.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newVertexT4.setStroke(JaxoPrefs.getFloatPref(200));
            newob = newVertexT4;
        } else if (vertexType == 40) {
            if (nofclicks % 3 != 0) {
                pointsON = true;
                int pos = nofclicks % 3 - 1;
                JaxoStaticCanvasMethods.points[2 * pos] = xin;
                JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
            } else {
                pointsON = false;
                JaxoStaticCanvasMethods.points[4] = xin;
                JaxoStaticCanvasMethods.points[5] = yin;
                JaVertexT5 newVertexT5 = new JaVertexT5();
                newVertexT5.setVertexPts(points[0], points[1], points[2], points[3], points[4], points[5]);
                newVertexT5.setStroke(JaxoPrefs.getFloatPref(200));
                newVertexT5.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
                newVertexT5.setFillColor(JaxoStaticCanvasMethods.getDefaultFillColor());
                newob = newVertexT5;
            }
        } else if (vertexType == 41) {
            JaVertexT6 newVertexT6 = new JaVertexT6();
            newVertexT6.setX(xin);
            newVertexT6.setY(yin);
            newVertexT6.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newob = newVertexT6;
        }
        return newob;
    }

    public static JaObject newZigZagLine(int xin, int yin) {
        JaZigZagLine newZigZagLine = new JaZigZagLine();
        newZigZagLine.setX(xin);
        newZigZagLine.setY(yin);
        newZigZagLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newZigZagLine.setAmp(JaxoPrefs.getIntPref(104));
        newZigZagLine.setFreq(20.0f);
        newZigZagLine.setStroke(JaxoPrefs.getFloatPref(200));
        newZigZagLine.setSymm(false);
        newZigZagLine.setDoubleLine(false);
        newZigZagLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newZigZagLine;
    }

    public static JaObject newPSText(int xin, int yin) {
        JaText newText = new JaText();
        String psText = JaxoStaticCanvasMethods.getText();
        if (psText.length() != 0) {
            newText.setX(xin);
            newText.setY(yin);
            newText.setRotAngle(JaxoPrefs.getIntPref(109));
            newText.setColor(JaxoColor.getColor(JaxoPrefs.getPref(8)));
            newText.setText(psText);
            newText.setAvailableFonts(SYSTEM_FONTS);
            newText.setFont(new Font(JaxoPrefs.getPref(7), JaxoPrefs.getIntPref(105), JaxoPrefs.getIntPref(106)));
            return newText;
        }
        return null;
    }

    public static JaObject newLatexText(int xin, int yin) {
        JaLatexText newText = new JaLatexText();
        String latexText = JaxoStaticCanvasMethods.getText();
        if (latexText.length() != 0) {
            newText.setX(xin);
            newText.setY(yin);
            newText.setRotAngle(JaxoPrefs.getIntPref(113));
            newText.setColor(JaxoColor.getColor(JaxoPrefs.getPref(8)));
            newText.setTextString(latexText);
            newText.setAllign(JaxoPrefs.getIntPref(108));
            newText.setLatexFS(JaxoPrefs.getIntPref(107));
            newText.createLatexPanel();
            return newText;
        }
        return null;
    }

    public static JaObject newPLine(int xin, int yin) {
        JaPLine newPLine = new JaPLine();
        newPLine.setX(xin);
        newPLine.setY(yin);
        newPLine.setAmp(JaxoPrefs.getIntPref(104));
        newPLine.setFreq(20.0f);
        newPLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newPLine.setStroke(JaxoPrefs.getFloatPref(200));
        newPLine.setSymm(false);
        newPLine.setDoubleLine(false);
        newPLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newPLine;
    }

    public static JaObject newPArc(int xin, int yin) {
        JaPArc newob = null;
        if (nofclicks % 3 != 0) {
            pointsON = true;
            int pos = nofclicks % 3 - 1;
            JaxoStaticCanvasMethods.points[2 * pos] = xin;
            JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
        } else {
            pointsON = false;
            JaxoStaticCanvasMethods.points[4] = xin;
            JaxoStaticCanvasMethods.points[5] = yin;
            JaPArc newPArc = new JaPArc();
            newPArc.setArcPts(points[0], points[1], points[2], points[3], points[4], points[5]);
            newPArc.setAmp(-JaxoPrefs.getIntPref(104));
            newPArc.setFreq(20.0f);
            newPArc.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newPArc.setStroke(JaxoPrefs.getFloatPref(200));
            newPArc.setDoubleLine(false);
            newPArc.setDLSeparation(JaxoPrefs.getFloatPref(201));
            newob = newPArc;
        }
        return newob;
    }

    public static JaObject newPLoop(int xin, int yin) {
        JaPLoop newPLoop = new JaPLoop();
        newPLoop.setX(xin);
        newPLoop.setY(yin);
        newPLoop.setAmp(JaxoPrefs.getIntPref(104));
        newPLoop.setFreq(20.0f);
        newPLoop.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newPLoop.setStroke(JaxoPrefs.getFloatPref(200));
        newPLoop.setDoubleLine(false);
        newPLoop.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newPLoop;
    }

    public static JaObject newGlLine(int xin, int yin) {
        JaGlLine newGlLine = new JaGlLine();
        newGlLine.setX(xin);
        newGlLine.setY(yin);
        newGlLine.setAmp(JaxoPrefs.getIntPref(104));
        newGlLine.setFreq(20.0f);
        newGlLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newGlLine.setStroke(JaxoPrefs.getFloatPref(200));
        newGlLine.setSymm(false);
        newGlLine.setDoubleLine(false);
        newGlLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newGlLine;
    }

    public static JaObject newGlArc(int xin, int yin) {
        JaGlArc newob = null;
        if (nofclicks % 3 != 0) {
            pointsON = true;
            int pos = nofclicks % 3 - 1;
            JaxoStaticCanvasMethods.points[2 * pos] = xin;
            JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
        } else {
            pointsON = false;
            JaxoStaticCanvasMethods.points[4] = xin;
            JaxoStaticCanvasMethods.points[5] = yin;
            JaGlArc newGlArc = new JaGlArc();
            newGlArc.setArcPts(points[0], points[1], points[2], points[3], points[4], points[5]);
            newGlArc.setAmp(JaxoPrefs.getIntPref(104));
            newGlArc.setFreq(20.0f);
            newGlArc.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newGlArc.setStroke(JaxoPrefs.getFloatPref(200));
            newGlArc.setDoubleLine(false);
            newGlArc.setDLSeparation(JaxoPrefs.getFloatPref(201));
            newob = newGlArc;
        }
        return newob;
    }

    public static JaObject newGlLoop(int xin, int yin) {
        JaGlLoop newGlLoop = new JaGlLoop();
        newGlLoop.setX(xin);
        newGlLoop.setY(yin);
        newGlLoop.setAmp(JaxoPrefs.getIntPref(104));
        newGlLoop.setFreq(20.0f);
        newGlLoop.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newGlLoop.setStroke(JaxoPrefs.getFloatPref(200));
        newGlLoop.setDoubleLine(false);
        newGlLoop.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newGlLoop;
    }

    public static JaObject newFLine(int xin, int yin) {
        JaFLine newFLine = new JaFLine();
        newFLine.setX(xin);
        newFLine.setY(yin);
        newFLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newFLine.setStroke(JaxoPrefs.getFloatPref(200));
        newFLine.setArrow(JaxoPrefs.getBooleanPref(303));
        newFLine.setFlip(false);
        newFLine.setDoubleLine(false);
        newFLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newFLine;
    }

    public static JaObject newFLoop(int xin, int yin) {
        JaFLoop newFLoop = new JaFLoop();
        newFLoop.setX(xin);
        newFLoop.setY(yin);
        newFLoop.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newFLoop.setStroke(JaxoPrefs.getFloatPref(200));
        newFLoop.setArrow(JaxoPrefs.getBooleanPref(303));
        newFLoop.setFlip(false);
        newFLoop.setDoubleLine(false);
        newFLoop.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newFLoop;
    }

    public static JaObject newFArc(int xin, int yin) {
        JaFArc newob = null;
        if (nofclicks % 3 != 0) {
            pointsON = true;
            int pos = nofclicks % 3 - 1;
            JaxoStaticCanvasMethods.points[2 * pos] = xin;
            JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
        } else {
            pointsON = false;
            JaxoStaticCanvasMethods.points[4] = xin;
            JaxoStaticCanvasMethods.points[5] = yin;
            JaFArc newFArc = new JaFArc();
            newFArc.setArcPts(points[0], points[1], points[2], points[3], points[4], points[5]);
            newFArc.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newFArc.setStroke(JaxoPrefs.getFloatPref(200));
            newFArc.setArrow(JaxoPrefs.getBooleanPref(303));
            newFArc.setFlip(false);
            newFArc.setStangle(0);
            newFArc.setDoubleLine(false);
            newFArc.setDLSeparation(JaxoPrefs.getFloatPref(201));
            newob = newFArc;
        }
        return newob;
    }

    public static JaObject newSLine(int xin, int yin) {
        JaSLine newSLine = new JaSLine();
        newSLine.setX(xin);
        newSLine.setY(yin);
        newSLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newSLine.setStroke(JaxoPrefs.getFloatPref(200));
        newSLine.setDash(10.0f);
        newSLine.setArrow(JaxoPrefs.getBooleanPref(303));
        newSLine.setFlip(false);
        newSLine.setDoubleLine(false);
        newSLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newSLine;
    }

    public static JaObject newSLoop(int xin, int yin) {
        JaSLoop newSLoop = new JaSLoop();
        newSLoop.setX(xin);
        newSLoop.setY(yin);
        newSLoop.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newSLoop.setStroke(JaxoPrefs.getFloatPref(200));
        newSLoop.setDash(10.0f);
        newSLoop.setArrow(JaxoPrefs.getBooleanPref(303));
        newSLoop.setFlip(false);
        newSLoop.setDoubleLine(false);
        newSLoop.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newSLoop;
    }

    public static JaObject newSArc(int xin, int yin) {
        JaSArc newob = null;
        if (nofclicks % 3 != 0) {
            pointsON = true;
            int pos = nofclicks % 3 - 1;
            JaxoStaticCanvasMethods.points[2 * pos] = xin;
            JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
        } else {
            pointsON = false;
            JaxoStaticCanvasMethods.points[4] = xin;
            JaxoStaticCanvasMethods.points[5] = yin;
            JaSArc newSArc = new JaSArc();
            newSArc.setArcPts(points[0], points[1], points[2], points[3], points[4], points[5]);
            newSArc.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newSArc.setStroke(JaxoPrefs.getFloatPref(200));
            newSArc.setDash(10.0f);
            newSArc.setArrow(JaxoPrefs.getBooleanPref(303));
            newSArc.setFlip(false);
            newSArc.setStangle(0);
            newSArc.setDoubleLine(false);
            newSArc.setDLSeparation(JaxoPrefs.getFloatPref(201));
            newob = newSArc;
        }
        return newob;
    }

    public static JaObject newGLine(int xin, int yin) {
        JaGLine newGLine = new JaGLine();
        newGLine.setX(xin);
        newGLine.setY(yin);
        newGLine.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newGLine.setStroke(JaxoPrefs.getFloatPref(200));
        newGLine.setDash(2.0f);
        newGLine.setArrow(JaxoPrefs.getBooleanPref(303));
        newGLine.setFlip(false);
        newGLine.setDoubleLine(false);
        newGLine.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newGLine;
    }

    public static JaObject newGLoop(int xin, int yin) {
        JaGLoop newGLoop = new JaGLoop();
        newGLoop.setX(xin);
        newGLoop.setY(yin);
        newGLoop.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        newGLoop.setStroke(JaxoPrefs.getFloatPref(200));
        newGLoop.setDash(2.0f);
        newGLoop.setArrow(JaxoPrefs.getBooleanPref(303));
        newGLoop.setFlip(false);
        newGLoop.setDoubleLine(false);
        newGLoop.setDLSeparation(JaxoPrefs.getFloatPref(201));
        return newGLoop;
    }

    public static JaObject newGArc(int xin, int yin) {
        JaGArc newob = null;
        if (nofclicks % 3 != 0) {
            pointsON = true;
            int pos = nofclicks % 3 - 1;
            JaxoStaticCanvasMethods.points[2 * pos] = xin;
            JaxoStaticCanvasMethods.points[2 * pos + 1] = yin;
        } else {
            pointsON = false;
            JaxoStaticCanvasMethods.points[4] = xin;
            JaxoStaticCanvasMethods.points[5] = yin;
            JaGArc newGArc = new JaGArc();
            newGArc.setArcPts(points[0], points[1], points[2], points[3], points[4], points[5]);
            newGArc.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
            newGArc.setStroke(JaxoPrefs.getFloatPref(200));
            newGArc.setArrow(JaxoPrefs.getBooleanPref(303));
            newGArc.setFlip(false);
            newGArc.setStangle(0);
            newGArc.setDash(2.0f);
            newGArc.setDoubleLine(false);
            newGArc.setDLSeparation(JaxoPrefs.getFloatPref(201));
            newob = newGArc;
        }
        return newob;
    }

    private static String getText() {
        String text = JOptionPane.showInputDialog(null, language.getString("Please_enter_a_text:"), language.getString("Enter_text"), -1);
        if (text != null) {
            return text;
        }
        return "";
    }

    private static Color getDefaultFillColor() {
        if (JaxoPrefs.getPref(6).equals(JaxoColor.getColorName(JaxoColor.BLACK))) {
            return JaxoColor.GRAYSCALE225;
        }
        return JaxoColor.GRAY;
    }

    static {
        points = new int[6];
        SYSTEM_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }
}

