/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoDraw;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import jhplot.HPlotJa;

public final class JaxoPrefs {
    public static final String PREF_FILENAME = ".Jaxorc";
    public static final int PREF_BROWSER = 0;
    public static final int PREF_EDITOR = 1;
    public static final int PREF_PSVIEWER = 2;
    public static final int PREF_LOOKNFEEL = 3;
    public static final int PREF_LANGUAGE = 4;
    public static final int PREF_GRIDTYPE = 5;
    public static final int PREF_COLOR = 6;
    public static final int PREF_PSFAMILY = 7;
    public static final int PREF_TEXTCOLOR = 8;
    public static final int PREF_LATEXPATH = 9;
    public static final int PREF_DVIPSPATH = 10;
    public static final int PREF_SCREENSIZEX = 100;
    public static final int PREF_SCREENSIZEY = 101;
    public static final int PREF_GRIDSIZE = 102;
    public static final int PREF_AMPLITUDE = 104;
    public static final int PREF_PSSTYLE = 105;
    public static final int PREF_PSSIZE = 106;
    public static final int PREF_TEXSIZE = 107;
    public static final int PREF_TEXALIGN = 108;
    public static final int PREF_PSROTANGLE = 109;
    public static final int PREF_ZOOMFACTOR = 110;
    public static final int PREF_ZOOMSIZEX = 111;
    public static final int PREF_ZOOMSIZEY = 112;
    public static final int PREF_TEXROTANGLE = 113;
    public static final int PREF_DEFAULTACTION = 114;
    public static final int PREF_LINEWIDTH = 200;
    public static final int PREF_DLSEP = 201;
    public static final int PREF_SHOWTOOL = 300;
    public static final int PREF_SHOWSTATUS = 301;
    public static final int PREF_ANTIALIAS = 302;
    public static final int PREF_ARROW = 303;
    public static final int PREF_GRIDONOFF = 304;
    public static final int PREF_SHOWEDITOR = 305;
    public static final int PREF_SHOWBROWSER = 306;
    private static final int[] PREFS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 114, 100, 101, 102, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 200, 201, 300, 301, 302, 303, 304, 305, 306};
    private static final int NO_OF_PREFS = PREFS.length;
    private static String[] prefKEYS = new String[]{"prefBROWSER", "prefEDITOR", "prefPSVIEWER", "prefLOOKNFEEL", "prefLANGUAGE", "prefGRIDTYPE", "prefCOLOR", "prefPSFAMILY", "prefTEXTCOLOR", "prefLATEXPATH", "prefDVIPSPATH", "prefDEFAULTACTION", "prefSCREENSIZEX", "prefSCREENSIZEY", "prefGRIDSIZE", "prefAMPLITUDE", "prefPSSTYLE", "prefPSSIZE", "prefTEXSIZE", "prefTEXALIGN", "prefPSROTANGLE", "prefZOOMFACTOR", "prefZOOMSIZEX", "prefZOOMSIZEY", "prefTEXROTANGLE", "prefLINEWIDTH", "prefDLSEP", "prefSHOWTOOL", "prefSHOWSTATUS", "prefANTIALIAS", "prefARROW", "prefGRIDONOFF", "prefSHOWEDITOR", "prefSHOWBROWSER"};
    private static final String BROWSER_DEFAULT = "";
    private static final String EDITOR_DEFAULT = "";
    private static final String PSVIEWER_DEFAULT = "";
    private static final String LOOKNFEEL_DEFAULT = "Metal";
    private static final String LANGUAGE_DEFAULT = "english";
    private static final String GRIDTYPE_DEFAULT = "rectangular";
    private static final String COLOR_DEFAULT = JaxoColor.getColorName(JaxoColor.BLACK);
    private static final String PSFAMILY_DEFAULT = "Default";
    private static final String TEXTCOLOR_DEFAULT = JaxoColor.getColorName(JaxoColor.BLACK);
    private static final String LATEXPATH_DEFAULT = "latex";
    private static final String DVIPSPATH_DEFAULT = "dvips";
    private static final String DEFAULTACTION_DEFAULT = "0";
    private static final String SCREENSIZEX_DEFAULT = "800";
    private static final String SCREENSIZEY_DEFAULT = "600";
    private static final String GRIDSIZE_DEFAULT = "15";
    private static final String AMPLITUDE_DEFAULT = "15";
    private static final String PSSTYLE_DEFAULT = "2";
    private static final String PSSIZE_DEFAULT = "18";
    private static final String TEXSIZE_DEFAULT = "6";
    private static final String TEXALIGN_DEFAULT = "2";
    private static final String PSROTANGLE_DEFAULT = "0";
    private static final String ZOOMFACTOR_DEFAULT = "2";
    private static final String ZOOMSIZEX_DEFAULT = "160";
    private static final String ZOOMSIZEY_DEFAULT = "100";
    private static final String TEXROTANGLE_DEFAULT = "0";
    private static final String LINEWIDTH_DEFAULT = "1.0";
    private static final String DLSEP_DEFAULT = "2.0";
    private static final String SHOWTOOL_DEFAULT = "false";
    private static final String SHOWEDITOR_DEFAULT = "false";
    private static final String SHOWBROWSER_DEFAULT = "false";
    private static final String SHOWSTATUS_DEFAULT = "true";
    private static final String ANTIALIAS_DEFAULT = "true";
    private static final String ARROW_DEFAULT = "true";
    private static final String GRIDONOFF_DEFAULT = "false";
    private static String[] prefDEFAULTS = new String[]{"", "", "", "Metal", "english", "rectangular", COLOR_DEFAULT, "Default", TEXTCOLOR_DEFAULT, "latex", "dvips", "0", "800", "600", "15", "15", "2", "18", "6", "2", "0", "2", "160", "100", "0", "1.0", "2.0", "false", "true", "true", "true", "false", "false", "false"};
    private static String[] preferences = prefDEFAULTS;
    private static boolean verbose = true;
    private static String[] recentKEYS = new String[]{"recentFile1", "recentFile2", "recentFile3", "recentFile4"};
    private static String[] recentFile = new String[]{"", "", "", ""};

    private JaxoPrefs() {
    }

    public static int getNofPrefs() {
        return NO_OF_PREFS;
    }

    public static boolean verbose() {
        return verbose;
    }

    public static void setVerbose(boolean verb) {
        verbose = verb;
    }

    public static String getRecentFile(int i) {
        String str = null;
        if (i >= 0 && i < 4) {
            str = recentFile[i];
        }
        return str;
    }

    public static void setRecentFile(int i, String str) {
        if (i >= 0 && i < 4) {
            JaxoPrefs.recentFile[i] = str;
        }
    }

    public static String getPref(int i) {
        String str = null;
        if (JaxoPrefs.getArrayIndex(i) < JaxoPrefs.getNofPrefs()) {
            str = preferences[JaxoPrefs.getArrayIndex(i)];
        }
        return str;
    }

    public static String getStringPref(int i) {
        String str = null;
        if (i >= 0 && i < 100) {
            str = preferences[JaxoPrefs.getArrayIndex(i)];
        }
        return str;
    }

    public static int getIntPref(int i) {
        int jj = -1;
        if (i >= 100 && i < 200) {
            String str = preferences[JaxoPrefs.getArrayIndex(i)];
            Integer jjInt = new Integer(str);
            jj = jjInt;
        }
        return jj;
    }

    public static float getFloatPref(int i) {
        float jj = 0.0f;
        if (i >= 200 && i < 300) {
            String str = preferences[JaxoPrefs.getArrayIndex(i)];
            Float jjFloat = new Float(str);
            jj = jjFloat.floatValue();
        }
        return jj;
    }

    public static boolean getBooleanPref(int i) {
        boolean jj = true;
        if (i >= 300 && i < 400) {
            String str = preferences[JaxoPrefs.getArrayIndex(i)];
            Boolean jjBool = Boolean.valueOf(str);
            jj = jjBool;
        }
        return jj;
    }

    public static void setPref(int i, String str) {
        JaxoPrefs.preferences[JaxoPrefs.getArrayIndex((int)i)] = str;
    }

    public static void setIntPref(int i, int newPref) {
        Integer j = new Integer(newPref);
        JaxoPrefs.preferences[JaxoPrefs.getArrayIndex((int)i)] = j.toString();
    }

    public static void setFloatPref(int i, float newPref) {
        Float j = new Float(newPref);
        JaxoPrefs.preferences[JaxoPrefs.getArrayIndex((int)i)] = j.toString();
    }

    public static void setBooleanPref(int i, boolean newPref) {
        Boolean j = newPref;
        JaxoPrefs.preferences[JaxoPrefs.getArrayIndex((int)i)] = j.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importPrefs(String fileName) {
        int j;
        ResourceBundle lang = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileName));
            Preferences.importPreferences(is);
        }
        catch (FileNotFoundException e) {
            if (JaxoPrefs.verbose()) {
                System.err.println(e);
            }
            JOptionPane.showMessageDialog(null, fileName + lang.getString("_does_not_exist!"));
        }
        catch (InvalidPreferencesFormatException ipfEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ipfEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("Unknown_preferences_file_format!"));
        }
        catch (IOException ioEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ioEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("IOException:_Cannot_open_preferences_file!"));
        }
        finally {
            block26: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block26;
                        System.err.println(ioEx);
                    }
                }
            }
        }
        Preferences pr = Preferences.userRoot().node(JaxoDraw.USER_HOME);
        for (j = 0; j < PREFS.length; ++j) {
            JaxoPrefs.preferences[j] = pr.get(prefKEYS[j], prefDEFAULTS[j]);
        }
        for (j = 0; j < 4; ++j) {
            JaxoPrefs.recentFile[j] = pr.get(recentKEYS[j], recentFile[j]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportPrefs(String fileName) {
        int j;
        ResourceBundle lang = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
        Preferences pr = Preferences.userRoot().node(JaxoDraw.USER_HOME);
        for (j = 0; j < PREFS.length; ++j) {
            pr.put(prefKEYS[j], preferences[j]);
        }
        for (j = 0; j < 4; ++j) {
            pr.put(recentKEYS[j], recentFile[j]);
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(fileName));
            pr.exportNode(os);
        }
        catch (IOException ioEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ioEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("IOException:_Cannot_save_preferences!"));
        }
        catch (BackingStoreException bsEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(bsEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("BackingStoreException:_Cannot_save_preferences!"));
        }
        finally {
            block21: {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block21;
                        System.err.println(ioEx);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRecentFiles() {
        ResourceBundle lang = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
        Preferences pr = Preferences.userRoot().node(JaxoDraw.USER_HOME);
        for (int j = 0; j < 4; ++j) {
            pr.put(recentKEYS[j], recentFile[j]);
        }
        String fileName = HPlotJa.PREFS_FILENAME;
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(fileName));
            pr.exportNode(os);
        }
        catch (IOException ioEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ioEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("IOException:_Cannot_save_preferences!"));
        }
        catch (BackingStoreException bsEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(bsEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("BackingStoreException:_Cannot_save_preferences!"));
        }
        finally {
            block20: {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block20;
                        System.err.println(ioEx);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRecentFiles() {
        ResourceBundle lang = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
        String fileName = HPlotJa.PREFS_FILENAME;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileName));
            Preferences.importPreferences(is);
        }
        catch (FileNotFoundException e) {
            if (JaxoPrefs.verbose()) {
                System.err.println(e);
            }
            JOptionPane.showMessageDialog(null, fileName + lang.getString("_does_not_exist!"));
        }
        catch (InvalidPreferencesFormatException ipfEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ipfEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("Unknown_preferences_file_format!"));
        }
        catch (IOException ioEx) {
            if (JaxoPrefs.verbose()) {
                System.err.println(ioEx);
            }
            JOptionPane.showMessageDialog(null, lang.getString("IOException:_Cannot_open_preferences_file!"));
        }
        finally {
            block25: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block25;
                        System.err.println(ioEx);
                    }
                }
            }
        }
        Preferences pr = Preferences.userRoot().node(JaxoDraw.USER_HOME);
        for (int j = 0; j < 4; ++j) {
            JaxoPrefs.recentFile[j] = pr.get(recentKEYS[j], recentFile[j]);
        }
    }

    public static void setSize(int sizeX, int sizeY) {
        String sx = Integer.toBinaryString(sizeX);
        String sy = Integer.toBinaryString(sizeY);
    }

    private static int getArrayIndex(int i) {
        int k = -1;
        for (int j = 0; j < JaxoPrefs.getNofPrefs(); ++j) {
            if (PREFS[j] != i) continue;
            k = j;
            break;
        }
        return k;
    }
}

