/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoLineOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class JaxoOptionsPanel
extends JPanel
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private String panelTitle = "";
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private Color newColor;
    private int newXin;
    private int newYin;
    private int newXfin;
    private int newYfin;
    private GridBagLayout gbLayout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private Insets insets = new Insets(0, 5, 5, 0);

    @Override
    public final void actionPerformed(ActionEvent evt) {
        JButton cb;
        if (evt.getSource() instanceof JButton && (cb = (JButton)evt.getSource()).getName().equals("colorbt")) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon.setImage(this.getChooserImage(this.newColor));
                cb.setIcon(this.colorPreviewIcon);
            }
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    public final void setPanelIcon(String icon) {
        this.theIcon = new ImageIcon(JaxoLineOptionsPanel.class.getClassLoader().getResource(icon));
    }

    public final Icon getPanelIcon() {
        return this.theIcon;
    }

    public final void setPanelTitle(String title) {
        this.panelTitle = this.language.getString(title);
    }

    public final String getPanelTitle() {
        return this.panelTitle;
    }

    public final void setInsets(int top, int left, int bottom, int right) {
        this.insets.top = top;
        this.insets.left = left;
        this.insets.right = right;
        this.insets.bottom = bottom;
    }

    public final void setColor(Color color) {
        this.newColor = color;
        this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
    }

    public final GridBagLayout getGBLayout() {
        return this.gbLayout;
    }

    public final void setGBLayout(JPanel panel) {
        this.gbLayout.setConstraints(panel, this.gbConstraints);
    }

    public final GridBagConstraints getGBConstraints() {
        return this.gbConstraints;
    }

    public final void setGBConstraints(int gx, int gy) {
        this.gbConstraints.gridx = gx;
        this.gbConstraints.gridy = gy;
        this.gbConstraints.insets = this.insets;
    }

    @Override
    public final Insets getInsets() {
        return this.insets;
    }

    public final Color getColor() {
        return this.newColor;
    }

    public final int getXin() {
        return this.newXin;
    }

    public final int getXfin() {
        return this.newXfin;
    }

    public final int getYin() {
        return this.newYin;
    }

    public final int getYfin() {
        return this.newYfin;
    }

    public final void setXYLineCoord(int x, int y, int relw, int relh) {
        if (relw > 0 && relh >= 0) {
            this.newXin = x;
            this.newYin = y;
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y + Math.abs(relh);
        } else if (relw <= 0 && relh <= 0) {
            this.newXfin = x;
            this.newYfin = y;
            this.newXin = x + Math.abs(relw);
            this.newYin = y + Math.abs(relh);
        } else if (relw > 0 && relh < 0) {
            this.newXin = x;
            this.newYin = y + Math.abs(relh);
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y;
        } else if (relw <= 0 && relh > 0) {
            this.newXfin = x;
            this.newYfin = y + Math.abs(relh);
            this.newXin = x + Math.abs(relw);
            this.newYin = y;
        }
    }

    private JPanel getColorPanel() {
        JButton colorbt = new JButton(this.colorPreviewIcon);
        colorbt.setName("colorbt");
        colorbt.addActionListener(this);
        JPanel colorPanel = new JPanel();
        TitledBorder colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Color"));
        colorPanel.setBorder(colorPanelTitle);
        colorPanel.add(colorbt);
        return colorPanel;
    }

    public final void addColorPanel(int gridx, int gridy) {
        this.setInsets(5, 5, 0, 0);
        this.setGBConstraints(gridx, gridy);
        JPanel colorPanel = this.getColorPanel();
        colorPanel.setPreferredSize(new Dimension(100, 70));
        this.setGBLayout(colorPanel);
        this.add((Component)colorPanel, this.gbConstraints);
    }

    private JPanel getFinalDimSSPanel() {
        SpinnerListener spinnerListener = new SpinnerListener();
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("Xin: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        spxin.addChangeListener(spinnerListener);
        spxin.setName("spxin");
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Yin: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        spyin.addChangeListener(spinnerListener);
        spyin.setName("spyin");
        pyin.add(spyin);
        JPanel pxfin = new JPanel();
        pxfin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXfin = new SpinnerNumberModel(this.newXfin, 0, this.d.width, 1);
        JLabel xfin = new JLabel("Xfin: ", 4);
        pxfin.add(xfin);
        JSpinner spxfin = new JSpinner(modelXfin);
        spxfin.addChangeListener(spinnerListener);
        spxfin.setName("spxfin");
        pxfin.add(spxfin);
        JPanel pyfin = new JPanel();
        pyfin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYfin = new SpinnerNumberModel(this.newYfin, 0, this.d.height, 1);
        JLabel yfin = new JLabel("Yfin: ", 4);
        pyfin.add(yfin);
        JSpinner spyfin = new JSpinner(modelYfin);
        spyfin.addChangeListener(spinnerListener);
        spyfin.setName("spyfin");
        pyfin.add(spyfin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 0, 5);
        pxfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxfin, sc);
        dimSPanel.add((Component)pxfin, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 5);
        pyfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyfin, sc);
        dimSPanel.add((Component)pyfin, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        return finalDimSPanel;
    }

    public final void addFinalDimSPanel(int gridx, int gridy) {
        this.setInsets(0, 0, 5, 5);
        this.setGBConstraints(gridx, gridy);
        JPanel finalDimSPanel = this.getFinalDimSSPanel();
        this.setGBLayout(finalDimSPanel);
        this.add((Component)finalDimSPanel, this.gbConstraints);
    }

    public abstract boolean showPanel();

    class SpinnerListener
    implements ChangeListener {
        SpinnerListener() {
        }

        @Override
        public final void stateChanged(ChangeEvent evt) {
            JSpinner spinner = (JSpinner)evt.getSource();
            SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
            String name = spinner.getName();
            if (name.equals("spxin")) {
                JaxoOptionsPanel.this.newXin = model.getNumber().intValue();
            } else if (name.equals("spyin")) {
                JaxoOptionsPanel.this.newYin = model.getNumber().intValue();
            } else if (name.equals("spxfin")) {
                JaxoOptionsPanel.this.newXfin = model.getNumber().intValue();
            } else if (name.equals("spyfin")) {
                JaxoOptionsPanel.this.newYfin = model.getNumber().intValue();
            }
        }
    }
}

