/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoLatexPackage;
import japlot.jaxodraw.JaxoLooknFeel;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoPrefsPanel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class JaxoOptionsMenu
extends JMenu
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoMainPanel thePanel;
    private JMenu languageM;
    private JMenu vertexM;
    private JMenu axesM;
    private JMenuItem showtoolMI;
    private JMenuItem showeditorMI;
    private JMenuItem showbrowserMI;
    private JMenuItem showStatusMI;
    private JMenuItem antialiasOnMI;
    private JMenuItem gridOnMI;
    private JMenuItem arrowMI;
    private JMenuItem lookAndFeelMI;
    private JMenuItem preferencesMI;
    private JMenu defaultM;
    private JRadioButtonMenuItem englishBT;
    private JRadioButtonMenuItem germanBT;
    private JRadioButtonMenuItem frenchBT;
    private JRadioButtonMenuItem spanishBT;
    private JRadioButtonMenuItem italianBT;
    private JRadioButtonMenuItem type1BT;
    private JRadioButtonMenuItem type2BT;
    private JRadioButtonMenuItem type3BT;
    private JRadioButtonMenuItem type4BT;
    private JRadioButtonMenuItem type5BT;
    private JRadioButtonMenuItem type6BT;
    private ButtonGroup languageGroup;
    private ButtonGroup vertexGroup;
    private ButtonGroup axesGroup;
    private JRadioButtonMenuItem t11;
    private JRadioButtonMenuItem t12;
    private JRadioButtonMenuItem t21;
    private JRadioButtonMenuItem t22;
    private int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private String[] defaults = new String[]{this.language.getString("None"), this.language.getString("Fermion_Line"), this.language.getString("Fermion_Loop"), this.language.getString("Fermion_Arc"), this.language.getString("Scalar_Line"), this.language.getString("Scalar_Loop"), this.language.getString("Scalar_Arc"), this.language.getString("Ghost_Line"), this.language.getString("Ghost_Loop"), this.language.getString("Ghost_Arc"), this.language.getString("Photon_Line"), this.language.getString("Photon_Loop"), this.language.getString("Photon_Arc"), this.language.getString("Gluon_Line"), this.language.getString("Gluon_Loop"), this.language.getString("Gluon_Arc"), this.language.getString("Box"), this.language.getString("Blob"), this.language.getString("Vertex"), this.language.getString("Zigzag"), this.language.getString("Text"), this.language.getString("LaTex"), this.language.getString("Move"), this.language.getString("Resize"), this.language.getString("Copy"), this.language.getString("Color"), this.language.getString("Edit")};
    private String[] defactions = new String[]{"None", "Fermion_Line", "Fermion_Loop", "Fermion_Arc", "Scalar_Line", "Scalar_Loop", "Scalar_Arc", "Ghost_Line", "Ghost_Loop", "Ghost_Arc", "Photon_Line", "Photon_Loop", "Photon_Arc", "Gluon_Line", "Gluon_Loop", "Gluon_Arc", "Box", "Blob", "Vertex", "Zigzag", "Text", "LaTex", "Move", "Resize", "Copy", "Color", "Edit"};
    private int nofdef = 27;
    private JMenuItem[] defMIs = new JMenuItem[this.nofdef];

    public JaxoOptionsMenu(JaxoMainPanel mainPanel) {
        super(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Options"));
        this.thePanel = mainPanel;
        this.lookAndFeelMI = new JMenuItem(this.language.getString("Look_And_Feel"));
        this.add(this.lookAndFeelMI);
        this.lookAndFeelMI.addActionListener(this);
        this.lookAndFeelMI.setAccelerator(KeyStroke.getKeyStroke(76, this.keyMask));
        this.lookAndFeelMI.setActionCommand("Look_And_Feel");
        this.languageM = new JMenu(this.language.getString("Language"));
        this.languageM.addActionListener(this);
        this.setupLanguageMenu();
        this.add(this.languageM);
        this.defaultM = new JMenu(this.language.getString("Default") + ":  " + this.defaults[JaxoPrefs.getIntPref(114)]);
        this.defaultM.addActionListener(this);
        this.setupDefaultMenu();
        this.add(this.defaultM);
        this.addSeparator();
        this.vertexM = new JMenu(this.language.getString("Vertex_types"));
        this.vertexM.addActionListener(this);
        this.setupVertexMenu();
        this.add(this.vertexM);
        this.axesM = new JMenu("Add pads");
        this.axesM.addActionListener(this);
        this.setupAxesMenu();
        this.add(this.axesM);
        this.addSeparator();
        this.showtoolMI = new JMenuItem(this.language.getString("Show_Toolbar"));
        if (JaxoPrefs.getBooleanPref(300)) {
            this.showtoolMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.showtoolMI.setIcon(null);
        }
        this.add(this.showtoolMI);
        this.showtoolMI.addActionListener(this);
        this.showtoolMI.setAccelerator(KeyStroke.getKeyStroke(66, this.keyMask));
        this.showtoolMI.setActionCommand("Show_Toolbar");
        this.showeditorMI = new JMenuItem(this.language.getString("Show_Editor"));
        if (JaxoPrefs.getBooleanPref(305)) {
            this.showeditorMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.showeditorMI.setIcon(null);
        }
        this.add(this.showeditorMI);
        this.showeditorMI.addActionListener(this);
        this.showeditorMI.setAccelerator(KeyStroke.getKeyStroke(69, this.keyMask));
        this.showeditorMI.setActionCommand("Show_Editor");
        this.showbrowserMI = new JMenuItem(this.language.getString("Show_Browser"));
        if (JaxoPrefs.getBooleanPref(306)) {
            this.showbrowserMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.showbrowserMI.setIcon(null);
        }
        this.add(this.showbrowserMI);
        this.showbrowserMI.addActionListener(this);
        this.showbrowserMI.setAccelerator(KeyStroke.getKeyStroke(79, this.keyMask));
        this.showbrowserMI.setActionCommand("Show_Browser");
        this.showStatusMI = new JMenuItem(this.language.getString("Show_Statusbar"));
        if (JaxoPrefs.getBooleanPref(301)) {
            this.showStatusMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.showStatusMI.setIcon(null);
        }
        this.add(this.showStatusMI);
        this.showStatusMI.addActionListener(this);
        this.showStatusMI.setAccelerator(KeyStroke.getKeyStroke(70, this.keyMask));
        this.showStatusMI.setActionCommand("Show_Statusbar");
        this.antialiasOnMI = new JMenuItem(this.language.getString("Antialias_on"));
        if (JaxoPrefs.getBooleanPref(302)) {
            this.showStatusMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.antialiasOnMI.setIcon(null);
        }
        this.add(this.antialiasOnMI);
        this.antialiasOnMI.addActionListener(this);
        this.antialiasOnMI.setActionCommand("Antialias_on");
        this.arrowMI = new JMenuItem(this.language.getString("Arrow"));
        if (JaxoPrefs.getBooleanPref(303)) {
            this.arrowMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.arrowMI.setIcon(null);
        }
        this.add(this.arrowMI);
        this.arrowMI.addActionListener(this);
        this.arrowMI.setActionCommand("Arrow");
        this.gridOnMI = new JMenuItem(this.language.getString("Grid_on"));
        if (JaxoPrefs.getBooleanPref(304)) {
            this.gridOnMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
        } else {
            this.gridOnMI.setIcon(null);
        }
        this.add(this.gridOnMI);
        this.gridOnMI.addActionListener(this);
        this.gridOnMI.setActionCommand("Grid_on");
        this.addSeparator();
        this.preferencesMI = new JMenuItem(this.language.getString("Preferences"));
        this.add(this.preferencesMI);
        this.preferencesMI.addActionListener(this);
        this.preferencesMI.setAccelerator(KeyStroke.getKeyStroke(82, this.keyMask));
        this.preferencesMI.setActionCommand("Preferences");
    }

    private void setupAxesMenu() {
        this.axesGroup = new ButtonGroup();
        this.t11 = new JRadioButtonMenuItem("pad 1x1");
        this.t12 = new JRadioButtonMenuItem("pad 1x2");
        this.t21 = new JRadioButtonMenuItem("pad 2x1");
        this.t22 = new JRadioButtonMenuItem("pad 2x2");
        this.t11.addActionListener(this);
        this.t11.setActionCommand("pad 1x1");
        this.t12.addActionListener(this);
        this.t12.setActionCommand("pad 1x2");
        this.t21.addActionListener(this);
        this.t21.setActionCommand("pad 2x1");
        this.t22.addActionListener(this);
        this.t22.setActionCommand("pad 2x2");
        this.axesGroup.add(this.t11);
        this.axesGroup.add(this.t12);
        this.axesGroup.add(this.t21);
        this.axesGroup.add(this.t22);
        this.axesM.add(this.t11);
        this.axesM.add(this.t12);
        this.axesM.add(this.t21);
        this.axesM.add(this.t22);
    }

    private void setupVertexMenu() {
        this.vertexGroup = new ButtonGroup();
        this.type1BT = new JRadioButtonMenuItem(this.language.getString("Dot"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT1.png")), true);
        this.type1BT.setAccelerator(KeyStroke.getKeyStroke(68, 1));
        this.type2BT = new JRadioButtonMenuItem(this.language.getString("Circle_cross"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT2.png")));
        this.type2BT.setAccelerator(KeyStroke.getKeyStroke(67, 1));
        this.type3BT = new JRadioButtonMenuItem(this.language.getString("Square"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT3.png")));
        this.type3BT.setAccelerator(KeyStroke.getKeyStroke(83, 1));
        this.type4BT = new JRadioButtonMenuItem(this.language.getString("Cross"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT4.png")));
        this.type4BT.setAccelerator(KeyStroke.getKeyStroke(88, 1));
        this.type5BT = new JRadioButtonMenuItem(this.language.getString("Triangle"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT5.png")));
        this.type5BT.setAccelerator(KeyStroke.getKeyStroke(84, 1));
        this.type6BT = new JRadioButtonMenuItem(this.language.getString("Diamond"), new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexsT6.png")));
        this.type6BT.setAccelerator(KeyStroke.getKeyStroke(73, 1));
        this.type1BT.addActionListener(this);
        this.type1BT.setActionCommand("Dot");
        this.type2BT.addActionListener(this);
        this.type2BT.setActionCommand("Circle_cross");
        this.type3BT.addActionListener(this);
        this.type3BT.setActionCommand("Square");
        this.type4BT.addActionListener(this);
        this.type4BT.setActionCommand("Cross");
        this.type5BT.addActionListener(this);
        this.type5BT.setActionCommand("Triangle");
        this.type6BT.addActionListener(this);
        this.type6BT.setActionCommand("Diamond");
        this.vertexGroup.add(this.type1BT);
        this.vertexGroup.add(this.type2BT);
        this.vertexGroup.add(this.type3BT);
        this.vertexGroup.add(this.type4BT);
        this.vertexGroup.add(this.type5BT);
        this.vertexGroup.add(this.type6BT);
        this.vertexM.add(this.type1BT);
        this.vertexM.add(this.type2BT);
        this.vertexM.add(this.type3BT);
        this.vertexM.add(this.type4BT);
        this.vertexM.add(this.type5BT);
        this.vertexM.add(this.type6BT);
    }

    private void setupLanguageMenu() {
        this.languageGroup = new ButtonGroup();
        this.englishBT = new JRadioButtonMenuItem(this.language.getString("English"));
        this.englishBT.addActionListener(this);
        this.englishBT.setActionCommand("English");
        this.englishBT.setAccelerator(KeyStroke.getKeyStroke('e'));
        this.languageGroup.add(this.englishBT);
        this.germanBT = new JRadioButtonMenuItem(this.language.getString("German"));
        this.germanBT.addActionListener(this);
        this.germanBT.setActionCommand("German");
        this.germanBT.setAccelerator(KeyStroke.getKeyStroke('g'));
        this.languageGroup.add(this.germanBT);
        this.frenchBT = new JRadioButtonMenuItem(this.language.getString("French"));
        this.frenchBT.addActionListener(this);
        this.frenchBT.setActionCommand("French");
        this.frenchBT.setAccelerator(KeyStroke.getKeyStroke('f'));
        this.languageGroup.add(this.frenchBT);
        this.spanishBT = new JRadioButtonMenuItem(this.language.getString("Spanish"));
        this.spanishBT.addActionListener(this);
        this.spanishBT.setActionCommand("Spanish");
        this.spanishBT.setAccelerator(KeyStroke.getKeyStroke('s'));
        this.languageGroup.add(this.spanishBT);
        this.italianBT = new JRadioButtonMenuItem(this.language.getString("Italian"));
        this.italianBT.addActionListener(this);
        this.italianBT.setActionCommand("Italian");
        this.italianBT.setAccelerator(KeyStroke.getKeyStroke('i'));
        this.languageGroup.add(this.italianBT);
        this.languageM.add(this.englishBT);
        this.languageM.add(this.germanBT);
        this.languageM.add(this.frenchBT);
        this.languageM.add(this.spanishBT);
        this.languageM.add(this.italianBT);
        if (JaxoPrefs.getPref(4).equals("english")) {
            this.englishBT.setSelected(true);
        } else if (JaxoPrefs.getPref(4).equals("german")) {
            this.germanBT.setSelected(true);
        } else if (JaxoPrefs.getPref(4).equals("french")) {
            this.frenchBT.setSelected(true);
        } else if (JaxoPrefs.getPref(4).equals("spanish")) {
            this.spanishBT.setSelected(true);
        } else if (JaxoPrefs.getPref(4).equals("italian")) {
            this.italianBT.setSelected(true);
        }
    }

    private void setupDefaultMenu() {
        for (int i = 0; i < this.nofdef; ++i) {
            this.defMIs[i] = new JMenuItem(this.defaults[i]);
            this.defMIs[i].addActionListener(this);
            this.defMIs[i].setActionCommand(this.defactions[i]);
            this.defaultM.add(this.defMIs[i]);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        if (source.getActionCommand().equals("Describe")) {
            this.describe();
        } else if (source.getActionCommand().equals("Package")) {
            this.latexPackage();
        } else if (source.getActionCommand().equals("Look_And_Feel")) {
            this.lookNFeel();
        } else if (source.getActionCommand().equals("English")) {
            this.thePanel.setLanguage("english");
        } else if (source.getActionCommand().equals("German")) {
            this.thePanel.setLanguage("german");
        } else if (source.getActionCommand().equals("French")) {
            this.thePanel.setLanguage("french");
        } else if (source.getActionCommand().equals("Spanish")) {
            this.thePanel.setLanguage("spanish");
        } else if (source.getActionCommand().equals("Italian")) {
            this.thePanel.setLanguage("italian");
        } else if (source.getActionCommand().equals("Dot")) {
            this.thePanel.setVertexType(36);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT1.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(36);
        } else if (source.getActionCommand().equals("Circle_cross")) {
            this.thePanel.setVertexType(37);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT2.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(37);
        } else if (source.getActionCommand().equals("Square")) {
            this.thePanel.setVertexType(38);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT3.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(38);
        } else if (source.getActionCommand().equals("Cross")) {
            this.thePanel.setVertexType(39);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT4.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(39);
        } else if (source.getActionCommand().equals("Triangle")) {
            this.thePanel.setVertexType(40);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT5.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(40);
        } else if (source.getActionCommand().equals("Diamond")) {
            this.thePanel.setVertexType(41);
            this.thePanel.getMbtPanel().getVertexButton().setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/vertexT6.png")));
            this.thePanel.getMbtPanel().getVertexButton().doClick();
            this.thePanel.getMbtPanel().updatePop(41);
        } else if (source.getActionCommand().equals("pad 1x1")) {
            this.thePanel.setAxes(1, 1);
        } else if (source.getActionCommand().equals("pad 1x2")) {
            this.thePanel.setAxes(1, 2);
        } else if (source.getActionCommand().equals("pad 2x1")) {
            this.thePanel.setAxes(2, 1);
        } else if (source.getActionCommand().equals("pad 2x2")) {
            this.thePanel.setAxes(2, 2);
        } else if (source.getActionCommand().equals("Show_Toolbar")) {
            if (!JaxoPrefs.getBooleanPref(300)) {
                this.showToolbar(true);
            } else {
                this.showToolbar(false);
            }
        } else if (source.getActionCommand().equals("Show_Editor")) {
            if (!JaxoPrefs.getBooleanPref(305)) {
                this.showEditorbar(true);
            } else {
                this.showEditorbar(false);
            }
        } else if (source.getActionCommand().equals("Show_Browser")) {
            if (!JaxoPrefs.getBooleanPref(306)) {
                this.showBrowserbar(true);
            } else {
                this.showBrowserbar(false);
            }
        } else if (source.getActionCommand().equals("Show_Statusbar")) {
            if (!JaxoPrefs.getBooleanPref(301)) {
                this.showStatusbar(true);
            } else {
                this.showStatusbar(false);
            }
        } else if (source.getActionCommand().equals("Antialias_on")) {
            if (!JaxoPrefs.getBooleanPref(302)) {
                this.antialiasOn(true);
            } else {
                this.antialiasOn(false);
            }
        } else if (source.getActionCommand().equals("Arrow")) {
            if (!JaxoPrefs.getBooleanPref(303)) {
                this.arrow(true);
            } else {
                this.arrow(false);
            }
        } else if (source.getActionCommand().equals("Grid_on")) {
            if (!JaxoPrefs.getBooleanPref(304)) {
                this.gridOn(true);
            } else {
                this.gridOn(false);
            }
        } else if (source.getActionCommand().equals("Preferences")) {
            JaxoPrefsPanel prefDialog = new JaxoPrefsPanel(this.thePanel);
            prefDialog.pack();
            prefDialog.setVisible(true);
        } else {
            for (int i = 0; i < this.nofdef; ++i) {
                if (!source.getActionCommand().equals(this.defactions[i])) continue;
                this.setDefault(i);
            }
        }
    }

    public final void lookNFeel() {
        JaxoLooknFeel laf = new JaxoLooknFeel();
        laf.updateState();
        SwingUtilities.updateComponentTreeUI(this.thePanel);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        super.setText(this.language.getString("Options"));
        this.showtoolMI.setText(this.language.getString("Show_Toolbar"));
        this.showStatusMI.setText(this.language.getString("Show_Statusbar"));
        this.antialiasOnMI.setText(this.language.getString("Antialias_on"));
        this.gridOnMI.setText(this.language.getString("Grid_on"));
        this.arrowMI.setText(this.language.getString("Arrow"));
        this.vertexM.setText(this.language.getString("Vertex_types"));
        this.lookAndFeelMI.setText(this.language.getString("Look_And_Feel"));
        this.languageM.setText(this.language.getString("Language"));
        this.englishBT.setText(this.language.getString("English"));
        this.germanBT.setText(this.language.getString("German"));
        this.frenchBT.setText(this.language.getString("French"));
        this.spanishBT.setText(this.language.getString("Spanish"));
        this.italianBT.setText(this.language.getString("Italian"));
        this.type1BT.setText(this.language.getString("Dot"));
        this.type2BT.setText(this.language.getString("Circle_cross"));
        this.type3BT.setText(this.language.getString("Square"));
        this.type4BT.setText(this.language.getString("Cross"));
        this.type5BT.setText(this.language.getString("Triangle"));
        this.type6BT.setText(this.language.getString("Diamond"));
        this.preferencesMI.setText(this.language.getString("Preferences"));
        this.defaultM.setText(this.language.getString("Default") + ":  " + this.language.getString(this.defactions[JaxoPrefs.getIntPref(114)]));
        for (int i = 0; i < this.nofdef; ++i) {
            this.defMIs[i].setText(this.language.getString(this.defactions[i]));
        }
    }

    public final void showToolbar(boolean show) {
        if (show) {
            this.showtoolMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.showToolbar(true);
        } else {
            this.showtoolMI.setIcon(null);
            this.thePanel.showToolbar(false);
        }
    }

    public final void showEditorbar(boolean show) {
        if (show) {
            this.showeditorMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.showEditorbar(true);
        } else {
            this.showeditorMI.setIcon(null);
            this.thePanel.showEditorbar(false);
        }
    }

    public final void showBrowserbar(boolean show) {
        if (show) {
            this.showbrowserMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.showBrowserbar(true);
        } else {
            this.showbrowserMI.setIcon(null);
            this.thePanel.showBrowserbar(false);
        }
    }

    public final void showStatusbar(boolean show) {
        if (show) {
            this.showStatusMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.showStatusbar(true);
        } else {
            this.showStatusMI.setIcon(null);
            this.thePanel.showStatusbar(false);
        }
    }

    public final void antialiasOn(boolean on) {
        if (on) {
            this.antialiasOnMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.antialiasOn(true);
        } else {
            this.antialiasOnMI.setIcon(null);
            this.thePanel.antialiasOn(false);
        }
    }

    public final void arrow(boolean on) {
        if (on) {
            this.arrowMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.arrow(true);
        } else {
            this.arrowMI.setIcon(null);
            this.thePanel.arrow(false);
        }
    }

    public final void gridOn(boolean on) {
        if (on) {
            this.gridOnMI.setIcon(new ImageIcon(JaxoOptionsMenu.class.getClassLoader().getResource("japlot/jaxodraw/icons/checkmark.png")));
            this.thePanel.gridOn(true);
        } else {
            this.gridOnMI.setIcon(null);
            this.thePanel.gridOn(false);
        }
    }

    public final void describe() {
        String describeText = this.thePanel.getCanvas().getCanvasGraph().getDescription();
        String msg1 = this.language.getString("Please_enter_a_short_description_of_this_Graph.");
        String msg2 = this.language.getString("It_will_appear_as_a_comment_in_all_your_output_files.");
        JTextField textField = new JTextField(describeText, 70);
        Object[] array = new Object[]{msg1, msg2, textField};
        String btn1 = this.language.getString("OK");
        String btn2 = this.language.getString("Cancel");
        Object[] options = new Object[]{btn1, btn2};
        int n = JOptionPane.showOptionDialog(null, array, this.language.getString("Enter_description"), 2, -1, null, options, btn1);
        if (n == 0) {
            describeText = textField.getText();
        }
        this.thePanel.getCanvas().getCanvasGraph().setDescription(describeText);
    }

    public final void latexPackage() {
        ArrayList packageList = this.thePanel.getCanvas().getCanvasGraph().getPackageList();
        JaxoLatexPackage latexPackage = new JaxoLatexPackage(packageList);
        ArrayList newPackageList = latexPackage.getPackageList();
        this.thePanel.getCanvas().getCanvasGraph().setPackageList(newPackageList);
    }

    public final void setPopVT(int popvt) {
        if (popvt == 36) {
            this.type1BT.setSelected(true);
        } else if (popvt == 37) {
            this.type2BT.setSelected(true);
        } else if (popvt == 38) {
            this.type3BT.setSelected(true);
        } else if (popvt == 39) {
            this.type4BT.setSelected(true);
        } else if (popvt == 40) {
            this.type5BT.setSelected(true);
        } else if (popvt == 41) {
            this.type6BT.setSelected(true);
        }
    }

    public final void setDefault(int act) {
        this.defaultM.setText(this.language.getString("Default") + ":  " + this.language.getString(this.defactions[act]));
        if (act != JaxoPrefs.getIntPref(114)) {
            JaxoPrefs.setIntPref(114, act);
        }
    }
}

