/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoPrefs;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class JaxoLooknFeel {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JRadioButton[] lookAndFeelRB;
    private JPanel lafPanel;

    public JaxoLooknFeel() {
        String currentLookAndFeel = UIManager.getLookAndFeel().getName();
        LookAndFeel thisLaF = UIManager.getLookAndFeel();
        ButtonGroup group = new ButtonGroup();
        this.lafPanel = new JPanel(false);
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int num = info.length;
        String[] humanReadableName = new String[num];
        String[] className = new String[num];
        this.lookAndFeelRB = new JRadioButton[num];
        RadioListener myListener = new RadioListener();
        for (int i = 0; i < num; ++i) {
            block5: {
                humanReadableName[i] = info[i].getName();
                className[i] = info[i].getClassName();
                this.lookAndFeelRB[i] = new JRadioButton(humanReadableName[i]);
                try {
                    UIManager.setLookAndFeel(className[i]);
                }
                catch (Exception exc) {
                    this.lookAndFeelRB[i].setEnabled(false);
                }
                try {
                    UIManager.setLookAndFeel(thisLaF);
                }
                catch (Exception exc) {
                    if (!JaxoPrefs.verbose()) break block5;
                    System.err.println(exc);
                }
            }
            this.lafPanel.add(this.lookAndFeelRB[i]);
            group.add(this.lookAndFeelRB[i]);
            this.lookAndFeelRB[i].setActionCommand(humanReadableName[i]);
            this.lookAndFeelRB[i].addActionListener(myListener);
            if (!humanReadableName[i].equals(currentLookAndFeel)) continue;
            this.lookAndFeelRB[i].setSelected(true);
        }
        Object[] optionButtonNames = new String[]{this.language.getString("OK")};
        JOptionPane.showOptionDialog(null, this.lafPanel, this.language.getString("Look_And_Feel"), -1, 1, null, optionButtonNames, optionButtonNames[0]);
    }

    public final void updateState() {
        String lnfName = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int num = info.length;
        for (int i = 0; i < num; ++i) {
            if (!lnfName.equals(info[i].getClassName())) continue;
            this.lookAndFeelRB[i].setSelected(true);
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
            int num = info.length;
            String[] humanReadableName = new String[num];
            String[] className = new String[num];
            String chosen = e.getActionCommand();
            String newLAF = "";
            String newLAFname = "";
            for (int i = 0; i < num; ++i) {
                humanReadableName[i] = info[i].getName();
                className[i] = info[i].getClassName();
                if (!chosen.equals(humanReadableName[i])) continue;
                newLAF = className[i];
                newLAFname = humanReadableName[i];
            }
            try {
                JaxoPrefs.setPref(3, newLAFname);
                UIManager.setLookAndFeel(newLAF);
            }
            catch (Exception exc) {
                JRadioButton button = (JRadioButton)e.getSource();
                button.setEnabled(false);
                JaxoLooknFeel.this.updateState();
                if (JaxoPrefs.verbose()) {
                    System.err.println(exc);
                }
                JOptionPane.showMessageDialog(JaxoLooknFeel.this.lafPanel, newLAFname + JaxoLooknFeel.this.language.getString("_Look_and_Feel_is_not_supported_on_this_platform!"));
            }
        }
    }
}

