/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaLineObject;

public class JaxoLineOptionsPanel
extends JaxoOptionsPanel
implements ItemListener,
ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaLineObject theLine;
    private int type;
    private SpinnerNumberModel modelampin;
    private SpinnerNumberModel modelwigin;
    private SpinnerNumberModel modelsep;
    private SpinnerNumberModel modelstin;
    private SpinnerNumberModel modeldsin;
    private JCheckBox arrowcb;
    private JRadioButton middlerb;
    private JRadioButton endrb;
    private JCheckBox flipcb;
    private JCheckBox symmcb;
    private boolean newFlip;
    private boolean newArrow;
    private boolean newEnd;
    private boolean newSymm;
    private int newWidth;
    private int newHeight;
    private int newRelWidth;
    private int newRelHeight;
    private int newAmp;
    private float newFreq;
    private int newWiggles;
    private float newStroke;
    private float newDash;
    private float newLength;
    private boolean newDLine;
    private float newDLSep;
    private JCheckBox dlcb;
    private JLabel stsep;
    private JSpinner spsep;

    public JaxoLineOptionsPanel(int whichObject) {
        this.type = whichObject;
        this.setLayout(this.getGBLayout());
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.arrowcb) {
            this.newArrow = !this.newArrow;
            this.flipcb.setEnabled(this.newArrow);
            this.middlerb.setEnabled(this.newArrow);
            if (this.type == 3) {
                this.endrb.setEnabled(this.newArrow);
            }
        } else if (source == this.flipcb) {
            this.newFlip = !this.newFlip;
            this.theLine.setInflip(!this.theLine.isInflip());
        } else if (source == this.middlerb) {
            this.newEnd = false;
        } else if (source == this.endrb) {
            this.newEnd = true;
        } else if (source == this.symmcb) {
            this.newSymm = !this.newSymm;
        } else if (source == this.dlcb) {
            this.newDLine = !this.newDLine;
            this.stsep.setEnabled(this.newDLine);
            this.spsep.setEnabled(this.newDLine);
        }
    }

    public final void initParams(JaLineObject line) {
        this.theLine = line;
        this.setColor(this.theLine.getColor());
        this.newArrow = this.theLine.getArrow();
        this.newFlip = this.theLine.getFlip();
        this.newEnd = this.theLine.getEnd();
        this.newWidth = this.theLine.getSize().width;
        this.newHeight = this.theLine.getSize().height;
        this.newRelWidth = this.theLine.getRelSize().width;
        this.newRelHeight = this.theLine.getRelSize().height;
        this.setXYLineCoord(this.theLine.getX(), this.theLine.getY(), this.newRelWidth, this.newRelHeight);
        this.newAmp = this.theLine.getAmp();
        this.newStroke = this.theLine.getStroke();
        this.newDash = this.theLine.getDash();
        this.newLength = (float)Math.sqrt(this.newWidth * this.newWidth + this.newHeight * this.newHeight);
        this.newFreq = this.theLine.getFreq();
        this.newWiggles = (int)(this.newLength / this.newFreq);
        if (this.type == 15) {
            this.newWiggles = (int)((this.newLength / this.newFreq - 1.0f) / 0.6f);
        }
        this.newSymm = this.theLine.getSymm();
        this.newDLine = this.theLine.getDoubleLine();
        this.newDLSep = this.theLine.getDLSeparation();
        if ((double)this.newDLSep < 0.5) {
            this.newDLSep = JaxoPrefs.getFloatPref(201);
        }
    }

    @Override
    public final boolean showPanel() {
        boolean changed = false;
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.getPanelTitle(), 2, 1, this.getPanelIcon(), optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            this.theLine.setArrow(this.newArrow);
            this.theLine.setFlip(this.newFlip);
            Color newColor = this.getColor();
            if (newColor != null) {
                this.theLine.setColor(newColor);
            }
            this.newStroke = Math.abs(this.modelstin.getNumber().floatValue());
            this.newDash = Math.abs(this.modeldsin.getNumber().floatValue());
            if (this.type == 12 || this.type == 33 || this.type == 15) {
                this.newAmp = this.modelampin.getNumber().intValue();
                this.newWiggles = this.modelwigin.getNumber().intValue();
                this.newLength = (float)Math.sqrt(this.newWidth * this.newWidth + this.newHeight * this.newHeight);
                this.newFreq = this.type == 15 ? this.newLength / ((float)this.newWiggles * 0.6f + 1.0f) : this.newLength / (float)this.newWiggles;
            }
            this.theLine.setDoubleLine(this.newDLine);
            this.newDLSep = this.modelsep.getNumber().floatValue();
            this.theLine.setDLSeparation(this.newDLSep);
            this.theLine.setEnd(this.newEnd);
            this.theLine.setDash(this.newDash);
            this.theLine.setStroke(this.newStroke);
            this.theLine.setAmp(this.newAmp);
            this.theLine.setFreq(this.newFreq);
            this.theLine.setSymm(this.newSymm);
            this.setXYRelWAndH(this.getXin(), this.getYin(), this.getXfin(), this.getYfin());
            changed = true;
        }
        return changed;
    }

    private void setXYRelWAndH(int xin, int yin, int xfin, int yfin) {
        int relw = xfin - xin;
        int relh = yfin - yin;
        this.theLine.setRelWAndH(relw, relh);
        if (relw >= 0 && relh >= 0) {
            this.theLine.setLocation(xin, yin);
        } else if (relw >= 0 && relh < 0) {
            this.theLine.setLocation(xin, yfin);
        } else if (relw < 0 && relh >= 0) {
            this.theLine.setLocation(xfin, yin);
        } else if (relw < 0 && relh < 0) {
            this.theLine.setLocation(xfin, yfin);
        }
    }

    private JPanel getLineSymmPanel() {
        this.symmcb = new JCheckBox(this.language.getString("Yes"));
        this.symmcb.setSelected(this.newSymm);
        this.symmcb.addItemListener(this);
        JPanel lineSymmPanel = new JPanel();
        lineSymmPanel.setLayout(new GridLayout(0, 1));
        TitledBorder lineSymmTitle = BorderFactory.createTitledBorder(this.language.getString("Symmetric_?"));
        lineSymmPanel.setBorder(lineSymmTitle);
        lineSymmPanel.add(this.symmcb);
        return lineSymmPanel;
    }

    public final void addLineSymmPanel(int gridx, int gridy) {
        this.setInsets(0, 5, 5, 0);
        this.setGBConstraints(gridx, gridy);
        JPanel lineSymmPanel = this.getLineSymmPanel();
        lineSymmPanel.setPreferredSize(new Dimension(100, 50));
        this.setGBLayout(lineSymmPanel);
        this.add((Component)lineSymmPanel, this.getGBConstraints());
    }

    private JPanel getDlPanel() {
        this.dlcb = new JCheckBox(this.language.getString("Double_line"));
        this.dlcb.setSelected(this.newDLine);
        this.dlcb.addItemListener(this);
        this.modelsep = new SpinnerNumberModel(this.newDLSep, 0.5, 5.0, 0.5);
        this.stsep = new JLabel(this.language.getString("Separation") + ": ");
        this.spsep = new JSpinner(this.modelsep);
        this.stsep.setEnabled(this.newDLine);
        this.spsep.setEnabled(this.newDLine);
        JPanel dlP = new JPanel();
        GridBagLayout subdl = new GridBagLayout();
        GridBagConstraints subcdl = new GridBagConstraints();
        dlP.setLayout(subdl);
        subcdl.gridx = 0;
        subcdl.gridy = 0;
        subdl.setConstraints(this.dlcb, subcdl);
        dlP.add((Component)this.dlcb, subcdl);
        subcdl.gridx = 0;
        subcdl.gridy = 1;
        this.setInsets(5, 0, 5, 0);
        subcdl.insets = this.getInsets();
        subdl.setConstraints(this.stsep, subcdl);
        dlP.add((Component)this.stsep, subcdl);
        subcdl.gridx = 1;
        subcdl.gridy = 1;
        this.setInsets(5, 0, 5, 5);
        subcdl.insets = this.getInsets();
        this.spsep.setPreferredSize(new Dimension(50, 20));
        subdl.setConstraints(this.spsep, subcdl);
        dlP.add((Component)this.spsep, subcdl);
        JPanel dlPanel = new JPanel();
        dlPanel.setLayout(new BoxLayout(dlPanel, 0));
        TitledBorder dlTitle = BorderFactory.createTitledBorder(this.language.getString("Double_line"));
        dlPanel.setBorder(dlTitle);
        dlPanel.add(dlP);
        return dlPanel;
    }

    public final void addDlPanel(int gridx, int gridy) {
        this.setGBConstraints(gridx, gridy);
        JPanel dlPanel = this.getDlPanel();
        this.setGBLayout(dlPanel);
        this.add((Component)dlPanel, this.getGBConstraints());
    }

    private JPanel getLineMiddlePanel() {
        this.middlerb = new JRadioButton(this.language.getString("Middle"));
        this.middlerb.setSelected(!this.newEnd);
        this.middlerb.addItemListener(this);
        this.endrb = new JRadioButton(this.language.getString("End"));
        this.endrb.setSelected(this.newEnd);
        this.endrb.addItemListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.middlerb);
        bg.add(this.endrb);
        JPanel lineMiddlePanel = new JPanel();
        lineMiddlePanel.setLayout(new GridLayout(0, 1));
        TitledBorder lineMiddleTitle = BorderFactory.createTitledBorder(this.language.getString("Arrow_Position"));
        lineMiddlePanel.setBorder(lineMiddleTitle);
        lineMiddlePanel.add(this.middlerb);
        lineMiddlePanel.add(this.endrb);
        this.middlerb.setEnabled(this.newArrow);
        this.endrb.setEnabled(this.newArrow);
        if (this.type == 6 || this.type == 9) {
            this.endrb.setEnabled(false);
        }
        return lineMiddlePanel;
    }

    public final void addLineMiddlePanel(int gridx, int gridy) {
        this.setInsets(0, 5, 5, 0);
        this.setGBConstraints(gridx, gridy);
        JPanel lineMiddlePanel = this.getLineMiddlePanel();
        lineMiddlePanel.setPreferredSize(new Dimension(150, 70));
        this.setGBLayout(lineMiddlePanel);
        this.add((Component)lineMiddlePanel, this.getGBConstraints());
    }

    private JPanel getLineArrowPanel() {
        this.arrowcb = new JCheckBox(this.language.getString("Arrow"));
        this.arrowcb.setSelected(this.theLine.getArrow());
        this.arrowcb.addItemListener(this);
        this.flipcb = new JCheckBox(this.language.getString("Flip"));
        this.flipcb.setSelected(this.theLine.getFlip());
        this.flipcb.addItemListener(this);
        JPanel lineArrowPanel = new JPanel();
        lineArrowPanel.setLayout(new GridLayout(0, 1));
        TitledBorder lineArrowTitle = BorderFactory.createTitledBorder(this.language.getString("Arrow"));
        lineArrowPanel.setBorder(lineArrowTitle);
        lineArrowPanel.add(this.arrowcb);
        lineArrowPanel.add(this.flipcb);
        this.flipcb.setEnabled(this.newArrow);
        return lineArrowPanel;
    }

    public final void addLineArrowPanel(int gridx, int gridy) {
        this.setInsets(0, 5, 5, 0);
        this.setGBConstraints(gridx, gridy);
        JPanel lineArrowPanel = this.getLineArrowPanel();
        lineArrowPanel.setPreferredSize(new Dimension(100, 70));
        this.setGBLayout(lineArrowPanel);
        this.add((Component)lineArrowPanel, this.getGBConstraints());
    }

    private JPanel getFinalAwSPanel() {
        JPanel finalAwSPanel = new JPanel();
        JPanel pampin = new JPanel();
        GridBagLayout subgb2 = new GridBagLayout();
        GridBagConstraints subc2 = new GridBagConstraints();
        pampin.setLayout(subgb2);
        this.modelampin = new SpinnerNumberModel((double)this.newAmp, -500.0, 500.0, 1.0);
        JLabel ampin = new JLabel(this.language.getString("Amplitude"), 4);
        JSpinner spampin = new JSpinner(this.modelampin);
        subc2.gridx = 0;
        subc2.gridy = 0;
        subgb2.setConstraints(ampin, subc2);
        pampin.add((Component)ampin, subc2);
        subc2.gridx = 1;
        subc2.gridy = 0;
        this.setInsets(0, 0, 0, 5);
        subc2.insets = this.getInsets();
        spampin.setPreferredSize(new Dimension(60, 20));
        subgb2.setConstraints(spampin, subc2);
        pampin.add((Component)spampin, subc2);
        JPanel pwigin = new JPanel();
        GridBagLayout subgb3 = new GridBagLayout();
        GridBagConstraints subc3 = new GridBagConstraints();
        pampin.setLayout(subgb3);
        this.modelwigin = new SpinnerNumberModel((double)this.newWiggles, 0.0, 1000.0, 1.0);
        JLabel wigin = new JLabel("  " + this.language.getString("Wiggles"), 4);
        JSpinner spwigin = new JSpinner(this.modelwigin);
        subc3.gridx = 0;
        subc3.gridy = 0;
        this.setInsets(0, 0, 5, 5);
        subc3.insets = this.getInsets();
        subgb3.setConstraints(wigin, subc3);
        pwigin.add((Component)wigin, subc3);
        subc3.gridx = 1;
        subc3.gridy = 0;
        spwigin.setPreferredSize(new Dimension(60, 20));
        subgb3.setConstraints(spwigin, subc3);
        pwigin.add((Component)spwigin, subc3);
        JPanel awSPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints sc2 = new GridBagConstraints();
        awSPanel.setLayout(gb2);
        sc2.gridx = 0;
        sc2.gridy = 0;
        gb2.setConstraints(pampin, sc2);
        awSPanel.add((Component)pampin, sc2);
        sc2.gridx = 0;
        sc2.gridy = 1;
        this.setInsets(0, 0, 5, 5);
        sc2.insets = this.getInsets();
        gb2.setConstraints(pwigin, sc2);
        awSPanel.add((Component)pwigin, sc2);
        finalAwSPanel.setLayout(new BoxLayout(finalAwSPanel, 0));
        TitledBorder awSTitle = BorderFactory.createTitledBorder(this.language.getString("Amplitude/Wiggles"));
        finalAwSPanel.setBorder(awSTitle);
        finalAwSPanel.add(awSPanel);
        return finalAwSPanel;
    }

    public final void addFinalAwSPanel(int gridx, int gridy) {
        this.setInsets(0, 5, 5, 5);
        this.setGBConstraints(gridx, gridy);
        JPanel finalAwSPanel = this.getFinalAwSPanel();
        this.setGBLayout(finalAwSPanel);
        this.add((Component)finalAwSPanel, this.getGBConstraints());
    }

    private JPanel getFinalStrSPanel() {
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        this.modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(this.modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 0, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel pdsin = new JPanel();
        GridBagLayout subgb1 = new GridBagLayout();
        GridBagConstraints subc1 = new GridBagConstraints();
        pdsin.setLayout(subgb);
        this.modeldsin = new SpinnerNumberModel(this.newDash, 0.0, 50.0, 0.2);
        JLabel dsin = new JLabel(" " + this.language.getString("Dash_Size"), 4);
        pdsin.add(dsin);
        JSpinner spdsin = new JSpinner(this.modeldsin);
        subc1.gridx = 0;
        subc1.gridy = 0;
        subc1.insets = new Insets(0, 5, 5, 5);
        subgb1.setConstraints(dsin, subc1);
        pdsin.add((Component)dsin, subc1);
        subc1.gridx = 1;
        subc1.gridy = 0;
        spdsin.setPreferredSize(new Dimension(50, 20));
        subgb1.setConstraints(spdsin, subc1);
        pdsin.add((Component)spdsin, subc1);
        if (this.type == 3 || this.type == 12 || this.type == 15 || this.type == 33) {
            dsin.setEnabled(false);
            spdsin.setEnabled(false);
        }
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        sc1.gridx = 0;
        sc1.gridy = 1;
        sc1.insets = new Insets(5, 0, 0, 0);
        gb1.setConstraints(pdsin, sc1);
        strSPanel.add((Component)pdsin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width/Dashing"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        return finalStrSPanel;
    }

    public final void addFinalStrSPanel(int gridx, int gridy) {
        this.setInsets(5, 0, 0, 5);
        this.setGBConstraints(gridx, gridy);
        JPanel finalStrSPanel = this.getFinalStrSPanel();
        this.setGBLayout(finalStrSPanel);
        this.add((Component)finalStrSPanel, this.getGBConstraints());
    }
}

