/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaLatexText;

public class JaxoLatexTextOptionsPanel
extends JPanel
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private JaLatexText theLatexText;
    private String sText;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private String textStringNames = "LaTeX";
    private JLabel textStringLabels = new JLabel();
    private JTextField textStringFields = new JTextField();
    private JPanel textStringNamesPanel;
    private JPanel textStringFieldsPanel;
    private JPanel textFinalStringPanel;
    private TitledBorder textStringTitle;
    private JButton colorbt;
    private JPanel colorPanel;
    private TitledBorder colorPanelTitle;
    private JComboBox allicomb;
    private JPanel alliPanel;
    private TitledBorder alliPanelTitle;
    private JComboBox fscomb;
    private JPanel fsPanel;
    private TitledBorder fsPanelTitle;
    private Color newColor;
    private Image colorPreview;
    private int newX;
    private int newY;
    private String newTextString;
    private int newAlli;
    private int newLatexFS;
    private boolean changed = false;
    private int newRot;

    public JaxoLatexTextOptionsPanel(JaLatexText latexText) {
        this.theLatexText = latexText;
        this.sText = this.language.getString("LaTeX_text_parameters");
        this.theIcon = new ImageIcon(JaxoLatexTextOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/latex.png"));
        this.newTextString = this.theLatexText.getTextString();
        this.newX = this.theLatexText.getX();
        this.newY = this.theLatexText.getY();
        this.newColor = this.theLatexText.getColor();
        this.newAlli = this.theLatexText.getAllign();
        this.newLatexFS = this.theLatexText.getLatexFS();
        this.newRot = -this.theLatexText.getRotAngle();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.textStringNamesPanel = new JPanel();
        this.textStringNamesPanel.setLayout(new GridLayout(0, 2));
        this.textStringFieldsPanel = new JPanel();
        this.textStringFieldsPanel.setLayout(new GridLayout(1, 0));
        String textStringPar = this.newTextString;
        this.textStringLabels = new JLabel(this.textStringNames + ": ", 4);
        this.textStringNamesPanel.add(this.textStringLabels);
        this.textStringFields = new JTextField(textStringPar);
        this.textStringNamesPanel.add(this.textStringFields);
        this.textFinalStringPanel = new JPanel();
        this.textFinalStringPanel.setLayout(new BorderLayout());
        this.textStringTitle = BorderFactory.createTitledBorder(this.language.getString("Text"));
        this.textFinalStringPanel.setBorder(this.textStringTitle);
        this.textFinalStringPanel.add((Component)this.textStringNamesPanel, "North");
        this.textFinalStringPanel.add((Component)this.textStringFieldsPanel, "South");
        String[] possible = new String[]{this.language.getString("Left-Top"), this.language.getString("Left-Center"), this.language.getString("Left-Bottom"), this.language.getString("Center-Top"), this.language.getString("Center-Center"), this.language.getString("Center-Bottom"), this.language.getString("Right-Top"), this.language.getString("Right-Center"), this.language.getString("Right-Bottom")};
        this.allicomb = new JComboBox<String>(possible);
        this.allicomb.setSelectedIndex(this.newAlli);
        this.allicomb.addActionListener(this);
        this.alliPanel = new JPanel();
        this.alliPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Alignment"));
        this.alliPanel.setBorder(this.alliPanelTitle);
        this.alliPanel.add(this.allicomb);
        String[] allowed = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
        this.fscomb = new JComboBox<String>(allowed);
        this.fscomb.setSelectedIndex(this.newLatexFS);
        this.fscomb.addActionListener(this);
        this.fsPanel = new JPanel();
        this.fsPanelTitle = BorderFactory.createTitledBorder("TeX" + this.language.getString("Font_size"));
        this.fsPanel.setBorder(this.fsPanelTitle);
        this.fsPanel.add(this.fscomb);
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newX, 0, this.d.width, 1);
        JLabel xin = new JLabel("X: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newY, 0, this.d.height, 1);
        JLabel yin = new JLabel("Y: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 0);
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 5);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel protin = new JPanel();
        GridBagLayout subgb1 = new GridBagLayout();
        GridBagConstraints subc1 = new GridBagConstraints();
        protin.setLayout(subgb1);
        SpinnerNumberModel modelrotin = new SpinnerNumberModel(this.newRot, -360, 360, 1);
        JLabel rotin = new JLabel(this.language.getString("Rot._Angle") + ": ", 4);
        JSpinner sprotin = new JSpinner(modelrotin);
        subc1.gridx = 0;
        subc1.gridy = 0;
        subc1.insets = new Insets(0, 5, 5, 5);
        subgb1.setConstraints(rotin, subc1);
        protin.add((Component)rotin, subc1);
        subc1.gridx = 1;
        subc1.gridy = 0;
        sprotin.setPreferredSize(new Dimension(50, 20));
        subgb1.setConstraints(sprotin, subc1);
        protin.add((Component)sprotin, subc1);
        JPanel rotrSPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints sc2 = new GridBagConstraints();
        rotrSPanel.setLayout(gb2);
        sc2.gridx = 0;
        sc2.gridy = 0;
        gb2.setConstraints(protin, sc2);
        rotrSPanel.add((Component)protin, sc2);
        JPanel finalRotrSPanel = new JPanel();
        finalRotrSPanel.setLayout(new BoxLayout(finalRotrSPanel, 0));
        TitledBorder rotrSTitle = BorderFactory.createTitledBorder(this.language.getString("Rotate"));
        finalRotrSPanel.setBorder(rotrSTitle);
        finalRotrSPanel.add(rotrSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Text_color"));
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorPanel.add(this.colorbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 5);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 5);
        gridbag.setConstraints(finalRotrSPanel, c);
        this.add((Component)finalRotrSPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 5);
        this.alliPanel.setPreferredSize(new Dimension(150, 60));
        gridbag.setConstraints(this.alliPanel, c);
        this.add((Component)this.alliPanel, c);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.fsPanel.setPreferredSize(new Dimension(150, 60));
        gridbag.setConstraints(this.fsPanel, c);
        this.add((Component)this.fsPanel, c);
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 0, 0, 5);
        this.textFinalStringPanel.setPreferredSize(new Dimension(260, 50));
        gridbag.setConstraints(this.textFinalStringPanel, c);
        this.add((Component)this.textFinalStringPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sText, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            if (this.newColor != null) {
                this.theLatexText.setColor(this.newColor);
            }
            this.newTextString = this.textStringFields.getText();
            this.theLatexText.setTextString(this.newTextString);
            this.newX = modelXin.getNumber().intValue();
            this.newY = modelYin.getNumber().intValue();
            this.theLatexText.setX(this.newX);
            this.theLatexText.setY(this.newY);
            this.theLatexText.setAllign(this.newAlli);
            this.theLatexText.setLatexFS(this.newLatexFS);
            this.newRot = modelrotin.getNumber().intValue();
            this.theLatexText.setRotAngle(-this.newRot);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        } else if (evt.getSource() == this.allicomb) {
            this.newAlli = this.allicomb.getSelectedIndex();
        } else if (evt.getSource() == this.fscomb) {
            this.newLatexFS = this.fscomb.getSelectedIndex();
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }
}

