/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoAxodraw;
import japlot.jaxodraw.JaxoChooseFile;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoSaveGraph;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaObject;

public final class JaxoIO {
    private JaxoIO() {
    }

    public static void save(JaxoGraph graph, String currentTab) {
        String saveFileName = "";
        if (graph.getSaveFileName().length() == 0) {
            saveFileName = JaxoIO.getSaveFileName(currentTab);
            if (saveFileName.length() != 0) {
                JaxoIO.save(graph, saveFileName, currentTab);
                graph.setSaved(true);
            }
        } else {
            JaxoIO.save(graph, graph.getSaveFileName(), currentTab);
            graph.setSaved(true);
        }
    }

    public static void saveAs(JaxoGraph graph, String currentTab) {
        String saveFileName = JaxoIO.getSaveFileName(currentTab);
        if (saveFileName.length() != 0) {
            JaxoIO.save(graph, saveFileName, currentTab);
            graph.setSaved(true);
        }
    }

    public static void save(JaxoGraph graph, String fileName, String currentTab) {
        if (!fileName.trim().endsWith(".xml")) {
            fileName = fileName.trim() + ".xml";
        }
        graph.setSaveFileName(fileName);
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(fileName)));
            encoder.writeObject(graph.getSaveGraph());
            encoder.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("FileNotFoundException_in_XMLEncoder_!"));
        }
    }

    public static String getSaveFileName(String currentTab) {
        JaxoChooseFile c = new JaxoChooseFile();
        String[] suffix = new String[]{"xml"};
        String saveFileName = c.chooseFile(suffix, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Save"), ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("XML_data_file_(*.xml)"), currentTab);
        if (saveFileName.trim().length() > 0) {
            File testfile;
            if (!saveFileName.trim().endsWith(".xml")) {
                saveFileName = saveFileName.trim() + ".xml";
            }
            if ((testfile = new File(saveFileName)).exists()) {
                String s1 = ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Overwrite");
                String s2 = ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Cancel");
                Object[] options = new Object[]{s1, s2};
                int n = JOptionPane.showOptionDialog(null, saveFileName + " " + ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("_exists!_Overwrite?"), ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Overwrite_Confirmation"), 0, 3, null, options, s1);
                if (n != 0) {
                    saveFileName = "";
                }
            }
        } else {
            saveFileName = "";
        }
        return saveFileName;
    }

    public static JaxoGraph open() {
        JaxoGraph openedGraph = null;
        String openFileName = JaxoIO.getOpenFileName();
        if (openFileName.length() != 0) {
            openedGraph = JaxoIO.open(openFileName);
            openedGraph.setSaved(true);
        }
        return openedGraph;
    }

    public static void opendata() {
        String openFileName = JaxoIO.getOpenFileName();
        if (openFileName.length() != 0) {
            System.out.println("DataFile opened=" + openFileName);
        }
    }

    public static JaxoGraph importLatex() {
        JaxoGraph openedGraph = null;
        String openFileName = JaxoIO.getImportFileName();
        if (openFileName.length() != 0) {
            openedGraph = JaxoIO.importLatex(openFileName);
            openedGraph.setSaved(true);
        }
        return openedGraph;
    }

    public static JaxoGraph open(String fileName) {
        boolean exception;
        JaxoSaveGraph newSaveGraph;
        JaxoGraph openedGraph;
        block3: {
            openedGraph = new JaxoGraph();
            newSaveGraph = new JaxoSaveGraph();
            exception = false;
            try {
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(fileName)));
                newSaveGraph = (JaxoSaveGraph)decoder.readObject();
                decoder.close();
            }
            catch (FileNotFoundException e) {
                exception = true;
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Error:_No_such_file."), "IO error", 1);
                if (!JaxoPrefs.verbose()) break block3;
                System.err.println(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("FileNotFoundException_in_XMLDecoder_!"));
            }
        }
        if (!exception) {
            openedGraph.setSaveGraph(newSaveGraph);
            openedGraph.setSaved(true);
            openedGraph.setSaveFileName(fileName);
            return openedGraph;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JaxoGraph importLatex(String fileName) {
        JaxoGraph openedGraph = new JaxoGraph();
        JaxoSaveGraph newSaveGraph = new JaxoSaveGraph();
        JaxoAxodraw axo = new JaxoAxodraw();
        boolean exception = false;
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(fileName));
            boolean[] isValid = axo.getValid();
            while ((str = in.readLine()) != null) {
                str = str.trim();
                axo.checkRequired(str);
                isValid = axo.getValid();
                if (!isValid[2]) continue;
            }
            newSaveGraph.setPackageList(axo.getPackages());
            isValid = axo.getValid();
            if (!(isValid[0] && isValid[1] && isValid[2])) {
                String missing = "";
                if (!isValid[0]) {
                    missing = "\\documentclass";
                } else if (!isValid[1]) {
                    missing = "\\begin{document}";
                } else if (!isValid[2]) {
                    missing = "\\begin{picture}";
                }
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("The_following_command_was_not_found_in_") + fileName + ":\n" + missing);
            } else {
                while ((str = in.readLine()) != null) {
                    JaObject ob = axo.getJaxoObject(str = str.trim());
                    if (ob == null) continue;
                    newSaveGraph.addObject(ob);
                }
            }
            newSaveGraph.setDescription(axo.getComment());
            in.close();
        }
        catch (IOException e) {
            exception = true;
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Error:_No_such_file."), "IO error", 1);
            if (JaxoPrefs.verbose()) {
                System.err.println(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("FileNotFoundException_in_XMLDecoder_!"));
            }
        }
        finally {
            block24: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block24;
                        System.err.println(ioEx);
                    }
                }
            }
        }
        if (!exception) {
            openedGraph.setSaveGraph(newSaveGraph);
            openedGraph.setSaved(true);
            openedGraph.setSaveFileName(fileName);
            return openedGraph;
        }
        return null;
    }

    public static String getOpenFileName() {
        String openFileName = "";
        String[] suffix = new String[]{"xml"};
        JaxoChooseFile c = new JaxoChooseFile();
        openFileName = c.chooseFile(suffix, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Open"), ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("XML_data_file_(*.xml)"), "");
        return openFileName;
    }

    public static String getImportFileName() {
        String importFileName = "";
        String[] suffix = new String[]{"tex"};
        JaxoChooseFile c = new JaxoChooseFile();
        importFileName = c.chooseFile(suffix, ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Import"), ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("LaTex_file_(*.tex)"), "");
        return importFileName;
    }
}

