/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;

public class JaxoGrid {
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private int gridsize;
    private boolean hexagonal;
    private boolean isEvenRow = true;

    public JaxoGrid(int gs, String hx) {
        this.gridsize = gs;
        this.hexagonal = hx.equals("hexagonal");
    }

    public final int snapX(int x) {
        int snappedX;
        if (this.hexagonal) {
            if (this.isEvenRow) {
                int snappedX1 = -Math.round((float)this.gridsize / 2.0f) + this.gridsize * Math.round((float)x / (float)this.gridsize);
                int snappedX2 = Math.round((float)this.gridsize / 2.0f) + this.gridsize * Math.round((float)x / (float)this.gridsize);
                snappedX = Math.abs(x - snappedX1) < Math.abs(x - snappedX2) ? snappedX1 : snappedX2;
            } else {
                snappedX = this.gridsize * Math.round((float)x / (float)this.gridsize);
            }
        } else {
            snappedX = this.gridsize * Math.round((float)x / (float)this.gridsize);
        }
        return snappedX;
    }

    public final int snapY(int y) {
        int snappedY;
        if (this.hexagonal) {
            double tanfact = Math.tan(Math.toRadians(60.0));
            snappedY = (int)Math.round(tanfact * (double)this.gridsize / 2.0 * (double)Math.round((double)y / (tanfact * (double)this.gridsize / 2.0)));
            this.isEvenRow = (int)(Math.round((double)y / (tanfact * (double)this.gridsize / 2.0)) % 2L) == 1;
        } else {
            snappedY = this.gridsize * Math.round((float)y / (float)this.gridsize);
        }
        return snappedY;
    }

    public final void jaxoDrawGrid(Graphics2D g2) {
        int width = this.d.width;
        int height = this.d.height;
        double tanfact = Math.tan(Math.toRadians(60.0));
        float[] dash = new float[]{1.0f, this.gridsize - 1};
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
        g2.setColor(JaxoColor.GRAYSCALE120);
        int i = 0;
        while (i * this.gridsize < height - 1) {
            if (this.hexagonal) {
                g2.drawLine(0, (int)Math.round((double)i * tanfact * (double)this.gridsize / 2.0), width - 1, (int)Math.round((double)i * tanfact * (double)this.gridsize / 2.0));
                g2.drawLine(-this.gridsize / 2, (int)Math.round((double)(i + 1) * tanfact * (double)this.gridsize / 2.0), width + this.gridsize / 2, (int)Math.round((double)(i + 1) * tanfact * (double)this.gridsize / 2.0));
                ++i;
            } else {
                g2.drawLine(0, i * this.gridsize, width - 1, i * this.gridsize);
            }
            ++i;
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    public final void setGridSize(int gs) {
        this.gridsize = gs;
    }

    public final int getGridSize() {
        return this.gridsize;
    }

    public final void setGridType(boolean hx) {
        this.hexagonal = hx;
    }

    public final boolean getGridType() {
        return this.hexagonal;
    }
}

