/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoExport;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoGroup;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Dimension;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaObject;

public class JaxoExportLatex
extends JaxoExport {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));

    @Override
    public final void export(JaxoGraph newGraph) {
        this.setGraph(newGraph);
        this.checkforPSText();
        String exportFileName = this.getExportFileName();
        if (exportFileName.length() != 0) {
            this.exportLatex(newGraph, exportFileName);
        }
    }

    public final void exportLatex(JaxoGraph graph, String fileName) {
        JaObject ob;
        PrintWriter texFile;
        this.setGraph(graph);
        String defaultColor = "\\SetColor{Black}";
        String defaultWidth = "\\SetWidth{0.5}";
        if (!fileName.trim().endsWith(".tex")) {
            fileName = fileName.trim() + ".tex";
        }
        try {
            texFile = new PrintWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Can't_open_file_") + fileName + "!");
            if (JaxoPrefs.verbose()) {
                System.err.println(e);
            }
            return;
        }
        double[] bBox = graph.getBoundingBox();
        int bBoxWidth = (int)(bBox[2] - bBox[0]);
        int bBoxHeight = (int)(bBox[3] - bBox[1]);
        Dimension bBoxDim = new Dimension(bBoxWidth, bBoxHeight);
        float boxWidth = (float)(bBox[2] - bBox[0]) / 3.0f;
        float boxHeight = (float)(bBox[3] - bBox[1]) / 3.0f;
        float scaleX = boxWidth / 204.92f;
        float scaleY = boxHeight / 291.92f;
        float scaleFactor = scaleX;
        if (scaleY > scaleX) {
            scaleFactor = scaleY;
        }
        if (scaleFactor < 1.0f) {
            scaleFactor = 1.0f;
        }
        this.writeHeader(texFile);
        String comment = graph.getDescription();
        if (comment.length() > 0) {
            comment = " " + comment;
        }
        texFile.println("\\begin{document}\n\n");
        texFile.println("%%JaxoComment:" + comment);
        texFile.println("%%JaxoScale{" + scaleFactor + "}\n\n");
        texFile.println("\\begin{center}");
        texFile.println("\\fcolorbox{white}{white}{");
        texFile.println("  \\begin{picture}(" + (int)((float)bBoxWidth / scaleFactor) + "," + (int)((float)bBoxHeight / scaleFactor) + ") (" + (int)((float)bBox[0] / scaleFactor) + "," + (int)((float)(-bBox[1]) / scaleFactor) + ")");
        ArrayList templist = graph.copyFrom(graph.getObjectList());
        while (this.areGroupObjects(templist)) {
            for (int j = 0; j < templist.size(); ++j) {
                ob = (JaObject)templist.get(j);
                if (!(ob instanceof JaxoGroup)) continue;
                JaxoGroup tempg = (JaxoGroup)ob;
                for (int k = 0; k < tempg.groupObListSize(); ++k) {
                    JaObject tempob = (JaObject)tempg.getObList().get(k);
                    templist.add(j + k + 1, tempob);
                }
                templist.remove(j);
            }
        }
        for (int i = 0; i < templist.size(); ++i) {
            ob = (JaObject)templist.get(i);
            String latexCommand = ob.latexCommand(scaleFactor, bBoxDim);
            String latexColor = JaxoColor.getLatexColorCommand(ob.getColor());
            String latexWidth = ob.latexWidth();
            if (i == 0) {
                if (!(ob instanceof JaLatexText)) {
                    texFile.println("    " + latexWidth);
                } else {
                    texFile.println("    " + defaultWidth);
                }
                texFile.println("    " + latexColor);
                texFile.println("    " + latexCommand);
                defaultColor = latexColor;
                defaultWidth = latexWidth;
                continue;
            }
            if (latexWidth.compareTo(defaultWidth) != 0 && !(ob instanceof JaLatexText)) {
                texFile.println("    " + latexWidth);
                defaultWidth = latexWidth;
            }
            if (latexColor.compareTo(defaultColor) != 0 && !(ob instanceof JaLatexText)) {
                texFile.println("    " + latexColor);
                defaultColor = latexColor;
            }
            texFile.println("    " + latexCommand);
        }
        texFile.println("  \\end{picture}");
        texFile.println("}");
        texFile.println("\\end{center}\n\n");
        texFile.println("\\end{document}");
        texFile.close();
    }

    private boolean areGroupObjects(ArrayList list) {
        boolean thereare = false;
        for (int i = 0; i < list.size(); ++i) {
            JaObject ob = (JaObject)list.get(i);
            if (!(ob instanceof JaxoGroup)) continue;
            thereare = true;
            break;
        }
        return thereare;
    }

    private void writeHeader(PrintWriter texFile) {
        Calendar rightNow = Calendar.getInstance();
        String creationDate = "CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
        JaxoGraph graph = this.getGraph();
        texFile.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        texFile.println("%%%\t\tLaTex file generated by japlot.jaxodraw-1.0");
        texFile.println("%%%\t\t\t" + creationDate);
        texFile.println("%%%\tMake sure you have the axodraw package installed in order to proceed!");
        texFile.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        texFile.println("\\documentclass[a4paper]{article}\n");
        ArrayList packageList = graph.getPackageList();
        for (int j = 0; j < packageList.size(); ++j) {
            texFile.println("\\usepackage{" + packageList.get(j) + "}");
        }
        texFile.println("\\setlength{\\oddsidemargin}{0pt}");
        texFile.println("\\setlength{\\evensidemargin}{0pt}");
        texFile.println("\\setlength{\\topmargin}{0pt}");
        texFile.println("\\setlength{\\headheight}{0pt}");
        texFile.println("\\setlength{\\headsep}{0pt}");
        texFile.println("\\setlength{\\topskip}{0pt}");
        texFile.println("\\setlength{\\footskip}{0pt}");
        texFile.println("\\setlength{\\textwidth}{\\paperwidth}");
        texFile.println("\\addtolength{\\textwidth}{-2in}");
        texFile.println("\\setlength{\\textheight}{\\paperheight}");
        texFile.println("\\addtolength{\\textheight}{-2in}");
        texFile.println("\\pagestyle{empty}\n\n");
    }
}

