/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaObject;

public class JaxoDraw {
    private static ResourceBundle language;
    private ArrayList<JaObject> list;
    private JaxoMainPanel feyn;
    public static final String VERSION_NUMBER = "1.0";
    public static final String VERSION = "japlot.jaxodraw-1.0";
    public static final String WEB_SITE = "http://jaxodraw.sourceforge.net";
    public static final String USER_NAME;
    public static final String USER_HOME;
    public static final String OS_NAME;
    public static final String OS_ARCH;
    public static final String OS_VERSION;
    public static final String JAVA_VERSION;
    public static final String JAVA_RUNTIME_VERSION;
    public static final String JAVA_HOME;
    public static final String JAVA_CLASSPATH;
    public static final String PREFS_FILENAME = ".Jaxorc";
    private static String curDIR;
    protected int N1final;
    protected int N2final;

    public JaxoDraw(String inputFile) {
    }

    public JaxoDraw() {
        this(null);
    }

    public void add(JaObject ob) {
        ob.updateCoor();
        this.list.add(ob);
    }

    public void clear() {
        this.list.clear();
        JaxoGraph firstGraph = new JaxoGraph(this.list);
        this.feyn.setGraph(firstGraph);
    }

    public void update() {
        JaxoGraph firstGraph = new JaxoGraph(this.list);
        this.feyn.setGraph(firstGraph);
        this.feyn.repaintCanvas();
    }

    public static void main(String[] args) {
        String inputFile = JaxoDraw.getCommandLineArgs(args);
        JaxoDraw jd = new JaxoDraw(inputFile);
    }

    public static void getPreferences() {
        String prefFileName = USER_HOME + File.separator + PREFS_FILENAME;
        File prefFile = new File(prefFileName);
        if (prefFile.exists()) {
            JaxoPrefs.importPrefs(prefFileName);
        }
    }

    public int getSizeX() {
        return this.feyn.getSizeX();
    }

    public int getSizeY() {
        return this.feyn.getSizeY();
    }

    private static String getCommandLineArgs(String[] args) {
        String inputFile = "";
        int nofJax = 0;
        if (args.length > 0) {
            if (args[0].startsWith("--")) {
                if (args[0].equals("--version")) {
                    System.out.println(VERSION);
                } else if (args[0].equals("--info")) {
                    JaxoDraw.info();
                } else if (args[0].equals("--help")) {
                    JaxoDraw.help();
                } else {
                    System.out.println(language.getString("Unknown_option:") + args[0]);
                }
                JaxoDraw.shutdown(0);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].endsWith(".xml")) {
                        System.out.println(language.getString("Reading_file") + args[i]);
                        inputFile = args[i];
                        if (nofJax > 0) {
                            System.out.println(language.getString("Warning:_You_can_only_read_one_input_file!"));
                        }
                        ++nofJax;
                        continue;
                    }
                    if (args[i].equals("-verbose")) {
                        JaxoPrefs.setVerbose(true);
                        continue;
                    }
                    if (args[i].equals("-quiet")) {
                        JaxoPrefs.setVerbose(false);
                        continue;
                    }
                    System.out.println(language.getString("Unknown_option:") + args[i]);
                }
            }
        }
        return inputFile;
    }

    public static String getCurDir() {
        return curDIR;
    }

    public static void setCurDir(String newDir) {
        curDIR = newDir;
    }

    public static void shutdown(int status) {
        System.exit(status);
    }

    private static void getUserDir() {
        try {
            curDIR = System.getProperty("user.dir");
        }
        catch (SecurityException aSecurityException) {
            JOptionPane.showMessageDialog(null, language.getString("SecurityException:_Cannot_get_system_properties!"));
            System.err.println(aSecurityException);
        }
    }

    private static void help() {
        System.out.println(language.getString("Start_the_program_with:") + language.getString("jaxodraw_[options]") + language.getString("and_check_the_User_Guide_in_the_Help_menu.") + language.getString("Command_line_options:") + language.getString("--version__prints_out_the_version_number_of_JaxoDraw") + language.getString("--help_____prints_out_this_help") + language.getString("--info_____prints_out_some_information_about_your_system") + language.getString("_-verbose__turns_on_verbose_error_messaging_(default_in_the_current_version)") + language.getString("_-quiet____turns_off_verbose_error_messaging"));
    }

    private static void info() {
        System.out.println(language.getString("OS_name:") + OS_NAME + "\n" + language.getString("OS_architecture:") + OS_ARCH + "\n" + language.getString("OS_version:") + OS_VERSION + "\n" + language.getString("Java_version:") + JAVA_VERSION + "\n" + language.getString("Java_runtime_version:") + JAVA_RUNTIME_VERSION + "\n" + language.getString("Java_home_directory:") + JAVA_HOME + "\n" + language.getString("Java_class_path:") + JAVA_CLASSPATH);
    }

    public void setRangeX(double min, double max) {
    }

    public void setRangeY(double min, double max) {
    }

    static {
        USER_NAME = System.getProperty("user.name");
        USER_HOME = System.getProperty("user.home");
        OS_NAME = System.getProperty("os.name");
        OS_ARCH = System.getProperty("os.arch");
        OS_VERSION = System.getProperty("os.version");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
        JAVA_HOME = System.getProperty("java.home");
        JAVA_CLASSPATH = System.getProperty("java.class.path");
        curDIR = "";
    }
}

