/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhplot.jadraw.JaObject;

public class JaxoColorChooser {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Color newcolor;

    public final Color color(JaObject selectedObject, boolean fCol) {
        final Color oldColor = selectedObject.getColor();
        final JColorChooser tcc = new JColorChooser();
        tcc.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent e) {
            }
        });
        tcc.setColor(selectedObject.getColor());
        JaxoColorPreviewPanel previewPanel = new JaxoColorPreviewPanel(tcc);
        previewPanel.setSize(previewPanel.getPreferredSize());
        tcc.setPreviewPanel(previewPanel);
        ActionListener okListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                JaxoColorChooser.this.newcolor = tcc.getColor();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                JaxoColorChooser.this.newcolor = oldColor;
            }
        };
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[]{new JaxoColorPanel(fCol)};
        tcc.setChooserPanels(panels);
        tcc.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        tcc.setPreferredSize(new Dimension(500, 300));
        boolean bool = true;
        JDialog dialog = JColorChooser.createDialog(null, this.language.getString("Choose_a_Color"), bool, tcc, okListener, cancelListener);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public final void windowClosing(WindowEvent we) {
                JaxoColorChooser.this.newcolor = oldColor;
            }
        });
        dialog.setVisible(true);
        dialog.setEnabled(false);
        dialog.pack();
        return this.newcolor;
    }

    public final Color color(Color color, boolean fCol) {
        final Color oldColor = color;
        final JColorChooser tcc = new JColorChooser();
        tcc.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent e) {
            }
        });
        tcc.setColor(color);
        JaxoColorPreviewPanel previewPanel = new JaxoColorPreviewPanel(tcc);
        previewPanel.setSize(previewPanel.getPreferredSize());
        tcc.setPreviewPanel(previewPanel);
        ActionListener okListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                JaxoColorChooser.this.newcolor = tcc.getColor();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                JaxoColorChooser.this.newcolor = oldColor;
            }
        };
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[]{new JaxoColorPanel(fCol)};
        tcc.setChooserPanels(panels);
        tcc.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        tcc.setPreferredSize(new Dimension(500, 300));
        boolean bool = true;
        JDialog dialog = JColorChooser.createDialog(null, this.language.getString("Choose_a_Color"), bool, tcc, okListener, cancelListener);
        dialog.setVisible(true);
        dialog.setEnabled(false);
        dialog.pack();
        return this.newcolor;
    }

    class JaxoColorPreviewPanel
    extends JComponent {
        private Color curColor;

        public JaxoColorPreviewPanel(JColorChooser chooser) {
            this.curColor = chooser.getColor();
            ColorSelectionModel model = chooser.getSelectionModel();
            model.addChangeListener(new ChangeListener(){

                @Override
                public final void stateChanged(ChangeEvent evt) {
                    ColorSelectionModel newModel = (ColorSelectionModel)evt.getSource();
                    JaxoColorPreviewPanel.this.curColor = newModel.getSelectedColor();
                }
            });
            this.setPreferredSize(new Dimension(500, 20));
        }

        @Override
        public final void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.curColor);
            g2.setFont(new Font("SansSerif", 1, 24));
            if (JaxoPrefs.getBooleanPref(302)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            String base = JaxoColorChooser.this.language.getString("_This_color_is:_");
            String colorName = JaxoColorChooser.this.language.getString(JaxoColor.getColorName(this.curColor));
            g2.drawString(base + colorName, 20, 30);
        }
    }

    class JaxoColorPanel
    extends AbstractColorChooserPanel {
        private int noC;
        private JToggleButton[] jaxButton;

        public JaxoColorPanel(boolean fillColor) {
            if (fillColor) {
                this.noC = JaxoColor.getNofColors();
                this.jaxButton = new JToggleButton[this.noC];
            } else {
                this.noC = JaxoColor.getIndex(JaxoColor.GRAYSCALE15);
                this.jaxButton = new JToggleButton[this.noC + 1];
            }
        }

        @Override
        public final void updateChooser() {
            Color color = this.getColorFromModel();
            for (int i = 0; i < this.noC; ++i) {
                if (!color.equals(JaxoColor.getColor(i))) continue;
                this.jaxButton[i].setSelected(true);
            }
        }

        public final Image getChooserImage(Color iconColor) {
            int width = 25;
            int height = 25;
            int size = width * height;
            int[] pixels = new int[size];
            for (int i = 0; i < size; ++i) {
                pixels[i] = iconColor.getRGB();
            }
            MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
            Image jaxColorBox = this.createImage(source);
            return jaxColorBox;
        }

        @Override
        protected void buildChooser() {
            this.setLayout(new GridLayout(7, 12));
            JaxoColorListener jcl = new JaxoColorListener();
            ButtonGroup boxOfJaxoColors = new ButtonGroup();
            Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
            if (this.noC == JaxoColor.getIndex(JaxoColor.GRAYSCALE15)) {
                for (int i = 0; i < this.noC; ++i) {
                    Image jaxBox = this.getChooserImage(JaxoColor.getColor(i));
                    String colorName = JaxoColorChooser.this.language.getString(JaxoColor.getColorName(JaxoColor.getColor(i)));
                    this.jaxButton[i] = new JToggleButton(new ImageIcon(jaxBox));
                    this.jaxButton[i].setActionCommand(JaxoColor.getColorName(i));
                    this.jaxButton[i].addActionListener(jcl);
                    this.jaxButton[i].setBorder(border);
                    this.jaxButton[i].setToolTipText(colorName);
                    boxOfJaxoColors.add(this.jaxButton[i]);
                    this.add(this.jaxButton[i]);
                }
                Image jaxBox = this.getChooserImage(JaxoColor.WHITE);
                String colorName = JaxoColorChooser.this.language.getString(JaxoColor.getColorName(JaxoColor.WHITE));
                this.jaxButton[this.noC] = new JToggleButton(new ImageIcon(jaxBox));
                this.jaxButton[this.noC].setActionCommand(JaxoColor.getColorName(JaxoColor.WHITE));
                this.jaxButton[this.noC].addActionListener(jcl);
                this.jaxButton[this.noC].setBorder(border);
                this.jaxButton[this.noC].setToolTipText(colorName);
                boxOfJaxoColors.add(this.jaxButton[this.noC]);
                this.add(this.jaxButton[this.noC]);
            } else {
                for (int i = 0; i < this.noC; ++i) {
                    Image jaxBox = this.getChooserImage(JaxoColor.getColor(i));
                    String colorName = JaxoColorChooser.this.language.getString(JaxoColor.getColorName(JaxoColor.getColor(i)));
                    this.jaxButton[i] = new JToggleButton(new ImageIcon(jaxBox));
                    this.jaxButton[i].setActionCommand(JaxoColor.getColorName(i));
                    this.jaxButton[i].addActionListener(jcl);
                    this.jaxButton[i].setBorder(border);
                    this.jaxButton[i].setToolTipText(colorName);
                    boxOfJaxoColors.add(this.jaxButton[i]);
                    this.add(this.jaxButton[i]);
                }
            }
        }

        @Override
        public final String getDisplayName() {
            return JaxoColorChooser.this.language.getString("JaxoColors");
        }

        @Override
        public final Icon getSmallDisplayIcon() {
            return null;
        }

        @Override
        public final Icon getLargeDisplayIcon() {
            return null;
        }

        class JaxoColorListener
        implements ActionListener {
            JaxoColorListener() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                Color newColor = null;
                JToggleButton source = (JToggleButton)e.getSource();
                if (JaxoColorPanel.this.noC == JaxoColor.getIndex(JaxoColor.GRAYSCALE15)) {
                    for (int i = 0; i < JaxoColorPanel.this.noC; ++i) {
                        if (!source.getActionCommand().equals(JaxoColor.getColorName(i))) continue;
                        newColor = JaxoColor.getColor(i);
                    }
                    if (source.getActionCommand().equals(JaxoColor.getColorName(JaxoColor.WHITE))) {
                        newColor = JaxoColor.WHITE;
                    }
                } else {
                    for (int i = 0; i < JaxoColorPanel.this.noC; ++i) {
                        if (!source.getActionCommand().equals(JaxoColor.getColorName(i))) continue;
                        newColor = JaxoColor.getColor(i);
                    }
                }
                JaxoColorPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        }
    }
}

