/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.DataBrowser;
import japlot.Global;
import japlot.Plot;
import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoGrid;
import japlot.jaxodraw.JaxoGroup;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoRescalePanel;
import japlot.jaxodraw.JaxoStaticCanvasMethods;
import japlot.jaxodraw.JaxoZoom;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jhplot.jadraw.JaArcObject;
import jhplot.jadraw.JaAxes;
import jhplot.jadraw.JaFLine;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaGLine;
import jhplot.jadraw.JaGlLine;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaLineObject;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaSLine;
import jhplot.jadraw.JaText;
import jhplot.jadraw.JaVertexT5;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static final int HANDLE_UL = 0;
    public static final int HANDLE_LL = 1;
    public static final int HANDLE_LR = 2;
    public static final int HANDLE_UR = 3;
    public static Color BCKG_COLOR = Color.white;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoMainPanel thePanel;
    private JaxoGraph canvasGraph;
    private String canvasTick = ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Untitled");
    private Image offScreenImage;
    private Image backupImage;
    private JaxoGrid grid = new JaxoGrid(JaxoPrefs.getIntPref(102), JaxoPrefs.getPref(5));
    private int xin;
    private int yin;
    private int lastX;
    private int lastY;
    private int startX;
    private int startY;
    private int curDragMode;
    private int curHandle;
    private int fboxX;
    private int fboxY;
    private boolean fboxON = false;
    private boolean isUsed = false;
    private DecimalFormat form = new DecimalFormat("#.##");
    private boolean withHandles;
    private boolean withVisualAid;
    private double[] oldbb;
    private int nofclicks = 0;
    private int archand = 0;
    private int[] points = new int[6];
    private int evX;
    private int evY;
    private boolean pointsON;
    private static boolean start = false;
    private static double startUSERx = 0.0;
    private static double startUSERy = 0.0;
    private static int zoomPADx = -1;
    private static int zoomPADy = -1;
    private static String padInfo = "pad[1,1]";
    private static int padX = -1;
    private static int padY = -1;
    private VectorGraphics g2;
    private static JaAxes jaxes = null;
    protected JPopupMenu menu;
    public JMenuItem m_info;
    public JMenuItem m_data;
    public JMenuItem m_axes;
    public JMenuItem m_refresh;
    public JMenuItem m_clear;

    public JaxoCanvas(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        this.setBackground(JaxoColor.WHITE);
        int prefSCREENSIZEX = JaxoPrefs.getIntPref(100);
        int prefSCREENSIZEY = JaxoPrefs.getIntPref(101);
        this.setPreferredSize(new Dimension(prefSCREENSIZEX, prefSCREENSIZEY));
        this.addComponentListener(this);
        this.menu = new JPopupMenu();
        this.m_info = new JMenuItem(padInfo);
        this.m_info.setEnabled(false);
        this.m_info.setForeground(Color.blue);
        this.m_axes = new JMenuItem("Edit axes");
        this.m_data = new JMenuItem("Edit data");
        this.m_refresh = new JMenuItem("Refresh");
        this.m_clear = new JMenuItem("Clear");
        this.m_refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JaxoCanvas.this.thePanel.update();
            }
        });
        this.m_axes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean ischanged;
                if (jaxes != null && (ischanged = jaxes.editPanel())) {
                    JaxoCanvas.this.thePanel.update();
                }
            }
        });
        this.m_data.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (jaxes != null) {
                    DataBrowser db = new DataBrowser(jaxes, JaxoCanvas.this.thePanel);
                    db.showIt(true);
                }
            }
        });
        this.m_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (padX > -1 && padY > -1) {
                    JaxoCanvas.this.thePanel.clearData(padX, padY);
                    JaxoCanvas.this.thePanel.update();
                }
            }
        });
        this.menu.add(this.m_info);
        this.menu.addSeparator();
        this.menu.add(this.m_axes);
        this.menu.add(this.m_data);
        this.menu.add(this.m_refresh);
        this.menu.add(this.m_clear);
    }

    public final void setCanvasGraph(JaxoGraph theGraph) {
        this.canvasGraph = theGraph;
    }

    public final JaxoGraph getCanvasGraph() {
        return this.canvasGraph;
    }

    public final void setCanvasTick(String theTick) {
        this.canvasTick = theTick;
    }

    public final String getCanvasTick() {
        return this.canvasTick;
    }

    public final int getDragMode() {
        return this.curDragMode;
    }

    public final void setDragMode(int newDragMode) {
        this.curDragMode = newDragMode;
    }

    public final double[] getOldbb() {
        return this.oldbb;
    }

    public final void setOldbb(double[] bb) {
        this.oldbb = bb;
    }

    @Override
    public final void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public final void paintComponent(Graphics g) {
        JaObject selectedOb;
        JaObject ob;
        this.g2 = VectorGraphics.create((Graphics)g);
        this.createBackground();
        this.createScreen();
        this.g2.clipRect(0, 0, this.getWidth(), this.getHeight());
        int mouseMode = this.getDragMode();
        if ((mouseMode == 50 || mouseMode == 51) && (ob = this.canvasGraph.getSelectedObject()) != null) {
            if (Plot.drawFirst(ob)) {
                ob.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(ob, this.g2, true);
        }
        if (this.withVisualAid && (selectedOb = this.canvasGraph.getSelectedObject()) != null) {
            selectedOb.drawVisualAid(this.g2);
        }
        if (this.withHandles) {
            this.canvasGraph.drawHandles(this.g2);
        }
        if (this.thePanel.getMode() == 59) {
            this.canvasGraph.drawGroupHandles(this.g2);
        }
        if (this.fboxON) {
            this.drawFaintBox(this.g2);
        }
        if (this.pointsON) {
            this.drawPointsAid(this.g2);
        }
        this.g2.setClip(null);
    }

    public final Image getOffScreenImage() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.offScreenImage = this.createImage(d.width, d.height);
        return this.offScreenImage;
    }

    private void createOffScreenImage() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.g2 == null) {
            return;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JaxoGraph actCanGraph = this.getCanvasGraph();
        for (int i = 0; i < actCanGraph.listSize(); ++i) {
            JaObject jaxoOb = actCanGraph.listElementAt(i);
            if (Plot.drawFirst(jaxoOb)) {
                jaxoOb.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(jaxoOb, this.g2, true);
        }
    }

    private void createScreen() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.g2 == null) {
            return;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JaxoGraph actCanGraph = this.getCanvasGraph();
        for (int i = 0; i < actCanGraph.listSize(); ++i) {
            JaObject jaxoOb = actCanGraph.listElementAt(i);
            if (Plot.drawFirst(jaxoOb)) {
                jaxoOb.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(jaxoOb, this.g2, true);
        }
    }

    public void setBackgroundBox(Color c) {
        BCKG_COLOR = c;
    }

    public Color getBackgroundBox() {
        return BCKG_COLOR;
    }

    private void createBackground() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, d.width, d.height);
        this.g2.setPaint((Paint)BCKG_COLOR);
        this.g2.fill((Shape)rect);
        this.g2.setColor(Color.black);
        if (JaxoPrefs.getBooleanPref(304)) {
            this.grid.jaxoDrawGrid((Graphics2D)this.g2);
        }
    }

    public final void dispose() {
        this.clearOffScreenImage();
        if (this.g2 == null) {
            return;
        }
        this.g2.dispose();
    }

    public final void saveBackupImage() {
        if (this.g2 == null) {
            this.createBackground();
        }
    }

    public final void swapImages() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Image tmpImage = this.createImage(d.width, d.height);
        tmpImage.getGraphics().drawImage(this.offScreenImage, 0, 0, null);
        this.offScreenImage.getGraphics().drawImage(this.backupImage, 0, 0, null);
        this.backupImage.getGraphics().drawImage(tmpImage, 0, 0, null);
        tmpImage.flush();
    }

    public final void clearOffScreenImage() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.g2 == null) {
            return;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(BCKG_COLOR);
        this.g2.fillRect(0, 0, d.width, d.height);
        this.g2.setColor(Color.black);
        if (JaxoPrefs.getBooleanPref(304)) {
            this.grid.jaxoDrawGrid((Graphics2D)this.g2);
        }
        this.g2.dispose();
    }

    public final void updateOffScreenImage() {
        if (this.g2 == null) {
            return;
        }
        if (JaxoPrefs.getBooleanPref(302)) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.g2.setClip((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        this.g2.setColor(BCKG_COLOR);
        this.g2.fillRect((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        if (JaxoPrefs.getBooleanPref(304)) {
            this.grid.jaxoDrawGrid((Graphics2D)this.g2);
        }
        Rectangle oldrect = new Rectangle((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            double[] bb = jaxoOb.getBoundingBox();
            Rectangle rectOb = new Rectangle((int)bb[0] - 5, (int)bb[1] - 5, (int)(bb[2] - bb[0]) + 10, (int)(bb[3] - bb[1]) + 10);
            if (!rectOb.intersects(oldrect)) continue;
            this.g2.setClip((int)bb[0] - 5, (int)bb[1] - 5, (int)(bb[2] - bb[0]) + 10, (int)(bb[3] - bb[1]) + 10);
            if (Plot.drawFirst(jaxoOb)) {
                jaxoOb.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(jaxoOb, this.g2, true);
        }
        this.repaint();
        this.g2.dispose();
    }

    public final void updateOffScreenImage(JaObject selectedOb) {
        if (this.g2 == null) {
            return;
        }
        if (JaxoPrefs.getBooleanPref(302)) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.g2.setClip((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        this.g2.setColor(BCKG_COLOR);
        this.g2.fillRect((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        if (JaxoPrefs.getBooleanPref(304)) {
            this.grid.jaxoDrawGrid((Graphics2D)this.g2);
        }
        Rectangle oldrect = new Rectangle((int)this.oldbb[0] - 5, (int)this.oldbb[1] - 5, (int)(this.oldbb[2] - this.oldbb[0]) + 10, (int)(this.oldbb[3] - this.oldbb[1]) + 10);
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            double[] bb;
            Rectangle rectOb;
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            if (jaxoOb == selectedOb || !(rectOb = new Rectangle((int)(bb = jaxoOb.getBoundingBox())[0] - 5, (int)bb[1] - 5, (int)(bb[2] - bb[0]) + 10, (int)(bb[3] - bb[1]) + 10)).intersects(oldrect)) continue;
            this.g2.setClip((int)bb[0] - 5, (int)bb[1] - 5, (int)(bb[2] - bb[0]) + 10, (int)(bb[3] - bb[1]) + 10);
            if (Plot.drawFirst(jaxoOb)) {
                jaxoOb.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(jaxoOb, this.g2, true);
        }
        this.repaint();
        this.g2.dispose();
    }

    private void selectObjectsToGroup(MouseEvent e) {
        this.lastY = e.getY();
        this.lastX = e.getX();
        JaObject newSelectedOb = null;
        int i = this.canvasGraph.listSize();
        while (newSelectedOb == null && i >= 1) {
            JaObject curOb;
            if ((curOb = this.canvasGraph.listElementAt(--i)) == null) continue;
            int grabStatus = curOb.getGrabbedHandle(this.lastX, this.lastY, 50);
            if (grabStatus != 0) {
                newSelectedOb.setAsMarked(!(newSelectedOb = curOb).isMarked());
                this.repaint();
                this.canvasGraph.setSelectedObject(curOb);
            }
            this.setStartCoordinates();
        }
    }

    private void selectObject(MouseEvent e, int editmode) {
        this.lastY = e.getY();
        this.lastX = e.getX();
        JaObject newSelectedOb = null;
        int i = this.canvasGraph.listSize();
        while (newSelectedOb == null && i >= 1) {
            int grabStatus;
            JaObject curOb;
            if ((curOb = this.canvasGraph.listElementAt(--i)) == null || (grabStatus = curOb.getGrabbedHandle(this.lastX, this.lastY, editmode)) == 0) continue;
            newSelectedOb = curOb;
            this.canvasGraph.setSelectedObject(curOb);
            if (grabStatus == 11) {
                this.setDragMode(50);
            } else if (grabStatus == 12) {
                this.setDragMode(51);
                this.curHandle = 0;
            } else if (grabStatus == 13) {
                this.setDragMode(51);
                this.curHandle = 3;
            } else if (grabStatus == 14) {
                this.setDragMode(51);
                this.curHandle = 2;
            } else if (grabStatus == 15) {
                this.setDragMode(51);
                this.curHandle = 1;
            } else {
                this.archand = grabStatus;
                this.setDragMode(51);
            }
            this.setStartCoordinates();
        }
        this.saveBackupImage();
        this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
        this.canvasGraph.setBackupSelectedObject(this.canvasGraph.getSelectedObject());
        this.canvasGraph.setSelectedObject(newSelectedOb);
        this.lastY = e.getY();
        this.lastX = e.getX();
    }

    private void setStartCoordinates() {
        JaObject selectedOb = this.canvasGraph.getSelectedObject();
        if (selectedOb == null) {
            return;
        }
        Dimension d = selectedOb.getSize();
        int handle = this.curHandle;
        this.startY = selectedOb.getY();
        this.startX = selectedOb.getX();
        if (handle == 3 || handle == 0) {
            this.startY += d.height;
        }
        if (handle == 1 || handle == 0) {
            this.startX += d.width;
        }
    }

    public final void showCoordinates(MouseEvent e) {
        this.evX = e.getX();
        this.evY = e.getY();
        padX = -1;
        padY = -1;
        String ss1 = this.form.format(Global.toX(this.evX));
        String ss2 = this.form.format(Global.toY(this.evY));
        String ss3 = padInfo;
        String mess = "NDC(" + ss1 + "," + ss2 + ")";
        this.thePanel.setFlagPanelCoordinates(mess);
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            if (jaxoOb instanceof JaAxes && this.evX > jaxoOb.getX() && this.evX < jaxoOb.getX() + jaxoOb.getRelw() && this.evY > jaxoOb.getY() && this.evY < jaxoOb.getY() + jaxoOb.getRelh()) {
                jaxes = (JaAxes)jaxoOb;
                padX = jaxes.getPad(0) + 1;
                padY = jaxes.getPad(1) + 1;
                ss1 = this.form.format(jaxes.toUserX(this.evX));
                ss2 = this.form.format(jaxes.toUserY(this.evY));
                padInfo = ss3 = "pad[" + Integer.toString(padX) + "," + Integer.toString(padY) + "]";
                this.m_info.setText(ss3);
                mess = mess + " on " + ss3;
                mess = mess + "  USER(" + ss1 + " , " + ss2 + ")";
                this.thePanel.setFlagPanelCoordinates(mess);
            }
            if (!(jaxoOb instanceof JaLatexText)) continue;
            if (((JaLatexText)jaxoOb).isRolledOver(e.getX(), e.getY())) {
                ((JaLatexText)jaxoOb).getLatexPanel().setVisible(true);
                continue;
            }
            ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        int currentMode = this.thePanel.getMode();
        if ((e.getModifiers() & 8) != 0 && currentMode == 58) {
            this.canvasGraph.setAsMarked(false);
            this.repaint();
        }
        if ((e.getModifiers() & 4) != 0 && currentMode == 58) {
            Vector groupObjects = this.buildGroupList();
            if (groupObjects.size() > 1) {
                this.saveBackupImage();
                this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                double[] groupBounds = this.getGroupBounds(groupObjects);
                JaxoGroup newGroup = new JaxoGroup();
                newGroup.setObList(groupObjects);
                newGroup.setX((int)groupBounds[0]);
                newGroup.setY((int)groupBounds[1]);
                newGroup.setRelw((int)Math.round(groupBounds[2] - groupBounds[0]));
                newGroup.setRelh((int)Math.round(groupBounds[3] - groupBounds[1]));
                newGroup.setAvailableFonts(JaxoStaticCanvasMethods.getSystemFonts());
                this.removeFromGraph(groupObjects);
                JaxoGroup newob = newGroup;
                this.canvasGraph.setBackupSelectedObject(newob);
                this.canvasGraph.addObject(newob);
                this.canvasGraph.setSelectedObject(newob);
                this.setDragMode(0);
                this.withHandles = true;
                this.withVisualAid = false;
                this.repaint();
                this.curHandle = 2;
                this.setStartCoordinates();
                this.oldbb = newGroup.getBoundingBox();
                this.lastY = e.getY();
                this.lastX = e.getX();
            }
            this.setDefaultAction();
        }
        if ((e.getModifiers() & 0x10) != 0 && this.fboxON || (e.getModifiers() & 4) != 0 && this.fboxON) {
            this.fboxON = false;
            this.thePanel.getClipboard().clear();
            this.canvasGraph.setAsMarked(false);
        }
        if ((e.getModifiers() & 0x10) != 0 && !this.fboxON) {
            JaObject selectedOb;
            JaObject ob;
            if (currentMode == 0) {
                return;
            }
            if (currentMode == 58) {
                this.selectObjectsToGroup(e);
                this.setDragMode(0);
            } else if (currentMode == 59) {
                this.selectObject(e, 50);
                ob = this.canvasGraph.getSelectedObject();
                if (ob != null && ob instanceof JaxoGroup) {
                    JaxoGroup tempg = (JaxoGroup)ob;
                    for (int i = 0; i < tempg.groupObListSize(); ++i) {
                        JaObject tempob = (JaObject)tempg.getObList().elementAt(i);
                        tempob.setAsMarked(false);
                        this.canvasGraph.addObject(tempob);
                    }
                    this.canvasGraph.delete(tempg);
                }
                for (int j = 0; j < this.canvasGraph.listSize(); ++j) {
                    JaObject jaxoOb = this.canvasGraph.listElementAt(j);
                    if (!(jaxoOb instanceof JaLatexText)) continue;
                    ((JaLatexText)jaxoOb).createLatexPanel();
                    this.add(((JaLatexText)jaxoOb).getLatexPanel());
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
                }
                this.withHandles = false;
                this.unsavedCanvas();
                this.setDefaultAction();
                this.repaint();
            } else if (currentMode == 50) {
                selectedOb = this.canvasGraph.getSelectedObject();
                if (selectedOb != null) {
                    this.oldbb = selectedOb.getBoundingBox();
                }
            } else if (currentMode == 51) {
                this.selectObject(e, 50);
                ob = this.canvasGraph.getSelectedObject();
                if (ob != null && ob instanceof JaxoGroup) {
                    JaxoRescalePanel rescalep = new JaxoRescalePanel((JaxoGroup)ob);
                    this.oldbb = ((JaxoGroup)ob).getBoundingBox();
                    this.updateOffScreenImage();
                    this.oldbb = ((JaxoGroup)ob).getBoundingBox();
                    this.updateOffScreenImage();
                    if (rescalep.hasChanged()) {
                        this.unsavedCanvas();
                    }
                }
            } else if (currentMode == 52) {
                this.selectObject(e, currentMode);
            } else if (currentMode == 53) {
                this.selectObject(e, 52);
                selectedOb = this.canvasGraph.getSelectedObject();
                if (selectedOb != null) {
                    this.showColorChooser(selectedOb);
                }
            } else if (currentMode == 55) {
                this.selectObject(e, 50);
                ob = this.canvasGraph.getSelectedObject();
                this.saveBackupImage();
                this.canvasGraph.setBackupSelectedObject(ob);
                this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                if (ob != null) {
                    this.oldbb = this.canvasGraph.getSelectedObject().getBoundingBox();
                    this.canvasGraph.delete(ob);
                    this.updateOffScreenImage();
                    if (ob instanceof JaLatexText) {
                        ((JaLatexText)ob).getLatexPanel().setVisible(false);
                    }
                }
                this.unsavedCanvas();
                this.setDefaultAction();
                this.setDragMode(0);
            } else if (currentMode == 56) {
                this.selectObject(e, 50);
                this.saveBackupImage();
                this.canvasGraph.setBackupSelectedObject(this.canvasGraph.getSelectedObject());
                this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                if (this.canvasGraph.getSelectedObject() != null) {
                    this.canvasGraph.background(this.canvasGraph.getSelectedObject());
                    this.oldbb = this.canvasGraph.getBoundingBox();
                    this.updateOffScreenImage();
                }
                this.setDefaultAction();
                this.setDragMode(0);
            } else if (currentMode == 57) {
                this.selectObject(e, 50);
                this.saveBackupImage();
                this.canvasGraph.setBackupSelectedObject(this.canvasGraph.getSelectedObject());
                this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                if (this.canvasGraph.getSelectedObject() != null) {
                    this.canvasGraph.foreground(this.canvasGraph.getSelectedObject());
                    this.oldbb = this.canvasGraph.getBoundingBox();
                    this.updateOffScreenImage();
                }
                this.setDefaultAction();
                this.setDragMode(0);
            } else if (this.thePanel.getMode() == 54) {
                this.selectObject(e, 50);
                selectedOb = this.canvasGraph.getSelectedObject();
                if (selectedOb != null) {
                    this.oldbb = selectedOb.getBoundingBox();
                    this.saveBackupImage();
                    this.canvasGraph.setBackupSelectedObject(selectedOb);
                    this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                    boolean hasChanged = selectedOb.editPanel();
                    this.updateOffScreenImage();
                    this.oldbb = selectedOb.getBoundingBox();
                    this.updateOffScreenImage();
                    if (selectedOb instanceof JaLatexText) {
                        ((JaLatexText)selectedOb).setLatexLabel(" " + ((JaLatexText)selectedOb).getTextString() + " ");
                    }
                    if (hasChanged) {
                        this.unsavedCanvas();
                    }
                }
                this.setDefaultAction();
                this.setDragMode(0);
            }
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            ++this.nofclicks;
        }
        int currentMode = this.thePanel.getMode();
        zoomPADx = -1;
        zoomPADy = -1;
        if ((e.getModifiers() & 8) != 0 && currentMode != 47 && currentMode != 50 && currentMode != 52 && currentMode != 51 && currentMode != 58) {
            int evX = e.getX();
            int evY = e.getY();
            for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
                JaObject jaxoOb = this.canvasGraph.listElementAt(i);
                if (jaxoOb instanceof JaAxes && evX > jaxoOb.getX() && evX < jaxoOb.getX() + jaxoOb.getRelw() && evY > jaxoOb.getY() && evY < jaxoOb.getY() + jaxoOb.getRelh()) {
                    zoomPADx = ((JaAxes)jaxoOb).getPad(0);
                    zoomPADy = ((JaAxes)jaxoOb).getPad(1);
                    startUSERx = ((JaAxes)jaxoOb).toUserX(evX);
                    startUSERy = ((JaAxes)jaxoOb).toUserY(evY);
                }
                if (!(jaxoOb instanceof JaLatexText)) continue;
                if (((JaLatexText)jaxoOb).isRolledOver(e.getX(), e.getY())) {
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(true);
                    continue;
                }
                ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
            }
        }
        if ((e.getModifiers() & 0x10) != 0 && !this.fboxON && currentMode != 47) {
            if (currentMode == 0) {
                return;
            }
            if (currentMode == 50 || currentMode == 51) {
                this.selectObject(e, currentMode);
                JaObject ob = this.canvasGraph.getSelectedObject();
                if (ob != null) {
                    this.withHandles = false;
                    this.withVisualAid = true;
                    if (ob instanceof JaArcObject && currentMode == 51) {
                        ((JaArcObject)ob).setIsResizing(true);
                    }
                    this.repaint();
                    this.oldbb = ob.getBoundingBox();
                    this.updateOffScreenImage(this.canvasGraph.getSelectedObject());
                }
            } else if (currentMode == 52) {
                int lY = e.getY();
                int lX = e.getX();
                this.selectObject(e, 50);
                JaObject ob = this.canvasGraph.getSelectedObject();
                if (ob != null) {
                    this.withHandles = false;
                    this.withVisualAid = true;
                    this.repaint();
                    JaObject copyOb = ob.copy();
                    if (copyOb instanceof JaLatexText) {
                        ((JaLatexText)copyOb).createLatexPanel();
                        this.add(((JaLatexText)copyOb).getLatexPanel());
                        ((JaLatexText)copyOb).getLatexPanel().setVisible(false);
                    }
                    this.canvasGraph.addObject(copyOb);
                    this.canvasGraph.setSelectedObject(copyOb);
                    this.setDragMode(50);
                    copyOb.getGrabbedHandle(lX, lY, currentMode);
                    this.setStartCoordinates();
                }
            } else {
                if (currentMode == 54 || currentMode == 53 || currentMode == 56 || currentMode == 57 || currentMode == 55 || currentMode == 58) {
                    return;
                }
                this.xin = e.getX();
                this.yin = e.getY();
                if (this.thePanel.getSnap()) {
                    this.xin = this.grid.snapX(this.xin);
                    this.yin = this.grid.snapY(this.yin);
                }
                this.saveBackupImage();
                JaObject newob = this.createNewObject(currentMode, this.xin, this.yin);
                this.unsavedCanvas();
                if (newob != null) {
                    this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                    this.canvasGraph.setBackupSelectedObject(newob);
                    this.canvasGraph.addObject(newob);
                    this.canvasGraph.setSelectedObject(newob);
                }
                this.setDragMode(51);
                this.withHandles = false;
                this.withVisualAid = true;
                this.repaint();
                this.curHandle = 2;
                this.setStartCoordinates();
            }
        } else if (currentMode == 47) {
            this.setDragMode(0);
            JaxoZoom zoom = this.thePanel.getZoom();
            if ((e.getModifiers() & 0x10) != 0) {
                zoom.setZoomWindowWidth(160);
                zoom.setZoomWindowHeight(100);
            } else if ((e.getModifiers() & 8) != 0) {
                zoom.setZoomWindowWidth(240);
                zoom.setZoomWindowHeight(150);
            } else if ((e.getModifiers() & 4) != 0) {
                zoom.setZoomWindowWidth(320);
                zoom.setZoomWindowHeight(200);
            }
            zoom.setZoomWindowX(e.getX() - zoom.getZoomWindowWidth() / 2);
            zoom.setZoomWindowY(e.getY() - zoom.getZoomWindowHeight() / 2);
            zoom.drawZoomWindow();
        }
        this.lastY = e.getY();
        this.lastX = e.getX();
        this.showCoordinates(e);
        if ((e.getModifiers() & 4) != 0 && padX > 0 && padY > 0) {
            this.menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        JaObject selectedOb = this.canvasGraph.getSelectedObject();
        int currentMode = this.thePanel.getMode();
        int dragMode = this.getDragMode();
        if ((currentMode == 5 || currentMode == 8 || currentMode == 11 || currentMode == 14 || currentMode == 17) && this.nofclicks % 3 != 0) {
            return;
        }
        if (selectedOb != null) {
            this.oldbb = selectedOb.getBoundingBox();
        }
        if (currentMode == 47) {
            JaxoZoom zoom = this.thePanel.getZoom();
            zoom.dragZoomWindow(e.getX(), e.getY());
        } else if ((e.getModifiers() & 8) != 0 || (e.getModifiers() & 4) != 0) {
            this.fboxY = e.getY();
            this.fboxX = e.getX();
            this.fboxON = true;
            this.repaint();
        }
        if ((e.getModifiers() & 0x10) != 0) {
            if (dragMode == 51 && selectedOb != null) {
                this.canvasGraph.foreground(selectedOb);
                int curY = e.getY();
                int curX = e.getX();
                if (this.thePanel.getSnap()) {
                    curY = this.grid.snapY(curY);
                    curX = this.grid.snapX(curX);
                }
                if (selectedOb instanceof JaArcObject) {
                    JaArcObject arcOb = (JaArcObject)selectedOb;
                    arcOb.setIsResizing(true);
                    if (this.archand == 1) {
                        arcOb.setX1(curX);
                        arcOb.setY1(curY);
                    } else if (this.archand == 2) {
                        arcOb.setX2(curX);
                        arcOb.setY2(curY);
                    } else {
                        arcOb.setX(curX);
                        arcOb.setY(curY);
                    }
                } else if (selectedOb instanceof JaVertexT5) {
                    JaVertexT5 vt5 = (JaVertexT5)selectedOb;
                    if (this.archand == 1) {
                        vt5.setX1(curX);
                        vt5.setY1(curY);
                    } else if (this.archand == 2) {
                        vt5.setX2(curX);
                        vt5.setY2(curY);
                    } else {
                        vt5.setX(curX);
                        vt5.setY(curY);
                    }
                } else {
                    int handle = this.curHandle;
                    if (handle == 3 && curX < this.startX) {
                        this.curHandle = 0;
                    } else if (handle == 2 && curX < this.startX) {
                        this.curHandle = 1;
                    } else if (handle == 0 && curX > this.startX) {
                        this.curHandle = 3;
                    } else if (handle == 1 && curX > this.startX) {
                        this.curHandle = 1;
                    }
                    if (handle == 3 && curY > this.startY) {
                        this.curHandle = 2;
                    } else if (handle == 2 && curY < this.startY) {
                        this.curHandle = 3;
                    } else if (handle == 0 && curY > this.startY) {
                        this.curHandle = 1;
                    } else if (handle == 1 && curY < this.startY) {
                        this.curHandle = 0;
                    }
                    int newX = Math.min(curX, this.startX);
                    int newY = Math.min(curY, this.startY);
                    int newWidth = Math.abs(curX - this.startX);
                    int newHeight = Math.abs(curY - this.startY);
                    int newrelw = curX - this.startX;
                    int newrelh = curY - this.startY;
                    selectedOb.setLocation(newX, newY);
                    selectedOb.setSize(newWidth, newHeight, newrelw, newrelh);
                }
                this.lastY = curY;
                this.lastX = curX;
                this.unsavedCanvas();
                this.repaint();
            }
            if (dragMode == 50 && selectedOb != null) {
                this.canvasGraph.foreground(selectedOb);
                if (this.thePanel.getSnap() && (currentMode == 50 || currentMode == 52)) {
                    this.reSnap(selectedOb);
                }
                int newY = e.getY();
                int newX = e.getX();
                if (this.thePanel.getSnap()) {
                    this.lastY = this.grid.snapY(this.lastY);
                    this.lastX = this.grid.snapX(this.lastX);
                    newY = this.grid.snapY(newY);
                    newX = this.grid.snapX(newX);
                }
                selectedOb.moveBy(newX - this.lastX, newY - this.lastY);
                this.lastY = newY;
                this.lastX = newX;
                if (this.grid.getGridType()) {
                    this.lastY = e.getY();
                    this.lastX = e.getX();
                }
                this.unsavedCanvas();
                this.repaint();
            }
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        int currentMode = this.thePanel.getMode();
        this.showCoordinates(e);
        boolean zoom_done = false;
        if ((e.getModifiers() & 8) != 0 && currentMode != 47 && currentMode != 50 && currentMode != 52 && currentMode != 51 && currentMode != 58 && currentMode != 59 && zoomPADx > -1 && zoomPADy > -1) {
            int evX = e.getX();
            int evY = e.getY();
            for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
                JaObject jaxoOb = this.canvasGraph.listElementAt(i);
                if (jaxoOb instanceof JaAxes) {
                    int n1 = ((JaAxes)jaxoOb).getPad(0);
                    int n2 = ((JaAxes)jaxoOb).getPad(1);
                    if (n1 == zoomPADx && n2 == zoomPADy && evX > jaxoOb.getX() && evX < jaxoOb.getX() + jaxoOb.getRelw() && evY > jaxoOb.getY() && evY < jaxoOb.getY() + jaxoOb.getRelh()) {
                        JaAxes ja = (JaAxes)jaxoOb;
                        double x = ja.toUserX(evX);
                        double y = ja.toUserY(evY);
                        if (startUSERx < x) {
                            ja.setRange(0, startUSERx, x);
                        }
                        if (startUSERx > x) {
                            ja.setRange(0, x, startUSERx);
                        }
                        if (startUSERy < y) {
                            ja.setRange(1, startUSERy, y);
                        }
                        if (startUSERy > y) {
                            ja.setRange(1, y, startUSERy);
                        }
                        if (ja.isContour()) {
                            if (ja.getPlotType() == 2) {
                                ja.parseContour();
                            }
                            if (ja.getPlotType() == 201) {
                                ja.parseH2D();
                            }
                        }
                        zoom_done = true;
                        zoomPADx = -1;
                        zoomPADy = -1;
                    }
                }
                if (!(jaxoOb instanceof JaLatexText)) continue;
                if (((JaLatexText)jaxoOb).isRolledOver(e.getX(), e.getY())) {
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(true);
                    continue;
                }
                ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
            }
        }
        if (zoom_done) {
            this.update();
        }
        if (currentMode == 47) {
            JaxoZoom zoom = this.thePanel.getZoom();
            zoom.eraseZoomWindow();
        }
        if ((e.getModifiers() & 8) != 0 && this.fboxON) {
            this.fboxON = false;
            this.thePanel.getClipboard().clear();
            Vector groupObjects = this.buildGroupList();
            if (groupObjects.size() > 1) {
                this.saveBackupImage();
                this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
                double[] groupBounds = this.getGroupBounds(groupObjects);
                JaxoGroup newGroup = new JaxoGroup();
                newGroup.setObList(groupObjects);
                newGroup.setX((int)groupBounds[0]);
                newGroup.setY((int)groupBounds[1]);
                newGroup.setRelw((int)Math.round(groupBounds[2] - groupBounds[0]));
                newGroup.setRelh((int)Math.round(groupBounds[3] - groupBounds[1]));
                newGroup.setAvailableFonts(JaxoStaticCanvasMethods.getSystemFonts());
                this.removeFromGraph(groupObjects);
                JaxoGroup newob = newGroup;
                this.canvasGraph.setBackupSelectedObject(newob);
                this.canvasGraph.addObject(newob);
                this.canvasGraph.setSelectedObject(newob);
                this.oldbb = newGroup.getBoundingBox();
            }
            this.canvasGraph.setAsMarked(false);
            this.repaint();
        }
        if ((e.getModifiers() & 4) != 0 && this.fboxON) {
            this.fboxON = false;
            this.canvasGraph.setAsMarked(false);
            this.repaint();
        }
        if ((e.getModifiers() & 0x10) != 0) {
            JaObject ob;
            if (this.fboxON) {
                this.fboxON = false;
                this.canvasGraph.setAsMarked(false);
                this.repaint();
            }
            if (currentMode == 50 || currentMode == 52) {
                this.withHandles = true;
                this.withVisualAid = false;
                this.drawSelectedObject();
                this.setDefaultAction();
            } else if (currentMode == 4 || currentMode == 13 || currentMode == 7 || currentMode == 16 || currentMode == 10 || currentMode == 3 || currentMode == 6 || currentMode == 9 || currentMode == 15 || currentMode == 12 || currentMode == 8 && this.nofclicks % 3 == 0 || currentMode == 11 && this.nofclicks % 3 == 0 || currentMode == 17 && this.nofclicks % 3 == 0 || currentMode == 14 && this.nofclicks % 3 == 0 || currentMode == 5 && this.nofclicks % 3 == 0 || currentMode == 32 && (this.thePanel.getVertexType() == 36 || this.thePanel.getVertexType() == 37 || this.thePanel.getVertexType() == 38 || this.thePanel.getVertexType() == 39 || this.thePanel.getVertexType() == 40 && this.nofclicks % 3 == 0 || this.thePanel.getVertexType() == 41) || currentMode == 30 || currentMode == 31 || currentMode == 33) {
                if (!this.fboxON) {
                    this.withHandles = false;
                    this.withVisualAid = false;
                    this.drawSelectedObject();
                    this.setDefaultAction();
                }
            } else if (this.getDragMode() == 51 && (ob = this.canvasGraph.getSelectedObject()) != null) {
                if (ob instanceof JaFLine || ob instanceof JaSLine || ob instanceof JaGLine) {
                    JaLineObject lineObject = (JaLineObject)ob;
                    if (lineObject.getBack()) {
                        lineObject.setRelWAndH(-lineObject.getRelw(), -lineObject.getRelh());
                        lineObject.setInflip(!lineObject.getInflip());
                        lineObject.setBack(false);
                    }
                } else if (ob instanceof JaGlLine) {
                    JaGlLine glLineObject = (JaGlLine)ob;
                    if (glLineObject.getBack()) {
                        glLineObject.setRelWAndH(-glLineObject.getRelw(), -glLineObject.getRelh());
                        glLineObject.setAngamp(-glLineObject.getAngamp());
                        glLineObject.setBack(false);
                    }
                } else if (ob instanceof JaArcObject) {
                    JaArcObject arcOb = (JaArcObject)ob;
                    arcOb.setIsResizing(false);
                }
                this.withVisualAid = false;
                this.withHandles = true;
                if (Plot.drawFirst(ob)) {
                    this.drawObject(ob);
                }
                this.drawRest(ob);
                this.setDefaultAction();
            }
        }
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        this.evX = e.getX();
        this.evY = e.getY();
        if (this.pointsON) {
            if (this.thePanel.getSnap()) {
                this.evY = this.grid.snapY(this.evY);
                this.evX = this.grid.snapX(this.evX);
            }
            this.repaint();
        }
    }

    public void update() {
        this.clearOffScreenImage();
        this.updateObjectLocation();
    }

    public final void setGridSize(int gs) {
        this.grid.setGridSize(gs);
    }

    public final int getGridSize() {
        return this.grid.getGridSize();
    }

    public final void setGridType(boolean type) {
        this.grid.setGridType(type);
    }

    public final boolean getGridType() {
        return this.grid.getGridType();
    }

    private void drawFaintBox(VectorGraphics g2) {
        this.thePanel.getClipboard().clear();
        int width = this.fboxX - this.lastX;
        int height = this.fboxY - this.lastY;
        Rectangle faintbox = height < 0 ? (width < 0 ? new Rectangle(this.fboxX, this.fboxY, -width, -height) : new Rectangle(this.lastX, this.fboxY, width, -height)) : (width < 0 ? new Rectangle(this.fboxX, this.lastY, -width, height) : new Rectangle(this.lastX, this.lastY, width, height));
        g2.setColor(JaxoColor.GRAYSCALE150);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.draw((Shape)faintbox);
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            double[] bb = jaxoOb.getBoundingBox();
            Rectangle rectOb = new Rectangle((int)bb[0] - 5, (int)bb[1] - 5, (int)(bb[2] - bb[0]) + 5, (int)(bb[3] - bb[1]) + 5);
            if (faintbox.contains(rectOb)) {
                this.thePanel.getClipboard().addObject(jaxoOb.copy());
                jaxoOb.setAsMarked(true);
                continue;
            }
            this.thePanel.getClipboard().delete(jaxoOb);
            jaxoOb.setAsMarked(false);
        }
    }

    private Vector buildGroupList() {
        Vector<JaObject> groupObjects = new Vector<JaObject>(5, 5);
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject ob = (JaObject)this.canvasGraph.getObjectList().get(i);
            if (!ob.isMarked()) continue;
            groupObjects.add(ob);
        }
        return groupObjects;
    }

    private double[] getGroupBounds(Vector groupObList) {
        double minX = 0.0;
        double maxX = 1.0;
        double minY = 0.0;
        double maxY = 1.0;
        double[] bBox = new double[]{minX, maxX, minY, maxY};
        int length = groupObList.size();
        for (int i = 0; i < length; ++i) {
            JaObject ob = (JaObject)groupObList.elementAt(i);
            bBox = ob.getBoundingBox();
            if (i == 0) {
                minX = bBox[0];
                minY = bBox[1];
                maxX = bBox[2];
                maxY = bBox[3];
                continue;
            }
            if (bBox[0] < minX) {
                minX = bBox[0];
            }
            if (bBox[1] < minY) {
                minY = bBox[1];
            }
            if (bBox[2] > maxX) {
                maxX = bBox[2];
            }
            if (!(bBox[3] > maxY)) continue;
            maxY = bBox[3];
        }
        bBox[0] = minX;
        bBox[1] = minY;
        bBox[2] = maxX;
        bBox[3] = maxY;
        return bBox;
    }

    private void removeFromGraph(Vector<JaObject> obList) {
        for (int i = 0; i < obList.size(); ++i) {
            JaObject jaxoOb = obList.elementAt(i);
            if (jaxoOb instanceof JaLatexText) {
                ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
            }
            this.canvasGraph.delete(obList.elementAt(i));
        }
    }

    public final void unsavedCanvas() {
        this.canvasGraph.setSaved(false);
        this.isUsed = true;
        this.thePanel.getCanvasPanel().setModifiedIcon(this.thePanel.getCanvasPanel().indexOfComponent(this));
    }

    public final boolean hasBeenUsed() {
        return this.isUsed;
    }

    public final boolean isWithHandles() {
        return this.withHandles;
    }

    public final void drawWithHandles(boolean draw) {
        this.withHandles = draw;
    }

    public final boolean isWithVisualAid() {
        return this.withVisualAid;
    }

    public final void drawVisualAid(boolean draw) {
        this.withVisualAid = draw;
    }

    private void drawText(JaObject newob, boolean drawToScreen) {
        VectorGraphics g2 = (VectorGraphics)this.offScreenImage.getGraphics();
        if (JaxoPrefs.getBooleanPref(302)) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (Plot.drawFirst(newob)) {
            newob.jaxoDraw(g2, drawToScreen);
        }
        Plot.drawRest(newob, g2, drawToScreen);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
    }

    private void reSnap(JaObject ob) {
        int cx = 0;
        int cy = 0;
        int qx = 0;
        int qy = 0;
        if (ob.getRelw() >= 0 && ob.getRelh() > 0) {
            cx = ob.getX();
            cy = ob.getY();
        } else if (ob.getRelw() > 0 && ob.getRelh() <= 0) {
            cx = ob.getX();
            cy = ob.getY() + ob.getHeight();
        } else if (ob.getRelw() <= 0 && ob.getRelh() < 0) {
            cx = ob.getX() + ob.getWidth();
            cy = ob.getY() + ob.getHeight();
        } else if (ob.getRelw() < 0 && ob.getRelh() >= 0) {
            cx = ob.getX() + ob.getWidth();
            cy = ob.getY();
        }
        qy = this.grid.snapY(cy);
        qx = this.grid.snapX(cx);
        if (this.grid.getGridType() && Math.abs(cx - qx) == this.grid.getGridSize()) {
            qx = cx;
        }
        ob.moveBy(qx - cx, qy - cy);
    }

    public final void resetNOfClicks() {
        this.nofclicks = 0;
    }

    private void drawPointsAid(VectorGraphics g2) {
        GeneralPath gp = new GeneralPath();
        if (this.nofclicks % 3 == 1) {
            gp.moveTo(this.points[0], this.points[1]);
            gp.lineTo(this.evX, this.evY);
        } else if (this.nofclicks % 3 == 2) {
            gp.moveTo(this.points[0], this.points[1]);
            gp.lineTo(this.points[2], this.points[3]);
            gp.lineTo(this.evX, this.evY);
        }
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.draw((Shape)gp);
    }

    private JaObject createNewObject(int currentMode, int x, int y) {
        this.canvasGraph.setSelectedObject(null);
        JaxoStaticCanvasMethods.setNofClicks(this.nofclicks);
        JaxoStaticCanvasMethods.setLanguage(this.language);
        JaxoStaticCanvasMethods.setPoints(this.points);
        JaxoStaticCanvasMethods.setPointsON(this.pointsON);
        JaxoStaticCanvasMethods.setVertexType(this.thePanel.getVertexType());
        JaObject newob = JaxoStaticCanvasMethods.createNewObject(currentMode, x, y);
        this.pointsON = JaxoStaticCanvasMethods.getPointsON();
        this.points = JaxoStaticCanvasMethods.getPoints();
        if (newob instanceof JaLatexText) {
            this.add(((JaLatexText)newob).getLatexPanel());
            ((JaLatexText)newob).getLatexPanel().setVisible(false);
            this.drawText(newob, true);
            this.setDefaultAction();
        } else if (newob instanceof JaText) {
            this.drawText(newob, true);
            this.setDefaultAction();
        }
        return newob;
    }

    private void showColorChooser(JaObject ob) {
        Color oldColor;
        this.saveBackupImage();
        this.canvasGraph.setBackupSelectedObject(ob);
        this.canvasGraph.setBackupList(this.canvasGraph.copyFrom(this.canvasGraph.getObjectList()));
        Color newColor = oldColor = ob.getColor();
        JaxoColorChooser colorChooser = new JaxoColorChooser();
        if (ob instanceof JaFillObject) {
            Color oldFillColor;
            JaFillObject fillObject = (JaFillObject)ob;
            Color newFillColor = oldFillColor = fillObject.getFillColor();
            newFillColor = colorChooser.color(oldFillColor, true);
            if (!oldFillColor.equals(newFillColor) && newFillColor != null) {
                fillObject.setFillColor(newFillColor);
                if (JaxoColor.isGrayScale(newFillColor)) {
                    fillObject.setColor(JaxoColor.BLACK);
                }
                this.unsavedCanvas();
            }
        } else if (ob instanceof JaxoGroup) {
            if ((newColor = colorChooser.color(newColor, false)) != null) {
                ((JaxoGroup)ob).setGroupColor(newColor);
                this.unsavedCanvas();
            }
        } else if (ob instanceof JaText) {
            newColor = colorChooser.color(ob, true);
            if (!oldColor.equals(newColor) && newColor != null) {
                ob.setColor(newColor);
                this.unsavedCanvas();
            }
        } else {
            newColor = colorChooser.color(ob, false);
            if (!oldColor.equals(newColor) && newColor != null) {
                ob.setColor(newColor);
                this.unsavedCanvas();
            }
        }
        this.oldbb = ob.getBoundingBox();
        this.updateOffScreenImage();
        this.setDefaultAction();
        this.setDragMode(0);
    }

    private void drawSelectedObject() {
        JaObject ob;
        if (this.g2 == null) {
            return;
        }
        if (JaxoPrefs.getBooleanPref(302)) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if ((ob = this.canvasGraph.getSelectedObject()) != null) {
            if (Plot.drawFirst(ob)) {
                ob.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(ob, this.g2, true);
            if ((int)ob.getSize().getWidth() == 0 && (int)ob.getSize().getHeight() == 0) {
                this.canvasGraph.delete(ob);
            }
        }
        this.repaint();
        this.g2.dispose();
    }

    private void drawObject(JaObject ob) {
        if (this.g2 == null) {
            return;
        }
        if (JaxoPrefs.getBooleanPref(302)) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (ob != null) {
            if (Plot.drawFirst(ob)) {
                ob.jaxoDraw(this.g2, true);
            }
            Plot.drawRest(ob, this.g2, true);
        }
        this.repaint();
        this.g2.dispose();
    }

    private void drawRest(JaObject ob) {
        if (this.g2 == null) {
            return;
        }
        if (JaxoPrefs.getBooleanPref(302)) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (ob != null) {
            Plot.drawRest(ob, this.g2, true);
        }
        this.repaint();
        this.g2.dispose();
    }

    private void setDefaultAction() {
        int def = JaxoPrefs.getIntPref(114);
        if (def != 0) {
            if (def < 16 && this.thePanel.getMode() - def - 2 != 0) {
                this.thePanel.getPbtPanel().clickButton(def - 1);
            } else if (def > 15 && def < 22 && this.thePanel.getMode() - def - 14 != 0) {
                this.thePanel.getMbtPanel().clickButton(def - 16);
            } else if (def > 21 && this.thePanel.getMode() - def - 28 != 0) {
                this.thePanel.getEbtPanel().clickButton(def - 22);
            }
        }
    }

    public void updateObjectLocation() {
        if (this.canvasGraph == null || this.canvasGraph.listSize() == 0) {
            return;
        }
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            if (jaxoOb == null) continue;
            jaxoOb.updateCoor();
            this.drawObject(jaxoOb);
            this.drawRest(jaxoOb);
        }
    }

    public void updateLocations() {
        if (this.canvasGraph == null || this.canvasGraph.listSize() == 0) {
            return;
        }
        for (int i = 0; i < this.canvasGraph.listSize(); ++i) {
            JaObject jaxoOb = this.canvasGraph.listElementAt(i);
            if (jaxoOb == null) continue;
            jaxoOb.updateCoor();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (start) {
            Dimension d = this.getSize();
            Global.sizeX = (int)d.getWidth();
            Global.sizeY = (int)d.getHeight();
            this.clearOffScreenImage();
            this.updateObjectLocation();
        }
        start = true;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

