/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.Icon;
import jplot.GPoints;

public class KeyIcon
implements Icon {
    private Color color;
    private boolean selected;
    private int width;
    private int height;
    private int type = 2;
    private int size = 10;
    private Polygon poly;
    private static final int DEFAULT_WIDTH = 10;
    private static final int DEFAULT_HEIGHT = 10;

    public KeyIcon(Color color) {
        this(color, true, 10, 10);
    }

    public KeyIcon(Color color, boolean selected) {
        this(color, selected, 10, 10);
    }

    public KeyIcon(Color color, boolean selected, int width, int height) {
        this.color = color;
        this.selected = selected;
        this.width = width;
        this.height = height;
        this.initPolygon();
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    private void initPolygon() {
        this.poly = new Polygon();
        int halfWidth = this.width / 2;
        int halfHeight = this.height / 2;
        this.poly.addPoint(0, halfHeight);
        this.poly.addPoint(halfWidth, 0);
        this.poly.addPoint(this.width, halfHeight);
        this.poly.addPoint(halfWidth, this.height);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        GPoints.drawPointType(this.width, g2, x + this.size + 1, y, this.height);
    }
}

