/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.apache.commons.math3.util.FastMath;
import org.freehep.graphics2d.VectorGraphics;

public class DrawUtils {
    protected int al = 10;
    protected int aw = 5;
    protected int haw = 2;
    protected double hhaw = 0.5;
    protected int[] xValues = new int[3];
    protected int[] yValues = new int[3];

    public void drawArrow(VectorGraphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        this.calcValues(x1, y1, x2, y2);
        g.fillPolygon(this.xValues, this.yValues, 3);
    }

    public void calcValues(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y2 < y1) {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 + this.al, x2 + this.haw, y2 + this.al);
            } else {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 - this.al, x2 + this.haw, y2 - this.al);
            }
            return;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                this.arrowCoords(x2, y2, x2 - this.al, y2 - this.haw, x2 - this.al, y2 + this.haw);
            } else {
                this.arrowCoords(x2, y2, x2 + this.al, y2 - this.haw, x2 + this.al, y2 + this.haw);
            }
            return;
        }
        this.calcValuesQuad(x1, y1, x2, y2);
    }

    public void calcValuesQuad(int x1, int y1, int x2, int y2) {
        double arrowAng = FastMath.toDegrees((double)FastMath.atan((double)((double)this.haw / (double)this.al)));
        double dist = FastMath.sqrt((double)(this.al * this.al + this.aw));
        double lineAng = FastMath.toDegrees((double)FastMath.atan((double)((double)FastMath.abs((int)(x1 - x2)) / (double)FastMath.abs((int)(y1 - y2)))));
        if (x1 > x2) {
            if (y1 > y2) {
                lineAng = 180.0 - lineAng;
            }
        } else {
            lineAng = y1 > y2 ? 180.0 + lineAng : 360.0 - lineAng;
        }
        this.xValues[0] = x2;
        this.yValues[0] = y2;
        this.calcCoords(1, x2, y2, dist, lineAng - arrowAng);
        this.calcCoords(2, x2, y2, dist, lineAng + arrowAng);
    }

    public void calcCoords(int index, int x, int y, double dist, double dirn) {
        while (dirn < 0.0) {
            dirn = 360.0 + dirn;
        }
        while (dirn > 360.0) {
            dirn -= 360.0;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x + (int)(FastMath.sin((double)FastMath.toRadians((double)dirn)) * dist);
            this.yValues[index] = y - (int)(FastMath.cos((double)FastMath.toRadians((double)dirn)) * dist);
            return;
        }
        if (dirn <= 180.0) {
            this.xValues[index] = x + (int)(FastMath.cos((double)FastMath.toRadians((double)(dirn - 90.0))) * dist);
            this.yValues[index] = y + (int)(FastMath.sin((double)FastMath.toRadians((double)(dirn - 90.0))) * dist);
            return;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x - (int)(FastMath.sin((double)FastMath.toRadians((double)(dirn - 180.0))) * dist);
            this.yValues[index] = y + (int)(FastMath.cos((double)FastMath.toRadians((double)(dirn - 180.0))) * dist);
        } else {
            this.xValues[index] = x - (int)(FastMath.cos((double)FastMath.toRadians((double)(dirn - 270.0))) * dist);
            this.yValues[index] = y - (int)(FastMath.sin((double)FastMath.toRadians((double)(dirn - 270.0))) * dist);
        }
    }

    public void arrowCoords(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.xValues[0] = x1;
        this.yValues[0] = y1;
        this.xValues[1] = x2;
        this.yValues[1] = y2;
        this.xValues[2] = x3;
        this.yValues[2] = y3;
    }

    public void drawArrow2(VectorGraphics g, int x1, int y1, int x2, int y2) {
        g.drawPolygon(this.getArrow(x1, y1, x2, y2, this.al, this.aw, this.hhaw));
    }

    private Polygon getArrow(int x1, int y1, int x2, int y2, int headsize, int difference, double factor) {
        int[] crosslinebase = this.getArrowHeadLine(x1, y1, x2, y2, headsize);
        int[] headbase = this.getArrowHeadLine(x1, y1, x2, y2, headsize - difference);
        int[] crossline = this.getArrowHeadCrossLine(crosslinebase[0], crosslinebase[1], x2, y2, factor);
        Polygon head = new Polygon();
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(crossline[0], crossline[1]);
        head.addPoint(x2, y2);
        head.addPoint(crossline[2], crossline[3]);
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(x1, y1);
        return head;
    }

    private int[] getArrowHeadLine(int xsource, int ysource, int xdest, int ydest, int distance) {
        int[] arrowhead = new int[2];
        int headsize = distance;
        double stretchfactor = 0.0;
        stretchfactor = 1.0 - (double)headsize / FastMath.sqrt((double)((xdest - xsource) * (xdest - xsource) + (ydest - ysource) * (ydest - ysource)));
        arrowhead[0] = (int)(stretchfactor * (double)(xdest - xsource)) + xsource;
        arrowhead[1] = (int)(stretchfactor * (double)(ydest - ysource)) + ysource;
        return arrowhead;
    }

    private int[] getArrowHeadCrossLine(int x1, int x2, int b1, int b2, double factor) {
        int[] crossline = new int[4];
        int x_dest = (int)((double)(b1 - x1) * factor + (double)x1);
        int y_dest = (int)((double)(b2 - x2) * factor + (double)x2);
        crossline[0] = x1 + x2 - y_dest;
        crossline[1] = x2 + x_dest - x1;
        crossline[2] = crossline[0] + (x1 - crossline[0]) * 2;
        crossline[3] = crossline[1] + (x2 - crossline[1]) * 2;
        return crossline;
    }

    public static void drawPointType(int index, VectorGraphics g2, double _x, double _y, float ps) {
        GeneralPath gp;
        if (index > 12 || ps <= 0.0f) {
            return;
        }
        float x = (float)_x - ps / 2.0f;
        float y = (float)_y - ps / 2.0f;
        if (index == 0) {
            g2.draw((Shape)new Ellipse2D.Float(x, y, ps, ps));
        } else if (index == 1) {
            g2.draw((Shape)new Rectangle2D.Float(x, y, ps, ps));
        } else if (index == 2) {
            gp = new GeneralPath();
            gp.moveTo(x, y + ps / 2.0f);
            gp.lineTo(x + ps / 2.0f, y + ps);
            gp.lineTo(x + ps, y + ps / 2.0f);
            gp.lineTo(x + ps / 2.0f, y);
            gp.lineTo(x, y + ps / 2.0f);
            g2.draw((Shape)gp);
        } else if (index == 3) {
            gp = new GeneralPath();
            gp.moveTo(x, y + ps);
            gp.lineTo(x + ps, y + ps);
            gp.lineTo(x + ps / 2.0f, y);
            gp.lineTo(x, y + ps);
            g2.draw((Shape)gp);
        }
        if (index == 4) {
            g2.draw((Shape)new Ellipse2D.Float(x, y, ps, ps));
            g2.fill((Shape)new Ellipse2D.Float(x, y, ps, ps));
        } else if (index == 5) {
            g2.draw((Shape)new Rectangle2D.Float(x, y, ps, ps));
            g2.fill((Shape)new Rectangle2D.Float(x, y, ps, ps));
        } else if (index == 6) {
            gp = new GeneralPath();
            gp.moveTo(x, y + ps / 2.0f);
            gp.lineTo(x + ps / 2.0f, y + ps);
            gp.lineTo(x + ps, y + ps / 2.0f);
            gp.lineTo(x + ps / 2.0f, y);
            gp.lineTo(x, y + ps / 2.0f);
            g2.draw((Shape)gp);
            g2.fill((Shape)gp);
        } else if (index == 7) {
            gp = new GeneralPath();
            gp.moveTo(x, y + ps);
            gp.lineTo(x + ps, y + ps);
            gp.lineTo(x + ps / 2.0f, y);
            gp.lineTo(x, y + ps);
            g2.draw((Shape)gp);
            g2.fill((Shape)gp);
        } else if (index == 8) {
            g2.draw((Shape)new Line2D.Float(x, y + ps / 2.0f, x + ps, y + ps / 2.0f));
            g2.draw((Shape)new Line2D.Float(x + ps / 2.0f, y, x + ps / 2.0f, y + ps));
        } else if (index == 9) {
            g2.draw((Shape)new Line2D.Float(x, y, x + ps, y + ps));
            g2.draw((Shape)new Line2D.Float(x + ps, y, x, y + ps));
        } else if (index == 10) {
            g2.draw((Shape)new Line2D.Float(x, y + ps / 2.0f, x + ps, y + ps / 2.0f));
            g2.draw((Shape)new Line2D.Float(x + ps / 2.0f, y, x + ps / 2.0f, y + ps));
            g2.draw((Shape)new Line2D.Float(x, y, x + ps, y + ps));
            g2.draw((Shape)new Line2D.Float(x + ps, y, x, y + ps));
        } else if (index == 11) {
            g2.draw((Shape)new Line2D.Float(x + ps / 2.0f, y + ps / 2.0f, x + ps / 2.0f, y + ps / 2.0f));
        } else if (index == 12) {
            g2.draw((Shape)new Line2D.Float(x, y + ps / 3.0f, x + ps, y + ps / 3.0f));
            g2.draw((Shape)new Line2D.Float(x, y + 2.0f * ps / 3.0f, x + ps, y + 2.0f * ps / 3.0f));
            g2.draw((Shape)new Line2D.Float(x + ps / 3.0f, y, x + ps / 3.0f, y + ps));
            g2.draw((Shape)new Line2D.Float(x + 2.0f * ps / 3.0f, y, x + 2.0f * ps / 3.0f, y + ps));
        }
    }
}

